(function ($) {
  Drupal.behaviors.background_audio = {};
  Drupal.behaviors.background_audio.attach = function (context, settings) {
    if (typeof Drupal.settings.background_audio.processed != 'undefined') {
      return false;
    }
    Drupal.settings.background_audio.processed = 'processed';
    
    var div = document.createElement('div'),
    audioElement = document.createElement('audio'),
    source;
    div.className = 'background-audio background-audio-' + Drupal.settings.background_audio.position;
    

    /* Do not preload media - this prevents media loading if no autoplay. */
    audioElement.setAttribute('preload', 'none');
    if (Drupal.settings.background_audio.autoplay) {
      audioElement.setAttribute('autoplay', 'autoplay');
    }
    /* is set this attribute - then the "ended" event doesn't fire after song and it repeats just the first song */
    /*if (Drupal.settings.background_audio.background_audio_loop) {
      audioElement.setAttribute('loop', 'loop');
    }*/
    audioElement.setAttribute('controls', 'controls');
    
    document.body.appendChild(div);
    div.appendChild(audioElement);
    
    $.each(Drupal.settings.background_audio.files, function(index, element) {
      source = document.createElement('source');
      source.setAttribute('src', element.src);
      source.setAttribute('title', element.title);
      source.setAttribute('type', element.type);
      audioElement.appendChild(source);
    });

    var features = [];
    $.each(Drupal.settings.background_audio.controls, function(index, element) {
      features.push(index);
    });
    
    $(audioElement).mediaelementplayer({
      audioWidth: Drupal.settings.background_audio.width,
      audioHeight: Drupal.settings.background_audio.height,
      startVolume: Drupal.settings.background_audio.volume,
      loop: Drupal.settings.background_audio.loop,
      shuffle: Drupal.settings.background_audio.shuffle,
      playlist: Drupal.settings.background_audio.playlist,
      playlistposition: Drupal.settings.background_audio.playlist_position,
      features: features,
      success: function (mediaElement, domObject) {
        var state = $.cookie('background_audio_state');
        var volume = $.cookie('background_audio_volume');
        var muted = $.cookie('background_audio_muted');

        if (typeof state != 'undefined') {
          if (state == 'play') {
            mediaElement.load();
            mediaElement.play();
          }
          else if (state == 'pause') {
            mediaElement.pause();
          }
        }
        if (typeof volume != 'undefined') {
          mediaElement.setVolume(volume);
          console.log(volume);
        }
        if (typeof muted != 'undefined') {
          if (muted == 'true') {
            mediaElement.setMuted(muted);
          }
        }

        mediaElement.addEventListener('play', function () {
          $.cookie('background_audio_state', 'play', {expires: 7, path: '/'});
        });
        mediaElement.addEventListener('pause', function () {
          $.cookie('background_audio_state', 'pause', {expires: 7, path: '/'});
        });
        mediaElement.addEventListener('volumechange', function () {
          $.cookie('background_audio_volume', mediaElement.volume, {expires: 7, path: '/'});
          $.cookie('background_audio_muted', mediaElement.muted, {expires: 7, path: '/'});
        });
      }
    });
    
    /* Copy padding-top from body. */
    $(div).css('padding-top', $('body').css('padding-top'));
  };
})(jQuery);
