/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
var _this = this;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function (_, window) {
  var RuntimeCss = function () {
    function RuntimeCss() {
      var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'default';

      _classCallCheck(this, RuntimeCss);

      this.css = {};
      this.id = id + '-runtime-css';
      this.count = 0;
      this.element = document.head.querySelector('style#' + this.id);
      if (!this.element) {
        this.element = document.createElement('style');
        this.element.id = this.generateId();
        this.element.type = 'text/css';
        document.head.appendChild(this.element);
      }
    }

    _createClass(RuntimeCss, [{
      key: 'add',
      value: function add(selector) {
        var properties = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (selector instanceof Element) {
          var element = selector;
          if (!element.id) {
            element.id = this.generateId();
          }
          selector = '#' + element.id;
        }
        var current = this.css[selector] || {};
        var merged = _.extend({}, current, properties);
        if (!_.isEqual(current, merged)) {
          this.css[selector] = merged;
          this.update();
        }
      }
    }, {
      key: 'generateId',
      value: function generateId() {
        this.count = this.count + 1;
        var id = this.id + '-' + this.count;
        if (document.querySelector('#' + id)) {
          return this.generateId();
        }
        return id;
      }
    }, {
      key: 'remove',
      value: function remove(selector) {
        var properties = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

        if (selector instanceof Element) {
          var element = selector;
          if (!element.id) {
            element.id = this.generateId();
          }
          selector = '#' + element.id;
        }

        if (!this.css[selector]) {
          return;
        }

        var keys = [];
        if (typeof properties === 'string') {
          keys.push(properties);
        } else if (properties instanceof Array) {
          keys = properties;
        } else if (properties instanceof Object) {
          keys = Object.keys(properties);
        }

        if (!keys.length) {
          return;
        }

        var current = this.css[selector];
        var diff = _.omit(current, keys);
        if (!_.isEqual(current, diff)) {
          this.css[selector] = diff;
          this.update();
        }
      }
    }, {
      key: 'update',
      value: function update() {
        var rules = [];
        var selectors = Object.keys(this.css);
        for (var i = 0; i < selectors.length; i++) {
          var selector = selectors[i];
          var selectorProperties = Object.keys(this.css[selector]);
          var properties = [];
          for (var p = 0; p < selectorProperties.length; p++) {
            var value = this.css[selector][selectorProperties[p]];
            var prefix = RuntimeCss.prefixRegExp.test(selectorProperties[p]);
            var property = RuntimeCss.cleanProperty(selectorProperties[p]);
            if (prefix) {
              properties = properties.concat(RuntimeCss.prefix(property, value));
            }
            properties.push(property + ':' + value + ';');
          }

          var element = document.querySelector(selector);
          if (element) {
            element.style = properties.join(';') + ';';
          } else {
            rules.push(selector + ' { ' + properties.join(';') + '; }');
          }
        }
        this.element.textContent = rules.join();
      }
    }]);

    return RuntimeCss;
  }();

  RuntimeCss.prefixRegExp = /^-prefix-|prefix([A-Z])/;

  RuntimeCss.cleanProperty = function (property) {
    return property.replace(RuntimeCss.prefixRegExp, function (s, g1) {
      return g1 && g1.toLowerCase() || '';
    }).replace(/([a-z])([A-Z])/g, function (s, g1, g2) {
      return (g1 + '-' + g2).toLowerCase();
    });
  };

  RuntimeCss.getOffset = function () {
    var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.body;

    return {
      left: parseInt(window.getComputedStyle(element).marginLeft, 10) + parseInt(window.getComputedStyle(element).paddingLeft, 10),
      top: parseInt(window.getComputedStyle(element).marginTop, 10) + parseInt(window.getComputedStyle(element).paddingTop, 10)
    };
  };

  RuntimeCss.getScrollTop = function () {
    var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.body;
    return Math.max(window.pageYOffset, document.documentElement.scrollTop, element.scrollTop);
  };

  RuntimeCss.prefix = function (property, value) {
    return ['-webkit-' + property + ': ' + value + ';', '-moz-' + property + ': ' + value + ';', '-o-' + property + ': ' + value + ';', '-ms-' + property + ': ' + value + ';', property + ': ' + value + ';'];
  };

  RuntimeCss.hasRaf = !!window.requestAnimationFrame;

  RuntimeCss.raf = function (callback, context) {
    var self = context || _this;
    var fn = function fn() {
      return callback.call(self);
    };
    return RuntimeCss.hasRaf ? window.requestAnimationFrame(fn) : setTimeout(fn, 0);
  };

  RuntimeCss.supports = function (property) {
    return document.documentElement.style[property] !== undefined || document.documentElement.style['-webkit-' + property] !== undefined || document.documentElement.style['-moz-' + property] !== undefined || document.documentElement.style['-o-' + property] !== undefined || document.documentElement.style['-ms-' + property] !== undefined;
  };

  window.RuntimeCss = window.RuntimeCss || RuntimeCss;
})(window._, window);