<?php

namespace Drupal\background_image\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the background_image entity add/edit forms.
 *
 * Note: this is just a stub so it follows Drupal's normal Form API. Due to the
 * nature of how this form can be embedded in other forms, and how forms are
 * reconstructed after being cached in the database, it's easier to offload the
 * majority of this form's functionality into a separate easy to manage class.
 *
 * @see \Drupal\background_image\Form\BackgroundImageForm
 *
 * @ingroup background_image
 */
class BackgroundImageHandlerForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    /** @var \Drupal\background_image\BackgroundImageInterface $background_image */
    $background_image = $this->entity;
    BackgroundImageForm::create($background_image, $form, $form_state, $form)->build();
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state); // TODO: Change the autogenerated stub
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    // Intentionally left empty.
  }

}
