<?php

/**
 * @file
 *
 * Pages for background batch.
 *
 * @todo Implement proper error page instead of just 404.
 */


/**
 * System settings page.
 */
function background_batch_settings_form() {
  $form = array();
  $form['background_batch_cleanup'] = array(
    '#type' => 'textfield',
    '#default_value' => variable_get('background_batch_cleanup', BACKGROUND_BATCH_CLEANUP),
    '#title' => 'Cleanup',
    '#description' => t('Time in seconds before finished jobs are removed from the database'),
  );
  $form['background_batch_delay'] = array(
    '#type' => 'textfield',
    '#default_value' => variable_get('background_batch_delay', BACKGROUND_BATCH_DELAY),
    '#title' => 'Delay',
    '#description' => t('Time in microseconds for progress refresh'),
  );
  $form['background_batch_process_timeout'] = array(
    '#type' => 'textfield',
    '#default_value' => variable_get('background_batch_process_timeout', BACKGROUND_BATCH_PROCESS_TIMEOUT),
    '#title' => 'Process timeout',
    '#description' => t('Time in microseconds for process to run before starting a new process'),
  );
  return system_settings_form($form);
}

/**
 * Overview of current and recent batch jobs.
 */
function background_batch_overview_page() {
  $sql = "
SELECT b.bid, p.progress, p.message, p.start, p.end, p.current
FROM {batch} b
JOIN {progress} p
ON p.name = CONCAT('background_batch:', b.bid)
ORDER BY b.bid
";
  $result = db_query($sql);
  while ($row = db_fetch_object($result)) {
    $data[] = array(
      $row->end ? $row->bid : l($row->bid, 'batch', array('query' => 'op=start&id=' . $row->bid)),
      ($row->progress * 100) . '%',
      $row->message,
      $row->start ? format_date($row->start, 'small') : t('N/A'),
      $row->end ? format_date($row->end, 'small') : format_date(progress_estimate_completion($row), 'small'),
    );
  }
  $header = array('Batch ID', 'Progress', 'Message', 'Started', 'Finished/ETA');
  return theme('table', $header, $data);
}

/**
 * State-based dispatcher for the batch processing page.
 */
function background_batch_progress_page() {
  $batch =& batch_get();

  $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : FALSE;

  // Retrieve the current state of batch from db.
  if ($id && $data = db_result(db_query("SELECT batch FROM {batch} WHERE bid = %d AND token = '%s'", $id, drupal_get_token($id)))) {
    $batch = unserialize($data);
  }
  else {
    $batch = FALSE;
  }

  $op = isset($_REQUEST['op']) ? $_REQUEST['op'] : '';
  switch ($op) {
    case 'start':
      if (!$batch) {
        return drupal_not_found();
      }
      // If batch is already in progress, goto to the status page instead of starting it.
      $progress = progress_get_progress('background_batch:' . $id);
      if (!$progress) {
        $process = new BackgroundProcess();
        if (!$process->lock()) {
          return drupal_not_found();
        }

        progress_initialize_progress('background_batch:' . $id, 'Initialized');
        if (!$process->execute('_background_batch_process', array($id))) {
          // Couldn't start process, clean up
          db_query("DELETE FROM {batch} WHERE id = %d", $id);
          progress_remove_progress('background_batch:' . $id);
          return drupal_not_found();
        }
      }
      return _background_batch_progress_page_js();
    case 'do':
      return _background_batch_do();
    case 'finished':
      return _background_batch_finished_page();
    default:
      drupal_goto('admin/settings/batch/overview');
  }
}

/**
 * Batch processing page with JavaScript support.
 */
function _background_batch_progress_page_js() {
  require_once('includes/batch.inc');

  $batch = batch_get();

  // The first batch set gets to set the page title
  // and the initialization and error messages.
  $current_set = _batch_current_set();
  drupal_set_title($current_set['title']);
  drupal_add_js('misc/progress.js', 'core', 'header', FALSE, FALSE);

  $url = url($batch['url'], array('query' => array('id' => $batch['id'])));
  $js_setting = array(
    'batch' => array(
      'errorMessage' => $current_set['error_message'] .'<br/>'. $batch['error_message'],
      'initMessage' => $current_set['init_message'],
      'uri' => $url,
      'delay' => variable_get('background_batch_delay', BACKGROUND_BATCH_DELAY),
    ),
  );
  drupal_add_js($js_setting, 'setting');
  drupal_add_js('misc/batch.js', 'core', 'header', FALSE, FALSE);
  drupal_add_js(drupal_get_path('module', 'background_batch') . '/js/batch.js', 'module', 'header', FALSE, FALSE);

  $output = '<div id="background-progress"></div>';
  return $output;
}

/**
 * Do one pass of execution and inform back the browser about progression
 * (used for JavaScript-mode only).
 */
function _background_batch_do() {
  // HTTP POST required
  if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    drupal_set_message(t('HTTP POST is required.'), 'error');
    drupal_set_title(t('Error'));
    return '';
  }

  $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : FALSE;

  // Get progress
  $progress = progress_get_progress('background_batch:' . $id);
  $percentage = $progress->progress * 100;
  $message = $progress->message;
  progress_estimate_completion($progress);
  $message .= "<br>ETA: " . ($progress->estimate ? format_date($progress->estimate, 'large') : t('N/A'));

  session_save_session(FALSE);

  drupal_json(array('status' => TRUE, 'percentage' => sprintf("%.2f", $percentage), 'message' => $message));
}

/**
 * Resolve page redirection for a finished batch job.
 */
function _background_batch_finished_page() {
  $batch =& batch_get();
  $_batch = $batch;
  $batch = NULL;

  // Redirect if needed.
  if ($_batch['progressive']) {
    // Put back the 'destination' that was saved in batch_process().
    if (isset($_batch['destination'])) {
      $_REQUEST['destination'] = $_batch['destination'];
    }

    // Use $_batch['form_state']['redirect'], or $_batch['redirect'],
    // or $_batch['source_page'].
    if (isset($_batch['form_state']['redirect'])) {
      $redirect = $_batch['form_state']['redirect'];
    }
    elseif (isset($_batch['redirect'])) {
      $redirect = $_batch['redirect'];
    }
    else {
      $redirect = $_batch['source_page'];
    }

    // Let drupal_redirect_form handle redirection logic.
    $form = isset($batch['form']) ? $batch['form'] : array();
    if (empty($_batch['form_state']['rebuild']) && empty($_batch['form_state']['storage'])) {
      drupal_redirect_form($form, $redirect);
    }

    // We get here if $form['#redirect'] was FALSE, or if the form is a
    // multi-step form. We save the final $form_state value to be retrieved
    // by drupal_get_form, and we redirect to the originating page.
    $_SESSION['batch_form_state'] = $_batch['form_state'];
    drupal_goto($_batch['source_page']);
  }
}
