<?php
/**
 * @file
 */

/**
 * FAPI definition for settings page.
 */
function background_process_settings_form() {
  $form = array();
  $form['background_process_service_timeout'] = array(
    '#type' => 'textfield',
    '#title' => t('Service timeout'),
    '#description' => t('Timeout for service call in seconds (0 = disabled)'),
    '#default_value' => variable_get('background_process_service_timeout', BACKGROUND_PROCESS_SERVICE_TIMEOUT),
  );
  $form['background_process_connection_timeout'] = array(
    '#type' => 'textfield',
    '#title' => t('Connection timeout'),
    '#description' => t('Timeout for connection in seconds'),
    '#default_value' => variable_get('background_process_connection_timeout', BACKGROUND_PROCESS_CONNECTION_TIMEOUT),
  );
  $form['background_process_stream_timeout'] = array(
    '#type' => 'textfield',
    '#title' => t('Stream timeout'),
    '#description' => t('Timeout for stream in seconds'),
    '#default_value' => variable_get('background_process_stream_timeout', BACKGROUND_PROCESS_STREAM_TIMEOUT),
  );

  $options = variable_get('background_process_service_groups', array());
  foreach ($options as $key => &$value) {
    $value = (empty($value['description']) ? $key : $value['description']) . ' (' . join(',', $value['hosts']) . ')';
  }
  $options += array(NULL => 'none');
  $form['background_process_default_service_group'] = array(
    '#type' => 'select',
    '#title' => t('Default service group'),
    '#description' => t('The default service group to use'),
    '#options' => $options,
    '#default_value' => variable_get('background_process_default_service_group', 0),
  );

  $options = variable_get('background_process_service_hosts', array());
  foreach ($options as $key => &$value) {
    $value = empty($value['description']) ? $key : $value['description'];
  }

  $options += array(NULL => 'none');
  $form['background_process_default_service_host'] = array(
    '#type' => 'select',
    '#title' => t('Default service host'),
    '#description' => t('The default service host to use'),
    '#options' => $options,
    '#default_value' => variable_get('background_process_default_service_host', 0),
  );
  
  return system_settings_form($form);
}

/**
 * Overview of background processes.
 */
function background_process_overview_page() {
  $processes = background_process_get_processes();

  $data = array();
  foreach ($processes as $process) {
    $progress = progress_get_progress($process->handle);

    $data[] = array(
      $process->handle,
      $process->callback,
      $process->uid,
      $process->service_host,
      format_date($process->start, 'custom', 'Y-m-d H:i:s'),
      sprintf("%.02f%%", $progress->progress * 100),
      l(t('Unlock'), 'background-process/unlock/' . $process->handle,
        array('attributes' => array('class' => 'button-unlock'), 'query' => 'destination=' . trim(request_uri(), '/'))
      )
    );
  }
  $header = array('Handle', 'Callback', 'User', 'Host', 'Start time', 'Progress', '');
  $output = '';
  $output .= theme('table', $header, $data, array('class' => 'background-process-overview'));
  return $output;
}

/**
 * Unlock background process.
 *
 * @param $handle 
 *   Handle of process to unlock
 */
function background_process_service_unlock($handle) {
  if ($process = background_process_get_process($handle)) {
    // Unlock the process
    if (background_process_remove_process($process->handle, $process->start)) {
      drupal_set_message(t('Process %handle unlocked', array('%handle' => $handle)));
      module_invoke_all('background_process_shutdown', $process, FALSE, t('Manually unlocked'));
    }
  }
  else {
    drupal_set_message(t('Process %handle not found', array('%handle' => $handle)), 'error');
  }
  drupal_goto();
}
