<?php

/**
 * @file
 *
 * Pages for background batch.
 *
 * @todo Implement proper error page instead of just 404.
 */


/**
 * System settings page.
 */
function background_batch_settings_form() {
  $form = array();
  $form['background_batch_delay'] = array(
    '#type' => 'textfield',
    '#default_value' => variable_get('background_batch_delay', BACKGROUND_BATCH_DELAY),
    '#title' => 'Delay',
    '#description' => t('Time in microseconds for progress refresh'),
  );
  $form['background_batch_process_lifespan'] = array(
    '#type' => 'textfield',
    '#default_value' => variable_get('background_batch_process_lifespan', BACKGROUND_BATCH_PROCESS_LIFESPAN),
    '#title' => 'Process lifespan',
    '#description' => t('Time in miliseconds for progress lifespan'),
  );
  return system_settings_form($form);
}

/**
 * Overview of current and recent batch jobs.
 */
function background_batch_overview_page() {
  $data = array();
  $sql = "
SELECT b.bid, p.progress, p.message, p.start, p.end, p.current
FROM {batch} b
JOIN {progress} p
ON p.name = CONCAT('_background_batch:', b.bid)
ORDER BY b.bid
";
  $result = db_query($sql);
  while ($row = db_fetch_object($result)) {
    $eta = progress_estimate_completion($row);
    $data[] = array(
      $row->end ? $row->bid : l($row->bid, 'batch', array('query' => array('op' => 'start', 'id' => $row->bid))),
      ($row->progress * 100) . '%',
      $row->message,
      $row->start ? format_date((int)$row->start, 'small') : t('N/A'),
      $row->end ? format_date((int)$row->end, 'small') : ($eta ? format_date((int)$eta, 'small') : t('N/A')),
    );
  }
  $header = array('Batch ID', 'Progress', 'Message', 'Started', 'Finished/ETA');
  return theme('table', $header, $data);
}

/**
 * Default page callback for batches.
 */
function background_batch_page() {
  require_once './includes/batch.inc';
  $output = _background_batch_page();
  if ($output === FALSE) {
    drupal_access_denied();
  }
  elseif (isset($output)) {
    // Force a page without blocks or messages to
    // display a list of collected messages later.
    print theme('page', $output, FALSE, FALSE);
  }
}

/**
 * State-based dispatcher for the batch processing page.
 */
function _background_batch_page() {
  $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : FALSE;
  if (!$id) {
    return drupal_not_found();
  }
  
  // Retrieve the current state of batch from db.
  $token = drupal_get_token($id);
  $data = db_result(db_query("SELECT batch FROM {batch} WHERE bid = %d AND token = '%s'", $id, $token));
  if (!$data) {
    return drupal_not_found();
  }

  $batch =& batch_get();
  $batch = unserialize($data);

  $op = isset($_REQUEST['op']) ? $_REQUEST['op'] : '';
  switch ($op) {
    case 'start':
      return _background_batch_page_start($id, $token);
    case 'do':
      return _background_batch_page_do_js($id);
    case 'do_nojs':
      return _background_batch_page_do_nojs($id);
    case 'finished':
      require_once('includes/batch.inc');
      progress_remove_progress('_background_batch:' . $id);
      return _batch_finished();
    default:
      drupal_goto('admin/config/system/batch/overview');
  }
}

/**
 * Start a batch job in the background
 *
 * @param $id
 *   Batch ID
 * @param $token
 *   Token of batch job
 * @return type 
 */
function _background_batch_page_start($id, $token) {
  $batch =& batch_get();
  $handle = 'background_batch:' . $id;
  // If batch is already in progress, goto to the status page instead of starting it.
  $process = background_process_get_process($handle);
  $progress = progress_get_progress('_' . $handle);
  if (!$process) {
    if (!$progress || !$progress->end) {
      // Hasn't run yet or has stopped. (re)start batch job.
      // Alter operations
      _background_batch_batch_alter($batch);
      _batch_shutdown();
      $process = new BackgroundProcess($handle);
      $process->service_host = 'background_batch';
      if ($process->lock()) {
        $message = $batch['sets'][0]['init_message'];
        progress_initialize_progress('_' . $handle, $message);
        $result = $process->execute('_background_batch_process', array($id, $token));
      }
    }
    else {
      // Job has already run and finished. Cleanup?
    }
  }
  else {
    // Job running. Goto status page.
  }

  if (isset($_COOKIE['has_js']) && $_COOKIE['has_js']) {
    return _background_batch_page_progress_js();
  }
  else {
    return _background_batch_page_do_nojs();
  }
}

/**
 * Batch processing page with JavaScript support.
 */
function _background_batch_page_progress_js() {
  $batch = batch_get();

  // The first batch set gets to set the page title
  // and the initialization and error messages.
  $current_set = _batch_current_set();
  drupal_set_title($current_set['title']);
  drupal_add_js('misc/progress.js', 'core', 'header', FALSE, FALSE);

  $url = url($batch['url'], array('query' => array('id' => $batch['id'])));
  $js_setting = array(
    'batch' => array(
      'errorMessage' => $current_set['error_message'] .'<br/>'. $batch['error_message'],
      'initMessage' => 'ETA: ' . t('N/A') . '<br/>' . $current_set['init_message'],
      'uri' => $url,
    ),
  );
  drupal_add_js($js_setting, 'setting');
  drupal_add_js('misc/batch.js', 'core', 'header', FALSE, FALSE);

  $output = '<div id="progress"></div>';
  return $output;
}

/**
 * Do one pass of execution and inform back the browser about progression
 * (used for JavaScript-mode only).
 */
function _background_batch_page_do_js($id) {
  // HTTP POST required.
  if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    drupal_set_message(t('HTTP POST is required.'), 'error');
    drupal_set_title(t('Error'));
    return '';
  }

  session_save_session(FALSE);

  // Get progress
  if ($progress = progress_get_progress('_background_batch:' . $id)) {
    $percentage = $progress->progress * 100;
    $message = $progress->message;
    progress_estimate_completion($progress);
    $message = "ETA: " . ($progress->estimate ? format_date((int)$progress->estimate, 'large') : t('N/A')) . "<br/>$message";
  }
  else {
    $percentage = t('N/A');
    $message = '';
  }
  
  usleep(variable_get('background_batch_delay', BACKGROUND_BATCH_DELAY));
  drupal_json(array('status' => TRUE, 'percentage' => sprintf("%.02f", $percentage), 'message' => $message));
}

/**
 * Output a batch processing page without JavaScript support.
 *
 * @see _batch_process()
 */
function _background_batch_page_do_nojs() {
  $batch =& batch_get();
  $current_set = _batch_current_set();

  drupal_set_title($current_set['title']);

  $new_op = 'do_nojs';

  // This is one of the later requests: do some processing first.

  // Error handling: if PHP dies due to a fatal error (e.g. non-existant
  // function), it will output whatever is in the output buffer,
  // followed by the error message.
  ob_start();
  $fallback = $current_set['error_message'] .'<br/>'. $batch['error_message'];
  drupal_maintenance_theme();
  $fallback = theme('maintenance_page', $fallback, FALSE, FALSE);

  // We strip the end of the page using a marker in the template, so any
  // additional HTML output by PHP shows up inside the page rather than
  // below it. While this causes invalid HTML, the same would be true if
  // we didn't, as content is not allowed to appear after </html> anyway.
  list($fallback) = explode('<!--partial-->', $fallback);
  print $fallback;

  // Get progress
  if ($progress = progress_get_progress('_background_batch:' . $id)) {
    $percentage = $progress->progress * 100;
    $message = $progress->message;
    progress_estimate_completion($progress);
    $message = "ETA: " . ($progress->estimate ? format_date((int)$progress->estimate, 'large') : t('N/A')) . "<br/>$message";
  }
  else {
    $percentage = t('N/A');
    $message = '';
  }
  
  if ($percentage == 100) {
    $new_op = 'finished';
  }

  // PHP did not die : remove the fallback output.
  ob_end_clean();

  $url = url($batch['url'], array('query' => array('id' => $batch['id'], 'op' => $new_op)));
  drupal_set_html_head('<meta http-equiv="Refresh" content="0; URL='. $url .'">');
  $output = theme('progress_bar', sprintf("%.02f", $percentage), $message);
  return $output;
}
