// $Id: batch.js,v 1.4 2007/10/21 18:59:01 goba Exp $

/**
 * Start monitoring progress via Ajax.
 */
Drupal.progressBar.prototype.startMonitoring = function (uri, delay, suppress_error) {
  this.delay = delay;
  this.uri = uri;
  if (suppress_error) {
    this.sendPingBackground();
  }
  else {
    this.sendPing();
  }
};

/**
 * Request progress data from server.
 */
Drupal.progressBar.prototype.sendPingBackground = function () {
  if (this.timer) {
    clearTimeout(this.timer);
  }
  if (this.uri) {
    var pb = this;
    // When doing a post request, you need non-null data. Otherwise a
    // HTTP 411 or HTTP 406 (with Apache mod_security) error may result.
    $.ajax({
      type: this.method,
      url: this.uri,
      data: '',
      dataType: 'json',
      success: function (progress) {
        // Update display
        pb.setProgress(progress.percentage, progress.message);
        // Schedule next timer
        pb.timer = setTimeout(function() { pb.sendPingBackground(); }, pb.delay);
      },
      error: function (xmlhttp) {
        pb.displayError(Drupal.ahahError(xmlhttp, pb.uri));
      }
    });
  }
};


/**
 * Attaches the batch behavior to progress bars.
 */
Drupal.behaviors.backgroundBatch = function (context) {
  // This behavior attaches by ID, so is only valid once on a page.
  if ($('#background-progress.batch-processed').size()) {
    return;
  }
  $('#background-progress', context).addClass('batch-processed').each(function () {
    var holder = this;
    var uri = Drupal.settings.batch.uri;
    var initMessage = Drupal.settings.batch.initMessage;
    var errorMessage = Drupal.settings.batch.errorMessage;

    // Success: redirect to the summary.
    var updateCallback = function (progress, status, pb) {
      if (progress == 100) {
        pb.stopMonitoring();
        window.location = uri+'&op=finished';
      }
    };

    var errorCallback = function (pb) {
      var div = document.createElement('p');
      div.className = 'error';
      $(div).html(errorMessage);
      $(holder).prepend(div);
      $('#wait').hide();
    };

    var progress = new Drupal.progressBar('updateprogress', updateCallback, "POST", errorCallback);
    progress.setProgress(-1, initMessage);
    $(holder).append(progress.element);
    progress.startMonitoring(uri+'&op=do', Drupal.settings.batch.delay / 1000, true);
  });
};
