<?php
// $Id: common.inc,v 1.4 2006/05/10 16:10:14 nedjo Exp $

/**
 * Returns the base URL path of the Drupal installation.
 * At the very least, this will always default to /.
 */
function base_path() {
  return $GLOBALS['base_path'];
}

/**
 * Add a JavaScript file to the output.
 *
 * The first time this function is invoked per page request,
 * it adds "misc/drupal.js" to the output. Other scripts
 * depends on the 'killswitch' inside it.
 */
function drupal_add_js($file, $nocache = FALSE) {
  static $sent = array();

  $path = drupal_get_path('module', 'backport');
  $postfix = $nocache ? '?'. time() : '';
  if (!isset($sent[$path .'/drupal.js'])) {
    drupal_set_html_head('<script type="text/javascript" src="'. base_path() . $path .'/drupal.js'. $postfix .'"></script>');
    $sent[$path .'/drupal.js'] = true;
  }
  if (!isset($sent[$file])) {
    drupal_set_html_head('<script type="text/javascript" src="'. check_url(base_path() . $file) . $postfix .'"></script>');
    $sent[$file] = true;
  }
}

/**
 * Generates a Javascript call, while importing the arguments as is.
 * PHP arrays are turned into JS objects to preserve keys. This means the array
 * keys must conform to JS's member naming rules.
 *
 * @param $function
 *   The name of the function to call.
 * @param $arguments
 *   An array of arguments.
 */
function drupal_call_js($function) {
  $arguments = func_get_args();
  array_shift($arguments);
  $args = array();
  foreach ($arguments as $arg) {
    $args[] = drupal_to_js($arg);
  }
  $output = '<script type="text/javascript">'. $function .'('. implode(', ', $args) .');</script>';
  return $output;
}

/**
 * Converts a PHP variable into its Javascript equivalent.
 *
 * We use HTML-safe strings, i.e. with <, > and & escaped.
 */
function drupal_to_js($var) {
  switch (gettype($var)) {
    case 'boolean':
      return $var ? 'true' : 'false'; // Lowercase necessary!
    case 'integer':
    case 'double':
      return $var;
    case 'resource':
    case 'string':
      return '"'. str_replace(array("\r", "\n", "<", ">", "&"),
                              array('\r', '\n', '\x3c', '\x3e', '\x26'),
                              addslashes($var)) .'"';
    case 'array':
      if (array_keys($var) === range(0, sizeof($var) - 1)) {
        $output = array();
        foreach($var as $v) {
          $output[] = drupal_to_js($v);
        }
        return '[ '. implode(', ', $output) .' ]';
      }
      // Fall through
    case 'object':
      $output = array();
      foreach ($var as $k => $v) {
        $output[] = drupal_to_js(strval($k)) .': '. drupal_to_js($v);
      }
      return '{ '. implode(', ', $output) .' }';
    default:
      return 'null';
  }
}

