<?php
// $Id: system.inc,v 1.4 2006/05/10 16:10:14 nedjo Exp $

/**
 * Implementation of hook_elements().
 */
function system_elements() {
  // Top level form
  $type['form'] = array('#method' => 'post', '#action' => request_uri());

  // Inputs
  $type['checkbox'] = array('#input' => TRUE, '#return_value' => 1);
  $type['submit'] = array('#input' => TRUE, '#name' => 'op', '#button_type' => 'submit', '#executes_submit_callback' => TRUE);
  $type['button'] = array('#input' => TRUE, '#name' => 'op', '#button_type' => 'submit', '#executes_submit_callback' => FALSE);
  $type['textfield'] = array('#input' => TRUE, '#size' => 60, '#maxlength' => 128, '#autocomplete_path' => FALSE);
  $type['password'] = array('#input' => TRUE, '#size' => 30);
  $type['password_confirm'] = array('#input' => TRUE, '#process' => array('expand_password_confirm' => array()));
  $type['textarea'] = array('#input' => TRUE, '#cols' => 60, '#rows' => 5);
  $type['radios'] = array('#input' => TRUE, '#process' => array('expand_radios' => array()));
  $type['radio'] = array('#input' => TRUE);
  $type['checkboxes'] = array('#input' => TRUE, '#process' => array('expand_checkboxes' => array()), '#tree' => TRUE);
  $type['select'] = array('#input' => TRUE);
  $type['weight'] = array('#input' => TRUE, '#delta' => 10, '#default_value' => 0);
  $type['date'] = array('#input' => TRUE, '#process' => array('expand_date' => array()));
  $type['file'] = array('#input' => TRUE, '#size' => 60);

  // Form structure
  $type['item'] = array();
  $type['hidden'] = array('#input' => TRUE);
  $type['value'] = array('#input' => TRUE);
  $type['markup'] = array('#prefix' => '', '#suffix' => '');
  $type['fieldset'] = array('#collapsible' => FALSE, '#collapsed' => FALSE);
  return $type;
}

/**
 * Output a confirmation form
 *
 * This function outputs a complete form for confirming an action. A link is
 * offered to go back to the item that is being changed in case the user changes
 * his/her mind.
 *
 * You should use $GLOBALS['values']['edit'][$name] (where $name is usually 'confirm') to
 * check if the confirmation was successful.
 *
 * @param $form_id
 *   The unique form identifier. Used by the form API to construct the theme.
 * @param $form
 *   Additional elements to inject into the form, for example hidden elements.
 * @param $question
 *   The question to ask the user (e.g. "Are you sure you want to delete the
 *   block <em>foo</em>?").
 * @param $path
 *   The page to go to if the user denies the action.
 * @param $description
 *   Additional text to display (defaults to "This action cannot be undone.").
 * @param $yes
 *   A caption for the button which confirms the action (e.g. "Delete",
 *   "Replace", ...).
 * @param $no
 *   A caption for the link which denies the action (e.g. "Cancel").
 * @param $name
 *   The internal name used to refer to the confirmation item.
 * @return
 *   A themed HTML string representing the form.
 */

function confirm_form($form_id, $form, $question, $path, $description = NULL, $yes = NULL, $no = NULL, $name = 'confirm') {

  $description = ($description) ? $description : t('This action cannot be undone.');
  drupal_set_title($question);
  $form['#attributes'] = array('class' => 'confirmation');
  $form['description'] = array('#value' => $description);
  $form[$name] = array('#type' => 'hidden', '#value' => 1);

  $form['actions'] = array('#prefix' => '<div class="container-inline">', '#suffix' => '</div>');
  $form['actions']['submit'] = array('#type' => 'submit', '#value' => $yes ? $yes : t('Confirm'));
  $form['actions']['cancel'] = array('#value' => l($no ? $no : t('Cancel'), $path));
  return drupal_get_form($form_id, $form, 'confirm_form');
}
