# Backport Composer

A very lightweight module that registers Composer's Autoloader in Drupal 7.

This module is primarily to support the [Backport](https://www.drupal.org/project/backport)
module as the preferred or "native" Composer solution in Drupal 7, similar to
what is now done in Drupal 8.

This is, essentially, a standalone implementation and not a heavy hitter solution
like [Composer Manager](https://www.drupal.org/project/composer_manager).

### Installation

1. Copy the module into your `sites/all/modules` folder.
2. Go to `/admin/modules` and enable the `Backport Composer` in the `Utilities`
   section (or if you use Drush: `drush en backport_composer`).

### Configuration

This module attempts to locate an `autoload.php` file in the one of the following
"common" Drupal 8 locations:

- `./DOCROOT/autoload.php` - Top level, where `DOCROOT` === `DRUPAL_ROOT`
- `./DOCROOT/vendor/autoload.php` - Inside top level `vendor` directory
- `./DOCROOT/../autoload.php` - One level up (just outside `DOCROOT`)
- `./DOCROOT/../vendor/autoload.php` - Inside `vendor` directory, one level up
   (just outside `DOCROOT`)
   
It also supports automated detection of configuration based paths, e.g. where
`CONF_PATH` === `sites/default` or `sites/example.com`. This allows for easier
migration for an existing site that wishes to change from something a little more
complex like [Composer Manager](https://www.drupal.org/project/composer_manager)
to this module: 

- `./DOCROOT/CONF_PATH/autoload.php` - Top level site configuration path
- `./DOCROOT/CONF_PATH/vendor/autoload.php` - Inside `vendor` director, within
  the site configuration path.

Note: the automated discovery of `autoload.php` is cached. If its location changes,
you will need to clear the database cache for it to rediscover it. This is primarily
to reduce unnecessary calls to check if files exist on each bootstrap.

If you have Composer installed at a different location there are a couple ways you
can customize which autoloader is used:

1. Create a custom file in the root of your site (e.g. `./DOCROOT/autoload.php`)
   and then return the autoloader from a different location (like what Drupal 8 does):
   ```php
   <?php
   // Note: you should always use `require` instead of `require_once` as the latter
   // will return TRUE instead of the autoloader instance if it has already been
   // required in PHP (which can be a possibility). 
   return require '/absolute/path/to/composer/vendor/autoload.php';
   ```
2. Set the following variable in your site's `settings.php` or `settings.local.php`
   file to an absolute path where the Composer autoloader resides. Note: if this
   variable is set, it will take precedence over any automated discovery:
   ```php
   <?php
   $conf['backport_composer_autoload_path'] = '/absolute/path/to/composer/vendor/autoload.php';
   ```
