(function ($, Drupal, once) {
  Drupal.behaviors.requireCtrlForDelete = {
    attach(context, settings) {
      once(
        'requireCtrlForDelete',
        '#delete-unselected-scenarios-button',
        context,
      ).forEach(function (element) {
        $(element).on('click', function (e) {
          if (!e.ctrlKey) {
            e.preventDefault();
            alert(
              "To delete all unselected scenarios, press the Control key when clicking the 'Delete Unselected' button.",
            );
          }
        });
      });
    },
  };
})(jQuery, Drupal, once);
