---
title: Color system
status_issue: https://github.com/github/design-systems/issues/301
status: New release
source: https://github.com/primer/primer/blob/master/modules/primer-support/lib/variables/color-system.scss
---

{:toc}

## Color palette

<div class="markdown-no-margin mb-6 d-flex h5">
  <div class="gray-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end text-white">Gray</p>
  </div>
  <div class="blue-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end text-white">Blue</p>
  </div>
  <div class="green-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end text-white">Green</p>
  </div>
  <div class="purple-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end text-white">Purple</p>
  </div>
  <div class="yellow-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end">Yellow</p>
  </div>
  <div class="orange-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end">Orange</p>
  </div>
  <div class="red-500 d-flex color-square mr-2">
    <p class="p-3 flex-self-end text-white">Red</p>
  </div>
  <div class="bg-white d-flex color-square border border-gray-dark">
    <p class="p-3 flex-self-end">White</p>
  </div>
</div>

## Color variables

<div class="d-flex flex-wrap gutter">

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Gray</h3>
    <div class="gray-500 my-2 p-3">
      <p class="text-white f00-light pb-3">Gray</p>
      <div class="d-flex text-white">
        <p class="h4 flex-auto">$gray-500</p>
        <p class="text-right text-mono flex-auto">#6a737d</p>
      </div>
    </div>
    <div class="gray-000 h4">
      <p class="p-3">$gray-000</p>
    </div>
    <div class="gray-100 h4">
      <p class="p-3">$gray-100</p>
    </div>
    <div class="gray-200 h4">
      <p class="p-3">$gray-200</p>
    </div>
    <div class="gray-300 h4">
      <p class="p-3">$gray-300</p>
    </div>
    <div class="gray-400 h4">
      <p class="p-3">$gray-400</p>
    </div>
    <div class="gray-500 h4">
      <p class="p-3 text-white">$gray-500</p>
    </div>
    <div class="gray-600 h4">
      <p class="p-3 text-white">$gray-600</p>
    </div>
    <div class="gray-700 h4">
      <p class="p-3 text-white">$gray-700</p>
    </div>
    <div class="gray-800 h4">
      <p class="p-3 text-white">$gray-800</p>
    </div>
    <div class="gray-900 h4">
      <p class="p-3 text-white">$gray-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Blue</h3>
    <div class="blue-500 my-2 p-3">
      <p class="text-white f00-light pb-3">Blue</p>
      <div class="d-flex text-white">
        <p class="h4 flex-auto">$blue-500</p>
        <p class="text-right text-mono flex-auto">#0366d6</p>
      </div>
    </div>
    <div class="blue-000 h4">
      <p class="p-3">$blue-000</p>
    </div>
    <div class="blue-100 h4">
      <p class="p-3">$blue-100</p>
    </div>
    <div class="blue-200 h4">
      <p class="p-3">$blue-200</p>
    </div>
    <div class="blue-300 h4">
      <p class="p-3">$blue-300</p>
    </div>
    <div class="blue-400 h4">
      <p class="p-3">$blue-400</p>
    </div>
    <div class="blue-500 h4">
      <p class="p-3 text-white">$blue-500</p>
    </div>
    <div class="blue-600 h4">
      <p class="p-3 text-white">$blue-600</p>
    </div>
    <div class="blue-700 h4">
      <p class="p-3 text-white">$blue-700</p>
    </div>
    <div class="blue-800 h4">
      <p class="p-3 text-white">$blue-800</p>
    </div>
    <div class="blue-900 h4">
      <p class="p-3 text-white">$blue-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Green</h3>
    <div class="green-500 my-2 p-3">
      <p class="text-white f00-light pb-3">Green</p>
      <div class="d-flex text-white">
        <p class="h4 flex-auto">$green-500</p>
        <p class="text-right text-mono flex-auto">#28a745</p>
      </div>
    </div>
    <div class="green-000 h4">
      <p class="p-3">$green-000</p>
    </div>
    <div class="green-100 h4">
      <p class="p-3">$green-100</p>
    </div>
    <div class="green-200 h4">
      <p class="p-3">$green-200</p>
    </div>
    <div class="green-300 h4">
      <p class="p-3">$green-300</p>
    </div>
    <div class="green-400 h4">
      <p class="p-3">$green-400</p>
    </div>
    <div class="green-500 h4">
      <p class="p-3 text-white">$green-500</p>
    </div>
    <div class="green-600 h4">
      <p class="p-3 text-white">$green-600</p>
    </div>
    <div class="green-700 h4">
      <p class="p-3 text-white">$green-700</p>
    </div>
    <div class="green-800 h4">
      <p class="p-3 text-white">$green-800</p>
    </div>
    <div class="green-900 h4">
      <p class="p-3 text-white">$green-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Purple</h3>
    <div class="purple-500 text-white my-2 p-3">
      <p class="f00-light pb-3">Purple</p>
      <div class="d-flex">
        <p class="h4 flex-auto">$purple-500</p>
        <p class="text-right text-mono flex-auto">#6f42c1</p>
      </div>
    </div>
    <div class="purple-000 h4">
      <p class="p-3">$purple-000</p>
    </div>
    <div class="purple-100 h4">
      <p class="p-3">$purple-100</p>
    </div>
    <div class="purple-200 h4">
      <p class="p-3">$purple-200</p>
    </div>
    <div class="purple-300 h4">
      <p class="p-3">$purple-300</p>
    </div>
    <div class="purple-400 h4">
      <p class="p-3">$purple-400</p>
    </div>
    <div class="purple-500 h4">
      <p class="p-3 text-white">$purple-500</p>
    </div>
    <div class="purple-600 h4">
      <p class="p-3 text-white">$purple-600</p>
    </div>
    <div class="purple-700 h4">
      <p class="p-3 text-white">$purple-700</p>
    </div>
    <div class="purple-800 h4">
      <p class="p-3 text-white">$purple-800</p>
    </div>
    <div class="purple-900 h4">
      <p class="p-3 text-white">$purple-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Yellow</h3>
    <div class="yellow-500 my-2 p-3">
      <p class="f00-light pb-3">Yellow</p>
      <div class="d-flex">
        <p class="h4 flex-auto">$yellow-500</p>
        <p class="text-right text-mono flex-auto">#ffd93d</p>
      </div>
    </div>
    <div class="yellow-000 h4">
      <p class="p-3">$yellow-000</p>
    </div>
    <div class="yellow-100 h4">
      <p class="p-3">$yellow-100</p>
    </div>
    <div class="yellow-200 h4">
      <p class="p-3">$yellow-200</p>
    </div>
    <div class="yellow-300 h4">
      <p class="p-3">$yellow-300</p>
    </div>
    <div class="yellow-400 h4">
      <p class="p-3">$yellow-400</p>
    </div>
    <div class="yellow-500 h4">
      <p class="p-3">$yellow-500</p>
    </div>
    <div class="yellow-600 h4">
      <p class="p-3">$yellow-600</p>
    </div>
    <div class="yellow-700 h4">
      <p class="p-3">$yellow-700</p>
    </div>
    <div class="yellow-800 h4">
      <p class="p-3 text-white">$yellow-800</p>
    </div>
    <div class="yellow-900 h4">
      <p class="p-3 text-white">$yellow-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Orange</h3>
    <div class="orange-500 my-2 p-3 text-white">
      <p class="f00-light pb-3">Orange</p>
      <div class="d-flex">
        <p class="h4 flex-auto">$orange-500</p>
        <p class="text-right text-mono flex-auto">#f66a0a</p>
      </div>
    </div>
    <div class="orange-000 h4">
      <p class="p-3">$orange-000</p>
    </div>
    <div class="orange-100 h4">
      <p class="p-3">$orange-100</p>
    </div>
    <div class="orange-200 h4">
      <p class="p-3">$orange-200</p>
    </div>
    <div class="orange-300 h4">
      <p class="p-3">$orange-300</p>
    </div>
    <div class="orange-400 h4">
      <p class="p-3">$orange-400</p>
    </div>
    <div class="orange-500 h4">
      <p class="p-3 text-white">$orange-500</p>
    </div>
    <div class="orange-600 h4">
      <p class="p-3 text-white">$orange-600</p>
    </div>
    <div class="orange-700 h4">
      <p class="p-3 text-white">$orange-700</p>
    </div>
    <div class="orange-800 h4">
      <p class="p-3 text-white">$orange-800</p>
    </div>
    <div class="orange-900 h4">
      <p class="p-3 text-white">$orange-900</p>
    </div>
  </div>

  <div class="mb-6 flex-column col-6 markdown-no-margin">
    <h3>Red</h3>
    <div class="red-500 text-white my-2 p-3">
      <p class="f00-light pb-3">Red</p>
      <div class="d-flex">
        <p class="h4 flex-auto">$red-500</p>
        <p class="text-right text-mono flex-auto">#dc3545</p>
      </div>
    </div>
    <div class="red-000 h4">
      <p class="p-3">$red-000</p>
    </div>
    <div class="red-100 h4">
      <p class="p-3">$red-100</p>
    </div>
    <div class="red-200 h4">
      <p class="p-3">$red-200</p>
    </div>
    <div class="red-300 h4">
      <p class="p-3">$red-300</p>
    </div>
    <div class="red-400 h4">
      <p class="p-3">$red-400</p>
    </div>
    <div class="red-500 h4">
      <p class="p-3 text-white">$red-500</p>
    </div>
    <div class="red-600 h4">
      <p class="p-3 text-white">$red-600</p>
    </div>
    <div class="red-700 h4">
      <p class="p-3 text-white">$red-700</p>
    </div>
    <div class="red-800 h4">
      <p class="p-3 text-white">$red-800</p>
    </div>
    <div class="red-900 h4">
      <p class="p-3 text-white">$red-900</p>
    </div>
  </div>

<div class="mb-6 flex-column col-6">
</div>
  <!-- Gray and fades (headings inside the markup) -->

  <div class="mb-3 flex-column col-6 markdown-no-margin">
    <h3>Black fades</h3>
    <div class="black text-white my-2 p-3">
      <p class="f00-light pb-3">Black</p>
      <div class="d-flex pb-1">
        <p class="h4 flex-auto">$black</p>
        <p class="text-right text-mono flex-auto"><code>rgb(27,31,35)</code> #1b1f23</p>
      </div>
      <p class="f5 pt-3 border-top border-white">Black fades apply alpha transparency to the <strong>$black</strong> variable. The black color value has a slight blue hue to match our grays.</p>
    </div>
    <div class="black-fade-15">
      <p class="h4 p-3">$black-fade-15</p>
    </div>
    <div class="black-fade-30">
      <p class="h4 p-3">$black-fade-30</p>
    </div>
    <div class="black-fade-50">
      <p class="h4 p-3">$black-fade-50</p>
    </div>
    <div class="black-fade-70">
      <p class="h4 p-3 text-white">$black-fade-70</p>
    </div>
    <div class="black-fade-85">
      <p class="h4 p-3 text-white">$black-fade-85</p>
    </div>
  </div>

  <div class="mb-3 flex-column col-6 markdown-no-margin">
    <h3>White fades</h3>
    <div class="bg-white border text-gray-dark my-2 p-3">
      <p class="f00-light pb-3">White</p>
      <div class="d-flex pb-1">
        <p class="h4 flex-auto">$white</p>
        <p class="text-right text-mono flex-auto"><code>rgb(255, 255, 255)</code> #fff</p>
      </div>
      <p class="f5 pt-3 border-top border-white">White fades apply alpha transparency to the <strong>$white</strong> variable, below these are shown overlaid on a dark gray background.</p>
    </div>
    <div class="bg-gray-dark pr-4">
      <div class="white-fade-15">
        <p class="h4 p-3 text-white">$white-fade-15</p>
      </div>
      <div class="white-fade-30">
        <p class="h4 p-3 text-white">$white-fade-30</p>
      </div>
      <div class="white-fade-50">
        <p class="h4 p-3">$white-fade-50</p>
      </div>
      <div class="white-fade-70">
        <p class="h4 p-3">$white-fade-70</p>
      </div>
      <div class="white-fade-85">
        <p class="h4 p-3">$white-fade-85</p>
      </div>
    </div>


</div>

</div>
