<?php
/**
 * @file
 * Contains BackupMigrate\Core\Service\StashLogger
 */


namespace BackupMigrate\Core\Service;


use Psr\Log\AbstractLogger;

/**
 * Saves log entries to memory to be processed during the current process.
 * This simple service does no clearing or memory management so should not be
 * used for a long-running process.
 *
 * Class StashLogger
 * @package BackupMigrate\Core\Service
 */
class StashLogger extends AbstractLogger {
  /**
   * @var array
   */
  protected $logs = [];

  /**
   * Logs with an arbitrary level.
   *
   * @param mixed $level
   * @param string $message
   * @param array $context
   *
   * @return null
   */
  public function log($level, $message, array $context = array()) {
    $this->logs[] = ['level' => $level, 'message' => $message, 'context' => $context];
  }

  /**
   * Get all of the log messages that were saved to this stash.
   *
   * @return array
   */
  public function getAll() {
    return $this->logs;
  }
}