Backup & Migrate Dropbox
========================

This module provides Dropbox as a destination to Backup & Migrate, allowing to
backup your site's data and files offsite into the cloud.

It allows you to:
- Define Dropbox destinations.
- Manually backup to Dropbox.
- Define schedules using a Dropbox destination to automatically backup to
  Dropbox.
- See a list of saved backups in your Dropbox destination.
- Restore from a backup in your Dropbox destination.
- Delete backups saved in your Dropbox destination.

Requirements
------------
- PHP 5.4 or later.
- Backup and Migrate 7.x-3.0 or later

Installation
------------
As usual. After enabling the module you can define (a) Dropbox destination(s)
and define schedules using this/those destinations.

Defining a Dropbox destination
------------------------------
Dropbox part:
1. Create or Login to your Dropbox account.
2. Go to https://www.dropbox.com/developers.
3. Click on the "Create app" button.
4. Select "Dropbox API".
5. Select "App folder". This will protect the rest of your Dropbox in case your
   site is compromised.
6. Enter an app name and create it. Note that the app name must be globally
   unique, so you may have to retry it a few times. Using your website name may
   help.
7. Set “Allow implicit grant” to “Disallow”.
8. Click op “Generate” below “Generated access token”.
9. Copy the token to your clipboard.

Drupal part:
1. Go to "Configuration - System - Backup and Migrate - Settings -
   Destinations - Add destination".
2. Select "Dropbox" from the off-site destinations list.
3. Fill in a "Destination name".
3. Optionally fill in the name of a subdirectory to place the backups to this
   destination in. E.g. use this if you have multiple destinations for this site
   (daily, weekly, ...) or multiple sites that backup to this account (mysite1,
   mysite2/daily, mysite2/weekly, ...).
4. Paste the token into the "Dropbox Access Token" field.
5. Click on "Save destination".

Test if everything works fine by doing a manual backup to the newly created
destination.

Troubleshooting
---------------
- If you receive out of memory errors use either Drush or the variables module
  to set the 'backup_migrate_dropbox_upload_limit' variable. Set the variable as
  high as possible without receiving an out of memory errors to ensure maximum
  performance.
- If you receive a 4XX error check that the access token is correct or generate
  a new token and copy it over.
- If you receive a 5XX error check status.dropbox.com to insure the the server
  is up and running.
- If you receive a different error please create an issue on the Backup Migrate
  Dropbox module page at https://www.drupal.org/project/backup_migrate_dropbox.
