<?php

/**
 * @file
 * Export role(s) and their associated permissions into csv.
 */

/**
 * Form constructor for resetting permission states of chosen roles.
 *
 * @see backup_permissions_select_roles_to_reset_submit()
 *
 * @ingroup forms
 */
function backup_permissions_reset_roles_data($form, &$form_state, $arg) {
  backup_permissions_backup_exist($arg);
  $data = _backup_permissions_get_roles_permissions($arg);
  return backup_permissions_select_roles_to_reset($data);
}

/**
 * Form constructor for export roles permissions as an array structure.
 *
 * @see permissions_export_rpermissions_export_form_submit()
 * @see permissions_export_rpermissions_export_form_validate()
 * @see _export_import_roles_permissions_get_importable_roles_permissions()
 */
function backup_permissions_export_form($form, &$form_state, $arg) {

  // Get Importable array structure as string.
  $export_data = unserialize(_backup_permissions_get_roles_permissions($arg));
  $export_data = drupal_json_encode($export_data);

  $export_desc = "For importing copy the content of the text area and paste";
  $export_desc .= " it into the import page.";
  $form['export_code'] = array(
    '#type' => 'textarea',
    '#title' => t('Export'),
    '#default_value' => $export_data,
    '#rows' => 15,
    '#description' => check_plain($export_desc),
  );

  $link = l(t('<< Back'), 'admin/people/permissions/backup_permissions');
  $form['back'] = array(
    '#type' => 'item',
    '#markup' => $link,
  );

  return $form;
}

/**
 * Fetched backup by backup id.
 */
function _backup_permissions_get_roles_permissions($arg) {
  $result = db_select('backup_permissions', 'pb')
    ->fields('pb')
    ->condition('id', $arg, '=')
    ->execute()
    ->fetch();
  return $result->backup;
}

/**
 * Menu callback function for exporting permissions as CSV.
 */
function backup_permissions_download_csv($arg) {
  $data = unserialize(_backup_permissions_get_roles_permissions($arg));
  $rows = $data['permissions'];
  $flat = backup_permissions_assoc_to_csv($rows);
  return backup_permissions_array_to_csv_download($flat, "backup_permissions.csv");
}

/**
 * Returns associative array of permission data.
 *
 * @param array $data
 *   Array of permissions and roles.
 *
 * @return array
 *   Associative array of permissions and roles.
 */
function backup_permissions_assoc_to_csv(array $data) {
  $labels = array_keys($data[0]);
  $data_out = array($labels);
  foreach ($data as $assoc_row) {
    $data_out[] = array_values($assoc_row);
  }
  return $data_out;
}
