<?php

/**
 * @file
 * Import role(s) and their associated permissions into csv.
 */

/**
 * Form constructor for import permissions from CSV.
 *
 * @see backup_permissions_import_form_validate()
 * @see backup_permissions_import_form_submit()
 */
function backup_permissions_import_form($form, &$form_state) {
  $form = array();

  if (isset($form_state['values']['backup_data']) && !empty($form_state['values']['backup_data'])) {
    $form = backup_permissions_select_roles_to_reset($form_state['values']['backup_data']);
  }
  else {
    $form['import'] = array(
      '#title' => t('Import'),
      '#type' => 'managed_file',
      '#description' => t('Allowed extensions: CSV'),
      '#upload_location' => 'public://tmp/',
      '#upload_validators' => array(
        'file_validate_extensions' => array('csv'),
      ),
      '#required' => TRUE,
    );
    $form['backup_data'] = array(
      '#type' => 'hidden',
      '#value' => '',
    );
    $form['submit'] = array(
      '#type' => 'submit',
      '#value' => t('Import Permissions'),
    );
    $link = l(t('cancel'), 'admin/people/permissions/backup_permissions');
    $form['back'] = array(
      '#type' => 'item',
      '#markup' => $link,
      '#prefix' => '<div style="display: inline-block">',
      '#suffix' => '</div>',
    );
  }
  return $form;
}

/**
 * Validate CSV file.
 *
 * @see backup_permissions_import_form()
 * @see backup_permissions_import_form_submit()
 */
function backup_permissions_import_form_validate($form, $form_state) {
  if (empty($form_state['values']['backup_data'])) {
    $file_id = $form_state['values']['import'];
    if (!$file_id) {
      file_save_upload('import', array(
        'file_validate_extensions' => array('csv'),
      ));
    }
  }
}

/**
 * Execute CSV file to restore permissions.
 *
 * @see backup_permissions_import_form()
 * @see backup_permissions_import_form_submit()
 */
function backup_permissions_import_form_submit($form, &$form_state) {
  if (empty($form_state['values']['backup_data'])) {
    $file_id = $form_state['values']['import'];
    $file = file_load($file_id);
    $uri = $file->uri;
    $handle = fopen($uri, 'r');
    $rows = array();
    $row = fgetcsv($handle);
    $columns = array();
    foreach ($row as $i => $header) {
      $columns[$i] = trim($header);
    }

    while ($row = fgetcsv($handle)) {
      $record = array();
      foreach ($row as $i => $field) {
        // This is pretty brittle... if someone screws up the field
        // names the data won't be written.
        $record[$columns[$i]] = $field;
      }
      $rows[] = $record;
    }
    fclose($handle);
    array_shift($columns);
    $data = array();
    $data['roles'] = $columns;
    $data['permissions'] = $rows;
    $form_state['values']['backup_data'] = serialize($data);
  }

  $form_state['rebuild'] = TRUE;
}
