<?php

namespace Drupal\badge_notification\Controller;

use Drupal\badge_notification\Plugin\BadgeNotificationBase;
use Drupal\badge_notification\Plugin\BadgeNotificationManager;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * BadgesAsync controller.
 */
class BadgeNotificationController extends ControllerBase {

  protected $badgeNotificationManager;
  protected $entityTypeManager;

  public function __construct(BadgeNotificationManager $badgeNotificationManager, EntityTypeManagerInterface $entityTypeManager) {
    $this->badgeNotificationManager = $badgeNotificationManager;
    $this->entityTypeManager = $entityTypeManager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.badge_notification'),
      $container->get('entity_type.manager'),
    );
  }

  /**
   * Returns json response
   */
  public function json(Request $request) {
    $content = json_decode($request->getContent(), TRUE);
    $plugins = [];
    $badges = [];

    // Fetch badge plugins
    foreach ($content['badges'] as $id => $badge) {

      if (empty($badge['plugin-name'])) {
        continue;
      } elseif (!empty($plugins[$badge['plugin-name']])) {
        /** @var BadgeNotificationBase $plugin */
        $plugin = $plugins[$badge['plugin-name']];
      } else {
        /** @var BadgeNotificationBase $plugin */
        $plugin = $this->badgeNotificationManager->createInstance($badge['plugin-name']);
        $plugins[$badge['plugin-name']] = $plugin;
      }

      $badges[$id] = $plugin->badgeResult($id, $badge['attributes']);
    }

    return new JsonResponse([
      'badges' => $badges,
    ]);
  }

}
