<?php

namespace Drupal\badge_notification\Plugin\BadgeNotification;

use Drupal\badge_notification\Annotation\BadgeNotification;
use Drupal\badge_notification\Plugin\BadgeNotificationBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\badge_notification\Service\BadgeNotificationMenu;

/**
 * Plugin implementation of the 'views_has_new' badge notification.
 *
 * @BadgeNotification(
 *   id = "views_has_new",
 *   label = @Translation("Views has new"),
 *   has_menu_notification = true
 * )
 */
class ViewsHasNew extends BadgeNotificationBase implements ContainerFactoryPluginInterface {

  private static $cache = [];

  protected $configFactory;
  protected $database;
  protected $currentUser;
  protected $entityTypeManager;
  protected $renderer;
  protected $badgeNotificationMenu;

  /**
   * @param array $configuration
   * @param $plugin_id
   * @param $plugin_definition
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   * @param \Drupal\Core\Database\Connection $database
   * @param \Drupal\Core\Session\AccountProxyInterface $currentUser
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   * @param \Drupal\Core\Render\RendererInterface $renderer
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    ConfigFactoryInterface $configFactory,
    Connection $database,
    AccountProxyInterface $currentUser,
    EntityTypeManagerInterface $entityTypeManager,
    RendererInterface $renderer,
    BadgeNotificationMenu $badgeNotificationMenu
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->configFactory = $configFactory;
    $this->database = $database;
    $this->currentUser = $currentUser;
    $this->entityTypeManager = $entityTypeManager;
    $this->renderer = $renderer;
    $this->badgeNotificationMenu = $badgeNotificationMenu;
  }

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static (
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('config.factory'),
      $container->get('database'),
      $container->get('current_user'),
      $container->get('entity_type.manager'),
      $container->get('renderer'),
      $container->get('badge_notification.menu')
    );
  }

  /**
   * Output badge html
   * @param string $badge_id
   * @param string $attributes
   */
  public function badgeResult(string $badge_id, string $attributes) {
    $count = $this->badgeNotificationMenu->viewsCountNew($attributes);

    $element = [
      '#theme' => 'badge_notification',
      '#content' => $count ? t('new') : '',
    ];

    return $this->renderer->render($element);
  }

}
