<?php

namespace Drupal\badge_notification\Service;

use Drupal\Core\Config\ConfigFactoryInterface;

class BadgeNotificationCore {

  protected $configFactory;
  protected $statusDisplay;
  protected $timeLimit;

  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
    $this->defineBadgeNotificationSettings();
  }

  private function defineBadgeNotificationSettings() {
    $config = $this->configFactory->get('badge_notification.settings');
    $this->statusDisplay = $config->get('status_display') ?: ['new' => 'new', 'updated' => 0];
    $days_limit = $config->get('days_limit') ?: 7;
    $this->timeLimit = strtotime('-' . $days_limit . ' day', \Drupal::time()->getRequestTime());
  }

  public function getStatusDisplay() {
    return $this->statusDisplay;
  }

  public function getTimeLimit() {
    return $this->timeLimit;
  }

}
