<?php

namespace Drupal\badge_notification\Service;

use Drupal\badge_notification\Plugin\BadgeNotificationManager;
use Drupal\views\Views;
use Drupal\Core\StringTranslation\TranslatableMarkup;

class BadgeNotificationMenu {

  protected $badgeNotificationManager;

  public function __construct(BadgeNotificationManager $badgeNotificationManager) {
    $this->badgeNotificationManager = $badgeNotificationManager;
  }

  public function getHandlersOptions() {
    $options = ['' => t('None')];

    $definitions = $this->badgeNotificationManager->getDefinitions();
    $views_options = $this->getHandlersViewsOptions();

    foreach ($definitions as $definition) {

      if (empty($definition['has_menu_notification'])) {
        continue;
      }

      /** @var TranslatableMarkup $group */
      $group = $definition['label'];
      $group_label = $group->render();

      foreach ($views_options as $key => $view_option) {
        $group_key = implode('::', [$definition['id'], $key]);
        $options[$group_label][$group_key] = $view_option;
      }
    }

    return $options;
  }

  public function getHandlersViewsOptions() {
    $options = [];
    $views = Views::getEnabledViews();

    foreach ($views as $view) {
      if ($view->get('base_table') !== 'node_field_data') {
        continue;
      }

      $options[$view->id()] = $view->label();
      $displays = $view->get('display');

      foreach ($displays as $display) {
        if ($display['id'] === 'default') {
          continue;
        }

        $key = implode('::', [$view->id(), $display['id']]);
        $options[$key] = '-- '.$display['display_title'];
      }
    }

    return $options;
  }

  public function renderMenuLinkcontentPlaceholderAttributes(string $badge_notification_option) {
    $option_array = explode('::', $badge_notification_option);
    $plugin_name = array_shift($option_array);

    return [
      'class' => 'badge-notification-placeholder',
      'data-id' => uniqid('badge-'),
      'data-plugin-name' => $plugin_name,
      'data-attributes' => implode('/', $option_array),
    ];
  }

  public function getView(string $attributes) {
    $view_setup = $this->resolvePluginAttributes($attributes);

    if (empty($view_setup['id'])) {
      return false;
    }

    $view_id = $view_setup['id'];
    $view_display = $view_setup['display'] ?: 'default';
    $view_arguments = $view_setup['arguments'] ?: [];

    $view = Views::getView($view_id);
    $view->views_count_new = true;
    $view->setDisplay($view_display);
    $view->setArguments($view_arguments);
    $view->execute();

    return $view;
  }

  public function resolvePluginAttributes(string $attributes) {

    $attributes_array = explode('/', $attributes);

    return [
      'id' => array_shift($attributes_array),
      'display' => array_shift($attributes_array),
      'arguments' => $attributes_array,
    ];

  }

  public function viewsCountNew(string $attributes) {

    $view = $this->getView($attributes);

    if (!$view) {
      return false;
    }

    return $view->total_rows;
  }

}
