<?php

namespace Drupal\badge_notification\Controller;

use Drupal\badge_notification\Plugin\BadgeNotificationManager;
use Drupal\Component\Serialization\Json;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Render\RendererInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * BadgesAsync controller.
 */
class BadgeNotificationController extends ControllerBase {

  protected $badgeNotificationManager;
  protected $entityTypeManager;
  protected $renderer;

  /**
   * {@inheritdoc}
   */
  public function __construct(BadgeNotificationManager $badgeNotificationManager,
                              EntityTypeManagerInterface $entityTypeManager,
                              RendererInterface $renderer) {
    $this->badgeNotificationManager = $badgeNotificationManager;
    $this->entityTypeManager = $entityTypeManager;
    $this->renderer = $renderer;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.badge_notification'),
      $container->get('entity_type.manager'),
      $container->get('renderer'),
    );
  }

  /**
   * Returns json response.
   */
  public function json(Request $request): JsonResponse {
    $content = json_decode($request->getContent(), TRUE);
    $plugins = [];
    $badges = [];

    // Fetch badge plugins.
    foreach ($content['badges'] as $id => $badge) {
      if (empty($badge['plugin-name'])) {
        continue;
      }
      elseif (!empty($plugins[$badge['plugin-name']])) {
        /** @var \Drupal\badge_notification\Plugin\BadgeNotificationBase $plugin */
        $plugin = $plugins[$badge['plugin-name']];
      }
      else {
        /** @var \Drupal\badge_notification\Plugin\BadgeNotificationBase $plugin */
        $plugin = $this->badgeNotificationManager->createInstance($badge['plugin-name']);
        $plugins[$badge['plugin-name']] = $plugin;
      }

      $badge_result = $plugin->badgeResult($id, $badge['attributes']);

      if ($badge_result) {
        $element = [
          '#theme' => 'badge_notification',
          '#content' => $badge_result,
        ];

        $badges[$id] = $this->renderer->render($element);
      }

    }

    return new JsonResponse([
      'badges' => $badges,
    ]);
  }

}
