<?php

namespace Drupal\badge_notification\Plugin\BadgeNotification;

use Drupal\badge_notification\Plugin\BadgeNotificationBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\badge_notification\Service\BadgeNotificationMenu;

/**
 * Plugin implementation of the 'views_count_new' badge notification.
 *
 * @BadgeNotification(
 *   id = "views_count_new",
 *   label = @Translation("Views count new"),
 *   has_menu_notification = true
 * )
 */
class ViewsCountNew extends BadgeNotificationBase implements ContainerFactoryPluginInterface {

  protected $configFactory;
  protected $database;
  protected $currentUser;
  protected $entityTypeManager;
  protected $badgeNotificationMenu;

  /**
   * @param array $configuration
   * @param $plugin_id
   * @param $plugin_definition
   * @param \Drupal\Core\Database\Connection $database
   * @param \Drupal\Core\Session\AccountProxyInterface $currentUser
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   * @param \Drupal\badge_notification\Service\BadgeNotificationMenu $badgeNotificationMenu
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    Connection $database,
    AccountProxyInterface $currentUser,
    EntityTypeManagerInterface $entityTypeManager,
    BadgeNotificationMenu $badgeNotificationMenu
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->database = $database;
    $this->currentUser = $currentUser;
    $this->entityTypeManager = $entityTypeManager;
    $this->badgeNotificationMenu = $badgeNotificationMenu;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('database'),
      $container->get('current_user'),
      $container->get('entity_type.manager'),
      $container->get('badge_notification.menu')
    );
  }

  /**
   * Return badge content.
   *
   * @param string $badge_id
   * @param string $attributes
   *
   * @return string
   *
   * @throws \Exception
   */
  public function badgeResult(string $badge_id, string $attributes): string {
    $count = $this->badgeNotificationMenu->viewsCountNew($attributes);
    if (!$count) {
      return '';
    }

    return $count;
  }

}
