<?php

namespace Drupal\badge_notification\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Component\Datetime\TimeInterface;

/**
 * BadgeNotification Core class.
 *
 * Helper functions to get module settings.
 */
class BadgeNotificationCore {

  /**
   * Configuration factory.
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Datetime
   * @var TimeInterface
   */
  protected $datetime;

  /**
   * Status display configuration.
   *
   * @var mixed
   */
  protected $statusDisplay;

  /**
   * Date limit configuration.
   *
   * @var string
   */
  protected $timeLimit;

  /**
   * Constructs a BadgeNotification Core object.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   * @param \Drupal\Component\Datetime\TimeInterface $datetime
   */
  public function __construct(ConfigFactoryInterface $configFactory, TimeInterface $datetime) {
    $this->configFactory = $configFactory;
    $this->datetime = $datetime;

    $config = $this->configFactory->get('badge_notification.settings');
    $this->statusDisplay = $config->get('status_display') ?: [
      'new' => 'new',
      'updated' => 0,
    ];
    $days_limit = $config->get('days_limit') ?: 7;
    $this->timeLimit = strtotime('-' . $days_limit . ' day', $this->datetime->getRequestTime());
  }

  /**
   * Return status display settings.
   * @return array
   */
  public function getStatusDisplay(): array {
    return $this->statusDisplay;
  }

  /**
   * Return time limit settings.
   */
  public function getTimeLimit() {
    return $this->timeLimit;
  }

}
