<?php

/**
 * @file
 * Plugin for the BagIt Drupal module that adds files attached to nodes using
 * the CCK FileField module.
 */

/**
 * Returns an array of file paths and names managed by CCK filefield fields.
 * Returns FALSE if no file are present or if FileField is not enabled.
 */
function bagit_plugin_copy_filefield_init($node) {
  $files_to_add = array();
  if (!module_exists('filefield')) {
    return FALSE;
  }

  $file_fields = bagit_get_fields_filefield();
  // Check for the existence of each field in the node, and if it exists,
  // get the files managed by each field and add their paths and names to
  // $files_to_add.
  foreach ($file_fields as $cck_field) {
    if (isset($node->$cck_field)) {
      // Each field can manage more than one file.
      if (count($node->$cck_field)) {
        foreach ($node->$cck_field as $file) {
          $extras = bagit_build_file_extra(array($file, array('field' => $cck_field)));
          if (isset($file['filepath'])) {
            $files_to_add[] = array(
              'path' => $file['filepath'],
              'name' => $file['filename'],
              'extra' => $extras
            );
          }
        }
      }
    }
  }

  if (count($files_to_add)) {
    return $files_to_add;
  }
  else {
    return FALSE;
  }
}

/**
 * Get list of CCK fields that are of filefield type.
 */
function bagit_plugin_copy_filefield_get_fields() {
  $fields = array();
  $result = db_query("SELECT field_name FROM {content_node_field} WHERE type = 'filefield'");
  while ($data = db_fetch_object($result)) {
    $fields[] = $data->field_name;
  }
  return $fields;
}
