<?php

/**
 * @file
 * Plugin for the BagIt Drupal module that adds files attached to nodes using
 * the Drupal 6 core Upload module.
 */

/**
 * Returns an array of file paths and names identified in $node->files. Returns
 * FALSE if no files are present.
 */
function bagit_plugin_copy_upload_init($node) {
  if (!module_exists('upload')) {
    return FALSE;
  }

  $files_to_add = array();
  if (!count($node->files)) {
    return FALSE;
  }

  foreach ($node->files as $file) {
    $extras = bagit_build_file_extra(array($file));
    $files_to_add[] = array(
      'path' => $file->filepath,
      'name' => $file->filename,
      'extras' => $extras
    );
  }
  return $files_to_add;
}
