/**
 * @file
 * BaguetteBox behaviours.
 */

(function ($, drupalSettings) {

  'use strict';

  Drupal.behaviors.baguetteBox = {
    attach: function (context) {

      var settings = drupalSettings.baguettebox;

      var captions = false;
      if (settings.captionsSource != 'none') {
        captions = function (a) {
          var $img = $(a).find('img');
          console.log(settings.captionsSource);
          var attribute = settings.captionsSource == 'image_title' ?
            'title' : 'alt';
          return $img.attr(attribute);
        };
      }

      baguetteBox.run('.baguettebox', {
        captions: captions,
        animation: settings.animation,
        buttons: settings.buttons ? 'auto' : false,
        fullScreen: settings.fullScreen,
        noScrollbars: settings.hideScrollbars
      });

    }
  };

})(jQuery, drupalSettings);
