<?php
/**
 * @file
 * Utility to get region name (Federal Information Processing Standards).
 */

 /**
 * Get region name (Federal Information Processing Standards).
 *
 * @param $country_code
 *   ISO 3166 2-character country code.
 * @param $region_code
 *   Region code (FIPS).
 * @return
 *   Region name.
 */
function smart_ip_get_region($country_code, $region_code) {
  $region_codes = array(
    'AD' => array(
      '02' => t('Canillo'),
      '03' => t('Encamp'),
      '04' => t('La Massana'),
      '05' => t('Ordino'),
      '06' => t('Sant Julia de Loria'),
      '07' => t('Andorra la Vella'),
      '08' => t('Escaldes-Engordany'),
    ),
    'AE' => array(
      '01' => t('Abu Dhabi'),
      '02' => t('Ajman'),
      '03' => t('Dubai'),
      '04' => t('Fujairah'),
      '05' => t('Ras Al Khaimah'),
      '06' => t('Sharjah'),
      '07' => t('Umm Al Quwain'),
    ),
    'AF' => array(
      '01' => t('Badakhshan'),
      '02' => t('Badghis'),
      '03' => t('Baghlan'),
      '05' => t('Bamian'),
      '06' => t('Farah'),
      '07' => t('Faryab'),
      '08' => t('Ghazni'),
      '09' => t('Ghowr'),
      '10' => t('Helmand'),
      '11' => t('Herat'),
      '13' => t('Kabol'),
      '14' => t('Kapisa'),
      '15' => t('Konar'),
      '16' => t('Laghman'),
      '17' => t('Lowgar'),
      '18' => t('Nangarhar'),
      '19' => t('Nimruz'),
      '21' => t('Paktia'),
      '22' => t('Parvan'),
      '23' => t('Kandahar'),
      '24' => t('Kondoz'),
      '26' => t('Takhar'),
      '27' => t('Vardak'),
      '28' => t('Zabol'),
      '29' => t('Paktika'),
      '30' => t('Balkh'),
      '31' => t('Jowzjan'),
      '32' => t('Samangan'),
      '33' => t('Sar-e Pol'),
      '34' => t('Konar'),
      '35' => t('Laghman'),
      '36' => t('Paktia'),
      '37' => t('Khowst'),
      '38' => t('Nurestan'),
      '39' => t('Oruzgan'),
      '40' => t('Parvan'),
      '41' => t('Daykondi'),
      '42' => t('Panjshir'),
    ),
    'AG' => array(
      '01' => t('Barbuda'),
      '03' => t('Saint George'),
      '04' => t('Saint John'),
      '05' => t('Saint Mary'),
      '06' => t('Saint Paul'),
      '07' => t('Saint Peter'),
      '08' => t('Saint Philip'),
    ),
    'AL' => array(
      '40' => t('Berat'),
      '41' => t('Diber'),
      '42' => t('Durres'),
      '43' => t('Elbasan'),
      '44' => t('Fier'),
      '45' => t('Gjirokaster'),
      '46' => t('Korce'),
      '47' => t('Kukes'),
      '48' => t('Lezhe'),
      '49' => t('Shkoder'),
      '50' => t('Tirane'),
      '51' => t('Vlore'),
    ),
    'AM' => array(
      '01' => t('Aragatsotn'),
      '02' => t('Ararat'),
      '03' => t('Armavir'),
      '04' => t("Geghark'unik'"),
      '05' => t("Kotayk'"),
      '06' => t('Lorri'),
      '07' => t('Shirak'),
      '08' => t("Syunik'"),
      '09' => t('Tavush'),
      '10' => t("Vayots' Dzor"),
      '11' => t('Yerevan'),
    ),
    'AO' => array(
      '01' => t('Benguela'),
      '02' => t('Bie'),
      '03' => t('Cabinda'),
      '04' => t('Cuando Cubango'),
      '05' => t('Cuanza Norte'),
      '06' => t('Cuanza Sul'),
      '07' => t('Cunene'),
      '08' => t('Huambo'),
      '09' => t('Huila'),
      '10' => t('Luanda'),
      '12' => t('Malanje'),
      '13' => t('Namibe'),
      '14' => t('Moxico'),
      '15' => t('Uige'),
      '16' => t('Zaire'),
      '17' => t('Lunda Norte'),
      '18' => t('Lunda Sul'),
      '19' => t('Bengo'),
      '20' => t('Luanda'),
    ),
    'AR' => array(
      '01' => t('Buenos Aires'),
      '02' => t('Catamarca'),
      '03' => t('Chaco'),
      '04' => t('Chubut'),
      '05' => t('Cordoba'),
      '06' => t('Corrientes'),
      '07' => t('Distrito Federal'),
      '08' => t('Entre Rios'),
      '09' => t('Formosa'),
      '10' => t('Jujuy'),
      '11' => t('La Pampa'),
      '12' => t('La Rioja'),
      '13' => t('Mendoza'),
      '14' => t('Misiones'),
      '15' => t('Neuquen'),
      '16' => t('Rio Negro'),
      '17' => t('Salta'),
      '18' => t('San Juan'),
      '19' => t('San Luis'),
      '20' => t('Santa Cruz'),
      '21' => t('Santa Fe'),
      '22' => t('Santiago del Estero'),
      '23' => t('Tierra del Fuego'),
      '24' => t('Tucuman'),
    ),
    'AT' => array(
      '01' => t('Burgenland'),
      '02' => t('Karnten'),
      '03' => t('Niederosterreich'),
      '04' => t('Oberosterreich'),
      '05' => t('Salzburg'),
      '06' => t('Steiermark'),
      '07' => t('Tirol'),
      '08' => t('Vorarlberg'),
      '09' => t('Wien'),
    ),
    'AU' => array(
      '01' => t('Australian Capital Territory'),
      '02' => t('New South Wales'),
      '03' => t('Northern Territory'),
      '04' => t('Queensland'),
      '05' => t('South Australia'),
      '06' => t('Tasmania'),
      '07' => t('Victoria'),
      '08' => t('Western Australia'),
    ),
    'AZ' => array(
      '01' => t('Abseron'),
      '02' => t('Agcabadi'),
      '03' => t('Agdam'),
      '04' => t('Agdas'),
      '05' => t('Agstafa'),
      '06' => t('Agsu'),
      '07' => t('Ali Bayramli'),
      '08' => t('Astara'),
      '09' => t('Baki'),
      '10' => t('Balakan'),
      '11' => t('Barda'),
      '12' => t('Beylaqan'),
      '13' => t('Bilasuvar'),
      '14' => t('Cabrayil'),
      '15' => t('Calilabad'),
      '16' => t('Daskasan'),
      '17' => t('Davaci'),
      '18' => t('Fuzuli'),
      '19' => t('Gadabay'),
      '20' => t('Ganca'),
      '21' => t('Goranboy'),
      '22' => t('Goycay'),
      '23' => t('Haciqabul'),
      '24' => t('Imisli'),
      '25' => t('Ismayilli'),
      '26' => t('Kalbacar'),
      '27' => t('Kurdamir'),
      '28' => t('Lacin'),
      '29' => t('Lankaran'),
      '30' => t('Lankaran'),
      '31' => t('Lerik'),
      '32' => t('Masalli'),
      '33' => t('Mingacevir'),
      '34' => t('Naftalan'),
      '35' => t('Naxcivan'),
      '36' => t('Neftcala'),
      '37' => t('Oguz'),
      '38' => t('Qabala'),
      '39' => t('Qax'),
      '40' => t('Qazax'),
      '41' => t('Qobustan'),
      '42' => t('Quba'),
      '43' => t('Qubadli'),
      '44' => t('Qusar'),
      '45' => t('Saatli'),
      '46' => t('Sabirabad'),
      '47' => t('Saki'),
      '48' => t('Saki'),
      '49' => t('Salyan'),
      '50' => t('Samaxi'),
      '51' => t('Samkir'),
      '52' => t('Samux'),
      '53' => t('Siyazan'),
      '54' => t('Sumqayit'),
      '55' => t('Susa'),
      '56' => t('Susa'),
      '57' => t('Tartar'),
      '58' => t('Tovuz'),
      '59' => t('Ucar'),
      '60' => t('Xacmaz'),
      '61' => t('Xankandi'),
      '62' => t('Xanlar'),
      '63' => t('Xizi'),
      '64' => t('Xocali'),
      '65' => t('Xocavand'),
      '66' => t('Yardimli'),
      '67' => t('Yevlax'),
      '68' => t('Yevlax'),
      '69' => t('Zangilan'),
      '70' => t('Zaqatala'),
      '71' => t('Zardab'),
    ),
    'BA' => array(
      '01' => t('Federation of Bosnia and Herzegovina'),
      '02' => t('Republika Srpska'),
    ),
    'BB' => array(
      '01' => t('Christ Church'),
      '02' => t('Saint Andrew'),
      '03' => t('Saint George'),
      '04' => t('Saint James'),
      '05' => t('Saint John'),
      '06' => t('Saint Joseph'),
      '07' => t('Saint Lucy'),
      '08' => t('Saint Michael'),
      '09' => t('Saint Peter'),
      '10' => t('Saint Philip'),
      '11' => t('Saint Thomas'),
    ),
    'BD' => array(
      '01' => t('Barisal'),
      '04' => t('Bandarban'),
      '05' => t('Comilla'),
      '12' => t('Mymensingh'),
      '13' => t('Noakhali'),
      '15' => t('Patuakhali'),
      '22' => t('Bagerhat'),
      '23' => t('Bhola'),
      '24' => t('Bogra'),
      '25' => t('Barguna'),
      '26' => t('Brahmanbaria'),
      '27' => t('Chandpur'),
      '28' => t('Chapai Nawabganj'),
      '29' => t('Chattagram'),
      '30' => t('Chuadanga'),
      '31' => t("Cox's Bazar"),
      '32' => t('Dhaka'),
      '33' => t('Dinajpur'),
      '34' => t('Faridpur'),
      '35' => t('Feni'),
      '36' => t('Gaibandha'),
      '37' => t('Gazipur'),
      '38' => t('Gopalganj'),
      '39' => t('Habiganj'),
      '40' => t('Jaipurhat'),
      '41' => t('Jamalpur'),
      '42' => t('Jessore'),
      '43' => t('Jhalakati'),
      '44' => t('Jhenaidah'),
      '45' => t('Khagrachari'),
      '46' => t('Khulna'),
      '47' => t('Kishorganj'),
      '48' => t('Kurigram'),
      '49' => t('Kushtia'),
      '50' => t('Laksmipur'),
      '51' => t('Lalmonirhat'),
      '52' => t('Madaripur'),
      '53' => t('Magura'),
      '54' => t('Manikganj'),
      '55' => t('Meherpur'),
      '56' => t('Moulavibazar'),
      '57' => t('Munshiganj'),
      '58' => t('Naogaon'),
      '59' => t('Narail'),
      '60' => t('Narayanganj'),
      '61' => t('Narsingdi'),
      '62' => t('Nator'),
      '63' => t('Netrakona'),
      '64' => t('Nilphamari'),
      '65' => t('Pabna'),
      '66' => t('Panchagar'),
      '67' => t('Parbattya Chattagram'),
      '68' => t('Pirojpur'),
      '69' => t('Rajbari'),
      '70' => t('Rajshahi'),
      '71' => t('Rangpur'),
      '72' => t('Satkhira'),
      '73' => t('Shariyatpur'),
      '74' => t('Sherpur'),
      '75' => t('Sirajganj'),
      '76' => t('Sunamganj'),
      '77' => t('Sylhet'),
      '78' => t('Tangail'),
      '79' => t('Thakurgaon'),
      '81' => t('Dhaka'),
      '82' => t('Khulna'),
      '83' => t('Rajshahi'),
      '84' => t('Chittagong'),
      '85' => t('Barisal'),
      '86' => t('Sylhet'),
    ),
    'BE' => array(
      '01' => t('Antwerpen'),
      '02' => t('Brabant'),
      '03' => t('Hainaut'),
      '04' => t('Liege'),
      '05' => t('Limburg'),
      '06' => t('Luxembourg'),
      '07' => t('Namur'),
      '08' => t('Oost-Vlaanderen'),
      '09' => t('West-Vlaanderen'),
      '10' => t('Brabant Wallon'),
      '11' => t('Brussels Hoofdstedelijk Gewest'),
      '12' => t('Vlaams-Brabant'),
    ),
    'BF' => array(
      '15' => t('Bam'),
      '19' => t('Boulkiemde'),
      '20' => t('Ganzourgou'),
      '21' => t('Gnagna'),
      '28' => t('Kouritenga'),
      '33' => t('Oudalan'),
      '34' => t('Passore'),
      '36' => t('Sanguie'),
      '40' => t('Soum'),
      '42' => t('Tapoa'),
      '44' => t('Zoundweogo'),
      '45' => t('Bale'),
      '46' => t('Banwa'),
      '47' => t('Bazega'),
      '48' => t('Bougouriba'),
      '49' => t('Boulgou'),
      '50' => t('Gourma'),
      '51' => t('Houet'),
      '52' => t('Ioba'),
      '53' => t('Kadiogo'),
      '54' => t('Kenedougou'),
      '55' => t('Komoe'),
      '56' => t('Komondjari'),
      '57' => t('Kompienga'),
      '58' => t('Kossi'),
      '59' => t('Koulpelogo'),
      '60' => t('Kourweogo'),
      '61' => t('Leraba'),
      '62' => t('Loroum'),
      '63' => t('Mouhoun'),
      '64' => t('Namentenga'),
      '65' => t('Naouri'),
      '66' => t('Nayala'),
      '67' => t('Noumbiel'),
      '68' => t('Oubritenga'),
      '69' => t('Poni'),
      '70' => t('Sanmatenga'),
      '71' => t('Seno'),
      '72' => t('Sissili'),
      '73' => t('Sourou'),
      '74' => t('Tuy'),
      '75' => t('Yagha'),
      '76' => t('Yatenga'),
      '77' => t('Ziro'),
      '78' => t('Zondoma'),
    ),
    'BG' => array(
      '33' => t('Mikhaylovgrad'),
      '38' => t('Blagoevgrad'),
      '39' => t('Burgas'),
      '40' => t('Dobrich'),
      '41' => t('Gabrovo'),
      '42' => t('Grad Sofiya'),
      '43' => t('Khaskovo'),
      '44' => t('Kurdzhali'),
      '45' => t('Kyustendil'),
      '46' => t('Lovech'),
      '47' => t('Montana'),
      '48' => t('Pazardzhik'),
      '49' => t('Pernik'),
      '50' => t('Pleven'),
      '51' => t('Plovdiv'),
      '52' => t('Razgrad'),
      '53' => t('Ruse'),
      '54' => t('Shumen'),
      '55' => t('Silistra'),
      '56' => t('Sliven'),
      '57' => t('Smolyan'),
      '58' => t('Sofiya'),
      '59' => t('Stara Zagora'),
      '60' => t('Turgovishte'),
      '61' => t('Varna'),
      '62' => t('Veliko Turnovo'),
      '63' => t('Vidin'),
      '64' => t('Vratsa'),
      '65' => t('Yambol'),
    ),
    'BH' => array(
      '01' => t('Al Hadd'),
      '02' => t('Al Manamah'),
      '03' => t('Al Muharraq'),
      '05' => t('Jidd Hafs'),
      '06' => t('Sitrah'),
      '07' => t("Ar Rifa' wa al Mintaqah al Janubiyah"),
      '08' => t('Al Mintaqah al Gharbiyah'),
      '09' => t('Mintaqat Juzur Hawar'),
      '10' => t('Al Mintaqah ash Shamaliyah'),
      '11' => t('Al Mintaqah al Wusta'),
      '12' => t('Madinat'),
      '13' => t('Ar Rifa'),
      '14' => t('Madinat Hamad'),
      '15' => t('Al Muharraq'),
      '16' => t('Al Asimah'),
      '17' => t('Al Janubiyah'),
      '18' => t('Ash Shamaliyah'),
      '19' => t('Al Wusta'),
    ),
    'BI' => array(
      '02' => t('Bujumbura'),
      '09' => t('Bubanza'),
      '10' => t('Bururi'),
      '11' => t('Cankuzo'),
      '12' => t('Cibitoke'),
      '13' => t('Gitega'),
      '14' => t('Karuzi'),
      '15' => t('Kayanza'),
      '16' => t('Kirundo'),
      '17' => t('Makamba'),
      '18' => t('Muyinga'),
      '19' => t('Ngozi'),
      '20' => t('Rutana'),
      '21' => t('Ruyigi'),
      '22' => t('Muramvya'),
      '23' => t('Mwaro'),
    ),
    'BJ' => array(
      '01' => t('Atakora'),
      '02' => t('Atlantique'),
      '03' => t('Borgou'),
      '04' => t('Mono'),
      '05' => t('Oueme'),
      '06' => t('Zou'),
      '07' => t('Alibori'),
      '08' => t('Atakora'),
      '09' => t('Atlanyique'),
      '10' => t('Borgou'),
      '11' => t('Collines'),
      '12' => t('Kouffo'),
      '13' => t('Donga'),
      '14' => t('Littoral'),
      '15' => t('Mono'),
      '16' => t('Oueme'),
      '17' => t('Plateau'),
      '18' => t('Zou'),
    ),
    'BM' => array(
      '01' => t('Devonshire'),
      '02' => t('Hamilton'),
      '03' => t('Hamilton'),
      '04' => t('Paget'),
      '05' => t('Pembroke'),
      '06' => t('Saint George'),
      '07' => t("Saint George's"),
      '08' => t('Sandys'),
      '09' => t('Smiths'),
      '10' => t('Southampton'),
      '11' => t('Warwick'),
    ),
    'BN' => array(
      '07' => t('Alibori'),
      '08' => t('Belait'),
      '09' => t('Brunei and Muara'),
      '10' => t('Temburong'),
      '11' => t('Collines'),
      '12' => t('Kouffo'),
      '13' => t('Donga'),
      '14' => t('Littoral'),
      '15' => t('Tutong'),
      '16' => t('Oueme'),
      '17' => t('Plateau'),
      '18' => t('Zou'),
    ),
    'BO' => array(
      '01' => t('Chuquisaca'),
      '02' => t('Cochabamba'),
      '03' => t('El Beni'),
      '04' => t('La Paz'),
      '05' => t('Oruro'),
      '06' => t('Pando'),
      '07' => t('Potosi'),
      '08' => t('Santa Cruz'),
      '09' => t('Tarija'),
    ),
    'BR' => array(
      '01' => t('Acre'),
      '02' => t('Alagoas'),
      '03' => t('Amapa'),
      '04' => t('Amazonas'),
      '05' => t('Bahia'),
      '06' => t('Ceara'),
      '07' => t('Distrito Federal'),
      '08' => t('Espirito Santo'),
      '11' => t('Mato Grosso do Sul'),
      '13' => t('Maranhao'),
      '14' => t('Mato Grosso'),
      '15' => t('Minas Gerais'),
      '16' => t('Para'),
      '17' => t('Paraiba'),
      '18' => t('Parana'),
      '20' => t('Piaui'),
      '21' => t('Rio de Janeiro'),
      '22' => t('Rio Grande do Norte'),
      '23' => t('Rio Grande do Sul'),
      '24' => t('Rondonia'),
      '25' => t('Roraima'),
      '26' => t('Santa Catarina'),
      '27' => t('Sao Paulo'),
      '28' => t('Sergipe'),
      '29' => t('Goias'),
      '30' => t('Pernambuco'),
      '31' => t('Tocantins'),
    ),
    'BS' => array(
      '05' => t('Bimini'),
      '06' => t('Cat Island'),
      '10' => t('Exuma'),
      '13' => t('Inagua'),
      '15' => t('Long Island'),
      '16' => t('Mayaguana'),
      '18' => t('Ragged Island'),
      '22' => t('Harbour Island'),
      '23' => t('New Providence'),
      '24' => t('Acklins and Crooked Islands'),
      '25' => t('Freeport'),
      '26' => t('Fresh Creek'),
      '27' => t("Governor's Harbour"),
      '28' => t('Green Turtle Cay'),
      '29' => t('High Rock'),
      '30' => t('Kemps Bay'),
      '31' => t('Marsh Harbour'),
      '32' => t('Nichollstown and Berry Islands'),
      '33' => t('Rock Sound'),
      '34' => t('Sandy Point'),
      '35' => t('San Salvador and Rum Cay'),
    ),
    'BT' => array(
      '05' => t('Bumthang'),
      '06' => t('Chhukha'),
      '07' => t('Chirang'),
      '08' => t('Daga'),
      '09' => t('Geylegphug'),
      '10' => t('Ha'),
      '11' => t('Lhuntshi'),
      '12' => t('Mongar'),
      '13' => t('Paro'),
      '14' => t('Pemagatsel'),
      '15' => t('Punakha'),
      '16' => t('Samchi'),
      '17' => t('Samdrup'),
      '18' => t('Shemgang'),
      '19' => t('Tashigang'),
      '20' => t('Thimphu'),
      '21' => t('Tongsa'),
      '22' => t('Wangdi Phodrang'),
    ),
    'BW' => array(
      '01' => t('Central'),
      '03' => t('Ghanzi'),
      '04' => t('Kgalagadi'),
      '05' => t('Kgatleng'),
      '06' => t('Kweneng'),
      '08' => t('North-East'),
      '09' => t('South-East'),
      '10' => t('Southern'),
      '11' => t('North-West'),
    ),
    'BY' => array(
      '01' => t("Brestskaya Voblasts'"),
      '02' => t("Homyel'skaya Voblasts'"),
      '03' => t("Hrodzyenskaya Voblasts'"),
      '04' => t('Minsk'),
      '05' => t("Minskaya Voblasts'"),
      '06' => t("Mahilyowskaya Voblasts'"),
      '07' => t("Vitsyebskaya Voblasts'"),
    ),
    'BZ' => array(
      '01' => t('Belize'),
      '02' => t('Cayo'),
      '03' => t('Corozal'),
      '04' => t('Orange Walk'),
      '05' => t('Stann Creek'),
      '06' => t('Toledo'),
    ),
    'CA' => array(
      'AB' => t('Alberta'),
      'BC' => t('British Columbia'),
      'MB' => t('Manitoba'),
      'NB' => t('New Brunswick'),
      'NL' => t('Newfoundland'),
      'NS' => t('Nova Scotia'),
      'NT' => t('Northwest Territories'),
      'NU' => t('Nunavut'),
      'ON' => t('Ontario'),
      'PE' => t('Prince Edward Island'),
      'QC' => t('Quebec'),
      'SK' => t('Saskatchewan'),
      'YT' => t('Yukon Territory'),
    ),
    'CD' => array(
      '01' => t('Bandundu'),
      '02' => t('Equateur'),
      '04' => t('Kasai-Oriental'),
      '05' => t('Katanga'),
      '06' => t('Kinshasa'),
      '07' => t('Kivu'),
      '08' => t('Bas-Congo'),
      '09' => t('Orientale'),
      '10' => t('Maniema'),
      '11' => t('Nord-Kivu'),
      '12' => t('Sud-Kivu'),
      '13' => t('Cuvette'),
    ),
    'CF' => array(
      '01' => t('Bamingui-Bangoran'),
      '02' => t('Basse-Kotto'),
      '03' => t('Haute-Kotto'),
      '04' => t('Mambere-Kadei'),
      '05' => t('Haut-Mbomou'),
      '06' => t('Kemo'),
      '07' => t('Lobaye'),
      '08' => t('Mbomou'),
      '09' => t('Nana-Mambere'),
      '11' => t('Ouaka'),
      '12' => t('Ouham'),
      '13' => t('Ouham-Pende'),
      '14' => t('Cuvette-Ouest'),
      '15' => t('Nana-Grebizi'),
      '16' => t('Sangha-Mbaere'),
      '17' => t('Ombella-Mpoko'),
      '18' => t('Bangui'),
    ),
    'CG' => array(
      '01' => t('Bouenza'),
      '03' => t('Cuvette'),
      '04' => t('Kouilou'),
      '05' => t('Lekoumou'),
      '06' => t('Likouala'),
      '07' => t('Niari'),
      '08' => t('Plateaux'),
      '10' => t('Sangha'),
      '11' => t('Pool'),
      '12' => t('Brazzaville'),
    ),
    'CH' => array(
      '01' => t('Aargau'),
      '02' => t('Ausser-Rhoden'),
      '03' => t('Basel-Landschaft'),
      '04' => t('Basel-Stadt'),
      '05' => t('Bern'),
      '06' => t('Fribourg'),
      '07' => t('Geneve'),
      '08' => t('Glarus'),
      '09' => t('Graubunden'),
      '10' => t('Inner-Rhoden'),
      '11' => t('Luzern'),
      '12' => t('Neuchatel'),
      '13' => t('Nidwalden'),
      '14' => t('Obwalden'),
      '15' => t('Sankt Gallen'),
      '16' => t('Schaffhausen'),
      '17' => t('Schwyz'),
      '18' => t('Solothurn'),
      '19' => t('Thurgau'),
      '20' => t('Ticino'),
      '21' => t('Uri'),
      '22' => t('Valais'),
      '23' => t('Vaud'),
      '24' => t('Zug'),
      '25' => t('Zurich'),
      '26' => t('Jura'),
    ),
    'CI' => array(
      '05' => t('Atacama'),
      '06' => t('Biobio'),
      '51' => t('Sassandra'),
      '61' => t('Abidjan'),
      '74' => t('Agneby'),
      '75' => t('Bafing'),
      '76' => t('Bas-Sassandra'),
      '77' => t('Denguele'),
      '78' => t('Dix-Huit Montagnes'),
      '79' => t('Fromager'),
      '80' => t('Haut-Sassandra'),
      '81' => t('Lacs'),
      '82' => t('Lagunes'),
      '83' => t('Marahoue'),
      '84' => t('Moyen-Cavally'),
      '85' => t('Moyen-Comoe'),
      '86' => t("N'zi-Comoe"),
      '87' => t('Savanes'),
      '88' => t('Sud-Bandama'),
      '89' => t('Sud-Comoe'),
      '90' => t('Vallee du Bandama'),
      '91' => t('Worodougou'),
      '92' => t('Zanzan'),
    ),
    'CL' => array(
      '01' => t('Valparaiso'),
      '02' => t('Aisen del General Carlos Ibanez del Campo'),
      '03' => t('Antofagasta'),
      '04' => t('Araucania'),
      '05' => t('Atacama'),
      '06' => t('Bio-Bio'),
      '07' => t('Coquimbo'),
      '08' => t("Libertador General Bernardo O'Higgins"),
      '09' => t('Los Lagos'),
      '10' => t('Magallanes y de la Antartica Chilena'),
      '11' => t('Maule'),
      '12' => t('Region Metropolitana'),
      '13' => t('Tarapaca'),
    ),
    'CM' => array(
      '04' => t('Est'),
      '05' => t('Littoral'),
      '07' => t('Nord-Ouest'),
      '08' => t('Ouest'),
      '09' => t('Sud-Ouest'),
      '10' => t('Adamaoua'),
      '11' => t('Centre'),
      '12' => t('Extreme-Nord'),
      '13' => t('Nord'),
      '14' => t('Sud'),
    ),
    'CN' => array(
      '01' => t('Anhui'),
      '02' => t('Zhejiang'),
      '03' => t('Jiangxi'),
      '04' => t('Jiangsu'),
      '05' => t('Jilin'),
      '06' => t('Qinghai'),
      '07' => t('Fujian'),
      '08' => t('Heilongjiang'),
      '09' => t('Henan'),
      '10' => t('Hebei'),
      '11' => t('Hunan'),
      '12' => t('Hubei'),
      '13' => t('Xinjiang'),
      '14' => t('Xizang'),
      '15' => t('Gansu'),
      '16' => t('Guangxi'),
      '18' => t('Guizhou'),
      '19' => t('Liaoning'),
      '20' => t('Nei Mongol'),
      '21' => t('Ningxia'),
      '22' => t('Beijing'),
      '23' => t('Shanghai'),
      '24' => t('Shanxi'),
      '25' => t('Shandong'),
      '26' => t('Shaanxi'),
      '28' => t('Tianjin'),
      '29' => t('Yunnan'),
      '30' => t('Guangdong'),
      '31' => t('Hainan'),
      '32' => t('Sichuan'),
      '33' => t('Chongqing'),
    ),
    'CO' => array(
      '01' => t('Amazonas'),
      '02' => t('Antioquia'),
      '03' => t('Arauca'),
      '04' => t('Atlantico'),
      '05' => t('Bolivar Department'),
      '06' => t('Boyaca Department'),
      '07' => t('Caldas Department'),
      '08' => t('Caqueta'),
      '09' => t('Cauca'),
      '10' => t('Cesar'),
      '11' => t('Choco'),
      '12' => t('Cordoba'),
      '14' => t('Guaviare'),
      '15' => t('Guainia'),
      '16' => t('Huila'),
      '17' => t('La Guajira'),
      '18' => t('Magdalena Department'),
      '19' => t('Meta'),
      '20' => t('Narino'),
      '21' => t('Norte de Santander'),
      '22' => t('Putumayo'),
      '23' => t('Quindio'),
      '24' => t('Risaralda'),
      '25' => t('San Andres y Providencia'),
      '26' => t('Santander'),
      '27' => t('Sucre'),
      '28' => t('Tolima'),
      '29' => t('Valle del Cauca'),
      '30' => t('Vaupes'),
      '31' => t('Vichada'),
      '32' => t('Casanare'),
      '33' => t('Cundinamarca'),
      '34' => t('Distrito Especial'),
      '35' => t('Bolivar'),
      '36' => t('Boyaca'),
      '37' => t('Caldas'),
      '38' => t('Magdalena'),
    ),
    'CR' => array(
      '01' => t('Alajuela'),
      '02' => t('Cartago'),
      '03' => t('Guanacaste'),
      '04' => t('Heredia'),
      '06' => t('Limon'),
      '07' => t('Puntarenas'),
      '08' => t('San Jose'),
    ),
    'CU' => array(
      '01' => t('Pinar del Rio'),
      '02' => t('Ciudad de la Habana'),
      '03' => t('Matanzas'),
      '04' => t('Isla de la Juventud'),
      '05' => t('Camaguey'),
      '07' => t('Ciego de Avila'),
      '08' => t('Cienfuegos'),
      '09' => t('Granma'),
      '10' => t('Guantanamo'),
      '11' => t('La Habana'),
      '12' => t('Holguin'),
      '13' => t('Las Tunas'),
      '14' => t('Sancti Spiritus'),
      '15' => t('Santiago de Cuba'),
      '16' => t('Villa Clara'),
    ),
    'CV' => array(
      '01' => t('Boa Vista'),
      '02' => t('Brava'),
      '04' => t('Maio'),
      '05' => t('Paul'),
      '07' => t('Ribeira Grande'),
      '08' => t('Sal'),
      '10' => t('Sao Nicolau'),
      '11' => t('Sao Vicente'),
      '13' => t('Mosteiros'),
      '14' => t('Praia'),
      '15' => t('Santa Catarina'),
      '16' => t('Santa Cruz'),
      '17' => t('Sao Domingos'),
      '18' => t('Sao Filipe'),
      '19' => t('Sao Miguel'),
      '20' => t('Tarrafal'),
    ),
    'CY' => array(
      '01' => t('Famagusta'),
      '02' => t('Kyrenia'),
      '03' => t('Larnaca'),
      '04' => t('Nicosia'),
      '05' => t('Limassol'),
      '06' => t('Paphos'),
    ),
    'CZ' => array(
      '03' => t('Blansko'),
      '04' => t('Breclav'),
      '20' => t('Hradec Kralove'),
      '21' => t('Jablonec nad Nisou'),
      '23' => t('Jicin'),
      '24' => t('Jihlava'),
      '30' => t('Kolin'),
      '33' => t('Liberec'),
      '36' => t('Melnik'),
      '37' => t('Mlada Boleslav'),
      '39' => t('Nachod'),
      '41' => t('Nymburk'),
      '45' => t('Pardubice'),
      '52' => t('Hlavni mesto Praha'),
      '61' => t('Semily'),
      '70' => t('Trutnov'),
      '78' => t('Jihomoravsky kraj'),
      '79' => t('Jihocesky kraj'),
      '80' => t('Vysocina'),
      '81' => t('Karlovarsky kraj'),
      '82' => t('Kralovehradecky kraj'),
      '83' => t('Liberecky kraj'),
      '84' => t('Olomoucky kraj'),
      '85' => t('Moravskoslezsky kraj'),
      '86' => t('Pardubicky kraj'),
      '87' => t('Plzensky kraj'),
      '88' => t('Stredocesky kraj'),
      '89' => t('Ustecky kraj'),
      '90' => t('Zlinsky kraj'),
    ),
    'DE' => array(
      '01' => t('Baden-Wurttemberg'),
      '02' => t('Bayern'),
      '03' => t('Bremen'),
      '04' => t('Hamburg'),
      '05' => t('Hessen'),
      '06' => t('Niedersachsen'),
      '07' => t('Nordrhein-Westfalen'),
      '08' => t('Rheinland-Pfalz'),
      '09' => t('Saarland'),
      '10' => t('Schleswig-Holstein'),
      '11' => t('Brandenburg'),
      '12' => t('Mecklenburg-Vorpommern'),
      '13' => t('Sachsen'),
      '14' => t('Sachsen-Anhalt'),
      '15' => t('Thuringen'),
      '16' => t('Berlin'),
    ),
    'DJ' => array(
      '01' => t('Ali Sabieh'),
      '04' => t('Obock'),
      '05' => t('Tadjoura'),
      '06' => t('Dikhil'),
      '07' => t('Djibouti'),
      '08' => t('Arta'),
    ),
    'DK' => array(
      '01' => t('Arhus'),
      '02' => t('Bornholm'),
      '03' => t('Frederiksborg'),
      '04' => t('Fyn'),
      '05' => t('Kobenhavn'),
      '06' => t('Staden Kobenhavn'),
      '07' => t('Nordjylland'),
      '08' => t('Ribe'),
      '09' => t('Ringkobing'),
      '10' => t('Roskilde'),
      '11' => t('Sonderjylland'),
      '12' => t('Storstrom'),
      '13' => t('Vejle'),
      '14' => t('Vestsjalland'),
      '15' => t('Viborg'),
      '17' => t('Hovedstaden'),
      '18' => t('Midtjyllen'),
      '19' => t('Nordjylland'),
      '20' => t('Sjelland'),
      '21' => t('Syddanmark'),
    ),
    'DM' => array(
      '02' => t('Saint Andrew'),
      '03' => t('Saint David'),
      '04' => t('Saint George'),
      '05' => t('Saint John'),
      '06' => t('Saint Joseph'),
      '07' => t('Saint Luke'),
      '08' => t('Saint Mark'),
      '09' => t('Saint Patrick'),
      '10' => t('Saint Paul'),
      '11' => t('Saint Peter'),
    ),
    'DO' => array(
      '01' => t('Azua'),
      '02' => t('Baoruco'),
      '03' => t('Barahona'),
      '04' => t('Dajabon'),
      '05' => t('Distrito Nacional'),
      '06' => t('Duarte'),
      '08' => t('Espaillat'),
      '09' => t('Independencia'),
      '10' => t('La Altagracia'),
      '11' => t('Elias Pina'),
      '12' => t('La Romana'),
      '14' => t('Maria Trinidad Sanchez'),
      '15' => t('Monte Cristi'),
      '16' => t('Pedernales'),
      '17' => t('Peravia'),
      '18' => t('Puerto Plata'),
      '19' => t('Salcedo'),
      '20' => t('Samana'),
      '21' => t('Sanchez Ramirez'),
      '23' => t('San Juan'),
      '24' => t('San Pedro De Macoris'),
      '25' => t('Santiago'),
      '26' => t('Santiago Rodriguez'),
      '27' => t('Valverde'),
      '28' => t('El Seibo'),
      '29' => t('Hato Mayor'),
      '30' => t('La Vega'),
      '31' => t('Monsenor Nouel'),
      '32' => t('Monte Plata'),
      '33' => t('San Cristobal'),
      '34' => t('Distrito Nacional'),
      '35' => t('Peravia'),
      '36' => t('San Jose de Ocoa'),
      '37' => t('Santo Domingo'),
    ),
    'DZ' => array(
      '01' => t('Alger'),
      '03' => t('Batna'),
      '04' => t('Constantine'),
      '06' => t('Medea'),
      '07' => t('Mostaganem'),
      '09' => t('Oran'),
      '10' => t('Saida'),
      '12' => t('Setif'),
      '13' => t('Tiaret'),
      '14' => t('Tizi Ouzou'),
      '15' => t('Tlemcen'),
      '18' => t('Bejaia'),
      '19' => t('Biskra'),
      '20' => t('Blida'),
      '21' => t('Bouira'),
      '22' => t('Djelfa'),
      '23' => t('Guelma'),
      '24' => t('Jijel'),
      '25' => t('Laghouat'),
      '26' => t('Mascara'),
      '27' => t("M'sila"),
      '29' => t('Oum el Bouaghi'),
      '30' => t('Sidi Bel Abbes'),
      '31' => t('Skikda'),
      '33' => t('Tebessa'),
      '34' => t('Adrar'),
      '35' => t('Ain Defla'),
      '36' => t('Ain Temouchent'),
      '37' => t('Annaba'),
      '38' => t('Bechar'),
      '39' => t('Bordj Bou Arreridj'),
      '40' => t('Boumerdes'),
      '41' => t('Chlef'),
      '42' => t('El Bayadh'),
      '43' => t('El Oued'),
      '44' => t('El Tarf'),
      '45' => t('Ghardaia'),
      '46' => t('Illizi'),
      '47' => t('Khenchela'),
      '48' => t('Mila'),
      '49' => t('Naama'),
      '50' => t('Ouargla'),
      '51' => t('Relizane'),
      '52' => t('Souk Ahras'),
      '53' => t('Tamanghasset'),
      '54' => t('Tindouf'),
      '55' => t('Tipaza'),
      '56' => t('Tissemsilt'),
    ),
    'EC' => array(
      '01' => t('Galapagos'),
      '02' => t('Azuay'),
      '03' => t('Bolivar'),
      '04' => t('Canar'),
      '05' => t('Carchi'),
      '06' => t('Chimborazo'),
      '07' => t('Cotopaxi'),
      '08' => t('El Oro'),
      '09' => t('Esmeraldas'),
      '10' => t('Guayas'),
      '11' => t('Imbabura'),
      '12' => t('Loja'),
      '13' => t('Los Rios'),
      '14' => t('Manabi'),
      '15' => t('Morona-Santiago'),
      '17' => t('Pastaza'),
      '18' => t('Pichincha'),
      '19' => t('Tungurahua'),
      '20' => t('Zamora-Chinchipe'),
      '22' => t('Sucumbios'),
      '23' => t('Napo'),
      '24' => t('Orellana'),
    ),
    'EE' => array(
      '01' => t('Harjumaa'),
      '02' => t('Hiiumaa'),
      '03' => t('Ida-Virumaa'),
      '04' => t('Jarvamaa'),
      '05' => t('Jogevamaa'),
      '06' => t('Kohtla-Jarve'),
      '07' => t('Laanemaa'),
      '08' => t('Laane-Virumaa'),
      '09' => t('Narva'),
      '10' => t('Parnu'),
      '11' => t('Parnumaa'),
      '12' => t('Polvamaa'),
      '13' => t('Raplamaa'),
      '14' => t('Saaremaa'),
      '15' => t('Sillamae'),
      '16' => t('Tallinn'),
      '17' => t('Tartu'),
      '18' => t('Tartumaa'),
      '19' => t('Valgamaa'),
      '20' => t('Viljandimaa'),
      '21' => t('Vorumaa'),
    ),
    'EG' => array(
      '01' => t('Ad Daqahliyah'),
      '02' => t('Al Bahr al Ahmar'),
      '03' => t('Al Buhayrah'),
      '04' => t('Al Fayyum'),
      '05' => t('Al Gharbiyah'),
      '06' => t('Al Iskandariyah'),
      '07' => t("Al Isma'iliyah"),
      '08' => t('Al Jizah'),
      '09' => t('Al Minufiyah'),
      '10' => t('Al Minya'),
      '11' => t('Al Qahirah'),
      '12' => t('Al Qalyubiyah'),
      '13' => t('Al Wadi al Jadid'),
      '14' => t('Ash Sharqiyah'),
      '15' => t('As Suways'),
      '16' => t('Aswan'),
      '17' => t('Asyut'),
      '18' => t('Bani Suwayf'),
      '19' => t("Bur Sa'id"),
      '20' => t('Dumyat'),
      '21' => t('Kafr ash Shaykh'),
      '22' => t('Matruh'),
      '23' => t('Qina'),
      '24' => t('Suhaj'),
      '26' => t("Janub Sina'"),
      '27' => t("Shamal Sina'"),
    ),
    'ER' => array(
      '01' => t('Anseba'),
      '02' => t('Debub'),
      '03' => t("Debubawi K'eyih Bahri"),
      '04' => t('Gash Barka'),
      '05' => t("Ma'akel"),
      '06' => t("Semenawi K'eyih Bahri"),
    ),
    'ES' => array(
      '07' => t('Islas Baleares'),
      '27' => t('La Rioja'),
      '29' => t('Madrid'),
      '31' => t('Murcia'),
      '32' => t('Navarra'),
      '34' => t('Asturias'),
      '39' => t('Cantabria'),
      '51' => t('Andalucia'),
      '52' => t('Aragon'),
      '53' => t('Canarias'),
      '54' => t('Castilla-La Mancha'),
      '55' => t('Castilla y Leon'),
      '56' => t('Catalonia'),
      '57' => t('Extremadura'),
      '58' => t('Galicia'),
      '59' => t('Pais Vasco'),
      '60' => t('Comunidad Valenciana'),
    ),
    'ET' => array(
      '02' => t('Amhara'),
      '07' => t('Somali'),
      '08' => t('Gambella'),
      '10' => t('Addis Abeba'),
      '11' => t('Southern'),
      '12' => t('Tigray'),
      '13' => t('Benishangul'),
      '14' => t('Afar'),
      '44' => t('Adis Abeba'),
      '45' => t('Afar'),
      '46' => t('Amara'),
      '47' => t('Binshangul Gumuz'),
      '48' => t('Dire Dawa'),
      '49' => t('Gambela Hizboch'),
      '50' => t('Hareri Hizb'),
      '51' => t('Oromiya'),
      '52' => t('Sumale'),
      '53' => t('Tigray'),
      '54' => t('YeDebub Biheroch Bihereseboch na Hizboch'),
    ),
    'FI' => array(
      '01' => t('Aland'),
      '06' => t('Lapland'),
      '08' => t('Oulu'),
      '13' => t('Southern Finland'),
      '14' => t('Eastern Finland'),
      '15' => t('Western Finland'),
    ),
    'FJ' => array(
      '01' => t('Central'),
      '02' => t('Eastern'),
      '03' => t('Northern'),
      '04' => t('Rotuma'),
      '05' => t('Western'),
    ),
    'FM' => array(
      '01' => t('Kosrae'),
      '02' => t('Pohnpei'),
      '03' => t('Chuuk'),
      '04' => t('Yap'),
    ),
    'FR' => array(
      '97' => t('Aquitaine'),
      '98' => t('Auvergne'),
      '99' => t('Basse-Normandie'),
      'A1' => t('Bourgogne'),
      'A2' => t('Bretagne'),
      'A3' => t('Centre'),
      'A4' => t('Champagne-Ardenne'),
      'A5' => t('Corse'),
      'A6' => t('Franche-Comte'),
      'A7' => t('Haute-Normandie'),
      'A8' => t('Ile-de-France'),
      'A9' => t('Languedoc-Roussillon'),
      'B1' => t('Limousin'),
      'B2' => t('Lorraine'),
      'B3' => t('Midi-Pyrenees'),
      'B4' => t('Nord-Pas-de-Calais'),
      'B5' => t('Pays de la Loire'),
      'B6' => t('Picardie'),
      'B7' => t('Poitou-Charentes'),
      'B8' => t("Provence-Alpes-Cote d'Azur"),
      'B9' => t('Rhone-Alpes'),
      'C1' => t('Alsace'),
    ),
    'GA' => array(
      '01' => t('Estuaire'),
      '02' => t('Haut-Ogooue'),
      '03' => t('Moyen-Ogooue'),
      '04' => t('Ngounie'),
      '05' => t('Nyanga'),
      '06' => t('Ogooue-Ivindo'),
      '07' => t('Ogooue-Lolo'),
      '08' => t('Ogooue-Maritime'),
      '09' => t('Woleu-Ntem'),
    ),
    'GB' => array(
      '01' => t('Avon'),
      '03' => t('Berkshire'),
      '07' => t('Cleveland'),
      '17' => t('Greater London'),
      '18' => t('Greater Manchester'),
      '20' => t('Hereford and Worcester'),
      '22' => t('Humberside'),
      '28' => t('Merseyside'),
      '37' => t('South Yorkshire'),
      '41' => t('Tyne and Wear'),
      '43' => t('West Midlands'),
      '45' => t('West Yorkshire'),
      '79' => t('Central'),
      '82' => t('Grampian'),
      '84' => t('Lothian'),
      '87' => t('Strathclyde'),
      '88' => t('Tayside'),
      '90' => t('Clwyd'),
      '91' => t('Dyfed'),
      '92' => t('Gwent'),
      '94' => t('Mid Glamorgan'),
      '96' => t('South Glamorgan'),
      '97' => t('West Glamorgan'),
      'A1' => t('Barking and Dagenham'),
      'A2' => t('Barnet'),
      'A3' => t('Barnsley'),
      'A4' => t('Bath and North East Somerset'),
      'A5' => t('Bedfordshire'),
      'A6' => t('Bexley'),
      'A7' => t('Birmingham'),
      'A8' => t('Blackburn with Darwen'),
      'A9' => t('Blackpool'),
      'B1' => t('Bolton'),
      'B2' => t('Bournemouth'),
      'B3' => t('Bracknell Forest'),
      'B4' => t('Bradford'),
      'B5' => t('Brent'),
      'B6' => t('Brighton and Hove'),
      'B7' => t('Bristol, City of'),
      'B8' => t('Bromley'),
      'B9' => t('Buckinghamshire'),
      'C1' => t('Bury'),
      'C2' => t('Calderdale'),
      'C3' => t('Cambridgeshire'),
      'C4' => t('Camden'),
      'C5' => t('Cheshire'),
      'C6' => t('Cornwall'),
      'C7' => t('Coventry'),
      'C8' => t('Croydon'),
      'C9' => t('Cumbria'),
      'D1' => t('Darlington'),
      'D2' => t('Derby'),
      'D3' => t('Derbyshire'),
      'D4' => t('Devon'),
      'D5' => t('Doncaster'),
      'D6' => t('Dorset'),
      'D7' => t('Dudley'),
      'D8' => t('Durham'),
      'D9' => t('Ealing'),
      'E1' => t('East Riding of Yorkshire'),
      'E2' => t('East Sussex'),
      'E3' => t('Enfield'),
      'E4' => t('Essex'),
      'E5' => t('Gateshead'),
      'E6' => t('Gloucestershire'),
      'E7' => t('Greenwich'),
      'E8' => t('Hackney'),
      'E9' => t('Halton'),
      'F1' => t('Hammersmith and Fulham'),
      'F2' => t('Hampshire'),
      'F3' => t('Haringey'),
      'F4' => t('Harrow'),
      'F5' => t('Hartlepool'),
      'F6' => t('Havering'),
      'F7' => t('Herefordshire'),
      'F8' => t('Hertford'),
      'F9' => t('Hillingdon'),
      'G1' => t('Hounslow'),
      'G2' => t('Isle of Wight'),
      'G3' => t('Islington'),
      'G4' => t('Kensington and Chelsea'),
      'G5' => t('Kent'),
      'G6' => t('Kingston upon Hull, City of'),
      'G7' => t('Kingston upon Thames'),
      'G8' => t('Kirklees'),
      'G9' => t('Knowsley'),
      'H1' => t('Lambeth'),
      'H2' => t('Lancashire'),
      'H3' => t('Leeds'),
      'H4' => t('Leicester'),
      'H5' => t('Leicestershire'),
      'H6' => t('Lewisham'),
      'H7' => t('Lincolnshire'),
      'H8' => t('Liverpool'),
      'H9' => t('London, City of'),
      'I1' => t('Luton'),
      'I2' => t('Manchester'),
      'I3' => t('Medway'),
      'I4' => t('Merton'),
      'I5' => t('Middlesbrough'),
      'I6' => t('Milton Keynes'),
      'I7' => t('Newcastle upon Tyne'),
      'I8' => t('Newham'),
      'I9' => t('Norfolk'),
      'J1' => t('Northamptonshire'),
      'J2' => t('North East Lincolnshire'),
      'J3' => t('North Lincolnshire'),
      'J4' => t('North Somerset'),
      'J5' => t('North Tyneside'),
      'J6' => t('Northumberland'),
      'J7' => t('North Yorkshire'),
      'J8' => t('Nottingham'),
      'J9' => t('Nottinghamshire'),
      'K1' => t('Oldham'),
      'K2' => t('Oxfordshire'),
      'K3' => t('Peterborough'),
      'K4' => t('Plymouth'),
      'K5' => t('Poole'),
      'K6' => t('Portsmouth'),
      'K7' => t('Reading'),
      'K8' => t('Redbridge'),
      'K9' => t('Redcar and Cleveland'),
      'L1' => t('Richmond upon Thames'),
      'L2' => t('Rochdale'),
      'L3' => t('Rotherham'),
      'L4' => t('Rutland'),
      'L5' => t('Salford'),
      'L6' => t('Shropshire'),
      'L7' => t('Sandwell'),
      'L8' => t('Sefton'),
      'L9' => t('Sheffield'),
      'M1' => t('Slough'),
      'M2' => t('Solihull'),
      'M3' => t('Somerset'),
      'M4' => t('Southampton'),
      'M5' => t('Southend-on-Sea'),
      'M6' => t('South Gloucestershire'),
      'M7' => t('South Tyneside'),
      'M8' => t('Southwark'),
      'M9' => t('Staffordshire'),
      'N1' => t('St. Helens'),
      'N2' => t('Stockport'),
      'N3' => t('Stockton-on-Tees'),
      'N4' => t('Stoke-on-Trent'),
      'N5' => t('Suffolk'),
      'N6' => t('Sunderland'),
      'N7' => t('Surrey'),
      'N8' => t('Sutton'),
      'N9' => t('Swindon'),
      'O1' => t('Tameside'),
      'O2' => t('Telford and Wrekin'),
      'O3' => t('Thurrock'),
      'O4' => t('Torbay'),
      'O5' => t('Tower Hamlets'),
      'O6' => t('Trafford'),
      'O7' => t('Wakefield'),
      'O8' => t('Walsall'),
      'O9' => t('Waltham Forest'),
      'P1' => t('Wandsworth'),
      'P2' => t('Warrington'),
      'P3' => t('Warwickshire'),
      'P4' => t('West Berkshire'),
      'P5' => t('Westminster'),
      'P6' => t('West Sussex'),
      'P7' => t('Wigan'),
      'P8' => t('Wiltshire'),
      'P9' => t('Windsor and Maidenhead'),
      'Q1' => t('Wirral'),
      'Q2' => t('Wokingham'),
      'Q3' => t('Wolverhampton'),
      'Q4' => t('Worcestershire'),
      'Q5' => t('York'),
      'Q6' => t('Antrim'),
      'Q7' => t('Ards'),
      'Q8' => t('Armagh'),
      'Q9' => t('Ballymena'),
      'R1' => t('Ballymoney'),
      'R2' => t('Banbridge'),
      'R3' => t('Belfast'),
      'R4' => t('Carrickfergus'),
      'R5' => t('Castlereagh'),
      'R6' => t('Coleraine'),
      'R7' => t('Cookstown'),
      'R8' => t('Craigavon'),
      'R9' => t('Down'),
      'S1' => t('Dungannon'),
      'S2' => t('Fermanagh'),
      'S3' => t('Larne'),
      'S4' => t('Limavady'),
      'S5' => t('Lisburn'),
      'S6' => t('Derry'),
      'S7' => t('Magherafelt'),
      'S8' => t('Moyle'),
      'S9' => t('Newry and Mourne'),
      'T1' => t('Newtownabbey'),
      'T2' => t('North Down'),
      'T3' => t('Omagh'),
      'T4' => t('Strabane'),
      'T5' => t('Aberdeen City'),
      'T6' => t('Aberdeenshire'),
      'T7' => t('Angus'),
      'T8' => t('Argyll and Bute'),
      'T9' => t('Scottish Borders, The'),
      'U1' => t('Clackmannanshire'),
      'U2' => t('Dumfries and Galloway'),
      'U3' => t('Dundee City'),
      'U4' => t('East Ayrshire'),
      'U5' => t('East Dunbartonshire'),
      'U6' => t('East Lothian'),
      'U7' => t('East Renfrewshire'),
      'U8' => t('Edinburgh, City of'),
      'U9' => t('Falkirk'),
      'V1' => t('Fife'),
      'V2' => t('Glasgow City'),
      'V3' => t('Highland'),
      'V4' => t('Inverclyde'),
      'V5' => t('Midlothian'),
      'V6' => t('Moray'),
      'V7' => t('North Ayrshire'),
      'V8' => t('North Lanarkshire'),
      'V9' => t('Orkney'),
      'W1' => t('Perth and Kinross'),
      'W2' => t('Renfrewshire'),
      'W3' => t('Shetland Islands'),
      'W4' => t('South Ayrshire'),
      'W5' => t('South Lanarkshire'),
      'W6' => t('Stirling'),
      'W7' => t('West Dunbartonshire'),
      'W8' => t('Eilean Siar'),
      'W9' => t('West Lothian'),
      'X1' => t('Isle of Anglesey'),
      'X2' => t('Blaenau Gwent'),
      'X3' => t('Bridgend'),
      'X4' => t('Caerphilly'),
      'X5' => t('Cardiff'),
      'X6' => t('Ceredigion'),
      'X7' => t('Carmarthenshire'),
      'X8' => t('Conwy'),
      'X9' => t('Denbighshire'),
      'Y1' => t('Flintshire'),
      'Y2' => t('Gwynedd'),
      'Y3' => t('Merthyr Tydfil'),
      'Y4' => t('Monmouthshire'),
      'Y5' => t('Neath Port Talbot'),
      'Y6' => t('Newport'),
      'Y7' => t('Pembrokeshire'),
      'Y8' => t('Powys'),
      'Y9' => t('Rhondda Cynon Taff'),
      'Z1' => t('Swansea'),
      'Z2' => t('Torfaen'),
      'Z3' => t('Vale of Glamorgan, The'),
      'Z4' => t('Wrexham'),
    ),
    'GD' => array(
      '01' => t('Saint Andrew'),
      '02' => t('Saint David'),
      '03' => t('Saint George'),
      '04' => t('Saint John'),
      '05' => t('Saint Mark'),
      '06' => t('Saint Patrick'),
    ),
    'GE' => array(
      '01' => t('Abashis Raioni'),
      '02' => t('Abkhazia'),
      '03' => t('Adigenis Raioni'),
      '04' => t('Ajaria'),
      '05' => t('Akhalgoris Raioni'),
      '06' => t("Akhalk'alak'is Raioni"),
      '07' => t("Akhalts'ikhis Raioni"),
      '08' => t('Akhmetis Raioni'),
      '09' => t('Ambrolauris Raioni'),
      '10' => t('Aspindzis Raioni'),
      '11' => t("Baghdat'is Raioni"),
      '12' => t('Bolnisis Raioni'),
      '13' => t('Borjomis Raioni'),
      '14' => t("Chiat'ura"),
      '15' => t("Ch'khorotsqus Raioni"),
      '16' => t("Ch'okhatauris Raioni"),
      '17' => t("Dedop'listsqaros Raioni"),
      '18' => t('Dmanisis Raioni'),
      '19' => t("Dushet'is Raioni"),
      '20' => t('Gardabanis Raioni'),
      '21' => t('Gori'),
      '22' => t('Goris Raioni'),
      '23' => t('Gurjaanis Raioni'),
      '24' => t('Javis Raioni'),
      '25' => t("K'arelis Raioni"),
      '26' => t('Kaspis Raioni'),
      '27' => t('Kharagaulis Raioni'),
      '28' => t('Khashuris Raioni'),
      '29' => t('Khobis Raioni'),
      '30' => t('Khonis Raioni'),
      '31' => t("K'ut'aisi"),
      '32' => t('Lagodekhis Raioni'),
      '33' => t("Lanch'khut'is Raioni"),
      '34' => t('Lentekhis Raioni'),
      '35' => t('Marneulis Raioni'),
      '36' => t('Martvilis Raioni'),
      '37' => t('Mestiis Raioni'),
      '38' => t("Mts'khet'is Raioni"),
      '39' => t('Ninotsmindis Raioni'),
      '40' => t('Onis Raioni'),
      '41' => t("Ozurget'is Raioni"),
      '42' => t("P'ot'i"),
      '43' => t('Qazbegis Raioni'),
      '44' => t('Qvarlis Raioni'),
      '45' => t("Rust'avi"),
      '46' => t("Sach'kheris Raioni"),
      '47' => t('Sagarejos Raioni'),
      '48' => t('Samtrediis Raioni'),
      '49' => t('Senakis Raioni'),
      '50' => t('Sighnaghis Raioni'),
      '51' => t("T'bilisi"),
      '52' => t("T'elavis Raioni"),
      '53' => t("T'erjolis Raioni"),
      '54' => t("T'et'ritsqaros Raioni"),
      '55' => t("T'ianet'is Raioni"),
      '56' => t('Tqibuli'),
      '57' => t("Ts'ageris Raioni"),
      '58' => t('Tsalenjikhis Raioni'),
      '59' => t('Tsalkis Raioni'),
      '60' => t('Tsqaltubo'),
      '61' => t('Vanis Raioni'),
      '62' => t("Zestap'onis Raioni"),
      '63' => t('Zugdidi'),
      '64' => t('Zugdidis Raioni'),
    ),
    'GH' => array(
      '01' => t('Greater Accra'),
      '02' => t('Ashanti'),
      '03' => t('Brong-Ahafo'),
      '04' => t('Central'),
      '05' => t('Eastern'),
      '06' => t('Northern'),
      '08' => t('Volta'),
      '09' => t('Western'),
      '10' => t('Upper East'),
      '11' => t('Upper West'),
    ),
    'GL' => array(
      '01' => t('Nordgronland'),
      '02' => t('Ostgronland'),
      '03' => t('Vestgronland'),
    ),
    'GM' => array(
      '01' => t('Banjul'),
      '02' => t('Lower River'),
      '03' => t('Central River'),
      '04' => t('Upper River'),
      '05' => t('Western'),
      '07' => t('North Bank'),
    ),
    'GN' => array(
      '01' => t('Beyla'),
      '02' => t('Boffa'),
      '03' => t('Boke'),
      '04' => t('Conakry'),
      '05' => t('Dabola'),
      '06' => t('Dalaba'),
      '07' => t('Dinguiraye'),
      '09' => t('Faranah'),
      '10' => t('Forecariah'),
      '11' => t('Fria'),
      '12' => t('Gaoual'),
      '13' => t('Gueckedou'),
      '15' => t('Kerouane'),
      '16' => t('Kindia'),
      '17' => t('Kissidougou'),
      '18' => t('Koundara'),
      '19' => t('Kouroussa'),
      '21' => t('Macenta'),
      '22' => t('Mali'),
      '23' => t('Mamou'),
      '25' => t('Pita'),
      '27' => t('Telimele'),
      '28' => t('Tougue'),
      '29' => t('Yomou'),
      '30' => t('Coyah'),
      '31' => t('Dubreka'),
      '32' => t('Kankan'),
      '33' => t('Koubia'),
      '34' => t('Labe'),
      '35' => t('Lelouma'),
      '36' => t('Lola'),
      '37' => t('Mandiana'),
      '38' => t('Nzerekore'),
      '39' => t('Siguiri'),
    ),
    'GQ' => array(
      '03' => t('Annobon'),
      '04' => t('Bioko Norte'),
      '05' => t('Bioko Sur'),
      '06' => t('Centro Sur'),
      '07' => t('Kie-Ntem'),
      '08' => t('Litoral'),
      '09' => t('Wele-Nzas'),
    ),
    'GR' => array(
      '01' => t('Evros'),
      '02' => t('Rodhopi'),
      '03' => t('Xanthi'),
      '04' => t('Drama'),
      '05' => t('Serrai'),
      '06' => t('Kilkis'),
      '07' => t('Pella'),
      '08' => t('Florina'),
      '09' => t('Kastoria'),
      '10' => t('Grevena'),
      '11' => t('Kozani'),
      '12' => t('Imathia'),
      '13' => t('Thessaloniki'),
      '14' => t('Kavala'),
      '15' => t('Khalkidhiki'),
      '16' => t('Pieria'),
      '17' => t('Ioannina'),
      '18' => t('Thesprotia'),
      '19' => t('Preveza'),
      '20' => t('Arta'),
      '21' => t('Larisa'),
      '22' => t('Trikala'),
      '23' => t('Kardhitsa'),
      '24' => t('Magnisia'),
      '25' => t('Kerkira'),
      '26' => t('Levkas'),
      '27' => t('Kefallinia'),
      '28' => t('Zakinthos'),
      '29' => t('Fthiotis'),
      '30' => t('Evritania'),
      '31' => t('Aitolia kai Akarnania'),
      '32' => t('Fokis'),
      '33' => t('Voiotia'),
      '34' => t('Evvoia'),
      '35' => t('Attiki'),
      '36' => t('Argolis'),
      '37' => t('Korinthia'),
      '38' => t('Akhaia'),
      '39' => t('Ilia'),
      '40' => t('Messinia'),
      '41' => t('Arkadhia'),
      '42' => t('Lakonia'),
      '43' => t('Khania'),
      '44' => t('Rethimni'),
      '45' => t('Iraklion'),
      '46' => t('Lasithi'),
      '47' => t('Dhodhekanisos'),
      '48' => t('Samos'),
      '49' => t('Kikladhes'),
      '50' => t('Khios'),
      '51' => t('Lesvos'),
    ),
    'GT' => array(
      '01' => t('Alta Verapaz'),
      '02' => t('Baja Verapaz'),
      '03' => t('Chimaltenango'),
      '04' => t('Chiquimula'),
      '05' => t('El Progreso'),
      '06' => t('Escuintla'),
      '07' => t('Guatemala'),
      '08' => t('Huehuetenango'),
      '09' => t('Izabal'),
      '10' => t('Jalapa'),
      '11' => t('Jutiapa'),
      '12' => t('Peten'),
      '13' => t('Quetzaltenango'),
      '14' => t('Quiche'),
      '15' => t('Retalhuleu'),
      '16' => t('Sacatepequez'),
      '17' => t('San Marcos'),
      '18' => t('Santa Rosa'),
      '19' => t('Solola'),
      '20' => t('Suchitepequez'),
      '21' => t('Totonicapan'),
      '22' => t('Zacapa'),
    ),
    'GW' => array(
      '01' => t('Bafata'),
      '02' => t('Quinara'),
      '04' => t('Oio'),
      '05' => t('Bolama'),
      '06' => t('Cacheu'),
      '07' => t('Tombali'),
      '10' => t('Gabu'),
      '11' => t('Bissau'),
      '12' => t('Biombo'),
    ),
    'GY' => array(
      '10' => t('Barima-Waini'),
      '11' => t('Cuyuni-Mazaruni'),
      '12' => t('Demerara-Mahaica'),
      '13' => t('East Berbice-Corentyne'),
      '14' => t('Essequibo Islands-West Demerara'),
      '15' => t('Mahaica-Berbice'),
      '16' => t('Pomeroon-Supenaam'),
      '17' => t('Potaro-Siparuni'),
      '18' => t('Upper Demerara-Berbice'),
      '19' => t('Upper Takutu-Upper Essequibo'),
    ),
    'HN' => array(
      '01' => t('Atlantida'),
      '02' => t('Choluteca'),
      '03' => t('Colon'),
      '04' => t('Comayagua'),
      '05' => t('Copan'),
      '06' => t('Cortes'),
      '07' => t('El Paraiso'),
      '08' => t('Francisco Morazan'),
      '09' => t('Gracias a Dios'),
      '10' => t('Intibuca'),
      '11' => t('Islas de la Bahia'),
      '12' => t('La Paz'),
      '13' => t('Lempira'),
      '14' => t('Ocotepeque'),
      '15' => t('Olancho'),
      '16' => t('Santa Barbara'),
      '17' => t('Valle'),
      '18' => t('Yoro'),
    ),
    'HR' => array(
      '01' => t('Bjelovarsko-Bilogorska'),
      '02' => t('Brodsko-Posavska'),
      '03' => t('Dubrovacko-Neretvanska'),
      '04' => t('Istarska'),
      '05' => t('Karlovacka'),
      '06' => t('Koprivnicko-Krizevacka'),
      '07' => t('Krapinsko-Zagorska'),
      '08' => t('Licko-Senjska'),
      '09' => t('Medimurska'),
      '10' => t('Osjecko-Baranjska'),
      '11' => t('Pozesko-Slavonska'),
      '12' => t('Primorsko-Goranska'),
      '13' => t('Sibensko-Kninska'),
      '14' => t('Sisacko-Moslavacka'),
      '15' => t('Splitsko-Dalmatinska'),
      '16' => t('Varazdinska'),
      '17' => t('Viroviticko-Podravska'),
      '18' => t('Vukovarsko-Srijemska'),
      '19' => t('Zadarska'),
      '20' => t('Zagrebacka'),
      '21' => t('Grad Zagreb'),
    ),
    'HT' => array(
      '03' => t('Nord-Ouest'),
      '06' => t('Artibonite'),
      '07' => t('Centre'),
      '09' => t('Nord'),
      '10' => t('Nord-Est'),
      '11' => t('Ouest'),
      '12' => t('Sud'),
      '13' => t('Sud-Est'),
      '14' => t("Grand' Anse"),
      '15' => t('Nippes'),
    ),
    'HU' => array(
      '01' => t('Bacs-Kiskun'),
      '02' => t('Baranya'),
      '03' => t('Bekes'),
      '04' => t('Borsod-Abauj-Zemplen'),
      '05' => t('Budapest'),
      '06' => t('Csongrad'),
      '07' => t('Debrecen'),
      '08' => t('Fejer'),
      '09' => t('Gyor-Moson-Sopron'),
      '10' => t('Hajdu-Bihar'),
      '11' => t('Heves'),
      '12' => t('Komarom-Esztergom'),
      '13' => t('Miskolc'),
      '14' => t('Nograd'),
      '15' => t('Pecs'),
      '16' => t('Pest'),
      '17' => t('Somogy'),
      '18' => t('Szabolcs-Szatmar-Bereg'),
      '19' => t('Szeged'),
      '20' => t('Jasz-Nagykun-Szolnok'),
      '21' => t('Tolna'),
      '22' => t('Vas'),
      '23' => t('Veszprem'),
      '24' => t('Zala'),
      '25' => t('Gyor'),
      '26' => t('Bekescsaba'),
      '27' => t('Dunaujvaros'),
      '28' => t('Eger'),
      '29' => t('Hodmezovasarhely'),
      '30' => t('Kaposvar'),
      '31' => t('Kecskemet'),
      '32' => t('Nagykanizsa'),
      '33' => t('Nyiregyhaza'),
      '34' => t('Sopron'),
      '35' => t('Szekesfehervar'),
      '36' => t('Szolnok'),
      '37' => t('Szombathely'),
      '38' => t('Tatabanya'),
      '39' => t('Veszprem'),
      '40' => t('Zalaegerszeg'),
      '41' => t('Salgotarjan'),
      '42' => t('Szekszard'),
    ),
    'ID' => array(
      '01' => t('Aceh'),
      '02' => t('Bali'),
      '03' => t('Bengkulu'),
      '04' => t('Jakarta Raya'),
      '05' => t('Jambi'),
      '06' => t('Jawa Barat'),
      '07' => t('Jawa Tengah'),
      '08' => t('Jawa Timur'),
      '09' => t('Papua'),
      '10' => t('Yogyakarta'),
      '11' => t('Kalimantan Barat'),
      '12' => t('Kalimantan Selatan'),
      '13' => t('Kalimantan Tengah'),
      '14' => t('Kalimantan Timur'),
      '15' => t('Lampung'),
      '16' => t('Maluku'),
      '17' => t('Nusa Tenggara Barat'),
      '18' => t('Nusa Tenggara Timur'),
      '19' => t('Riau'),
      '20' => t('Sulawesi Selatan'),
      '21' => t('Sulawesi Tengah'),
      '22' => t('Sulawesi Tenggara'),
      '23' => t('Sulawesi Utara'),
      '24' => t('Sumatera Barat'),
      '25' => t('Sumatera Selatan'),
      '26' => t('Sumatera Utara'),
      '28' => t('Maluku'),
      '29' => t('Maluku Utara'),
      '30' => t('Jawa Barat'),
      '31' => t('Sulawesi Utara'),
      '32' => t('Sumatera Selatan'),
      '33' => t('Banten'),
      '34' => t('Gorontalo'),
      '35' => t('Kepulauan Bangka Belitung'),
      '36' => t('Papua'),
      '37' => t('Riau'),
      '38' => t('Sulawesi Selatan'),
      '39' => t('Irian Jaya Barat'),
      '40' => t('Kepulauan Riau'),
      '41' => t('Sulawesi Barat'),
    ),
    'IE' => array(
      '01' => t('Carlow'),
      '02' => t('Cavan'),
      '03' => t('Clare'),
      '04' => t('Cork'),
      '06' => t('Donegal'),
      '07' => t('Dublin'),
      '10' => t('Galway'),
      '11' => t('Kerry'),
      '12' => t('Kildare'),
      '13' => t('Kilkenny'),
      '14' => t('Leitrim'),
      '15' => t('Laois'),
      '16' => t('Limerick'),
      '18' => t('Longford'),
      '19' => t('Louth'),
      '20' => t('Mayo'),
      '21' => t('Meath'),
      '22' => t('Monaghan'),
      '23' => t('Offaly'),
      '24' => t('Roscommon'),
      '25' => t('Sligo'),
      '26' => t('Tipperary'),
      '27' => t('Waterford'),
      '29' => t('Westmeath'),
      '30' => t('Wexford'),
      '31' => t('Wicklow'),
    ),
    'IL' => array(
      '01' => t('HaDarom'),
      '02' => t('HaMerkaz'),
      '03' => t('HaZafon'),
      '04' => t('Hefa'),
      '05' => t('Tel Aviv'),
      '06' => t('Yerushalayim'),
    ),
    'IN' => array(
      '01' => t('Andaman and Nicobar Islands'),
      '02' => t('Andhra Pradesh'),
      '03' => t('Assam'),
      '05' => t('Chandigarh'),
      '06' => t('Dadra and Nagar Haveli'),
      '07' => t('Delhi'),
      '09' => t('Gujarat'),
      '10' => t('Haryana'),
      '11' => t('Himachal Pradesh'),
      '12' => t('Jammu and Kashmir'),
      '13' => t('Kerala'),
      '14' => t('Lakshadweep'),
      '16' => t('Maharashtra'),
      '17' => t('Manipur'),
      '18' => t('Meghalaya'),
      '19' => t('Karnataka'),
      '20' => t('Nagaland'),
      '21' => t('Orissa'),
      '22' => t('Puducherry'),
      '23' => t('Punjab'),
      '24' => t('Rajasthan'),
      '25' => t('Tamil Nadu'),
      '26' => t('Tripura'),
      '28' => t('West Bengal'),
      '29' => t('Sikkim'),
      '30' => t('Arunachal Pradesh'),
      '31' => t('Mizoram'),
      '32' => t('Daman and Diu'),
      '33' => t('Goa'),
      '34' => t('Bihar'),
      '35' => t('Madhya Pradesh'),
      '36' => t('Uttar Pradesh'),
      '37' => t('Chhattisgarh'),
      '38' => t('Jharkhand'),
      '39' => t('Uttarakhand'),
    ),
    'IQ' => array(
      '01' => t('Al Anbar'),
      '02' => t('Al Basrah'),
      '03' => t('Al Muthanna'),
      '04' => t('Al Qadisiyah'),
      '05' => t('As Sulaymaniyah'),
      '06' => t('Babil'),
      '07' => t('Baghdad'),
      '08' => t('Dahuk'),
      '09' => t('Dhi Qar'),
      '10' => t('Diyala'),
      '11' => t('Arbil'),
      '12' => t("Karbala'"),
      '13' => t("At Ta'mim"),
      '14' => t('Maysan'),
      '15' => t('Ninawa'),
      '16' => t('Wasit'),
      '17' => t('An Najaf'),
      '18' => t('Salah ad Din'),
    ),
    'IR' => array(
      '01' => t('Azarbayjan-e Bakhtari'),
      '02' => t('Azarbayjan-e Khavari'),
      '03' => t('Chahar Mahall va Bakhtiari'),
      '04' => t('Sistan va Baluchestan'),
      '05' => t('Kohkiluyeh va Buyer Ahmadi'),
      '07' => t('Fars'),
      '08' => t('Gilan'),
      '09' => t('Hamadan'),
      '10' => t('Ilam'),
      '11' => t('Hormozgan'),
      '12' => t('Kerman'),
      '13' => t('Bakhtaran'),
      '15' => t('Khuzestan'),
      '16' => t('Kordestan'),
      '17' => t('Mazandaran'),
      '18' => t('Semnan Province'),
      '19' => t('Markazi'),
      '21' => t('Zanjan'),
      '22' => t('Bushehr'),
      '23' => t('Lorestan'),
      '24' => t('Markazi'),
      '25' => t('Semnan'),
      '26' => t('Tehran'),
      '27' => t('Zanjan'),
      '28' => t('Esfahan'),
      '29' => t('Kerman'),
      '30' => t('Khorasan'),
      '31' => t('Yazd'),
      '32' => t('Ardabil'),
      '33' => t('East Azarbaijan'),
      '34' => t('Markazi'),
      '35' => t('Mazandaran'),
      '36' => t('Zanjan'),
      '37' => t('Golestan'),
      '38' => t('Qazvin'),
      '39' => t('Qom'),
      '40' => t('Yazd'),
      '41' => t('Khorasan-e Janubi'),
      '42' => t('Khorasan-e Razavi'),
      '43' => t('Khorasan-e Shemali'),
    ),
    'IS' => array(
      '03' => t('Arnessysla'),
      '05' => t('Austur-Hunavatnssysla'),
      '06' => t('Austur-Skaftafellssysla'),
      '07' => t('Borgarfjardarsysla'),
      '09' => t('Eyjafjardarsysla'),
      '10' => t('Gullbringusysla'),
      '15' => t('Kjosarsysla'),
      '17' => t('Myrasysla'),
      '20' => t('Nordur-Mulasysla'),
      '21' => t('Nordur-Tingeyjarsysla'),
      '23' => t('Rangarvallasysla'),
      '28' => t('Skagafjardarsysla'),
      '29' => t('Snafellsnes- og Hnappadalssysla'),
      '30' => t('Strandasysla'),
      '31' => t('Sudur-Mulasysla'),
      '32' => t('Sudur-Tingeyjarsysla'),
      '34' => t('Vestur-Bardastrandarsysla'),
      '35' => t('Vestur-Hunavatnssysla'),
      '36' => t('Vestur-Isafjardarsysla'),
      '37' => t('Vestur-Skaftafellssysla'),
      '40' => t('Norourland Eystra'),
      '41' => t('Norourland Vestra'),
      '42' => t('Suourland'),
      '43' => t('Suournes'),
      '44' => t('Vestfiroir'),
      '45' => t('Vesturland'),
    ),
    'IT' => array(
      '01' => t('Abruzzi'),
      '02' => t('Basilicata'),
      '03' => t('Calabria'),
      '04' => t('Campania'),
      '05' => t('Emilia-Romagna'),
      '06' => t('Friuli-Venezia Giulia'),
      '07' => t('Lazio'),
      '08' => t('Liguria'),
      '09' => t('Lombardia'),
      '10' => t('Marche'),
      '11' => t('Molise'),
      '12' => t('Piemonte'),
      '13' => t('Puglia'),
      '14' => t('Sardegna'),
      '15' => t('Sicilia'),
      '16' => t('Toscana'),
      '17' => t('Trentino-Alto Adige'),
      '18' => t('Umbria'),
      '19' => t("Valle d'Aosta"),
      '20' => t('Veneto'),
    ),
    'JM' => array(
      '01' => t('Clarendon'),
      '02' => t('Hanover'),
      '04' => t('Manchester'),
      '07' => t('Portland'),
      '08' => t('Saint Andrew'),
      '09' => t('Saint Ann'),
      '10' => t('Saint Catherine'),
      '11' => t('Saint Elizabeth'),
      '12' => t('Saint James'),
      '13' => t('Saint Mary'),
      '14' => t('Saint Thomas'),
      '15' => t('Trelawny'),
      '16' => t('Westmoreland'),
      '17' => t('Kingston'),
    ),
    'JO' => array(
      '02' => t("Al Balqa'"),
      '07' => t('Ma'),
      '09' => t('Al Karak'),
      '10' => t('Al Mafraq'),
      '11' => t('Amman Governorate'),
      '12' => t('At Tafilah'),
      '13' => t('Az Zarqa'),
      '14' => t('Irbid'),
      '16' => t('Amman'),
    ),
    'JP' => array(
      '01' => t('Aichi'),
      '02' => t('Akita'),
      '03' => t('Aomori'),
      '04' => t('Chiba'),
      '05' => t('Ehime'),
      '06' => t('Fukui'),
      '07' => t('Fukuoka'),
      '08' => t('Fukushima'),
      '09' => t('Gifu'),
      '10' => t('Gumma'),
      '11' => t('Hiroshima'),
      '12' => t('Hokkaido'),
      '13' => t('Hyogo'),
      '14' => t('Ibaraki'),
      '15' => t('Ishikawa'),
      '16' => t('Iwate'),
      '17' => t('Kagawa'),
      '18' => t('Kagoshima'),
      '19' => t('Kanagawa'),
      '20' => t('Kochi'),
      '21' => t('Kumamoto'),
      '22' => t('Kyoto'),
      '23' => t('Mie'),
      '24' => t('Miyagi'),
      '25' => t('Miyazaki'),
      '26' => t('Nagano'),
      '27' => t('Nagasaki'),
      '28' => t('Nara'),
      '29' => t('Niigata'),
      '30' => t('Oita'),
      '31' => t('Okayama'),
      '32' => t('Osaka'),
      '33' => t('Saga'),
      '34' => t('Saitama'),
      '35' => t('Shiga'),
      '36' => t('Shimane'),
      '37' => t('Shizuoka'),
      '38' => t('Tochigi'),
      '39' => t('Tokushima'),
      '40' => t('Tokyo'),
      '41' => t('Tottori'),
      '42' => t('Toyama'),
      '43' => t('Wakayama'),
      '44' => t('Yamagata'),
      '45' => t('Yamaguchi'),
      '46' => t('Yamanashi'),
      '47' => t('Okinawa'),
    ),
    'KE' => array(
      '01' => t('Central'),
      '02' => t('Coast'),
      '03' => t('Eastern'),
      '05' => t('Nairobi Area'),
      '06' => t('North-Eastern'),
      '07' => t('Nyanza'),
      '08' => t('Rift Valley'),
      '09' => t('Western'),
    ),
    'KG' => array(
      '01' => t('Bishkek'),
      '02' => t('Chuy'),
      '03' => t('Jalal-Abad'),
      '04' => t('Naryn'),
      '05' => t('Osh'),
      '06' => t('Talas'),
      '07' => t('Ysyk-Kol'),
      '08' => t('Osh'),
      '09' => t('Batken'),
    ),
    'KH' => array(
      '00' => t('Banteay Meanchey'),
      '01' => t('Batdambang'),
      '02' => t('Kampong Cham'),
      '03' => t('Kampong Chhnang'),
      '04' => t('Kampong Speu'),
      '05' => t('Kampong Thum'),
      '06' => t('Kampot'),
      '07' => t('Kandal'),
      '08' => t('Koh Kong'),
      '09' => t('Kracheh'),
      '10' => t('Mondulkiri'),
      '11' => t('Phnum Penh'),
      '12' => t('Pursat'),
      '13' => t('Preah Vihear'),
      '14' => t('Prey Veng'),
      '15' => t('Ratanakiri Kiri'),
      '16' => t('Siem Reap'),
      '17' => t('Stung Treng'),
      '18' => t('Svay Rieng'),
      '19' => t('Takeo'),
      '29' => t('Batdambang'),
      '30' => t('Pailin'),
    ),
    'KI' => array(
      '01' => t('Gilbert Islands'),
      '02' => t('Line Islands'),
      '03' => t('Phoenix Islands'),
    ),
    'KM' => array(
      '01' => t('Anjouan'),
      '02' => t('Grande Comore'),
      '03' => t('Moheli'),
    ),
    'KN' => array(
      '01' => t('Christ Church Nichola Town'),
      '02' => t('Saint Anne Sandy Point'),
      '03' => t('Saint George Basseterre'),
      '04' => t('Saint George Gingerland'),
      '05' => t('Saint James Windward'),
      '06' => t('Saint John Capisterre'),
      '07' => t('Saint John Figtree'),
      '08' => t('Saint Mary Cayon'),
      '09' => t('Saint Paul Capisterre'),
      '10' => t('Saint Paul Charlestown'),
      '11' => t('Saint Peter Basseterre'),
      '12' => t('Saint Thomas Lowland'),
      '13' => t('Saint Thomas Middle Island'),
      '15' => t('Trinity Palmetto Point'),
    ),
    'KP' => array(
      '01' => t('Chagang-do'),
      '03' => t('Hamgyong-namdo'),
      '06' => t('Hwanghae-namdo'),
      '07' => t('Hwanghae-bukto'),
      '08' => t('Kaesong-si'),
      '09' => t('Kangwon-do'),
      '11' => t("P'yongan-bukto"),
      '12' => t("P'yongyang-si"),
      '13' => t('Yanggang-do'),
      '14' => t("Namp'o-si"),
      '15' => t("P'yongan-namdo"),
      '17' => t('Hamgyong-bukto'),
      '18' => t('Najin Sonbong-si'),
    ),
    'KR' => array(
      '01' => t('Cheju-do'),
      '03' => t('Cholla-bukto'),
      '05' => t("Ch'ungch'ong-bukto"),
      '06' => t('Kangwon-do'),
      '10' => t('Pusan-jikhalsi'),
      '11' => t("Seoul-t'ukpyolsi"),
      '12' => t("Inch'on-jikhalsi"),
      '13' => t('Kyonggi-do'),
      '14' => t('Kyongsang-bukto'),
      '15' => t('Taegu-jikhalsi'),
      '16' => t('Cholla-namdo'),
      '17' => t("Ch'ungch'ong-namdo"),
      '18' => t('Kwangju-jikhalsi'),
      '19' => t('Taejon-jikhalsi'),
      '20' => t('Kyongsang-namdo'),
      '21' => t('Ulsan-gwangyoksi'),
    ),
    'KW' => array(
      '01' => t('Al Ahmadi'),
      '02' => t('Al Kuwayt'),
      '05' => t('Al Jahra'),
      '07' => t('Al Farwaniyah'),
      '08' => t('Hawalli'),
      '09' => t('Mubarak al Kabir'),
    ),
    'KY' => array(
      '01' => t('Creek'),
      '02' => t('Eastern'),
      '03' => t('Midland'),
      '04' => t('South Town'),
      '05' => t('Spot Bay'),
      '06' => t('Stake Bay'),
      '07' => t('West End'),
      '08' => t('Western'),
    ),
    'KZ' => array(
      '01' => t('Almaty'),
      '02' => t('Almaty City'),
      '03' => t('Aqmola'),
      '04' => t('Aqtobe'),
      '05' => t('Astana'),
      '06' => t('Atyrau'),
      '07' => t('West Kazakhstan'),
      '08' => t('Bayqonyr'),
      '09' => t('Mangghystau'),
      '10' => t('South Kazakhstan'),
      '11' => t('Pavlodar'),
      '12' => t('Qaraghandy'),
      '13' => t('Qostanay'),
      '14' => t('Qyzylorda'),
      '15' => t('East Kazakhstan'),
      '16' => t('North Kazakhstan'),
      '17' => t('Zhambyl'),
    ),
    'LA' => array(
      '01' => t('Attapu'),
      '02' => t('Champasak'),
      '03' => t('Houaphan'),
      '04' => t('Khammouan'),
      '05' => t('Louang Namtha'),
      '07' => t('Oudomxai'),
      '08' => t('Phongsali'),
      '09' => t('Saravan'),
      '10' => t('Savannakhet'),
      '11' => t('Vientiane'),
      '13' => t('Xaignabouri'),
      '14' => t('Xiangkhoang'),
      '17' => t('Louangphrabang'),
    ),
    'LB' => array(
      '01' => t('Beqaa'),
      '02' => t('Al Janub'),
      '03' => t('Liban-Nord'),
      '04' => t('Beyrouth'),
      '05' => t('Mont-Liban'),
      '06' => t('Liban-Sud'),
      '07' => t('Nabatiye'),
      '08' => t('Beqaa'),
      '09' => t('Liban-Nord'),
      '10' => t('Aakk,r'),
      '11' => t('Baalbek-Hermel'),
    ),
    'LC' => array(
      '01' => t('Anse-la-Raye'),
      '02' => t('Dauphin'),
      '03' => t('Castries'),
      '04' => t('Choiseul'),
      '05' => t('Dennery'),
      '06' => t('Gros-Islet'),
      '07' => t('Laborie'),
      '08' => t('Micoud'),
      '09' => t('Soufriere'),
      '10' => t('Vieux-Fort'),
      '11' => t('Praslin'),
    ),
    'LI' => array(
      '01' => t('Balzers'),
      '02' => t('Eschen'),
      '03' => t('Gamprin'),
      '04' => t('Mauren'),
      '05' => t('Planken'),
      '06' => t('Ruggell'),
      '07' => t('Schaan'),
      '08' => t('Schellenberg'),
      '09' => t('Triesen'),
      '10' => t('Triesenberg'),
      '11' => t('Vaduz'),
      '21' => t('Gbarpolu'),
      '22' => t('River Gee'),
    ),
    'LK' => array(
      '01' => t('Amparai'),
      '02' => t('Anuradhapura'),
      '03' => t('Badulla'),
      '04' => t('Batticaloa'),
      '06' => t('Galle'),
      '07' => t('Hambantota'),
      '09' => t('Kalutara'),
      '10' => t('Kandy'),
      '11' => t('Kegalla'),
      '12' => t('Kurunegala'),
      '14' => t('Matale'),
      '15' => t('Matara'),
      '16' => t('Moneragala'),
      '17' => t('Nuwara Eliya'),
      '18' => t('Polonnaruwa'),
      '19' => t('Puttalam'),
      '20' => t('Ratnapura'),
      '21' => t('Trincomalee'),
      '23' => t('Colombo'),
      '24' => t('Gampaha'),
      '25' => t('Jaffna'),
      '26' => t('Mannar'),
      '27' => t('Mullaittivu'),
      '28' => t('Vavuniya'),
      '29' => t('Central'),
      '30' => t('North Central'),
      '31' => t('Northern'),
      '32' => t('North Western'),
      '33' => t('Sabaragamuwa'),
      '34' => t('Southern'),
      '35' => t('Uva'),
      '36' => t('Western'),
    ),
    'LR' => array(
      '01' => t('Bong'),
      '04' => t('Grand Cape Mount'),
      '05' => t('Lofa'),
      '06' => t('Maryland'),
      '07' => t('Monrovia'),
      '09' => t('Nimba'),
      '10' => t('Sino'),
      '11' => t('Grand Bassa'),
      '12' => t('Grand Cape Mount'),
      '13' => t('Maryland'),
      '14' => t('Montserrado'),
      '17' => t('Margibi'),
      '18' => t('River Cess'),
      '19' => t('Grand Gedeh'),
      '20' => t('Lofa'),
      '21' => t('Gbarpolu'),
      '22' => t('River Gee'),
    ),
    'LS' => array(
      '10' => t('Berea'),
      '11' => t('Butha-Buthe'),
      '12' => t('Leribe'),
      '13' => t('Mafeteng'),
      '14' => t('Maseru'),
      '15' => t('Mohales Hoek'),
      '16' => t('Mokhotlong'),
      '17' => t('Qachas Nek'),
      '18' => t('Quthing'),
      '19' => t('Thaba-Tseka'),
    ),
    'LT' => array(
      '56' => t('Alytaus Apskritis'),
      '57' => t('Kauno Apskritis'),
      '58' => t('Klaipedos Apskritis'),
      '59' => t('Marijampoles Apskritis'),
      '60' => t('Panevezio Apskritis'),
      '61' => t('Siauliu Apskritis'),
      '62' => t('Taurages Apskritis'),
      '63' => t('Telsiu Apskritis'),
      '64' => t('Utenos Apskritis'),
      '65' => t('Vilniaus Apskritis'),
    ),
    'LU' => array(
      '01' => t('Diekirch'),
      '02' => t('Grevenmacher'),
      '03' => t('Luxembourg'),
    ),
    'LV' => array(
      '01' => t('Aizkraukles'),
      '02' => t('Aluksnes'),
      '03' => t('Balvu'),
      '04' => t('Bauskas'),
      '05' => t('Cesu'),
      '06' => t('Daugavpils'),
      '07' => t('Daugavpils'),
      '08' => t('Dobeles'),
      '09' => t('Gulbenes'),
      '10' => t('Jekabpils'),
      '11' => t('Jelgava'),
      '12' => t('Jelgavas'),
      '13' => t('Jurmala'),
      '14' => t('Kraslavas'),
      '15' => t('Kuldigas'),
      '16' => t('Liepaja'),
      '17' => t('Liepajas'),
      '18' => t('Limbazu'),
      '19' => t('Ludzas'),
      '20' => t('Madonas'),
      '21' => t('Ogres'),
      '22' => t('Preilu'),
      '23' => t('Rezekne'),
      '24' => t('Rezeknes'),
      '25' => t('Riga'),
      '26' => t('Rigas'),
      '27' => t('Saldus'),
      '28' => t('Talsu'),
      '29' => t('Tukuma'),
      '30' => t('Valkas'),
      '31' => t('Valmieras'),
      '32' => t('Ventspils'),
      '33' => t('Ventspils'),
    ),
    'LY' => array(
      '03' => t('Al Aziziyah'),
      '05' => t('Al Jufrah'),
      '08' => t('Al Kufrah'),
      '13' => t("Ash Shati'"),
      '30' => t('Murzuq'),
      '34' => t('Sabha'),
      '41' => t('Tarhunah'),
      '42' => t('Tubruq'),
      '45' => t('Zlitan'),
      '47' => t('Ajdabiya'),
      '48' => t('Al Fatih'),
      '49' => t('Al Jabal al Akhdar'),
      '50' => t('Al Khums'),
      '51' => t('An Nuqat al Khams'),
      '52' => t('Awbari'),
      '53' => t('Az Zawiyah'),
      '54' => t('Banghazi'),
      '55' => t('Darnah'),
      '56' => t('Ghadamis'),
      '57' => t('Gharyan'),
      '58' => t('Misratah'),
      '59' => t('Sawfajjin'),
      '60' => t('Surt'),
      '61' => t('Tarabulus'),
      '62' => t('Yafran'),
    ),
    'MA' => array(
      '01' => t('Agadir'),
      '02' => t('Al Hoceima'),
      '03' => t('Azilal'),
      '04' => t('Ben Slimane'),
      '05' => t('Beni Mellal'),
      '06' => t('Boulemane'),
      '07' => t('Casablanca'),
      '08' => t('Chaouen'),
      '09' => t('El Jadida'),
      '10' => t('El Kelaa des Srarhna'),
      '11' => t('Er Rachidia'),
      '12' => t('Essaouira'),
      '13' => t('Fes'),
      '14' => t('Figuig'),
      '15' => t('Kenitra'),
      '16' => t('Khemisset'),
      '17' => t('Khenifra'),
      '18' => t('Khouribga'),
      '19' => t('Marrakech'),
      '20' => t('Meknes'),
      '21' => t('Nador'),
      '22' => t('Ouarzazate'),
      '23' => t('Oujda'),
      '24' => t('Rabat-Sale'),
      '25' => t('Safi'),
      '26' => t('Settat'),
      '27' => t('Tanger'),
      '29' => t('Tata'),
      '30' => t('Taza'),
      '32' => t('Tiznit'),
      '33' => t('Guelmim'),
      '34' => t('Ifrane'),
      '35' => t('Laayoune'),
      '36' => t('Tan-Tan'),
      '37' => t('Taounate'),
      '38' => t('Sidi Kacem'),
      '39' => t('Taroudannt'),
      '40' => t('Tetouan'),
      '41' => t('Larache'),
      '45' => t('Grand Casablanca'),
      '46' => t('Fes-Boulemane'),
      '47' => t('Marrakech-Tensift-Al Haouz'),
      '48' => t('Meknes-Tafilalet'),
      '49' => t('Rabat-Sale-Zemmour-Zaer'),
      '50' => t('Chaouia-Ouardigha'),
      '51' => t('Doukkala-Abda'),
      '52' => t('Gharb-Chrarda-Beni Hssen'),
      '53' => t('Guelmim-Es Smara'),
      '54' => t('Oriental'),
      '55' => t('Souss-Massa-Dr,a'),
      '56' => t('Tadla-Azilal'),
      '57' => t('Tanger-Tetouan'),
      '58' => t('Taza-Al Hoceima-Taounate'),
      '59' => t('La,youne-Boujdour-Sakia El Hamra'),
    ),
    'MC' => array(
      '01' => t('La Condamine'),
      '02' => t('Monaco'),
      '03' => t('Monte-Carlo'),
    ),
    'MD' => array(
      '46' => t('Balti'),
      '47' => t('Cahul'),
      '48' => t('Chisinau'),
      '49' => t('Stinga Nistrului'),
      '50' => t('Edinet'),
      '51' => t('Gagauzia'),
      '52' => t('Lapusna'),
      '53' => t('Orhei'),
      '54' => t('Soroca'),
      '55' => t('Tighina'),
      '56' => t('Ungheni'),
      '58' => t('Stinga Nistrului'),
      '59' => t('Anenii Noi'),
      '60' => t('Balti'),
      '61' => t('Basarabeasca'),
      '62' => t('Bender'),
      '63' => t('Briceni'),
      '64' => t('Cahul'),
      '65' => t('Cantemir'),
      '66' => t('Calarasi'),
      '67' => t('Causeni'),
      '68' => t('Cimislia'),
      '69' => t('Criuleni'),
      '70' => t('Donduseni'),
      '71' => t('Drochia'),
      '72' => t('Dubasari'),
      '73' => t('Edinet'),
      '74' => t('Falesti'),
      '75' => t('Floresti'),
      '76' => t('Glodeni'),
      '77' => t('Hincesti'),
      '78' => t('Ialoveni'),
      '79' => t('Leova'),
      '80' => t('Nisporeni'),
      '81' => t('Ocnita'),
      '83' => t('Rezina'),
      '84' => t('Riscani'),
      '85' => t('Singerei'),
      '86' => t('Soldanesti'),
      '87' => t('Soroca'),
      '88' => t('Stefan-Voda'),
      '89' => t('Straseni'),
      '90' => t('Taraclia'),
      '91' => t('Telenesti'),
      '92' => t('Ungheni'),
    ),
    'MG' => array(
      '01' => t('Antsiranana'),
      '02' => t('Fianarantsoa'),
      '03' => t('Mahajanga'),
      '04' => t('Toamasina'),
      '05' => t('Antananarivo'),
      '06' => t('Toliara'),
    ),
    'MK' => array(
      '01' => t('Aracinovo'),
      '02' => t('Bac'),
      '03' => t('Belcista'),
      '04' => t('Berovo'),
      '05' => t('Bistrica'),
      '06' => t('Bitola'),
      '07' => t('Blatec'),
      '08' => t('Bogdanci'),
      '09' => t('Bogomila'),
      '10' => t('Bogovinje'),
      '11' => t('Bosilovo'),
      '12' => t('Brvenica'),
      '13' => t('Cair'),
      '14' => t('Capari'),
      '15' => t('Caska'),
      '16' => t('Cegrane'),
      '17' => t('Centar'),
      '18' => t('Centar Zupa'),
      '19' => t('Cesinovo'),
      '20' => t('Cucer-Sandevo'),
      '21' => t('Debar'),
      '22' => t('Delcevo'),
      '23' => t('Delogozdi'),
      '24' => t('Demir Hisar'),
      '25' => t('Demir Kapija'),
      '26' => t('Dobrusevo'),
      '27' => t('Dolna Banjica'),
      '28' => t('Dolneni'),
      '29' => t('Dorce Petrov'),
      '30' => t('Drugovo'),
      '31' => t('Dzepciste'),
      '32' => t('Gazi Baba'),
      '33' => t('Gevgelija'),
      '34' => t('Gostivar'),
      '35' => t('Gradsko'),
      '36' => t('Ilinden'),
      '37' => t('Izvor'),
      '38' => t('Jegunovce'),
      '39' => t('Kamenjane'),
      '40' => t('Karbinci'),
      '41' => t('Karpos'),
      '42' => t('Kavadarci'),
      '43' => t('Kicevo'),
      '44' => t('Kisela Voda'),
      '45' => t('Klecevce'),
      '46' => t('Kocani'),
      '47' => t('Konce'),
      '48' => t('Kondovo'),
      '49' => t('Konopiste'),
      '50' => t('Kosel'),
      '51' => t('Kratovo'),
      '52' => t('Kriva Palanka'),
      '53' => t('Krivogastani'),
      '54' => t('Krusevo'),
      '55' => t('Kuklis'),
      '56' => t('Kukurecani'),
      '57' => t('Kumanovo'),
      '58' => t('Labunista'),
      '59' => t('Lipkovo'),
      '60' => t('Lozovo'),
      '61' => t('Lukovo'),
      '62' => t('Makedonska Kamenica'),
      '63' => t('Makedonski Brod'),
      '64' => t('Mavrovi Anovi'),
      '65' => t('Meseista'),
      '66' => t('Miravci'),
      '67' => t('Mogila'),
      '68' => t('Murtino'),
      '69' => t('Negotino'),
      '70' => t('Negotino-Polosko'),
      '71' => t('Novaci'),
      '72' => t('Novo Selo'),
      '73' => t('Oblesevo'),
      '74' => t('Ohrid'),
      '75' => t('Orasac'),
      '76' => t('Orizari'),
      '77' => t('Oslomej'),
      '78' => t('Pehcevo'),
      '79' => t('Petrovec'),
      '80' => t('Plasnica'),
      '81' => t('Podares'),
      '82' => t('Prilep'),
      '83' => t('Probistip'),
      '84' => t('Radovis'),
      '85' => t('Rankovce'),
      '86' => t('Resen'),
      '87' => t('Rosoman'),
      '88' => t('Rostusa'),
      '89' => t('Samokov'),
      '90' => t('Saraj'),
      '91' => t('Sipkovica'),
      '92' => t('Sopiste'),
      '93' => t('Sopotnica'),
      '94' => t('Srbinovo'),
      '95' => t('Staravina'),
      '96' => t('Star Dojran'),
      '97' => t('Staro Nagoricane'),
      '98' => t('Stip'),
      '99' => t('Struga'),
      'A1' => t('Strumica'),
      'A2' => t('Studenicani'),
      'A3' => t('Suto Orizari'),
      'A4' => t('Sveti Nikole'),
      'A5' => t('Tearce'),
      'A6' => t('Tetovo'),
      'A7' => t('Topolcani'),
      'A8' => t('Valandovo'),
      'A9' => t('Vasilevo'),
      'B1' => t('Veles'),
      'B2' => t('Velesta'),
      'B3' => t('Vevcani'),
      'B4' => t('Vinica'),
      'B5' => t('Vitoliste'),
      'B6' => t('Vranestica'),
      'B7' => t('Vrapciste'),
      'B8' => t('Vratnica'),
      'B9' => t('Vrutok'),
      'C1' => t('Zajas'),
      'C2' => t('Zelenikovo'),
      'C3' => t('Zelino'),
      'C4' => t('Zitose'),
      'C5' => t('Zletovo'),
      'C6' => t('Zrnovci'),
    ),
    'ML' => array(
      '01' => t('Bamako'),
      '03' => t('Kayes'),
      '04' => t('Mopti'),
      '05' => t('Segou'),
      '06' => t('Sikasso'),
      '07' => t('Koulikoro'),
      '08' => t('Tombouctou'),
      '09' => t('Gao'),
      '10' => t('Kidal'),
    ),
    'MM' => array(
      '01' => t('Rakhine State'),
      '02' => t('Chin State'),
      '03' => t('Irrawaddy'),
      '04' => t('Kachin State'),
      '05' => t('Karan State'),
      '06' => t('Kayah State'),
      '07' => t('Magwe'),
      '08' => t('Mandalay'),
      '09' => t('Pegu'),
      '10' => t('Sagaing'),
      '11' => t('Shan State'),
      '12' => t('Tenasserim'),
      '13' => t('Mon State'),
      '14' => t('Rangoon'),
      '17' => t('Yangon'),
    ),
    'MN' => array(
      '01' => t('Arhangay'),
      '02' => t('Bayanhongor'),
      '03' => t('Bayan-Olgiy'),
      '05' => t('Darhan'),
      '06' => t('Dornod'),
      '07' => t('Dornogovi'),
      '08' => t('Dundgovi'),
      '09' => t('Dzavhan'),
      '10' => t('Govi-Altay'),
      '11' => t('Hentiy'),
      '12' => t('Hovd'),
      '13' => t('Hovsgol'),
      '14' => t('Omnogovi'),
      '15' => t('Ovorhangay'),
      '16' => t('Selenge'),
      '17' => t('Suhbaatar'),
      '18' => t('Tov'),
      '19' => t('Uvs'),
      '20' => t('Ulaanbaatar'),
      '21' => t('Bulgan'),
      '22' => t('Erdenet'),
      '23' => t('Darhan-Uul'),
      '24' => t('Govisumber'),
      '25' => t('Orhon'),
    ),
    'MO' => array(
      '01' => t('Ilhas'),
      '02' => t('Macau'),
    ),
    'MR' => array(
      '01' => t('Hodh Ech Chargui'),
      '02' => t('Hodh El Gharbi'),
      '03' => t('Assaba'),
      '04' => t('Gorgol'),
      '05' => t('Brakna'),
      '06' => t('Trarza'),
      '07' => t('Adrar'),
      '08' => t('Dakhlet Nouadhibou'),
      '09' => t('Tagant'),
      '10' => t('Guidimaka'),
      '11' => t('Tiris Zemmour'),
      '12' => t('Inchiri'),
    ),
    'MS' => array(
      '01' => t('Saint Anthony'),
      '02' => t('Saint Georges'),
      '03' => t('Saint Peter'),
    ),
    'MU' => array(
      '12' => t('Black River'),
      '13' => t('Flacq'),
      '14' => t('Grand Port'),
      '15' => t('Moka'),
      '16' => t('Pamplemousses'),
      '17' => t('Plaines Wilhems'),
      '18' => t('Port Louis'),
      '19' => t('Riviere du Rempart'),
      '20' => t('Savanne'),
      '21' => t('Agalega Islands'),
      '22' => t('Cargados Carajos'),
      '23' => t('Rodrigues'),
    ),
    'MV' => array(
      '01' => t('Seenu'),
      '02' => t('Aliff'),
      '03' => t('Laviyani'),
      '04' => t('Waavu'),
      '05' => t('Laamu'),
      '07' => t('Haa Aliff'),
      '08' => t('Thaa'),
      '12' => t('Meemu'),
      '13' => t('Raa'),
      '14' => t('Faafu'),
      '17' => t('Daalu'),
      '20' => t('Baa'),
      '23' => t('Haa Daalu'),
      '24' => t('Shaviyani'),
      '25' => t('Noonu'),
      '26' => t('Kaafu'),
      '27' => t('Gaafu Aliff'),
      '28' => t('Gaafu Daalu'),
      '29' => t('Naviyani'),
      '40' => t('Male'),
    ),
    'MW' => array(
      '02' => t('Chikwawa'),
      '03' => t('Chiradzulu'),
      '04' => t('Chitipa'),
      '05' => t('Thyolo'),
      '06' => t('Dedza'),
      '07' => t('Dowa'),
      '08' => t('Karonga'),
      '09' => t('Kasungu'),
      '11' => t('Lilongwe'),
      '12' => t('Mangochi'),
      '13' => t('Mchinji'),
      '15' => t('Mzimba'),
      '16' => t('Ntcheu'),
      '17' => t('Nkhata Bay'),
      '18' => t('Nkhotakota'),
      '19' => t('Nsanje'),
      '20' => t('Ntchisi'),
      '21' => t('Rumphi'),
      '22' => t('Salima'),
      '23' => t('Zomba'),
      '24' => t('Blantyre'),
      '25' => t('Mwanza'),
      '26' => t('Balaka'),
      '27' => t('Likoma'),
      '28' => t('Machinga'),
      '29' => t('Mulanje'),
      '30' => t('Phalombe'),
    ),
    'MX' => array(
      '01' => t('Aguascalientes'),
      '02' => t('Baja California'),
      '03' => t('Baja California Sur'),
      '04' => t('Campeche'),
      '05' => t('Chiapas'),
      '06' => t('Chihuahua'),
      '07' => t('Coahuila de Zaragoza'),
      '08' => t('Colima'),
      '09' => t('Distrito Federal'),
      '10' => t('Durango'),
      '11' => t('Guanajuato'),
      '12' => t('Guerrero'),
      '13' => t('Hidalgo'),
      '14' => t('Jalisco'),
      '15' => t('Mexico'),
      '16' => t('Michoacan de Ocampo'),
      '17' => t('Morelos'),
      '18' => t('Nayarit'),
      '19' => t('Nuevo Leon'),
      '20' => t('Oaxaca'),
      '21' => t('Puebla'),
      '22' => t('Queretaro de Arteaga'),
      '23' => t('Quintana Roo'),
      '24' => t('San Luis Potosi'),
      '25' => t('Sinaloa'),
      '26' => t('Sonora'),
      '27' => t('Tabasco'),
      '28' => t('Tamaulipas'),
      '29' => t('Tlaxcala'),
      '30' => t('Veracruz-Llave'),
      '31' => t('Yucatan'),
      '32' => t('Zacatecas'),
    ),
    'MY' => array(
      '01' => t('Johor'),
      '02' => t('Kedah'),
      '03' => t('Kelantan'),
      '04' => t('Melaka'),
      '05' => t('Negeri Sembilan'),
      '06' => t('Pahang'),
      '07' => t('Perak'),
      '08' => t('Perlis'),
      '09' => t('Pulau Pinang'),
      '11' => t('Sarawak'),
      '12' => t('Selangor'),
      '13' => t('Terengganu'),
      '14' => t('Kuala Lumpur'),
      '15' => t('Labuan'),
      '16' => t('Sabah'),
      '17' => t('Putrajaya'),
    ),
    'MZ' => array(
      '01' => t('Cabo Delgado'),
      '02' => t('Gaza'),
      '03' => t('Inhambane'),
      '04' => t('Maputo'),
      '05' => t('Sofala'),
      '06' => t('Nampula'),
      '07' => t('Niassa'),
      '08' => t('Tete'),
      '09' => t('Zambezia'),
      '10' => t('Manica'),
      '11' => t('Maputo'),
    ),
    'NA' => array(
      '01' => t('Bethanien'),
      '02' => t('Caprivi Oos'),
      '03' => t('Boesmanland'),
      '04' => t('Gobabis'),
      '05' => t('Grootfontein'),
      '06' => t('Kaokoland'),
      '07' => t('Karibib'),
      '08' => t('Keetmanshoop'),
      '09' => t('Luderitz'),
      '10' => t('Maltahohe'),
      '11' => t('Okahandja'),
      '12' => t('Omaruru'),
      '13' => t('Otjiwarongo'),
      '14' => t('Outjo'),
      '15' => t('Owambo'),
      '16' => t('Rehoboth'),
      '17' => t('Swakopmund'),
      '18' => t('Tsumeb'),
      '20' => t('Karasburg'),
      '21' => t('Windhoek'),
      '22' => t('Damaraland'),
      '23' => t('Hereroland Oos'),
      '24' => t('Hereroland Wes'),
      '25' => t('Kavango'),
      '26' => t('Mariental'),
      '27' => t('Namaland'),
      '28' => t('Caprivi'),
      '29' => t('Erongo'),
      '30' => t('Hardap'),
      '31' => t('Karas'),
      '32' => t('Kunene'),
      '33' => t('Ohangwena'),
      '34' => t('Okavango'),
      '35' => t('Omaheke'),
      '36' => t('Omusati'),
      '37' => t('Oshana'),
      '38' => t('Oshikoto'),
      '39' => t('Otjozondjupa'),
    ),
    'NE' => array(
      '01' => t('Agadez'),
      '02' => t('Diffa'),
      '03' => t('Dosso'),
      '04' => t('Maradi'),
      '05' => t('Niamey'),
      '06' => t('Tahoua'),
      '07' => t('Zinder'),
      '08' => t('Niamey'),
    ),
    'NG' => array(
      '05' => t('Lagos'),
      '10' => t('Rivers'),
      '11' => t('Federal Capital Territory'),
      '12' => t('Gongola'),
      '16' => t('Ogun'),
      '17' => t('Ondo'),
      '18' => t('Oyo'),
      '21' => t('Akwa Ibom'),
      '22' => t('Cross River'),
      '23' => t('Kaduna'),
      '24' => t('Katsina'),
      '25' => t('Anambra'),
      '26' => t('Benue'),
      '27' => t('Borno'),
      '28' => t('Imo'),
      '29' => t('Kano'),
      '30' => t('Kwara'),
      '31' => t('Niger'),
      '32' => t('Oyo'),
      '35' => t('Adamawa'),
      '36' => t('Delta'),
      '37' => t('Edo'),
      '39' => t('Jigawa'),
      '40' => t('Kebbi'),
      '41' => t('Kogi'),
      '42' => t('Osun'),
      '43' => t('Taraba'),
      '44' => t('Yobe'),
      '45' => t('Abia'),
      '46' => t('Bauchi'),
      '47' => t('Enugu'),
      '48' => t('Ondo'),
      '49' => t('Plateau'),
      '50' => t('Rivers'),
      '51' => t('Sokoto'),
      '52' => t('Bayelsa'),
      '53' => t('Ebonyi'),
      '54' => t('Ekiti'),
      '55' => t('Gombe'),
      '56' => t('Nassarawa'),
      '57' => t('Zamfara'),
    ),
    'NI' => array(
      '01' => t('Boaco'),
      '02' => t('Carazo'),
      '03' => t('Chinandega'),
      '04' => t('Chontales'),
      '05' => t('Esteli'),
      '06' => t('Granada'),
      '07' => t('Jinotega'),
      '08' => t('Leon'),
      '09' => t('Madriz'),
      '10' => t('Managua'),
      '11' => t('Masaya'),
      '12' => t('Matagalpa'),
      '13' => t('Nueva Segovia'),
      '14' => t('Rio San Juan'),
      '15' => t('Rivas'),
      '16' => t('Zelaya'),
      '17' => t('Autonoma Atlantico Norte'),
      '18' => t('Region Autonoma Atlantico Sur'),
    ),
    'NL' => array(
      '01' => t('Drenthe'),
      '02' => t('Friesland'),
      '03' => t('Gelderland'),
      '04' => t('Groningen'),
      '05' => t('Limburg'),
      '06' => t('Noord-Brabant'),
      '07' => t('Noord-Holland'),
      '08' => t('Overijssel'),
      '09' => t('Utrecht'),
      '10' => t('Zeeland'),
      '11' => t('Zuid-Holland'),
      '12' => t('Dronten'),
      '13' => t('Zuidelijke IJsselmeerpolders'),
      '14' => t('Lelystad'),
      '15' => t('Overijssel'),
      '16' => t('Flevoland'),
    ),
    'NO' => array(
      '01' => t('Akershus'),
      '02' => t('Aust-Agder'),
      '04' => t('Buskerud'),
      '05' => t('Finnmark'),
      '06' => t('Hedmark'),
      '07' => t('Hordaland'),
      '08' => t('More og Romsdal'),
      '09' => t('Nordland'),
      '10' => t('Nord-Trondelag'),
      '11' => t('Oppland'),
      '12' => t('Oslo'),
      '13' => t('Ostfold'),
      '14' => t('Rogaland'),
      '15' => t('Sogn og Fjordane'),
      '16' => t('Sor-Trondelag'),
      '17' => t('Telemark'),
      '18' => t('Troms'),
      '19' => t('Vest-Agder'),
      '20' => t('Vestfold'),
    ),
    'NP' => array(
      '01' => t('Bagmati'),
      '02' => t('Bheri'),
      '03' => t('Dhawalagiri'),
      '04' => t('Gandaki'),
      '05' => t('Janakpur'),
      '06' => t('Karnali'),
      '07' => t('Kosi'),
      '08' => t('Lumbini'),
      '09' => t('Mahakali'),
      '10' => t('Mechi'),
      '11' => t('Narayani'),
      '12' => t('Rapti'),
      '13' => t('Sagarmatha'),
      '14' => t('Seti'),
    ),
    'NR' => array(
      '01' => t('Aiwo'),
      '02' => t('Anabar'),
      '03' => t('Anetan'),
      '04' => t('Anibare'),
      '05' => t('Baiti'),
      '06' => t('Boe'),
      '07' => t('Buada'),
      '08' => t('Denigomodu'),
      '09' => t('Ewa'),
      '10' => t('Ijuw'),
      '11' => t('Meneng'),
      '12' => t('Nibok'),
      '13' => t('Uaboe'),
      '14' => t('Yaren'),
    ),
    'NZ' => array(
      '10' => t('Chatham Islands'),
      '85' => t('Waikato'),
      'E7' => t('Auckland'),
      'E8' => t('Bay of Plenty'),
      'E9' => t('Canterbury'),
      'F1' => t('Gisborne'),
      'F2' => t("Hawke's Bay"),
      'F3' => t('Manawatu-Wanganui'),
      'F4' => t('Marlborough'),
      'F5' => t('Nelson'),
      'F6' => t('Northland'),
      'F7' => t('Otago'),
      'F8' => t('Southland'),
      'F9' => t('Taranaki'),
      'G1' => t('Waikato'),
      'G2' => t('Wellington'),
      'G3' => t('West Coast'),
    ),
    'OM' => array(
      '01' => t('Ad Dakhiliyah'),
      '02' => t('Al Batinah'),
      '03' => t('Al Wusta'),
      '04' => t('Ash Sharqiyah'),
      '05' => t('Az Zahirah'),
      '06' => t('Masqat'),
      '07' => t('Musandam'),
      '08' => t('Zufar'),
    ),
    'PA' => array(
      '01' => t('Bocas del Toro'),
      '02' => t('Chiriqui'),
      '03' => t('Cocle'),
      '04' => t('Colon'),
      '05' => t('Darien'),
      '06' => t('Herrera'),
      '07' => t('Los Santos'),
      '08' => t('Panama'),
      '09' => t('San Blas'),
      '10' => t('Veraguas'),
    ),
    'PE' => array(
      '01' => t('Amazonas'),
      '02' => t('Ancash'),
      '03' => t('Apurimac'),
      '04' => t('Arequipa'),
      '05' => t('Ayacucho'),
      '06' => t('Cajamarca'),
      '07' => t('Callao'),
      '08' => t('Cusco'),
      '09' => t('Huancavelica'),
      '10' => t('Huanuco'),
      '11' => t('Ica'),
      '12' => t('Junin'),
      '13' => t('La Libertad'),
      '14' => t('Lambayeque'),
      '15' => t('Lima'),
      '16' => t('Loreto'),
      '17' => t('Madre de Dios'),
      '18' => t('Moquegua'),
      '19' => t('Pasco'),
      '20' => t('Piura'),
      '21' => t('Puno'),
      '22' => t('San Martin'),
      '23' => t('Tacna'),
      '24' => t('Tumbes'),
      '25' => t('Ucayali'),
    ),
    'PG' => array(
      '01' => t('Central'),
      '02' => t('Gulf'),
      '03' => t('Milne Bay'),
      '04' => t('Northern'),
      '05' => t('Southern Highlands'),
      '06' => t('Western'),
      '07' => t('North Solomons'),
      '08' => t('Chimbu'),
      '09' => t('Eastern Highlands'),
      '10' => t('East New Britain'),
      '11' => t('East Sepik'),
      '12' => t('Madang'),
      '13' => t('Manus'),
      '14' => t('Morobe'),
      '15' => t('New Ireland'),
      '16' => t('Western Highlands'),
      '17' => t('West New Britain'),
      '18' => t('Sandaun'),
      '19' => t('Enga'),
      '20' => t('National Capital'),
    ),
    'PH' => array(
      '01' => t('Abra Province'),
      '02' => t('Agusan del Norte Province'),
      '03' => t('Agusan del Sur Province'),
      '04' => t('Aklan Province'),
      '05' => t('Albay Province'),
      '06' => t('Antique Province'),
      '07' => t('Bataan Province'),
      '08' => t('Batanes Province'),
      '09' => t('Batangas Province'),
      '10' => t('Benguet Province'),
      '11' => t('Bohol Province'),
      '12' => t('Bukidnon Province'),
      '13' => t('Bulacan Province'),
      '14' => t('Cagayan Province'),
      '15' => t('Camarines Norte Province'),
      '16' => t('Camarines Sur Province'),
      '17' => t('Camiguin Province'),
      '18' => t('Capiz Province'),
      '19' => t('Catanduanes Province'),
      '20' => t('Cavite Province'),
      '21' => t('Cebu Province'),
      '22' => t('Basilan Province'),
      '23' => t('Eastern Samar Province'),
      '24' => t('Davao Province'),
      '25' => t('Davao del Sur Province'),
      '26' => t('Davao Oriental Province'),
      '27' => t('Ifugao Province'),
      '28' => t('Ilocos Norte Province'),
      '29' => t('Ilocos Sur Province'),
      '30' => t('Iloilo Province'),
      '31' => t('Isabela Province'),
      '32' => t('Kalinga-Apayao Province'),
      '33' => t('Laguna Province'),
      '34' => t('Lanao del Norte Province'),
      '35' => t('Lanao del Sur Province'),
      '36' => t('La Union Province'),
      '37' => t('Leyte Province'),
      '38' => t('Marinduque Province'),
      '39' => t('Masbate Province'),
      '40' => t('Mindoro Occidental Province'),
      '41' => t('Mindoro Oriental Province'),
      '42' => t('Misamis Occidental Province'),
      '43' => t('Misamis Oriental Province'),
      '44' => t('Mountain Province'),
      '45' => t('Negros Occidental Province'),
      '46' => t('Negros Oriental Province'),
      '47' => t('Nueva Ecija Province'),
      '48' => t('Nueva Vizcaya Province'),
      '49' => t('Palawan Province'),
      '50' => t('Pampanga Province'),
      '51' => t('Pangasinan Province'),
      '53' => t('Rizal Province'),
      '54' => t('Romblon Province'),
      '55' => t('Samar Province'),
      '56' => t('Maguindanao Province'),
      '57' => t('North Cotabato Province'),
      '58' => t('Sorsogon Province'),
      '59' => t('Southern Leyte Province'),
      '60' => t('Sulu Province'),
      '61' => t('Surigao del Norte Province'),
      '62' => t('Surigao del Sur Province'),
      '63' => t('Tarlac Province'),
      '64' => t('Zambales Province'),
      '65' => t('Zamboanga del Norte Province'),
      '66' => t('Zamboanga del Sur Province'),
      '67' => t('Northern Samar Province'),
      '68' => t('Quirino Province'),
      '69' => t('Siquijor Province'),
      '70' => t('South Cotabato Province'),
      '71' => t('Sultan Kudarat Province'),
      '72' => t('Tawitawi Province'),
      'A1' => t('Angeles Chartered City'),
      'A2' => t('Bacolod Chartered City'),
      'A3' => t('Bago Chartered City'),
      'A4' => t('Baguio Chartered City'),
      'A5' => t('Bais Chartered City'),
      'A6' => t('Basilan City Chartered City'),
      'A7' => t('Batangas City Chartered City'),
      'A8' => t('Butuan Chartered City'),
      'A9' => t('Cabanatuan Chartered City'),
      'B1' => t('Cadiz Chartered City'),
      'B2' => t('Cagayan de Oro Chartered City'),
      'B3' => t('Calbayog Chartered City'),
      'B4' => t('Caloocan Chartered City'),
      'B5' => t('Canlaon Chartered City'),
      'B6' => t('Cavite City Chartered City'),
      'B7' => t('Cebu City Chartered City'),
      'B8' => t('Cotabato Chartered City'),
      'B9' => t('Dagupan Chartered City'),
      'C1' => t('Danao Chartered City'),
      'C2' => t('Dapitan Chartered City'),
      'C3' => t('Davao City Chartered City'),
      'C4' => t('Dipolog Chartered City'),
      'C5' => t('Dumaguete Chartered City'),
      'C6' => t('General Santos Chartered City'),
      'C7' => t('Gingoog Chartered City'),
      'C8' => t('Iligan Chartered City'),
      'C9' => t('Iloilo City Chartered City'),
      'D1' => t('Iriga Chartered City'),
      'D2' => t('La Carlota Chartered City'),
      'D3' => t('Laoag Chartered City'),
      'D4' => t('Lapu-Lapu Chartered City'),
      'D5' => t('Legaspi Chartered City'),
      'D6' => t('Lipa Chartered City'),
      'D7' => t('Lucena Chartered City'),
      'D8' => t('Mandaue Chartered City'),
      'D9' => t('Manila Chartered City'),
      'E1' => t('Marawi Chartered City'),
      'E2' => t('Naga Chartered City'),
      'E3' => t('Olongapo Chartered City'),
      'E4' => t('Ormoc Chartered City'),
      'E5' => t('Oroquieta Chartered City'),
      'E6' => t('Ozamis Chartered City'),
      'E7' => t('Pagadian Chartered City'),
      'E8' => t('Palayan Chartered City'),
      'E9' => t('Pasay Chartered City'),
      'F1' => t('Puerto Princesa Chartered City'),
      'F2' => t('Quezon City Chartered City'),
      'F3' => t('Roxas Chartered City'),
      'F4' => t('San Carlos, Negros Occidental Chartered City'),
      'F5' => t('San Carlos, Pangasinan Chartered City'),
      'F6' => t('San Jose Chartered City'),
      'F7' => t('San Pablo Chartered City'),
      'F8' => t('Silay Chartered City'),
      'F9' => t('Surigao Chartered City'),
      'G1' => t('Tacloban Chartered City'),
      'G2' => t('Tagaytay Chartered City'),
      'G3' => t('Tagbilaran Chartered City'),
      'G4' => t('Tangub Chartered City'),
      'G5' => t('Toledo Chartered City'),
      'G6' => t('Trece Martires Chartered City'),
      'G7' => t('Zamboanga Chartered City'),
      'G8' => t('Aurora Province'),
      'H2' => t('Quezon Province'),
      'H3' => t('Negros Occidental Chartered City'),
    ),
    'PK' => array(
      '01' => t('Federally Administered Tribal Areas'),
      '02' => t('Balochistan'),
      '03' => t('North-West Frontier'),
      '04' => t('Punjab'),
      '05' => t('Sindh'),
      '06' => t('Azad Kashmir'),
      '07' => t('Northern Areas'),
      '08' => t('Islamabad'),
    ),
    'PL' => array(
      '23' => t('Biala Podlaska'),
      '24' => t('Bialystok'),
      '25' => t('Bielsko'),
      '26' => t('Bydgoszcz'),
      '27' => t('Chelm'),
      '28' => t('Ciechanow'),
      '29' => t('Czestochowa'),
      '30' => t('Elblag'),
      '31' => t('Gdansk'),
      '32' => t('Gorzow'),
      '33' => t('Jelenia Gora'),
      '34' => t('Kalisz'),
      '35' => t('Katowice'),
      '36' => t('Kielce'),
      '37' => t('Konin'),
      '38' => t('Koszalin'),
      '39' => t('Krakow'),
      '40' => t('Krosno'),
      '41' => t('Legnica'),
      '42' => t('Leszno'),
      '43' => t('Lodz'),
      '44' => t('Lomza'),
      '45' => t('Lublin'),
      '46' => t('Nowy Sacz'),
      '47' => t('Olsztyn'),
      '48' => t('Opole'),
      '49' => t('Ostroleka'),
      '50' => t('Pila'),
      '51' => t('Piotrkow'),
      '52' => t('Plock'),
      '53' => t('Poznan'),
      '54' => t('Przemysl'),
      '55' => t('Radom'),
      '56' => t('Rzeszow'),
      '57' => t('Siedlce'),
      '58' => t('Sieradz'),
      '59' => t('Skierniewice'),
      '60' => t('Slupsk'),
      '61' => t('Suwalki'),
      '62' => t('Szczecin'),
      '63' => t('Tarnobrzeg'),
      '64' => t('Tarnow'),
      '65' => t('Torun'),
      '66' => t('Walbrzych'),
      '67' => t('Warszawa'),
      '68' => t('Wloclawek'),
      '69' => t('Wroclaw'),
      '70' => t('Zamosc'),
      '71' => t('Zielona Gora'),
      '72' => t('Dolnoslaskie'),
      '73' => t('Kujawsko-Pomorskie'),
      '74' => t('Lodzkie'),
      '75' => t('Lubelskie'),
      '76' => t('Lubuskie'),
      '77' => t('Malopolskie'),
      '78' => t('Mazowieckie'),
      '79' => t('Opolskie'),
      '80' => t('Podkarpackie'),
      '81' => t('Podlaskie'),
      '82' => t('Pomorskie'),
      '83' => t('Slaskie'),
      '84' => t('Swietokrzyskie'),
      '85' => t('Warminsko-Mazurskie'),
      '86' => t('Wielkopolskie'),
      '87' => t('Zachodniopomorskie'),
    ),
    'PS' => array(
      'GZ' => t('Gaza'),
      'WE' => t('West Bank'),
    ),
    'PT' => array(
      '02' => t('Aveiro'),
      '03' => t('Beja'),
      '04' => t('Braga'),
      '05' => t('Braganca'),
      '06' => t('Castelo Branco'),
      '07' => t('Coimbra'),
      '08' => t('Evora'),
      '09' => t('Faro'),
      '10' => t('Madeira'),
      '11' => t('Guarda'),
      '13' => t('Leiria'),
      '14' => t('Lisboa'),
      '16' => t('Portalegre'),
      '17' => t('Porto'),
      '18' => t('Santarem'),
      '19' => t('Setubal'),
      '20' => t('Viana do Castelo'),
      '21' => t('Vila Real'),
      '22' => t('Viseu'),
      '23' => t('Azores'),
    ),
    'PY' => array(
      '01' => t('Alto Parana'),
      '02' => t('Amambay'),
      '03' => t('Boqueron'),
      '04' => t('Caaguazu'),
      '05' => t('Caazapa'),
      '06' => t('Central'),
      '07' => t('Concepcion'),
      '08' => t('Cordillera'),
      '10' => t('Guaira'),
      '11' => t('Itapua'),
      '12' => t('Misiones'),
      '13' => t('Neembucu'),
      '15' => t('Paraguari'),
      '16' => t('Presidente Hayes'),
      '17' => t('San Pedro'),
      '19' => t('Canindeyu'),
      '20' => t('Chaco'),
      '21' => t('Nueva Asuncion'),
      '23' => t('Alto Paraguay'),
    ),
    'QA' => array(
      '01' => t('Ad Dawhah'),
      '02' => t('Al Ghuwariyah'),
      '03' => t('Al Jumaliyah'),
      '04' => t('Al Khawr'),
      '05' => t('Al Wakrah Municipality'),
      '06' => t('Ar Rayyan'),
      '08' => t('Madinat ach Shamal'),
      '09' => t('Umm Salal'),
      '10' => t('Al Wakrah'),
      '11' => t('Jariyan al Batnah'),
      '12' => t("Umm Sa'id"),
    ),
    'RO' => array(
      '01' => t('Alba'),
      '02' => t('Arad'),
      '03' => t('Arges'),
      '04' => t('Bacau'),
      '05' => t('Bihor'),
      '06' => t('Bistrita-Nasaud'),
      '07' => t('Botosani'),
      '08' => t('Braila'),
      '09' => t('Brasov'),
      '10' => t('Bucuresti'),
      '11' => t('Buzau'),
      '12' => t('Caras-Severin'),
      '13' => t('Cluj'),
      '14' => t('Constanta'),
      '15' => t('Covasna'),
      '16' => t('Dambovita'),
      '17' => t('Dolj'),
      '18' => t('Galati'),
      '19' => t('Gorj'),
      '20' => t('Harghita'),
      '21' => t('Hunedoara'),
      '22' => t('Ialomita'),
      '23' => t('Iasi'),
      '25' => t('Maramures'),
      '26' => t('Mehedinti'),
      '27' => t('Mures'),
      '28' => t('Neamt'),
      '29' => t('Olt'),
      '30' => t('Prahova'),
      '31' => t('Salaj'),
      '32' => t('Satu Mare'),
      '33' => t('Sibiu'),
      '34' => t('Suceava'),
      '35' => t('Teleorman'),
      '36' => t('Timis'),
      '37' => t('Tulcea'),
      '38' => t('Vaslui'),
      '39' => t('Valcea'),
      '40' => t('Vrancea'),
      '41' => t('Calarasi'),
      '42' => t('Giurgiu'),
      '43' => t('Ilfov'),
    ),
    'RS' => array(
      '01' => t('Kosovo'),
      '02' => t('Vojvodina'),
    ),
    'RU' => array(
      '01' => t('Adygeya, Republic of'),
      '02' => t('Aginsky Buryatsky AO'),
      '03' => t('Gorno-Altay'),
      '04' => t('Altaisky krai'),
      '05' => t('Amur'),
      '06' => t("Arkhangel'sk"),
      '07' => t("Astrakhan'"),
      '08' => t('Bashkortostan'),
      '09' => t('Belgorod'),
      '10' => t('Bryansk'),
      '11' => t('Buryat'),
      '12' => t('Chechnya'),
      '13' => t('Chelyabinsk'),
      '14' => t('Chita'),
      '15' => t('Chukot'),
      '16' => t('Chuvashia'),
      '17' => t('Dagestan'),
      '18' => t('Evenk'),
      '19' => t('Ingush'),
      '20' => t('Irkutsk'),
      '21' => t('Ivanovo'),
      '22' => t('Kabardin-Balkar'),
      '23' => t('Kaliningrad'),
      '24' => t('Kalmyk'),
      '25' => t('Kaluga'),
      '26' => t('Kamchatka'),
      '27' => t('Karachay-Cherkess'),
      '28' => t('Karelia'),
      '29' => t('Kemerovo'),
      '30' => t('Khabarovsk'),
      '31' => t('Khakass'),
      '32' => t('Khanty-Mansiy'),
      '33' => t('Kirov'),
      '34' => t('Komi'),
      '35' => t('Komi-Permyak'),
      '36' => t('Koryak'),
      '37' => t('Kostroma'),
      '38' => t('Krasnodar'),
      '39' => t('Krasnoyarsk'),
      '40' => t('Kurgan'),
      '41' => t('Kursk'),
      '42' => t('Leningrad'),
      '43' => t('Lipetsk'),
      '44' => t('Magadan'),
      '45' => t('Mariy-El'),
      '46' => t('Mordovia'),
      '47' => t('Moskva'),
      '48' => t('Moscow City'),
      '49' => t('Murmansk'),
      '50' => t('Nenets'),
      '51' => t('Nizhegorod'),
      '52' => t('Novgorod'),
      '53' => t('Novosibirsk'),
      '54' => t('Omsk'),
      '55' => t('Orenburg'),
      '56' => t('Orel'),
      '57' => t('Penza'),
      '58' => t("Perm'"),
      '59' => t("Primor'ye"),
      '60' => t('Pskov'),
      '61' => t('Rostov'),
      '62' => t("Ryazan'"),
      '63' => t('Sakha'),
      '64' => t('Sakhalin'),
      '65' => t('Samara'),
      '66' => t('Saint Petersburg City'),
      '67' => t('Saratov'),
      '68' => t('North Ossetia'),
      '69' => t('Smolensk'),
      '70' => t("Stavropol'"),
      '71' => t('Sverdlovsk'),
      '72' => t('Tambovskaya oblast'),
      '73' => t('Tatarstan'),
      '74' => t('Taymyr'),
      '75' => t('Tomsk'),
      '76' => t('Tula'),
      '77' => t("Tver'"),
      '78' => t("Tyumen'"),
      '79' => t('Tuva'),
      '80' => t('Udmurt'),
      '81' => t("Ul'yanovsk"),
      '82' => t('Ust-Orda Buryat'),
      '83' => t('Vladimir'),
      '84' => t('Volgograd'),
      '85' => t('Vologda'),
      '86' => t('Voronezh'),
      '87' => t('Yamal-Nenets'),
      '88' => t("Yaroslavl'"),
      '89' => t('Yevrey'),
      '90' => t('Permskiy Kray'),
      '91' => t('Krasnoyarskiy Kray'),
      'CI' => t('Chechnya Republic'),
    ),
    'RW' => array(
      '01' => t('Butare'),
      '06' => t('Gitarama'),
      '07' => t('Kibungo'),
      '09' => t('Kigali'),
      '11' => t('Est'),
      '12' => t('Kigali'),
      '13' => t('Nord'),
      '14' => t('Ouest'),
      '15' => t('Sud'),
    ),
    'SA' => array(
      '02' => t('Al Bahah'),
      '03' => t('Al Jawf'),
      '05' => t('Al Madinah'),
      '06' => t('Ash Sharqiyah'),
      '08' => t('Al Qasim'),
      '09' => t('Al Qurayyat'),
      '10' => t('Ar Riyad'),
      '13' => t("Ha'il"),
      '14' => t('Makkah'),
      '15' => t('Al Hudud ash Shamaliyah'),
      '16' => t('Najran'),
      '17' => t('Jizan'),
      '19' => t('Tabuk'),
      '20' => t('Al Jawf'),
    ),
    'SB' => array(
      '03' => t('Malaita'),
      '06' => t('Guadalcanal'),
      '07' => t('Isabel'),
      '08' => t('Makira'),
      '09' => t('Temotu'),
      '10' => t('Central'),
      '11' => t('Western'),
      '12' => t('Choiseul'),
      '13' => t('Rennell and Bellona'),
    ),
    'SC' => array(
      '01' => t('Anse aux Pins'),
      '02' => t('Anse Boileau'),
      '03' => t('Anse Etoile'),
      '04' => t('Anse Louis'),
      '05' => t('Anse Royale'),
      '06' => t('Baie Lazare'),
      '07' => t('Baie Sainte Anne'),
      '08' => t('Beau Vallon'),
      '09' => t('Bel Air'),
      '10' => t('Bel Ombre'),
      '11' => t('Cascade'),
      '12' => t('Glacis'),
      '13' => t("Grand' Anse"),
      '14' => t("Grand' Anse"),
      '15' => t('La Digue'),
      '16' => t('La Riviere Anglaise'),
      '17' => t('Mont Buxton'),
      '18' => t('Mont Fleuri'),
      '19' => t('Plaisance'),
      '20' => t('Pointe La Rue'),
      '21' => t('Port Glaud'),
      '22' => t('Saint Louis'),
      '23' => t('Takamaka'),
    ),
    'SD' => array(
      '27' => t('Al Wusta'),
      '28' => t("Al Istiwa'iyah"),
      '29' => t('Al Khartum'),
      '30' => t('Ash Shamaliyah'),
      '31' => t('Ash Sharqiyah'),
      '32' => t('Bahr al Ghazal'),
      '33' => t('Darfur'),
      '34' => t('Kurdufan'),
      '35' => t('Upper Nile'),
      '40' => t('Al Wahadah State'),
      '44' => t('Central Equatoria State'),
    ),
    'SE' => array(
      '01' => t('Alvsborgs Lan'),
      '02' => t('Blekinge Lan'),
      '03' => t('Gavleborgs Lan'),
      '04' => t('Goteborgs och Bohus Lan'),
      '05' => t('Gotlands Lan'),
      '06' => t('Hallands Lan'),
      '07' => t('Jamtlands Lan'),
      '08' => t('Jonkopings Lan'),
      '09' => t('Kalmar Lan'),
      '10' => t('Dalarnas Lan'),
      '11' => t('Kristianstads Lan'),
      '12' => t('Kronobergs Lan'),
      '13' => t('Malmohus Lan'),
      '14' => t('Norrbottens Lan'),
      '15' => t('Orebro Lan'),
      '16' => t('Ostergotlands Lan'),
      '17' => t('Skaraborgs Lan'),
      '18' => t('Sodermanlands Lan'),
      '21' => t('Uppsala Lan'),
      '22' => t('Varmlands Lan'),
      '23' => t('Vasterbottens Lan'),
      '24' => t('Vasternorrlands Lan'),
      '25' => t('Vastmanlands Lan'),
      '26' => t('Stockholms Lan'),
      '27' => t('Skane Lan'),
      '28' => t('Vastra Gotaland'),
    ),
    'SH' => array(
      '01' => t('Ascension'),
      '02' => t('Saint Helena'),
      '03' => t('Tristan da Cunha'),
    ),
    'SI' => array(
      '01' => t('Ajdovscina'),
      '02' => t('Beltinci'),
      '03' => t('Bled'),
      '04' => t('Bohinj'),
      '05' => t('Borovnica'),
      '06' => t('Bovec'),
      '07' => t('Brda'),
      '08' => t('Brezice'),
      '09' => t('Brezovica'),
      '11' => t('Celje'),
      '12' => t('Cerklje na Gorenjskem'),
      '13' => t('Cerknica'),
      '14' => t('Cerkno'),
      '15' => t('Crensovci'),
      '16' => t('Crna na Koroskem'),
      '17' => t('Crnomelj'),
      '19' => t('Divaca'),
      '20' => t('Dobrepolje'),
      '22' => t('Dol pri Ljubljani'),
      '24' => t('Dornava'),
      '25' => t('Dravograd'),
      '26' => t('Duplek'),
      '27' => t('Gorenja Vas-Poljane'),
      '28' => t('Gorisnica'),
      '29' => t('Gornja Radgona'),
      '30' => t('Gornji Grad'),
      '31' => t('Gornji Petrovci'),
      '32' => t('Grosuplje'),
      '34' => t('Hrastnik'),
      '35' => t('Hrpelje-Kozina'),
      '36' => t('Idrija'),
      '37' => t('Ig'),
      '38' => t('Ilirska Bistrica'),
      '39' => t('Ivancna Gorica'),
      '40' => t('Izola-Isola'),
      '42' => t('Jursinci'),
      '44' => t('Kanal'),
      '45' => t('Kidricevo'),
      '46' => t('Kobarid'),
      '47' => t('Kobilje'),
      '49' => t('Komen'),
      '50' => t('Koper-Capodistria'),
      '51' => t('Kozje'),
      '52' => t('Kranj'),
      '53' => t('Kranjska Gora'),
      '54' => t('Krsko'),
      '55' => t('Kungota'),
      '57' => t('Lasko'),
      '61' => t('Ljubljana'),
      '62' => t('Ljubno'),
      '64' => t('Logatec'),
      '66' => t('Loski Potok'),
      '68' => t('Lukovica'),
      '71' => t('Medvode'),
      '72' => t('Menges'),
      '73' => t('Metlika'),
      '74' => t('Mezica'),
      '76' => t('Mislinja'),
      '77' => t('Moravce'),
      '78' => t('Moravske Toplice'),
      '79' => t('Mozirje'),
      '80' => t('Murska Sobota'),
      '81' => t('Muta'),
      '82' => t('Naklo'),
      '83' => t('Nazarje'),
      '84' => t('Nova Gorica'),
      '86' => t('Odranci'),
      '87' => t('Ormoz'),
      '88' => t('Osilnica'),
      '89' => t('Pesnica'),
      '91' => t('Pivka'),
      '92' => t('Podcetrtek'),
      '94' => t('Postojna'),
      '97' => t('Puconci'),
      '98' => t('Racam'),
      '99' => t('Radece'),
      'A1' => t('Radenci'),
      'A2' => t('Radlje ob Dravi'),
      'A3' => t('Radovljica'),
      'A6' => t('Rogasovci'),
      'A7' => t('Rogaska Slatina'),
      'A8' => t('Rogatec'),
      'B1' => t('Semic'),
      'B2' => t('Sencur'),
      'B3' => t('Sentilj'),
      'B4' => t('Sentjernej'),
      'B6' => t('Sevnica'),
      'B7' => t('Sezana'),
      'B8' => t('Skocjan'),
      'B9' => t('Skofja Loka'),
      'C1' => t('Skofljica'),
      'C2' => t('Slovenj Gradec'),
      'C4' => t('Slovenske Konjice'),
      'C5' => t('Smarje pri Jelsah'),
      'C6' => t('Smartno ob Paki'),
      'C7' => t('Sostanj'),
      'C8' => t('Starse'),
      'C9' => t('Store'),
      'D1' => t('Sveti Jurij'),
      'D2' => t('Tolmin'),
      'D3' => t('Trbovlje'),
      'D4' => t('Trebnje'),
      'D5' => t('Trzic'),
      'D6' => t('Turnisce'),
      'D7' => t('Velenje'),
      'D8' => t('Velike Lasce'),
      'E1' => t('Vipava'),
      'E2' => t('Vitanje'),
      'E3' => t('Vodice'),
      'E5' => t('Vrhnika'),
      'E6' => t('Vuzenica'),
      'E7' => t('Zagorje ob Savi'),
      'E9' => t('Zavrc'),
      'F1' => t('Zelezniki'),
      'F2' => t('Ziri'),
      'F3' => t('Zrece'),
      'G4' => t('Dobrova-Horjul-Polhov Gradec'),
      'G7' => t('Domzale'),
      'H4' => t('Jesenice'),
      'H6' => t('Kamnik'),
      'H7' => t('Kocevje'),
      'I2' => t('Kuzma'),
      'I3' => t('Lenart'),
      'I5' => t('Litija'),
      'I6' => t('Ljutomer'),
      'I7' => t('Loska Dolina'),
      'I9' => t('Luce'),
      'J1' => t('Majsperk'),
      'J2' => t('Maribor'),
      'J5' => t('Miren-Kostanjevica'),
      'J7' => t('Novo Mesto'),
      'J9' => t('Piran'),
      'K5' => t('Preddvor'),
      'K7' => t('Ptuj'),
      'L1' => t('Ribnica'),
      'L3' => t('Ruse'),
      'L7' => t('Sentjur pri Celju'),
      'L8' => t('Slovenska Bistrica'),
      'N2' => t('Videm'),
      'N3' => t('Vojnik'),
      'N5' => t('Zalec'),
    ),
    'SK' => array(
      '01' => t('Banska Bystrica'),
      '02' => t('Bratislava'),
      '03' => t('Kosice'),
      '04' => t('Nitra'),
      '05' => t('Presov'),
      '06' => t('Trencin'),
      '07' => t('Trnava'),
      '08' => t('Zilina'),
    ),
    'SL' => array(
      '01' => t('Eastern'),
      '02' => t('Northern'),
      '03' => t('Southern'),
      '04' => t('Western Area'),
    ),
    'SM' => array(
      '01' => t('Acquaviva'),
      '02' => t('Chiesanuova'),
      '03' => t('Domagnano'),
      '04' => t('Faetano'),
      '05' => t('Fiorentino'),
      '06' => t('Borgo Maggiore'),
      '07' => t('San Marino'),
      '08' => t('Monte Giardino'),
      '09' => t('Serravalle'),
    ),
    'SN' => array(
      '01' => t('Dakar'),
      '03' => t('Diourbel'),
      '04' => t('Saint-Louis'),
      '05' => t('Tambacounda'),
      '07' => t('Thies'),
      '08' => t('Louga'),
      '09' => t('Fatick'),
      '10' => t('Kaolack'),
      '11' => t('Kolda'),
      '12' => t('Ziguinchor'),
      '13' => t('Louga'),
      '14' => t('Saint-Louis'),
      '15' => t('Matam'),
    ),
    'SO' => array(
      '01' => t('Bakool'),
      '02' => t('Banaadir'),
      '03' => t('Bari'),
      '04' => t('Bay'),
      '05' => t('Galguduud'),
      '06' => t('Gedo'),
      '07' => t('Hiiraan'),
      '08' => t('Jubbada Dhexe'),
      '09' => t('Jubbada Hoose'),
      '10' => t('Mudug'),
      '11' => t('Nugaal'),
      '12' => t('Sanaag'),
      '13' => t('Shabeellaha Dhexe'),
      '14' => t('Shabeellaha Hoose'),
      '16' => t('Woqooyi Galbeed'),
      '18' => t('Nugaal'),
      '19' => t('Togdheer'),
      '20' => t('Woqooyi Galbeed'),
      '21' => t('Awdal'),
      '22' => t('Sool'),
    ),
    'SR' => array(
      '10' => t('Brokopondo'),
      '11' => t('Commewijne'),
      '12' => t('Coronie'),
      '13' => t('Marowijne'),
      '14' => t('Nickerie'),
      '15' => t('Para'),
      '16' => t('Paramaribo'),
      '17' => t('Saramacca'),
      '18' => t('Sipaliwini'),
      '19' => t('Wanica'),
    ),
    'ST' => array(
      '01' => t('Principe'),
      '02' => t('Sao Tome'),
    ),
    'SV' => array(
      '01' => t('Ahuachapan'),
      '02' => t('Cabanas'),
      '03' => t('Chalatenango'),
      '04' => t('Cuscatlan'),
      '05' => t('La Libertad'),
      '06' => t('La Paz'),
      '07' => t('La Union'),
      '08' => t('Morazan'),
      '09' => t('San Miguel'),
      '10' => t('San Salvador'),
      '11' => t('Santa Ana'),
      '12' => t('San Vicente'),
      '13' => t('Sonsonate'),
      '14' => t('Usulutan'),
    ),
    'SY' => array(
      '01' => t('Al Hasakah'),
      '02' => t('Al Ladhiqiyah'),
      '03' => t('Al Qunaytirah'),
      '04' => t('Ar Raqqah'),
      '05' => t("As Suwayda'"),
      '06' => t('Dar'),
      '07' => t('Dayr az Zawr'),
      '08' => t('Rif Dimashq'),
      '09' => t('Halab'),
      '10' => t('Hamah'),
      '11' => t('Hims'),
      '12' => t('Idlib'),
      '13' => t('Dimashq'),
      '14' => t('Tartus'),
    ),
    'SZ' => array(
      '01' => t('Hhohho'),
      '02' => t('Lubombo'),
      '03' => t('Manzini'),
      '04' => t('Shiselweni'),
      '05' => t('Praslin'),
    ),
    'TD' => array(
      '01' => t('Batha'),
      '02' => t('Biltine'),
      '03' => t('Borkou-Ennedi-Tibesti'),
      '04' => t('Chari-Baguirmi'),
      '05' => t('Guera'),
      '06' => t('Kanem'),
      '07' => t('Lac'),
      '08' => t('Logone Occidental'),
      '09' => t('Logone Oriental'),
      '10' => t('Mayo-Kebbi'),
      '11' => t('Moyen-Chari'),
      '12' => t('Ouaddai'),
      '13' => t('Salamat'),
      '14' => t('Tandjile'),
    ),
    'TG' => array(
      '09' => t('Lama-Kara'),
      '18' => t('Tsevie'),
      '22' => t('Centrale'),
      '23' => t('Kara'),
      '24' => t('Maritime'),
      '25' => t('Plateaux'),
      '26' => t('Savanes'),
    ),
    'TH' => array(
      '01' => t('Mae Hong Son'),
      '02' => t('Chiang Mai'),
      '03' => t('Chiang Rai'),
      '04' => t('Nan'),
      '05' => t('Lamphun'),
      '06' => t('Lampang'),
      '07' => t('Phrae'),
      '08' => t('Tak'),
      '09' => t('Sukhothai'),
      '10' => t('Uttaradit'),
      '11' => t('Kamphaeng Phet'),
      '12' => t('Phitsanulok'),
      '13' => t('Phichit'),
      '14' => t('Phetchabun'),
      '15' => t('Uthai Thani'),
      '16' => t('Nakhon Sawan'),
      '17' => t('Nong Khai'),
      '18' => t('Loei'),
      '20' => t('Sakon Nakhon'),
      '21' => t('Nakhon Phanom'),
      '22' => t('Khon Kaen'),
      '23' => t('Kalasin'),
      '24' => t('Maha Sarakham'),
      '25' => t('Roi Et'),
      '26' => t('Chaiyaphum'),
      '27' => t('Nakhon Ratchasima'),
      '28' => t('Buriram'),
      '29' => t('Surin'),
      '30' => t('Sisaket'),
      '31' => t('Narathiwat'),
      '32' => t('Chai Nat'),
      '33' => t('Sing Buri'),
      '34' => t('Lop Buri'),
      '35' => t('Ang Thong'),
      '36' => t('Phra Nakhon Si Ayutthaya'),
      '37' => t('Saraburi'),
      '38' => t('Nonthaburi'),
      '39' => t('Pathum Thani'),
      '40' => t('Krung Thep'),
      '41' => t('Phayao'),
      '42' => t('Samut Prakan'),
      '43' => t('Nakhon Nayok'),
      '44' => t('Chachoengsao'),
      '45' => t('Prachin Buri'),
      '46' => t('Chon Buri'),
      '47' => t('Rayong'),
      '48' => t('Chanthaburi'),
      '49' => t('Trat'),
      '50' => t('Kanchanaburi'),
      '51' => t('Suphan Buri'),
      '52' => t('Ratchaburi'),
      '53' => t('Nakhon Pathom'),
      '54' => t('Samut Songkhram'),
      '55' => t('Samut Sakhon'),
      '56' => t('Phetchaburi'),
      '57' => t('Prachuap Khiri Khan'),
      '58' => t('Chumphon'),
      '59' => t('Ranong'),
      '60' => t('Surat Thani'),
      '61' => t('Phangnga'),
      '62' => t('Phuket'),
      '63' => t('Krabi'),
      '64' => t('Nakhon Si Thammarat'),
      '65' => t('Trang'),
      '66' => t('Phatthalung'),
      '67' => t('Satun'),
      '68' => t('Songkhla'),
      '69' => t('Pattani'),
      '70' => t('Yala'),
      '71' => t('Ubon Ratchathani'),
      '72' => t('Yasothon'),
      '73' => t('Nakhon Phanom'),
      '75' => t('Ubon Ratchathani'),
      '76' => t('Udon Thani'),
      '77' => t('Amnat Charoen'),
      '78' => t('Mukdahan'),
      '79' => t('Nong Bua Lamphu'),
      '80' => t('Sa Kaeo'),
    ),
    'TJ' => array(
      '01' => t('Kuhistoni Badakhshon'),
      '02' => t('Khatlon'),
      '03' => t('Sughd'),
    ),
    'TM' => array(
      '01' => t('Ahal'),
      '02' => t('Balkan'),
      '03' => t('Dashoguz'),
      '04' => t('Lebap'),
      '05' => t('Mary'),
    ),
    'TN' => array(
      '02' => t('Kasserine'),
      '03' => t('Kairouan'),
      '06' => t('Jendouba'),
      '14' => t('El Kef'),
      '15' => t('Al Mahdia'),
      '16' => t('Al Munastir'),
      '17' => t('Bajah'),
      '18' => t('Bizerte'),
      '19' => t('Nabeul'),
      '22' => t('Siliana'),
      '23' => t('Sousse'),
      '26' => t('Ariana'),
      '27' => t('Ben Arous'),
      '28' => t('Madanin'),
      '29' => t('Gabes'),
      '30' => t('Gafsa'),
      '31' => t('Kebili'),
      '32' => t('Sfax'),
      '33' => t('Sidi Bou Zid'),
      '34' => t('Tataouine'),
      '35' => t('Tozeur'),
      '36' => t('Tunis'),
      '37' => t('Zaghouan'),
    ),
    'TO' => array(
      '01' => t('Ha'),
      '02' => t('Tongatapu'),
      '03' => t('Vava'),
    ),
    'TR' => array(
      '02' => t('Adiyaman'),
      '03' => t('Afyonkarahisar'),
      '04' => t('Agri'),
      '05' => t('Amasya'),
      '07' => t('Antalya'),
      '08' => t('Artvin'),
      '09' => t('Aydin'),
      '10' => t('Balikesir'),
      '11' => t('Bilecik'),
      '12' => t('Bingol'),
      '13' => t('Bitlis'),
      '14' => t('Bolu'),
      '15' => t('Burdur'),
      '16' => t('Bursa'),
      '17' => t('Canakkale'),
      '19' => t('Corum'),
      '20' => t('Denizli'),
      '21' => t('Diyarbakir'),
      '22' => t('Edirne'),
      '23' => t('Elazig'),
      '24' => t('Erzincan'),
      '25' => t('Erzurum'),
      '26' => t('Eskisehir'),
      '28' => t('Giresun'),
      '31' => t('Hatay'),
      '32' => t('Icel'),
      '33' => t('Isparta'),
      '34' => t('Istanbul'),
      '35' => t('Izmir'),
      '37' => t('Kastamonu'),
      '38' => t('Kayseri'),
      '39' => t('Kirklareli'),
      '40' => t('Kirsehir'),
      '41' => t('Kocaeli'),
      '43' => t('Kutahya'),
      '44' => t('Malatya'),
      '45' => t('Manisa'),
      '46' => t('Kahramanmaras'),
      '48' => t('Mugla'),
      '49' => t('Mus'),
      '50' => t('Nevsehir'),
      '52' => t('Ordu'),
      '53' => t('Rize'),
      '54' => t('Sakarya'),
      '55' => t('Samsun'),
      '57' => t('Sinop'),
      '58' => t('Sivas'),
      '59' => t('Tekirdag'),
      '60' => t('Tokat'),
      '61' => t('Trabzon'),
      '62' => t('Tunceli'),
      '63' => t('Sanliurfa'),
      '64' => t('Usak'),
      '65' => t('Van'),
      '66' => t('Yozgat'),
      '68' => t('Ankara'),
      '69' => t('Gumushane'),
      '70' => t('Hakkari'),
      '71' => t('Konya'),
      '72' => t('Mardin'),
      '73' => t('Nigde'),
      '74' => t('Siirt'),
      '75' => t('Aksaray'),
      '76' => t('Batman'),
      '77' => t('Bayburt'),
      '78' => t('Karaman'),
      '79' => t('Kirikkale'),
      '80' => t('Sirnak'),
      '81' => t('Adana'),
      '82' => t('Cankiri'),
      '83' => t('Gaziantep'),
      '84' => t('Kars'),
      '85' => t('Zonguldak'),
      '86' => t('Ardahan'),
      '87' => t('Bartin'),
      '88' => t('Igdir'),
      '89' => t('Karabuk'),
      '90' => t('Kilis'),
      '91' => t('Osmaniye'),
      '92' => t('Yalova'),
      '93' => t('Duzce'),
    ),
    'TT' => array(
      '01' => t('Arima'),
      '02' => t('Caroni'),
      '03' => t('Mayaro'),
      '04' => t('Nariva'),
      '05' => t('Port-of-Spain'),
      '06' => t('Saint Andrew'),
      '07' => t('Saint David'),
      '08' => t('Saint George'),
      '09' => t('Saint Patrick'),
      '10' => t('San Fernando'),
      '11' => t('Tobago'),
      '12' => t('Victoria'),
    ),
    'TW' => array(
      '01' => t('Fu-chien'),
      '02' => t('Kao-hsiung'),
      '03' => t("T'ai-pei"),
      '04' => t("T'ai-wan"),
    ),
    'TZ' => array(
      '02' => t('Pwani'),
      '03' => t('Dodoma'),
      '04' => t('Iringa'),
      '05' => t('Kigoma'),
      '06' => t('Kilimanjaro'),
      '07' => t('Lindi'),
      '08' => t('Mara'),
      '09' => t('Mbeya'),
      '10' => t('Morogoro'),
      '11' => t('Mtwara'),
      '12' => t('Mwanza'),
      '13' => t('Pemba North'),
      '14' => t('Ruvuma'),
      '15' => t('Shinyanga'),
      '16' => t('Singida'),
      '17' => t('Tabora'),
      '18' => t('Tanga'),
      '19' => t('Kagera'),
      '20' => t('Pemba South'),
      '21' => t('Zanzibar Central'),
      '22' => t('Zanzibar North'),
      '23' => t('Dar es Salaam'),
      '24' => t('Rukwa'),
      '25' => t('Zanzibar Urban'),
      '26' => t('Arusha'),
      '27' => t('Manyara'),
    ),
    'UA' => array(
      '01' => t("Cherkas'ka Oblast'"),
      '02' => t("Chernihivs'ka Oblast'"),
      '03' => t("Chernivets'ka Oblast'"),
      '04' => t("Dnipropetrovs'ka Oblast'"),
      '05' => t("Donets'ka Oblast'"),
      '06' => t("Ivano-Frankivs'ka Oblast'"),
      '07' => t("Kharkivs'ka Oblast'"),
      '08' => t("Khersons'ka Oblast'"),
      '09' => t("Khmel'nyts'ka Oblast'"),
      '10' => t("Kirovohrads'ka Oblast'"),
      '11' => t('Krym'),
      '12' => t('Kyyiv'),
      '13' => t("Kyyivs'ka Oblast'"),
      '14' => t("Luhans'ka Oblast'"),
      '15' => t("L'vivs'ka Oblast'"),
      '16' => t("Mykolayivs'ka Oblast'"),
      '17' => t("Odes'ka Oblast'"),
      '18' => t("Poltavs'ka Oblast'"),
      '19' => t("Rivnens'ka Oblast'"),
      '20' => t("Sevastopol'"),
      '21' => t("Sums'ka Oblast'"),
      '22' => t("Ternopil's'ka Oblast'"),
      '23' => t("Vinnyts'ka Oblast'"),
      '24' => t("Volyns'ka Oblast'"),
      '25' => t("Zakarpats'ka Oblast'"),
      '26' => t("Zaporiz'ka Oblast'"),
      '27' => t("Zhytomyrs'ka Oblast'"),
    ),
    'UG' => array(
      '05' => t('Busoga'),
      '08' => t('Karamoja'),
      '12' => t('South Buganda'),
      '18' => t('Central'),
      '20' => t('Eastern'),
      '21' => t('Nile'),
      '22' => t('North Buganda'),
      '23' => t('Northern'),
      '24' => t('Southern'),
      '25' => t('Western'),
      '33' => t('Jinja'),
      '36' => t('Kalangala'),
      '37' => t('Kampala'),
      '42' => t('Kiboga'),
      '52' => t('Mbarara'),
      '56' => t('Mubende'),
      '65' => t('Adjumani'),
      '66' => t('Bugiri'),
      '67' => t('Busia'),
      '69' => t('Katakwi'),
      '71' => t('Masaka'),
      '73' => t('Nakasongola'),
      '74' => t('Sembabule'),
      '77' => t('Arua'),
      '78' => t('Iganga'),
      '79' => t('Kabarole'),
      '80' => t('Kaberamaido'),
      '81' => t('Kamwenge'),
      '82' => t('Kanungu'),
      '83' => t('Kayunga'),
      '84' => t('Kitgum'),
      '85' => t('Kyenjojo'),
      '86' => t('Mayuge'),
      '87' => t('Mbale'),
      '88' => t('Moroto'),
      '89' => t('Mpigi'),
      '90' => t('Mukono'),
      '91' => t('Nakapiripirit'),
      '92' => t('Pader'),
      '93' => t('Rukungiri'),
      '94' => t('Sironko'),
      '95' => t('Soroti'),
      '96' => t('Wakiso'),
      '97' => t('Yumbe'),
    ),
    'US' => array(
      'AA' => t('Armed Forces Americas'),
      'AE' => t('Armed Forces Europe, Middle East, & Canada'),
      'AK' => t('Alaska'),
      'AL' => t('Alabama'),
      'AP' => t('Armed Forces Pacific'),
      'AR' => t('Arkansas'),
      'AS' => t('American Samoa'),
      'AZ' => t('Arizona'),
      'CA' => t('California'),
      'CO' => t('Colorado'),
      'CT' => t('Connecticut'),
      'DC' => t('District of Columbia'),
      'DE' => t('Delaware'),
      'FL' => t('Florida'),
      'FM' => t('Federated States of Micronesia'),
      'GA' => t('Georgia'),
      'GU' => t('Guam'),
      'HI' => t('Hawaii'),
      'IA' => t('Iowa'),
      'ID' => t('Idaho'),
      'IL' => t('Illinois'),
      'IN' => t('Indiana'),
      'KS' => t('Kansas'),
      'KY' => t('Kentucky'),
      'LA' => t('Louisiana'),
      'MA' => t('Massachusetts'),
      'MD' => t('Maryland'),
      'ME' => t('Maine'),
      'MH' => t('Marshall Islands'),
      'MI' => t('Michigan'),
      'MN' => t('Minnesota'),
      'MO' => t('Missouri'),
      'MP' => t('Northern Mariana Islands'),
      'MS' => t('Mississippi'),
      'MT' => t('Montana'),
      'NC' => t('North Carolina'),
      'ND' => t('North Dakota'),
      'NE' => t('Nebraska'),
      'NH' => t('New Hampshire'),
      'NJ' => t('New Jersey'),
      'NM' => t('New Mexico'),
      'NV' => t('Nevada'),
      'NY' => t('New York'),
      'OH' => t('Ohio'),
      'OK' => t('Oklahoma'),
      'OR' => t('Oregon'),
      'PA' => t('Pennsylvania'),
      'PR' => t('Puerto Rico'),
      'PW' => t('Palau'),
      'RI' => t('Rhode Island'),
      'SC' => t('South Carolina'),
      'SD' => t('South Dakota'),
      'TN' => t('Tennessee'),
      'TX' => t('Texas'),
      'UT' => t('Utah'),
      'VA' => t('Virginia'),
      'VI' => t('Virgin Islands'),
      'VT' => t('Vermont'),
      'WA' => t('Washington'),
      'WI' => t('Wisconsin'),
      'WV' => t('West Virginia'),
      'WY' => t('Wyoming'),
    ),
    'UY' => array(
      '01' => t('Artigas'),
      '02' => t('Canelones'),
      '03' => t('Cerro Largo'),
      '04' => t('Colonia'),
      '05' => t('Durazno'),
      '06' => t('Flores'),
      '07' => t('Florida'),
      '08' => t('Lavalleja'),
      '09' => t('Maldonado'),
      '10' => t('Montevideo'),
      '11' => t('Paysandu'),
      '12' => t('Rio Negro'),
      '13' => t('Rivera'),
      '14' => t('Rocha'),
      '15' => t('Salto'),
      '16' => t('San Jose'),
      '17' => t('Soriano'),
      '18' => t('Tacuarembo'),
      '19' => t('Treinta y Tres'),
    ),
    'UZ' => array(
      '01' => t('Andijon'),
      '02' => t('Bukhoro'),
      '03' => t('Farghona'),
      '04' => t('Jizzakh'),
      '05' => t('Khorazm'),
      '06' => t('Namangan'),
      '07' => t('Nawoiy'),
      '08' => t('Qashqadaryo'),
      '09' => t('Qoraqalpoghiston'),
      '10' => t('Samarqand'),
      '11' => t('Sirdaryo'),
      '12' => t('Surkhondaryo'),
      '13' => t('Toshkent'),
      '14' => t('Toshkent'),
    ),
    'VC' => array(
      '01' => t('Charlotte'),
      '02' => t('Saint Andrew'),
      '03' => t('Saint David'),
      '04' => t('Saint George'),
      '05' => t('Saint Patrick'),
      '06' => t('Grenadines'),
    ),
    'VE' => array(
      '01' => t('Amazonas'),
      '02' => t('Anzoategui'),
      '03' => t('Apure'),
      '04' => t('Aragua'),
      '05' => t('Barinas'),
      '06' => t('Bolivar'),
      '07' => t('Carabobo'),
      '08' => t('Cojedes'),
      '09' => t('Delta Amacuro'),
      '11' => t('Falcon'),
      '12' => t('Guarico'),
      '13' => t('Lara'),
      '14' => t('Merida'),
      '15' => t('Miranda'),
      '16' => t('Monagas'),
      '17' => t('Nueva Esparta'),
      '18' => t('Portuguesa'),
      '19' => t('Sucre'),
      '20' => t('Tachira'),
      '21' => t('Trujillo'),
      '22' => t('Yaracuy'),
      '23' => t('Zulia'),
      '24' => t('Dependencias Federales'),
      '25' => t('Distrito Federal'),
      '26' => t('Vargas'),
    ),
    'VN' => array(
      '01' => t('An Giang'),
      '02' => t('Bac Thai'),
      '03' => t('Ben Tre'),
      '04' => t('Binh Tri Thien'),
      '05' => t('Cao Bang'),
      '06' => t('Cuu Long'),
      '07' => t('Dac Lac'),
      '09' => t('Dong Thap'),
      '11' => t('Ha Bac'),
      '12' => t('Hai Hung'),
      '13' => t('Hai Phong'),
      '14' => t('Ha Nam Ninh'),
      '15' => t('Ha Noi'),
      '16' => t('Ha Son Binh'),
      '17' => t('Ha Tuyen'),
      '19' => t('Hoang Lien Son'),
      '20' => t('Ho Chi Minh'),
      '21' => t('Kien Giang'),
      '22' => t('Lai Chau'),
      '23' => t('Lam Dong'),
      '24' => t('Long An'),
      '25' => t('Minh Hai'),
      '26' => t('Nghe Tinh'),
      '27' => t('Nghia Binh'),
      '28' => t('Phu Khanh'),
      '29' => t('Quang Nam-Da Nang'),
      '30' => t('Quang Ninh'),
      '31' => t('Song Be'),
      '32' => t('Son La'),
      '33' => t('Tay Ninh'),
      '34' => t('Thanh Hoa'),
      '35' => t('Thai Binh'),
      '36' => t('Thuan Hai'),
      '37' => t('Tien Giang'),
      '38' => t('Vinh Phu'),
      '39' => t('Lang Son'),
      '40' => t('Dong Nai'),
      '43' => t('An Giang'),
      '44' => t('Dac Lac'),
      '45' => t('Dong Nai'),
      '46' => t('Dong Thap'),
      '47' => t('Kien Giang'),
      '48' => t('Minh Hai'),
      '49' => t('Song Be'),
      '50' => t('Vinh Phu'),
      '51' => t('Ha Noi'),
      '52' => t('Ho Chi Minh'),
      '53' => t('Ba Ria-Vung Tau'),
      '54' => t('Binh Dinh'),
      '55' => t('Binh Thuan'),
      '56' => t('Can Tho'),
      '57' => t('Gia Lai'),
      '58' => t('Ha Giang'),
      '59' => t('Ha Tay'),
      '60' => t('Ha Tinh'),
      '61' => t('Hoa Binh'),
      '62' => t('Khanh Hoa'),
      '63' => t('Kon Tum'),
      '64' => t('Quang Tri'),
      '65' => t('Nam Ha'),
      '66' => t('Nghe An'),
      '67' => t('Ninh Binh'),
      '68' => t('Ninh Thuan'),
      '69' => t('Phu Yen'),
      '70' => t('Quang Binh'),
      '71' => t('Quang Ngai'),
      '72' => t('Quang Tri'),
      '73' => t('Soc Trang'),
      '74' => t('Thua Thien'),
      '75' => t('Tra Vinh'),
      '76' => t('Tuyen Quang'),
      '77' => t('Vinh Long'),
      '78' => t('Da Nang'),
      '79' => t('Hai Duong'),
      '80' => t('Ha Nam'),
      '81' => t('Hung Yen'),
      '82' => t('Nam Dinh'),
      '83' => t('Phu Tho'),
      '84' => t('Quang Nam'),
      '85' => t('Thai Nguyen'),
      '86' => t('Vinh Puc Province'),
      '87' => t('Can Tho'),
      '88' => t('Dak Lak'),
      '89' => t('Lai Chau'),
      '90' => t('Lao Cai'),
      '91' => t('Dak Nong'),
      '92' => t('Dien Bien'),
      '93' => t('Hau Giang'),
    ),
    'VU' => array(
      '05' => t('Ambrym'),
      '06' => t('Aoba'),
      '07' => t('Torba'),
      '08' => t('Efate'),
      '09' => t('Epi'),
      '10' => t('Malakula'),
      '11' => t('Paama'),
      '12' => t('Pentecote'),
      '13' => t('Sanma'),
      '14' => t('Shepherd'),
      '15' => t('Tafea'),
      '16' => t('Malampa'),
      '17' => t('Penama'),
      '18' => t('Shefa'),
    ),
    'WS' => array(
      '02' => t('Aiga-i-le-Tai'),
      '03' => t('Atua'),
      '04' => t('Fa'),
      '05' => t('Gaga'),
      '06' => t('Va'),
      '07' => t('Gagaifomauga'),
      '08' => t('Palauli'),
      '09' => t('Satupa'),
      '10' => t('Tuamasaga'),
      '11' => t('Vaisigano'),
    ),
    'YE' => array(
      '01' => t('Abyan'),
      '02' => t('Adan'),
      '03' => t('Al Mahrah'),
      '04' => t('Hadramawt'),
      '05' => t('Shabwah'),
      '06' => t('Al Ghaydah'),
      '08' => t('Al Hudaydah'),
      '10' => t('Al Mahwit'),
      '11' => t('Dhamar'),
      '14' => t("Ma'rib"),
      '15' => t('Sa'),
      '16' => t('San'),
      '20' => t("Al Bayda'"),
      '21' => t('Al Jawf'),
      '22' => t('Hajjah'),
      '23' => t('Ibb'),
      '24' => t('Lahij'),
      '25' => t('Ta'),
    ),
    'ZA' => array(
      '01' => t('North-Western Province'),
      '02' => t('KwaZulu-Natal'),
      '03' => t('Free State'),
      '05' => t('Eastern Cape'),
      '06' => t('Gauteng'),
      '07' => t('Mpumalanga'),
      '08' => t('Northern Cape'),
      '09' => t('Limpopo'),
      '10' => t('North-West'),
      '11' => t('Western Cape'),
    ),
    'ZM' => array(
      '01' => t('Western'),
      '02' => t('Central'),
      '03' => t('Eastern'),
      '04' => t('Luapula'),
      '05' => t('Northern'),
      '06' => t('North-Western'),
      '07' => t('Southern'),
      '08' => t('Copperbelt'),
      '09' => t('Lusaka'),
    ),
    'ZW' => array(
      '01' => t('Manicaland'),
      '02' => t('Midlands'),
      '03' => t('Mashonaland Central'),
      '04' => t('Mashonaland East'),
      '05' => t('Mashonaland West'),
      '06' => t('Matabeleland North'),
      '07' => t('Matabeleland South'),
      '08' => t('Masvingo'),
      '09' => t('Bulawayo'),
      '10' => t('Harare'),
    ),
  );
  if (!isset($region_codes[$country_code][$region_code]) || empty($country_code) || empty($region_code)) {
    return '';
  }
  else {
    return $region_codes[$country_code][$region_code];
  }
}