<?php

/**
 * @file
 * Font list for the Edge Fonts module.
 */

/**
 * Helper function - hardcodes the list of available fonts and their variants.
 *
 * Updated 13-Nov-2012.
 */
function edge_fonts_list() {
  return array(
    'abel' => array(
      'name' => 'Abel',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121cc',
        ),
      ),
    ),
    'abril-fatface' => array(
      'name' => 'Abril Fatface',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000119b2',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000119b3',
        ),
      ),
    ),
    'aclonica' => array(
      'name' => 'Aclonica',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a4',
        ),
      ),
    ),
    'acme' => array(
      'name' => 'Acme',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121ce',
        ),
      ),
    ),
    'actor' => array(
      'name' => 'Actor',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121cd',
        ),
      ),
    ),
    'adamina' => array(
      'name' => 'Adamina',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121cf',
        ),
      ),
    ),
    'advent-pro' => array(
      'name' => 'Advent Pro',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/0000000000000000000121b9',
        ),
        'n2' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000121b5',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000121bb',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121b8',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/0000000000000000000121b6',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121ba',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121b7',
        ),
      ),
    ),
    'aguafina-script' => array(
      'name' => 'Aguafina Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a5',
        ),
      ),
    ),
    'aladin' => array(
      'name' => 'Aladin',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a6',
        ),
      ),
    ),
    'alegreya' => array(
      'name' => 'Alegreya',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac8',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac7',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac5',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac6',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac3',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012ac4',
        ),
      ),
    ),
    'alegreya-sc' => array(
      'name' => 'Alegreya SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122aa',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a9',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a8',
        ),
        'i7' => array(
          'name' => 'BoldItalic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ab',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/0000000000000000000121fb',
        ),
        'i9' => array(
          'name' => 'BlackItalic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a7',
        ),
      ),
    ),
    'alex-brush' => array(
      'name' => 'Alex Brush',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ac',
        ),
      ),
    ),
    'alexa-std' => array(
      'name' => 'Alexa Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131bf',
        ),
      ),
    ),
    'alfa-slab-one' => array(
      'name' => 'Alfa Slab One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ad',
        ),
      ),
    ),
    'alice' => array(
      'name' => 'Alice',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ae',
        ),
      ),
    ),
    'alike' => array(
      'name' => 'Alike',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122af',
        ),
      ),
    ),
    'alike-angular' => array(
      'name' => 'Alike Angular',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b0',
        ),
      ),
    ),
    'allan' => array(
      'name' => 'Allan',
      'variants' => array(
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b1',
        ),
      ),
    ),
    'allerta' => array(
      'name' => 'Allerta',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b2',
        ),
      ),
    ),
    'allura' => array(
      'name' => 'Allura',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b5',
        ),
      ),
    ),
    'almendra' => array(
      'name' => 'Almendra',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b7',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b8',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b6',
        ),
      ),
    ),
    'almendra-sc' => array(
      'name' => 'Almendra SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122b9',
        ),
      ),
    ),
    'amaranth' => array(
      'name' => 'Amaranth',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122bd',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122bb',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ba',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122bc',
        ),
      ),
    ),
    'amatic-sc' => array(
      'name' => 'Amatic SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122be',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122bf',
        ),
      ),
    ),
    'amethysta' => array(
      'name' => 'Amethysta',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c0',
        ),
      ),
    ),
    'andada' => array(
      'name' => 'Andada',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c1',
        ),
      ),
    ),
    'andika' => array(
      'name' => 'Andika',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c2',
        ),
      ),
    ),
    'annie-use-your-telescope' => array(
      'name' => 'Annie Use Your Telescope',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c4',
        ),
      ),
    ),
    'anonymous-pro' => array(
      'name' => 'Anonymous Pro',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000ffc5',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000ffc4',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000000ffc2',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000ffc3',
        ),
      ),
    ),
    'antic' => array(
      'name' => 'Antic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d9',
        ),
      ),
    ),
    'antic-didone' => array(
      'name' => 'Antic Didone',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a2',
        ),
      ),
    ),
    'antic-slab' => array(
      'name' => 'Antic Slab',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a3',
        ),
      ),
    ),
    'arapey' => array(
      'name' => 'Arapey',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122db',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122dc',
        ),
      ),
    ),
    'arbutus' => array(
      'name' => 'Arbutus',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e4',
        ),
      ),
    ),
    'architects-daughter' => array(
      'name' => 'Architects Daughter',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e5',
        ),
      ),
    ),
    'arimo' => array(
      'name' => 'Arimo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e6',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e8',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e7',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122e9',
        ),
      ),
    ),
    'arizonia' => array(
      'name' => 'Arizonia',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ee',
        ),
      ),
    ),
    'artifika' => array(
      'name' => 'Artifika',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f0',
        ),
      ),
    ),
    'arvo' => array(
      'name' => 'Arvo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ea',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ed',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ec',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122eb',
        ),
      ),
    ),
    'asap' => array(
      'name' => 'Asap',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f3',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f2',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f1',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f4',
        ),
      ),
    ),
    'asset' => array(
      'name' => 'Asset',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001264a',
        ),
      ),
    ),
    'astloch' => array(
      'name' => 'Astloch',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001230f',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012310',
        ),
      ),
    ),
    'asul' => array(
      'name' => 'Asul',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012311',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012312',
        ),
      ),
    ),
    'atomic-age' => array(
      'name' => 'Atomic Age',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122fe',
        ),
      ),
    ),
    'aubrey' => array(
      'name' => 'Aubrey',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012301',
        ),
      ),
    ),
    'average' => array(
      'name' => 'Average',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001249a',
        ),
      ),
    ),
    'averia-gruesa-libre' => array(
      'name' => 'Averia Gruesa Libre',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001249b',
        ),
      ),
    ),
    'averia-libre' => array(
      'name' => 'Averia Libre',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001249c',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012522',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012521',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001249d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001249f',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001249e',
        ),
      ),
    ),
    'averia-sans-libre' => array(
      'name' => 'Averia Sans Libre',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012526',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012527',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012528',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012520',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012525',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012529',
        ),
      ),
    ),
    'averia-serif-libre' => array(
      'name' => 'Averia Serif Libre',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012524',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001252d',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001252c',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001252a',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001251f',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001252b',
        ),
      ),
    ),
    'bad-script' => array(
      'name' => 'Bad Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012331',
        ),
      ),
    ),
    'balthazar' => array(
      'name' => 'Balthazar',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012332',
        ),
      ),
    ),
    'bangers' => array(
      'name' => 'Bangers',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012333',
        ),
      ),
    ),
    'basic' => array(
      'name' => 'Basic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012334',
        ),
      ),
    ),
    'baumans' => array(
      'name' => 'Baumans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012335',
        ),
      ),
    ),
    'bebas-neue' => array(
      'name' => 'Bebas Neue',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000010b09',
        ),
      ),
    ),
    'belgrano' => array(
      'name' => 'Belgrano',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012339',
        ),
      ),
    ),
    'bentham' => array(
      'name' => 'Bentham',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001233a',
        ),
      ),
    ),
    'berkshire-swash' => array(
      'name' => 'Berkshire Swash',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012499',
        ),
      ),
    ),
    'bigshot-one' => array(
      'name' => 'Bigshot One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001233c',
        ),
      ),
    ),
    'bilbo' => array(
      'name' => 'Bilbo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001233d',
        ),
      ),
    ),
    'bilbo-swash-caps' => array(
      'name' => 'Bilbo Swash Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001233e',
        ),
      ),
    ),
    'bitter' => array(
      'name' => 'Bitter',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001233f',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012340',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012341',
        ),
      ),
    ),
    'black-ops-one' => array(
      'name' => 'Black Ops One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012342',
        ),
      ),
    ),
    'bonbon' => array(
      'name' => 'Bonbon',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012344',
        ),
      ),
    ),
    'boogaloo' => array(
      'name' => 'Boogaloo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012345',
        ),
      ),
    ),
    'bowlby-one' => array(
      'name' => 'Bowlby One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012346',
        ),
      ),
    ),
    'bowlby-one-sc' => array(
      'name' => 'Bowlby One SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125db',
        ),
      ),
    ),
    'brawler' => array(
      'name' => 'Brawler',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012348',
        ),
      ),
    ),
    'bree-serif' => array(
      'name' => 'Bree Serif',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012136',
        ),
      ),
    ),
    'brush-script-std' => array(
      'name' => 'Brush Script Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c0',
        ),
      ),
    ),
    'bubblegum-sans' => array(
      'name' => 'Bubblegum Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001234a',
        ),
      ),
    ),
    'bubbler-one' => array(
      'name' => 'Bubbler One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012349',
        ),
      ),
    ),
    'buda' => array(
      'name' => 'Buda',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001234b',
        ),
      ),
    ),
    'buenard' => array(
      'name' => 'Buenard',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001234c',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001234d',
        ),
      ),
    ),
    'butcherman' => array(
      'name' => 'Butcherman',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001234e',
        ),
      ),
    ),
    'butcherman-caps' => array(
      'name' => 'Butcherman Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001234f',
        ),
      ),
    ),
    'butterfly-kids' => array(
      'name' => 'Butterfly Kids',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012350',
        ),
      ),
    ),
    'cabin' => array(
      'name' => 'Cabin',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012351',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012352',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000012355',
        ),
        'i5' => array(
          'name' => 'Medium Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012356',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/000000000000000000012357',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012358',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012353',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012354',
        ),
      ),
    ),
    'cabin-condensed' => array(
      'name' => 'Cabin Condensed',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012359',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/00000000000000000001235b',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/00000000000000000001235c',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001235a',
        ),
      ),
    ),
    'cabin-sketch' => array(
      'name' => 'Cabin Sketch',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001235d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001235e',
        ),
      ),
    ),
    'caesar-dressing' => array(
      'name' => 'Caesar Dressing',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001235f',
        ),
      ),
    ),
    'cagliostro' => array(
      'name' => 'Cagliostro',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012360',
        ),
      ),
    ),
    'calligraffitti' => array(
      'name' => 'Calligraffitti',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125eb',
        ),
      ),
    ),
    'cambo' => array(
      'name' => 'Cambo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012362',
        ),
      ),
    ),
    'cantarell' => array(
      'name' => 'Cantarell',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012364',
        ),
        'i4' => array(
          'name' => 'Oblique',
          'license' => 'http://typekit.com/eulas/000000000000000000012365',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012366',
        ),
        'i7' => array(
          'name' => 'Bold Oblique',
          'license' => 'http://typekit.com/eulas/000000000000000000012367',
        ),
      ),
    ),
    'cantata-one' => array(
      'name' => 'Cantata One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012aca',
        ),
      ),
    ),
    'cardo' => array(
      'name' => 'Cardo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012369',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001236a',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001236b',
        ),
      ),
    ),
    'carme' => array(
      'name' => 'Carme',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001236c',
        ),
      ),
    ),
    'carter-one' => array(
      'name' => 'Carter One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001236d',
        ),
      ),
    ),
    'caudex' => array(
      'name' => 'Caudex',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012370',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012371',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012372',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012373',
        ),
      ),
    ),
    'cedarville-cursive' => array(
      'name' => 'Cedarville Cursive',
      'variants' => array(
        'n4' => array(
          'name' => 'Cursive',
          'license' => 'http://typekit.com/eulas/00000000000000000001236e',
        ),
      ),
    ),
    'ceviche-one' => array(
      'name' => 'Ceviche One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001236f',
        ),
      ),
    ),
    'changa-one' => array(
      'name' => 'Changa One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012374',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012375',
        ),
      ),
    ),
    'chango' => array(
      'name' => 'Chango',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012376',
        ),
      ),
    ),
    'chelsea-market' => array(
      'name' => 'Chelsea Market',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012377',
        ),
      ),
    ),
    'cherry-cream-soda' => array(
      'name' => 'Cherry Cream Soda',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012390',
        ),
      ),
    ),
    'chewy' => array(
      'name' => 'Chewy',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012395',
        ),
      ),
    ),
    'chicle' => array(
      'name' => 'Chicle',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012396',
        ),
      ),
    ),
    'chivo' => array(
      'name' => 'Chivo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239a',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012399',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012397',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012398',
        ),
      ),
    ),
    'chunk' => array(
      'name' => 'Chunk',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d759',
        ),
      ),
    ),
    'clara' => array(
      'name' => 'Clara',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b6',
        ),
      ),
    ),
    'coda' => array(
      'name' => 'Coda',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b7',
        ),
        'n8' => array(
          'name' => 'Heavy',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b8',
        ),
      ),
    ),
    'coda-caption' => array(
      'name' => 'Coda Caption',
      'variants' => array(
        'n8' => array(
          'name' => 'Heavy',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b9',
        ),
      ),
    ),
    'codystar' => array(
      'name' => 'Codystar',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012498',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121bd',
        ),
      ),
    ),
    'comfortaa' => array(
      'name' => 'Comfortaa',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000125dd',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125dc',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125de',
        ),
      ),
    ),
    'coming-soon' => array(
      'name' => 'Coming Soon',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123bd',
        ),
      ),
    ),
    'concert-one' => array(
      'name' => 'Concert One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125df',
        ),
      ),
    ),
    'condiment' => array(
      'name' => 'Condiment',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123bf',
        ),
      ),
    ),
    'contrail-one' => array(
      'name' => 'Contrail One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c0',
        ),
      ),
    ),
    'convergence' => array(
      'name' => 'Convergence',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c3',
        ),
      ),
    ),
    'cookie' => array(
      'name' => 'Cookie',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c4',
        ),
      ),
    ),
    'cooper-black-std' => array(
      'name' => 'Cooper Black Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000013101',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000013102',
        ),
      ),
    ),
    'copse' => array(
      'name' => 'Copse',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c5',
        ),
      ),
    ),
    'corben' => array(
      'name' => 'Corben',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c6',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c7',
        ),
      ),
    ),
    'cousine' => array(
      'name' => 'Cousine',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c9',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ca',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123cb',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123cc',
        ),
      ),
    ),
    'coustard' => array(
      'name' => 'Coustard',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123cd',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ce',
        ),
      ),
    ),
    'covered-by-your-grace' => array(
      'name' => 'Covered By Your Grace',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123d9',
        ),
      ),
    ),
    'crafty-girls' => array(
      'name' => 'Crafty Girls',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123db',
        ),
      ),
    ),
    'creepster' => array(
      'name' => 'Creepster',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f7',
        ),
      ),
    ),
    'creepster-caps' => array(
      'name' => 'Creepster Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f9',
        ),
      ),
    ),
    'crete-round' => array(
      'name' => 'Crete Round',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123fd',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123fe',
        ),
      ),
    ),
    'crimson-text' => array(
      'name' => 'Crimson Text',
      'variants' => array(
        'n4' => array(
          'name' => 'Roman',
          'license' => 'http://typekit.com/eulas/000000000000000000012400',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124df',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e2',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e3',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e0',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e1',
        ),
      ),
    ),
    'crushed' => array(
      'name' => 'Crushed',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012401',
        ),
      ),
    ),
    'cuprum' => array(
      'name' => 'Cuprum',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125a8',
        ),
      ),
    ),
    'cutive' => array(
      'name' => 'Cutive',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001259e',
        ),
      ),
    ),
    'damion' => array(
      'name' => 'Damion',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012404',
        ),
      ),
    ),
    'dancing-script' => array(
      'name' => 'Dancing Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012405',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012406',
        ),
      ),
    ),
    'dawning-of-a-new-day' => array(
      'name' => 'Dawning of a New Day',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012408',
        ),
      ),
    ),
    'days-one' => array(
      'name' => 'Days One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012409',
        ),
      ),
    ),
    'de-walpergens-pica' => array(
      'name' => 'De Walpergen\'s Pica',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f1',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f0',
        ),
      ),
    ),
    'de-walpergens-pica-small-caps' => array(
      'name' => 'De Walpergen\'s Pica Small Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ef',
        ),
      ),
    ),
    'delius' => array(
      'name' => 'Delius',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001240a',
        ),
      ),
    ),
    'delius-swash-caps' => array(
      'name' => 'Delius Swash Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001240b',
        ),
      ),
    ),
    'delius-unicase' => array(
      'name' => 'Delius Unicase',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001240c',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001240d',
        ),
      ),
    ),
    'devonshire' => array(
      'name' => 'Devonshire',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001240e',
        ),
      ),
    ),
    'dhyana' => array(
      'name' => 'Dhyana',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125c4',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125c5',
        ),
      ),
    ),
    'didact-gothic' => array(
      'name' => 'Didact Gothic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012411',
        ),
      ),
    ),
    'diplomata' => array(
      'name' => 'Diplomata',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012412',
        ),
      ),
    ),
    'diplomata-sc' => array(
      'name' => 'Diplomata SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012413',
        ),
      ),
    ),
    'doppio-one' => array(
      'name' => 'Doppio One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012414',
        ),
      ),
    ),
    'dorsa' => array(
      'name' => 'Dorsa',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012415',
        ),
      ),
    ),
    'dosis' => array(
      'name' => 'Dosis',
      'variants' => array(
        'n2' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e3',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e4',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e5',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e6',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e7',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e8',
        ),
        'n8' => array(
          'name' => 'Extra Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125e9',
        ),
      ),
    ),
    'double-pica' => array(
      'name' => 'Double Pica',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e8',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e5',
        ),
      ),
    ),
    'double-pica-small-caps' => array(
      'name' => 'Double Pica Small Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e4',
        ),
      ),
    ),
    'dr-sugiyama' => array(
      'name' => 'Dr Sugiyama',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012416',
        ),
      ),
    ),
    'droid-sans' => array(
      'name' => 'Droid Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012417',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012418',
        ),
      ),
    ),
    'droid-sans-mono' => array(
      'name' => 'Droid Sans Mono',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012419',
        ),
      ),
    ),
    'droid-serif' => array(
      'name' => 'Droid Serif',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001241a',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001241b',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001241c',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001241d',
        ),
      ),
    ),
    'duru-sans' => array(
      'name' => 'Duru Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012acb',
        ),
      ),
    ),
    'dynalight' => array(
      'name' => 'Dynalight',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001241e',
        ),
      ),
    ),
    'eb-garamond' => array(
      'name' => 'EB Garamond',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012422',
        ),
      ),
    ),
    'eater' => array(
      'name' => 'Eater',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001241f',
        ),
      ),
    ),
    'eater-caps' => array(
      'name' => 'Eater Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012421',
        ),
      ),
    ),
    'economica' => array(
      'name' => 'Economica',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012423',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012424',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012425',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012426',
        ),
      ),
    ),
    'electrolize' => array(
      'name' => 'Electrolize',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012427',
        ),
      ),
    ),
    'emblema-one' => array(
      'name' => 'Emblema One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012428',
        ),
      ),
    ),
    'emilys-candy' => array(
      'name' => 'Emilys Candy',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012429',
        ),
      ),
    ),
    'engagement' => array(
      'name' => 'Engagement',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001242a',
        ),
      ),
    ),
    'english' => array(
      'name' => 'English',
      'variants' => array(
        'n4' => array(
          'name' => 'Roman',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e6',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e7',
        ),
      ),
    ),
    'english-small-caps' => array(
      'name' => 'English Small Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124e9',
        ),
      ),
    ),
    'enriqueta' => array(
      'name' => 'Enriqueta',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001242b',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001242c',
        ),
      ),
    ),
    'erica-one' => array(
      'name' => 'Erica One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001242d',
        ),
      ),
    ),
    'esteban' => array(
      'name' => 'Esteban',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001242e',
        ),
      ),
    ),
    'euphoria-script' => array(
      'name' => 'Euphoria Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001242f',
        ),
      ),
    ),
    'ewert' => array(
      'name' => 'Ewert',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012430',
        ),
      ),
    ),
    'exo' => array(
      'name' => 'Exo',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/000000000000000000012435',
        ),
        'i1' => array(
          'name' => 'Thin Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012436',
        ),
        'n2' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001243d',
        ),
        'i2' => array(
          'name' => 'Extra Light Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001243f',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012437',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012438',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012431',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012432',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000012439',
        ),
        'i5' => array(
          'name' => 'Medium Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012440',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/000000000000000000012441',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012442',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012433',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012434',
        ),
        'n8' => array(
          'name' => 'Extra Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001243b',
        ),
        'i8' => array(
          'name' => 'Extra Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001243c',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/00000000000000000001243e',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001243a',
        ),
      ),
    ),
    'expletus-sans' => array(
      'name' => 'Expletus Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012443',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012447',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000012445',
        ),
        'i5' => array(
          'name' => 'Medium Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001244a',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/000000000000000000012448',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012449',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012444',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012446',
        ),
      ),
    ),
    'fanwood-text' => array(
      'name' => 'Fanwood Text',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001244b',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001244c',
        ),
      ),
    ),
    'fascinate' => array(
      'name' => 'Fascinate',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001244e',
        ),
      ),
    ),
    'fascinate-inline' => array(
      'name' => 'Fascinate Inline',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001244f',
        ),
      ),
    ),
    'federant' => array(
      'name' => 'Federant',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001244d',
        ),
      ),
    ),
    'federo' => array(
      'name' => 'Federo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012452',
        ),
      ),
    ),
    'felipa' => array(
      'name' => 'Felipa',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012450',
        ),
      ),
    ),
    'flamenco' => array(
      'name' => 'Flamenco',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012454',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012453',
        ),
      ),
    ),
    'flavors' => array(
      'name' => 'Flavors',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012455',
        ),
      ),
    ),
    'fondamento' => array(
      'name' => 'Fondamento',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012456',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012457',
        ),
      ),
    ),
    'fontdiner-swanky' => array(
      'name' => 'Fontdiner Swanky',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012458',
        ),
      ),
    ),
    'forum' => array(
      'name' => 'Forum',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012459',
        ),
      ),
    ),
    'fredericka-the-great' => array(
      'name' => 'Fredericka the Great',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001245b',
        ),
      ),
    ),
    'fredoka-one' => array(
      'name' => 'Fredoka One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a5',
        ),
      ),
    ),
    'french-canon' => array(
      'name' => 'French Canon',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ea',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124eb',
        ),
      ),
    ),
    'french-canon-small-caps' => array(
      'name' => 'French Canon Small Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ec',
        ),
      ),
    ),
    'fresca' => array(
      'name' => 'Fresca',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001245d',
        ),
      ),
    ),
    'frijole' => array(
      'name' => 'Frijole',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001245e',
        ),
      ),
    ),
    'fugaz-one' => array(
      'name' => 'Fugaz One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001245f',
        ),
      ),
    ),
    'fusaka-std' => array(
      'name' => 'Fusaka Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c1',
        ),
      ),
    ),
    'gfs-didot' => array(
      'name' => 'GFS Didot',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246e',
        ),
      ),
    ),
    'gfs-neohellenic' => array(
      'name' => 'GFS Neohellenic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246f',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012472',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012470',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012471',
        ),
      ),
    ),
    'galdeano' => array(
      'name' => 'Galdeano',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012460',
        ),
      ),
    ),
    'gentium-basic' => array(
      'name' => 'Gentium Basic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012461',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012462',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012463',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012464',
        ),
      ),
    ),
    'gentium-book-basic' => array(
      'name' => 'Gentium Book Basic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012465',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012466',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012467',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012469',
        ),
      ),
    ),
    'geo' => array(
      'name' => 'Geo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246a',
        ),
        'i4' => array(
          'name' => 'Oblique',
          'license' => 'http://typekit.com/eulas/000000000000000000012468',
        ),
      ),
    ),
    'geostar' => array(
      'name' => 'Geostar',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246b',
        ),
      ),
    ),
    'geostar-fill' => array(
      'name' => 'Geostar Fill',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246c',
        ),
      ),
    ),
    'germania-one' => array(
      'name' => 'Germania One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001246d',
        ),
      ),
    ),
    'giddyup-std' => array(
      'name' => 'Giddyup Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c2',
        ),
      ),
    ),
    'give-you-glory' => array(
      'name' => 'Give You Glory',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012473',
        ),
      ),
    ),
    'glass-antiqua' => array(
      'name' => 'Glass Antiqua',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012474',
        ),
      ),
    ),
    'glegoo' => array(
      'name' => 'Glegoo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012475',
        ),
      ),
    ),
    'gloria-hallelujah' => array(
      'name' => 'Gloria Hallelujah',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012476',
        ),
      ),
    ),
    'goblin-one' => array(
      'name' => 'Goblin One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012478',
        ),
      ),
    ),
    'gochi-hand' => array(
      'name' => 'Gochi Hand',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012477',
        ),
      ),
    ),
    'gorditas' => array(
      'name' => 'Gorditas',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a6',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a7',
        ),
      ),
    ),
    'goudy-bookletter-1911' => array(
      'name' => 'Goudy Bookletter 1911',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012479',
        ),
      ),
    ),
    'graduate' => array(
      'name' => 'Graduate',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a0',
        ),
      ),
    ),
    'gravitas-one' => array(
      'name' => 'Gravitas One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001247a',
        ),
      ),
    ),
    'great-primer' => array(
      'name' => 'Great Primer',
      'variants' => array(
        'n4' => array(
          'name' => 'Roman',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ee',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ed',
        ),
      ),
    ),
    'great-primer-small-caps' => array(
      'name' => 'Great Primer Small Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f2',
        ),
      ),
    ),
    'gruppo' => array(
      'name' => 'Gruppo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125f4',
        ),
      ),
    ),
    'gudea' => array(
      'name' => 'Gudea',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001247c',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001247d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001247e',
        ),
      ),
    ),
    'habibi' => array(
      'name' => 'Habibi',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001247f',
        ),
      ),
    ),
    'hammersmith-one' => array(
      'name' => 'Hammersmith One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012480',
        ),
      ),
    ),
    'handlee' => array(
      'name' => 'Handlee',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012481',
        ),
      ),
    ),
    'happy-monkey' => array(
      'name' => 'Happy Monkey',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a8',
        ),
      ),
    ),
    'henny-penny' => array(
      'name' => 'Henny Penny',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012485',
        ),
      ),
    ),
    'herr-von-muellerhoff' => array(
      'name' => 'Herr Von Muellerhoff',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012484',
        ),
      ),
    ),
    'hobo-std' => array(
      'name' => 'Hobo Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c3',
        ),
      ),
    ),
    'holtwood-one-sc' => array(
      'name' => 'Holtwood One SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012486',
        ),
      ),
    ),
    'homemade-apple' => array(
      'name' => 'Homemade Apple',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012487',
        ),
      ),
    ),
    'homenaje' => array(
      'name' => 'Homenaje',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012488',
        ),
      ),
    ),
    'iceberg' => array(
      'name' => 'Iceberg',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012489',
        ),
      ),
    ),
    'iceland' => array(
      'name' => 'Iceland',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001248a',
        ),
      ),
    ),
    'immi-five-of-five' => array(
      'name' => 'Immi Five Of Five',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c4',
        ),
      ),
    ),
    'imprima' => array(
      'name' => 'Imprima',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a1',
        ),
      ),
    ),
    'inconsolata' => array(
      'name' => 'Inconsolata',
      'variants' => array(
        'n5' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012ace',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012acd',
        ),
      ),
    ),
    'inder' => array(
      'name' => 'Inder',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001248d',
        ),
      ),
    ),
    'indie-flower' => array(
      'name' => 'Indie Flower',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001248e',
        ),
      ),
    ),
    'inika' => array(
      'name' => 'Inika',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012490',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001248f',
        ),
      ),
    ),
    'irish-grover' => array(
      'name' => 'Irish Grover',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012491',
        ),
      ),
    ),
    'istok-web' => array(
      'name' => 'Istok Web',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012493',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012494',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012495',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012496',
        ),
      ),
    ),
    'italiana' => array(
      'name' => 'Italiana',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124a9',
        ),
      ),
    ),
    'italianno' => array(
      'name' => 'Italianno',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012497',
        ),
      ),
    ),
    'jim-nightshade' => array(
      'name' => 'Jim Nightshade',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c8',
        ),
      ),
    ),
    'jockey-one' => array(
      'name' => 'Jockey One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121df',
        ),
      ),
    ),
    'jolly-lodger' => array(
      'name' => 'Jolly Lodger',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121de',
        ),
      ),
    ),
    'josefin-sans' => array(
      'name' => 'Josefin Sans',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c6',
        ),
        'i1' => array(
          'name' => 'Thin Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c4',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c0',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c2',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c3',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c1',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c5',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c7',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121bf',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121be',
        ),
      ),
    ),
    'josefin-slab' => array(
      'name' => 'Josefin Slab',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/0000000000000000000121d9',
        ),
        'i1' => array(
          'name' => 'Thin Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121db',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000121d7',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121cb',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121c9',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121d8',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121dd',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121dc',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121ca',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121da',
        ),
      ),
    ),
    'judson' => array(
      'name' => 'Judson',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e2',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e1',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e0',
        ),
      ),
    ),
    'julee' => array(
      'name' => 'Julee',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e3',
        ),
      ),
    ),
    'junge' => array(
      'name' => 'Junge',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012523',
        ),
      ),
    ),
    'jura' => array(
      'name' => 'Jura',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e6',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e8',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e7',
        ),
        'n6' => array(
          'name' => 'Demibold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121e5',
        ),
      ),
    ),
    'just-another-hand' => array(
      'name' => 'Just Another Hand',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121fc',
        ),
      ),
    ),
    'just-me-again-down-here' => array(
      'name' => 'Just Me Again Down Here',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121fd',
        ),
      ),
    ),
    'kaffeesatz' => array(
      'name' => 'Kaffeesatz',
      'variants' => array(
        'n1' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000125f1',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000125f0',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125ef',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000125ee',
        ),
      ),
    ),
    'kameron' => array(
      'name' => 'Kameron',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000121ff',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000121fe',
        ),
      ),
    ),
    'karla' => array(
      'name' => 'Karla',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124aa',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ab',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ad',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ac',
        ),
      ),
    ),
    'kaushan-script' => array(
      'name' => 'Kaushan Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012200',
        ),
      ),
    ),
    'kelly-slab' => array(
      'name' => 'Kelly Slab',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012201',
        ),
      ),
    ),
    'kenia' => array(
      'name' => 'Kenia',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001285a',
        ),
      ),
    ),
    'knewave' => array(
      'name' => 'Knewave',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012204',
        ),
      ),
    ),
    'kotta-one' => array(
      'name' => 'Kotta One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012205',
        ),
      ),
    ),
    'kranky' => array(
      'name' => 'Kranky',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012208',
        ),
      ),
    ),
    'kreon' => array(
      'name' => 'Kreon',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d5',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d6',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d4',
        ),
      ),
    ),
    'kristi' => array(
      'name' => 'Kristi',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d7',
        ),
      ),
    ),
    'krona-one' => array(
      'name' => 'Krona One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012209',
        ),
      ),
    ),
    'la-belle-aurore' => array(
      'name' => 'La Belle Aurore',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001220a',
        ),
      ),
    ),
    'lancelot' => array(
      'name' => 'Lancelot',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001220b',
        ),
      ),
    ),
    'lateef' => array(
      'name' => 'Lateef',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001220c',
        ),
      ),
    ),
    'lato' => array(
      'name' => 'Lato',
      'variants' => array(
        'n1' => array(
          'name' => 'Hairline',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b2',
        ),
        'i1' => array(
          'name' => 'Hairline Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b3',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b4',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b5',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ae',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124af',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b0',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b1',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b6',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b7',
        ),
      ),
    ),
    'league-gothic' => array(
      'name' => 'League Gothic',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012b15',
        ),
      ),
    ),
    'leckerli-one' => array(
      'name' => 'Leckerli One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125ea',
        ),
      ),
    ),
    'ledger' => array(
      'name' => 'Ledger',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012219',
        ),
      ),
    ),
    'lekton' => array(
      'name' => 'Lekton',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001221c',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001221b',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001221a',
        ),
      ),
    ),
    'lemon' => array(
      'name' => 'Lemon',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001221d',
        ),
      ),
    ),
    'lilita-one' => array(
      'name' => 'Lilita One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001221e',
        ),
      ),
    ),
    'linden-hill' => array(
      'name' => 'Linden Hill',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001006b',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001006c',
        ),
      ),
    ),
    'lobster' => array(
      'name' => 'Lobster',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012224',
        ),
      ),
    ),
    'lobster-two' => array(
      'name' => 'Lobster Two',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012223',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012221',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012220',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012222',
        ),
      ),
    ),
    'londrina-outline' => array(
      'name' => 'Londrina Outline',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012503',
        ),
      ),
    ),
    'londrina-shadow' => array(
      'name' => 'Londrina Shadow',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012502',
        ),
      ),
    ),
    'londrina-sketch' => array(
      'name' => 'Londrina Sketch',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012504',
        ),
      ),
    ),
    'londrina-solid' => array(
      'name' => 'Londrina Solid',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012505',
        ),
      ),
    ),
    'lora' => array(
      'name' => 'Lora',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012228',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012225',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012227',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012226',
        ),
      ),
    ),
    'love-ya-like-a-sister' => array(
      'name' => 'Love Ya Like A Sister',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012229',
        ),
      ),
    ),
    'loved-by-the-king' => array(
      'name' => 'Loved by the King',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001222a',
        ),
      ),
    ),
    'luckiest-guy' => array(
      'name' => 'Luckiest Guy',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001222b',
        ),
      ),
    ),
    'lusitana' => array(
      'name' => 'Lusitana',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001222d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001222c',
        ),
      ),
    ),
    'lustria' => array(
      'name' => 'Lustria',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001222e',
        ),
      ),
    ),
    'm-1c' => array(
      'name' => 'M+ 1c',
      'variants' => array(
        'n2' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/00000000000000000000d305',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000000d302',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d304',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/00000000000000000000d303',
        ),
        'n7' => array(
          'name' => 'Bold ',
          'license' => 'http://typekit.com/eulas/00000000000000000000d300',
        ),
        'n8' => array(
          'name' => 'Black ',
          'license' => 'http://typekit.com/eulas/00000000000000000000d2ff',
        ),
        'n9' => array(
          'name' => 'Heavy ',
          'license' => 'http://typekit.com/eulas/00000000000000000000d301',
        ),
      ),
    ),
    'm-1m' => array(
      'name' => 'M+ 1m ',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/00000000000000000000d36e',
        ),
        'n2' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000000d370',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d36d',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/00000000000000000000d36f',
        ),
        'n7' => array(
          'name' => 'Bold ',
          'license' => 'http://typekit.com/eulas/00000000000000000000d371',
        ),
      ),
    ),
    'macondo' => array(
      'name' => 'Macondo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001222f',
        ),
      ),
    ),
    'macondo-swash-caps' => array(
      'name' => 'Macondo Swash Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012230',
        ),
      ),
    ),
    'maiden-orange' => array(
      'name' => 'Maiden Orange',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012233',
        ),
      ),
    ),
    'mako' => array(
      'name' => 'Mako',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012234',
        ),
      ),
    ),
    'marck-script' => array(
      'name' => 'Marck Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012235',
        ),
      ),
    ),
    'marko-one' => array(
      'name' => 'Marko One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012236',
        ),
      ),
    ),
    'marmelad' => array(
      'name' => 'Marmelad',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012237',
        ),
      ),
    ),
    'marvel' => array(
      'name' => 'Marvel',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001223a',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012238',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012239',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001223b',
        ),
      ),
    ),
    'mate' => array(
      'name' => 'Mate',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001223c',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001223d',
        ),
      ),
    ),
    'mate-sc' => array(
      'name' => 'Mate SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001223e',
        ),
      ),
    ),
    'maven-pro' => array(
      'name' => 'Maven Pro',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012240',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000012241',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012242',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/00000000000000000001223f',
        ),
      ),
    ),
    'meddon' => array(
      'name' => 'Meddon',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012243',
        ),
      ),
    ),
    'medievalsharp' => array(
      'name' => 'MedievalSharp',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012244',
        ),
      ),
    ),
    'medula-one' => array(
      'name' => 'Medula One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012245',
        ),
      ),
    ),
    'megrim' => array(
      'name' => 'Megrim',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012246',
        ),
      ),
    ),
    'merienda-one' => array(
      'name' => 'Merienda One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012247',
        ),
      ),
    ),
    'merriweather' => array(
      'name' => 'Merriweather',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001224b',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001224a',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012249',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012248',
        ),
      ),
    ),
    'metamorphous' => array(
      'name' => 'Metamorphous',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012ad4',
        ),
      ),
    ),
    'miama' => array(
      'name' => 'Miama',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001224f',
        ),
      ),
    ),
    'miltonian' => array(
      'name' => 'Miltonian',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012251',
        ),
      ),
    ),
    'miltonian-tattoo' => array(
      'name' => 'Miltonian Tattoo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001256d',
        ),
      ),
    ),
    'miniver' => array(
      'name' => 'Miniver',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012253',
        ),
      ),
    ),
    'miss-fajardose' => array(
      'name' => 'Miss Fajardose',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012254',
        ),
      ),
    ),
    'miss-saint-delafield' => array(
      'name' => 'Miss Saint Delafield',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012255',
        ),
      ),
    ),
    'modern-antiqua' => array(
      'name' => 'Modern Antiqua',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012256',
        ),
      ),
    ),
    'molengo' => array(
      'name' => 'Molengo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d8',
        ),
      ),
    ),
    'monofett' => array(
      'name' => 'Monofett',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124d9',
        ),
      ),
    ),
    'monoton' => array(
      'name' => 'Monoton',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124da',
        ),
      ),
    ),
    'monsieur-la-doulaise' => array(
      'name' => 'Monsieur La Doulaise',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124db',
        ),
      ),
    ),
    'montaga' => array(
      'name' => 'Montaga',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124dc',
        ),
      ),
    ),
    'montez' => array(
      'name' => 'Montez',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124dd',
        ),
      ),
    ),
    'montserrat' => array(
      'name' => 'Montserrat',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124de',
        ),
      ),
    ),
    'mountains-of-christmas' => array(
      'name' => 'Mountains of Christmas',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012257',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012264',
        ),
      ),
    ),
    'mr-bedfort' => array(
      'name' => 'Mr Bedfort',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012258',
        ),
      ),
    ),
    'mr-dafoe' => array(
      'name' => 'Mr Dafoe',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012259',
        ),
      ),
    ),
    'mr-de-haviland' => array(
      'name' => 'Mr De Haviland',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001225a',
        ),
      ),
    ),
    'mrs-saint-delafield' => array(
      'name' => 'Mrs Saint Delafield',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001225b',
        ),
      ),
    ),
    'mrs-sheppards' => array(
      'name' => 'Mrs Sheppards',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001225c',
        ),
      ),
    ),
    'muli' => array(
      'name' => 'Muli',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001225d',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001225f',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012260',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001225e',
        ),
      ),
    ),
    'mystery-quest' => array(
      'name' => 'Mystery Quest',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012261',
        ),
      ),
    ),
    'neuton' => array(
      'name' => 'Neuton',
      'variants' => array(
        'n2' => array(
          'name' => 'ExtraLight',
          'license' => 'http://typekit.com/eulas/00000000000000000001226b',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000001226c',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012269',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012268',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012266',
        ),
        'n8' => array(
          'name' => 'Extra Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012267',
        ),
      ),
    ),
    'neuton-cursive' => array(
      'name' => 'Neuton Cursive',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001226a',
        ),
      ),
    ),
    'niconne' => array(
      'name' => 'Niconne',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001226e',
        ),
      ),
    ),
    'nixie-one' => array(
      'name' => 'Nixie One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125f3',
        ),
      ),
    ),
    'nobile' => array(
      'name' => 'Nobile',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012273',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012275',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000012270',
        ),
        'i5' => array(
          'name' => 'Medium Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012271',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012272',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012274',
        ),
      ),
    ),
    'norican' => array(
      'name' => 'Norican',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012276',
        ),
      ),
    ),
    'nosifer' => array(
      'name' => 'Nosifer',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012277',
        ),
      ),
    ),
    'nothing-you-could-do' => array(
      'name' => 'Nothing You Could Do',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012278',
        ),
      ),
    ),
    'noticia-text' => array(
      'name' => 'Noticia Text',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001227a',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001227b',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012279',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001227c',
        ),
      ),
    ),
    'nova-cut' => array(
      'name' => 'Nova Cut',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001250f',
        ),
      ),
    ),
    'nova-flat' => array(
      'name' => 'Nova Flat',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012510',
        ),
      ),
    ),
    'nova-mono' => array(
      'name' => 'Nova Mono',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012511',
        ),
      ),
    ),
    'nova-oval' => array(
      'name' => 'Nova Oval',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012512',
        ),
      ),
    ),
    'nova-round' => array(
      'name' => 'Nova Round',
      'variants' => array(
        'n4' => array(
          'name' => 'Book',
          'license' => 'http://typekit.com/eulas/000000000000000000012513',
        ),
      ),
    ),
    'nova-script' => array(
      'name' => 'Nova Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012514',
        ),
      ),
    ),
    'nova-slim' => array(
      'name' => 'Nova Slim',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012515',
        ),
      ),
    ),
    'nova-square' => array(
      'name' => 'Nova Square',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012516',
        ),
      ),
    ),
    'numans' => array(
      'name' => 'Numans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012280',
        ),
      ),
    ),
    'nunito' => array(
      'name' => 'Nunito',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012ada',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012ad9',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012adb',
        ),
      ),
    ),
    'old-standard' => array(
      'name' => 'Old Standard',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000e036',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000e037',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000000e038',
        ),
      ),
    ),
    'oldenburg' => array(
      'name' => 'Oldenburg',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012284',
        ),
      ),
    ),
    'open-sans' => array(
      'name' => 'Open Sans',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000011c39',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c3a',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000011c3b',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c38',
        ),
        'n6' => array(
          'name' => 'Semi Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000011c3c',
        ),
        'i6' => array(
          'name' => 'Semi Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c3d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000011c34',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c35',
        ),
        'n8' => array(
          'name' => 'Extra Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000011c36',
        ),
        'i8' => array(
          'name' => 'Extra Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c37',
        ),
      ),
    ),
    'open-sans-condensed' => array(
      'name' => 'Open Sans Condensed',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012519',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001251a',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012518',
        ),
      ),
    ),
    'orbitron' => array(
      'name' => 'Orbitron',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/00000000000000000000ddb0',
        ),
        'n5' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000ddaf',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000000ddb1',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/00000000000000000000ddb2',
        ),
      ),
    ),
    'original-surfer' => array(
      'name' => 'Original Surfer',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012286',
        ),
      ),
    ),
    'over-the-rainbow' => array(
      'name' => 'Over the Rainbow',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012289',
        ),
      ),
    ),
    'overlock' => array(
      'name' => 'Overlock',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001228e',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001228d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001228c',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001228a',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012290',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001228b',
        ),
      ),
    ),
    'overlock-sc' => array(
      'name' => 'Overlock SC',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001228f',
        ),
      ),
    ),
    'ovo' => array(
      'name' => 'Ovo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012291',
        ),
      ),
    ),
    'pt-mono' => array(
      'name' => 'PT Mono',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d6',
        ),
      ),
    ),
    'pt-sans' => array(
      'name' => 'PT Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f9',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f6',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124fa',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f7',
        ),
      ),
    ),
    'pt-sans-caption' => array(
      'name' => 'PT Sans Caption',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f5',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f8',
        ),
      ),
    ),
    'pt-sans-narrow' => array(
      'name' => 'PT Sans Narrow',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f3',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124f4',
        ),
      ),
    ),
    'pt-serif' => array(
      'name' => 'PT Serif',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012500',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124fe',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ff',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124fd',
        ),
      ),
    ),
    'pt-serif-caption' => array(
      'name' => 'PT Serif Caption',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124fc',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124fb',
        ),
      ),
    ),
    'pacifico' => array(
      'name' => 'Pacifico',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012292',
        ),
      ),
    ),
    'parisienne' => array(
      'name' => 'Parisienne',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012293',
        ),
      ),
    ),
    'passero-one' => array(
      'name' => 'Passero One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012294',
        ),
      ),
    ),
    'passion-one' => array(
      'name' => 'Passion One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012297',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012296',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012295',
        ),
      ),
    ),
    'patrick-hand' => array(
      'name' => 'Patrick Hand',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125f2',
        ),
      ),
    ),
    'patua-one' => array(
      'name' => 'Patua One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012299',
        ),
      ),
    ),
    'paytone-one' => array(
      'name' => 'Paytone One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001229a',
        ),
      ),
    ),
    'permanent-marker' => array(
      'name' => 'Permanent Marker',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001229b',
        ),
      ),
    ),
    'petrona' => array(
      'name' => 'Petrona',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001229c',
        ),
      ),
    ),
    'philosopher' => array(
      'name' => 'Philosopher',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a0',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001229d',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001229e',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001229f',
        ),
      ),
    ),
    'piedra' => array(
      'name' => 'Piedra',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a1',
        ),
      ),
    ),
    'pinyon-script' => array(
      'name' => 'Pinyon Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a2',
        ),
      ),
    ),
    'plaster' => array(
      'name' => 'Plaster',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122a3',
        ),
      ),
    ),
    'play' => array(
      'name' => 'Play',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c6',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c5',
        ),
      ),
    ),
    'playball' => array(
      'name' => 'Playball',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122c7',
        ),
      ),
    ),
    'playfair-display' => array(
      'name' => 'Playfair Display',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012adf',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012ae0',
        ),
      ),
    ),
    'podkova' => array(
      'name' => 'Podkova',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ca',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122cb',
        ),
      ),
    ),
    'poiret-one' => array(
      'name' => 'Poiret One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122cc',
        ),
      ),
    ),
    'poller-one' => array(
      'name' => 'Poller One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122cd',
        ),
      ),
    ),
    'poly' => array(
      'name' => 'Poly',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122cf',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122ce',
        ),
      ),
    ),
    'pompiere' => array(
      'name' => 'Pompiere',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d0',
        ),
      ),
    ),
    'pontano-sans' => array(
      'name' => 'Pontano Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012207',
        ),
      ),
    ),
    'port-lligat-sans' => array(
      'name' => 'Port Lligat Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d1',
        ),
      ),
    ),
    'port-lligat-slab' => array(
      'name' => 'Port Lligat Slab',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d2',
        ),
      ),
    ),
    'prata' => array(
      'name' => 'Prata',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d3',
        ),
      ),
    ),
    'princess-sofia' => array(
      'name' => 'Princess Sofia',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d4',
        ),
      ),
    ),
    'prosto-one' => array(
      'name' => 'Prosto One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122d7',
        ),
      ),
    ),
    'puritan' => array(
      'name' => 'Puritan',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f7',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f8',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f6',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122f5',
        ),
      ),
    ),
    'quantico' => array(
      'name' => 'Quantico',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000122fd',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122fb',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000122fa',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000122fc',
        ),
      ),
    ),
    'quattrocento' => array(
      'name' => 'Quattrocento',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000125ae',
        ),
      ),
    ),
    'quattrocento-sans' => array(
      'name' => 'Quattrocento Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012300',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012304',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012303',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012302',
        ),
      ),
    ),
    'questrial' => array(
      'name' => 'Questrial',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012305',
        ),
      ),
    ),
    'quicksand' => array(
      'name' => 'Quicksand',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000012307',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001230b',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001230a',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012306',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012309',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012308',
        ),
      ),
    ),
    'qwigley' => array(
      'name' => 'Qwigley',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001230c',
        ),
      ),
    ),
    'radley' => array(
      'name' => 'Radley',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001230d',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001230e',
        ),
      ),
    ),
    'raleway' => array(
      'name' => 'Raleway',
      'variants' => array(
        'n1' => array(
          'name' => 'Thin',
          'license' => 'http://typekit.com/eulas/00000000000000000001328e',
        ),
      ),
    ),
    'rammetto-one' => array(
      'name' => 'Rammetto One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012314',
        ),
      ),
    ),
    'rancho' => array(
      'name' => 'Rancho',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012315',
        ),
      ),
    ),
    'rationale' => array(
      'name' => 'Rationale',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012316',
        ),
      ),
    ),
    'redressed' => array(
      'name' => 'Redressed',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012317',
        ),
      ),
    ),
    'reenie-beanie' => array(
      'name' => 'Reenie Beanie',
      'variants' => array(
        'n5' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000e039',
        ),
      ),
    ),
    'revalia' => array(
      'name' => 'Revalia',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b8',
        ),
      ),
    ),
    'ribeye' => array(
      'name' => 'Ribeye',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012319',
        ),
      ),
    ),
    'ribeye-marrow' => array(
      'name' => 'Ribeye Marrow',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001231a',
        ),
      ),
    ),
    'righteous' => array(
      'name' => 'Righteous',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001231b',
        ),
      ),
    ),
    'rochester' => array(
      'name' => 'Rochester',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001231c',
        ),
      ),
    ),
    'rock-salt' => array(
      'name' => 'Rock Salt',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001231d',
        ),
      ),
    ),
    'ropa-sans' => array(
      'name' => 'Ropa Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012322',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012321',
        ),
      ),
    ),
    'rosario' => array(
      'name' => 'Rosario',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012326',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012325',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012323',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000012324',
        ),
      ),
    ),
    'rouge-script' => array(
      'name' => 'Rouge Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012327',
        ),
      ),
    ),
    'ruda' => array(
      'name' => 'Ruda',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232a',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000012329',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/000000000000000000012328',
        ),
      ),
    ),
    'ruge-boogie' => array(
      'name' => 'Ruge Boogie',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232b',
        ),
      ),
    ),
    'ruluko' => array(
      'name' => 'Ruluko',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232c',
        ),
      ),
    ),
    'ruslan-display' => array(
      'name' => 'Ruslan Display',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232d',
        ),
      ),
    ),
    'ruthie' => array(
      'name' => 'Ruthie',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232e',
        ),
      ),
    ),
    'sail' => array(
      'name' => 'Sail',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001232f',
        ),
      ),
    ),
    'salsa' => array(
      'name' => 'Salsa',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012330',
        ),
      ),
    ),
    'sancreek' => array(
      'name' => 'Sancreek',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012378',
        ),
      ),
    ),
    'sansita-one' => array(
      'name' => 'Sansita One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012379',
        ),
      ),
    ),
    'sanvito-pro-display' => array(
      'name' => 'Sanvito Pro Display',
      'variants' => array(
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c5',
        ),
      ),
    ),
    'sarina' => array(
      'name' => 'Sarina',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237a',
        ),
      ),
    ),
    'satisfy' => array(
      'name' => 'Satisfy',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237b',
        ),
      ),
    ),
    'schoolbell' => array(
      'name' => 'Schoolbell',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237c',
        ),
      ),
    ),
    'seaweed-script' => array(
      'name' => 'Seaweed Script',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237d',
        ),
      ),
    ),
    'sevillana' => array(
      'name' => 'Sevillana',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237e',
        ),
      ),
    ),
    'shadows-into-light' => array(
      'name' => 'Shadows Into Light',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001237f',
        ),
      ),
    ),
    'shadows-into-light-two' => array(
      'name' => 'Shadows Into Light Two',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012380',
        ),
      ),
    ),
    'shanti' => array(
      'name' => 'Shanti',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012381',
        ),
      ),
    ),
    'share-regular' => array(
      'name' => 'Share Regular',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000010af6',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000010afd',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000010afe',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000010aff',
        ),
      ),
    ),
    'shojumaru' => array(
      'name' => 'Shojumaru',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012385',
        ),
      ),
    ),
    'short-stack' => array(
      'name' => 'Short Stack',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012387',
        ),
      ),
    ),
    'shuriken-std' => array(
      'name' => 'Shuriken Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Boy',
          'license' => 'http://typekit.com/eulas/0000000000000000000131c6',
        ),
      ),
    ),
    'sigmar-one' => array(
      'name' => 'Sigmar One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012388',
        ),
      ),
    ),
    'simonetta' => array(
      'name' => 'Simonetta',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001259f',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000125a0',
        ),
      ),
    ),
    'sirin-stencil' => array(
      'name' => 'Sirin Stencil',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239b',
        ),
      ),
    ),
    'six-caps' => array(
      'name' => 'Six Caps',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239c',
        ),
      ),
    ),
    'slackey' => array(
      'name' => 'Slackey',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239d',
        ),
      ),
    ),
    'smokum' => array(
      'name' => 'Smokum',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239e',
        ),
      ),
    ),
    'smythe' => array(
      'name' => 'Smythe',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001239f',
        ),
      ),
    ),
    'sniglet' => array(
      'name' => 'Sniglet',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123c8',
        ),
      ),
    ),
    'snippet' => array(
      'name' => 'Snippet',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a0',
        ),
      ),
    ),
    'sofia' => array(
      'name' => 'Sofia',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a1',
        ),
      ),
    ),
    'sonsie-one' => array(
      'name' => 'Sonsie One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a2',
        ),
      ),
    ),
    'sorts-mill-goudy' => array(
      'name' => 'Sorts Mill Goudy',
      'variants' => array(
        'n5' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d755',
        ),
        'i5' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000d756',
        ),
      ),
    ),
    'source-code-pro' => array(
      'name' => 'Source Code Pro',
      'variants' => array(
        'n2' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/000000000000000000013295',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000013296',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000013297',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/000000000000000000013294',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/000000000000000000013298',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/000000000000000000013299',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/00000000000000000001329a',
        ),
      ),
    ),
    'source-sans-pro' => array(
      'name' => 'Source Sans Pro',
      'variants' => array(
        'n2' => array(
          'name' => 'Extra Light',
          'license' => 'http://typekit.com/eulas/000000000000000000013180',
        ),
        'i2' => array(
          'name' => 'Extra Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000013181',
        ),
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/000000000000000000013183',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000013184',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000013185',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000013182',
        ),
        'n6' => array(
          'name' => 'Semibold',
          'license' => 'http://typekit.com/eulas/000000000000000000013186',
        ),
        'i6' => array(
          'name' => 'Semibold Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000013187',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001317e',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001317f',
        ),
        'n9' => array(
          'name' => 'Black',
          'license' => 'http://typekit.com/eulas/00000000000000000001317c',
        ),
        'i9' => array(
          'name' => 'Black Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000001317d',
        ),
      ),
    ),
    'special-elite' => array(
      'name' => 'Special Elite',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a3',
        ),
      ),
    ),
    'spicy-rice' => array(
      'name' => 'Spicy Rice',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a4',
        ),
      ),
    ),
    'spinnaker' => array(
      'name' => 'Spinnaker',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a6',
        ),
      ),
    ),
    'spirax' => array(
      'name' => 'Spirax',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a7',
        ),
      ),
    ),
    'squada-one' => array(
      'name' => 'Squada One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a8',
        ),
      ),
    ),
    'stardos-stencil' => array(
      'name' => 'Stardos Stencil',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123a9',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123aa',
        ),
      ),
    ),
    'stencil-std' => array(
      'name' => 'Stencil Std',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012e79',
        ),
      ),
    ),
    'stint-ultra-condensed' => array(
      'name' => 'Stint Ultra Condensed',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ab',
        ),
      ),
    ),
    'stint-ultra-expanded' => array(
      'name' => 'Stint Ultra Expanded',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ac',
        ),
      ),
    ),
    'stoke' => array(
      'name' => 'Stoke',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ad',
        ),
      ),
    ),
    'strong' => array(
      'name' => 'Strong',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ae',
        ),
      ),
    ),
    'strumpf-std' => array(
      'name' => 'Strumpf Std',
      'variants' => array(
        'n7' => array(
          'name' => 'Contour',
          'license' => 'http://typekit.com/eulas/00000000000000000001250e',
        ),
      ),
    ),
    'sue-ellen-francisco' => array(
      'name' => 'Sue Ellen Francisco',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123af',
        ),
      ),
    ),
    'sunshiney' => array(
      'name' => 'Sunshiney',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b0',
        ),
      ),
    ),
    'supermercado-one' => array(
      'name' => 'Supermercado One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/000000000000000000012aec',
        ),
      ),
    ),
    'swanky-and-moo-moo' => array(
      'name' => 'Swanky and Moo Moo',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b3',
        ),
      ),
    ),
    'syncopate' => array(
      'name' => 'Syncopate',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b4',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123b5',
        ),
      ),
    ),
    'tangerine' => array(
      'name' => 'Tangerine',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001292e',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000001292f',
        ),
      ),
    ),
    'telex' => array(
      'name' => 'Telex',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123d0',
        ),
      ),
    ),
    'tenor-sans' => array(
      'name' => 'Tenor Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123d1',
        ),
      ),
    ),
    'the-girl-next-door' => array(
      'name' => 'The Girl Next Door',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001251b',
        ),
      ),
    ),
    'tienne' => array(
      'name' => 'Tienne',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123dd',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123da',
        ),
        'n9' => array(
          'name' => 'Heavy',
          'license' => 'http://typekit.com/eulas/0000000000000000000123dc',
        ),
      ),
    ),
    'tinos' => array(
      'name' => 'Tinos',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123df',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123de',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e1',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e0',
        ),
      ),
    ),
    'titan-one' => array(
      'name' => 'Titan One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e2',
        ),
      ),
    ),
    'trade-winds' => array(
      'name' => 'Trade Winds',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e3',
        ),
      ),
    ),
    'trochut' => array(
      'name' => 'Trochut',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e6',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e4',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e5',
        ),
      ),
    ),
    'trykker' => array(
      'name' => 'Trykker',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e7',
        ),
      ),
    ),
    'tulpen-one' => array(
      'name' => 'Tulpen One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e8',
        ),
      ),
    ),
    'ubuntu' => array(
      'name' => 'Ubuntu',
      'variants' => array(
        'n3' => array(
          'name' => 'Light',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ec',
        ),
        'i3' => array(
          'name' => 'Light Italic',
          'license' => 'http://typekit.com/eulas/000000000000000000011c22',
        ),
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f0',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123eb',
        ),
        'n5' => array(
          'name' => 'Medium',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ed',
        ),
        'i5' => array(
          'name' => 'Medium Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ee',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123e9',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ea',
        ),
      ),
    ),
    'ubuntu-condensed' => array(
      'name' => 'Ubuntu Condensed',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ef',
        ),
      ),
    ),
    'ubuntu-mono' => array(
      'name' => 'Ubuntu Mono',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f4',
        ),
        'i4' => array(
          'name' => 'Regular Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f1',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f2',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f3',
        ),
      ),
    ),
    'ultra' => array(
      'name' => 'Ultra',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f5',
        ),
      ),
    ),
    'uncial-antiqua' => array(
      'name' => 'Uncial Antiqua',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f6',
        ),
      ),
    ),
    'unifrakturcook' => array(
      'name' => 'UnifrakturCook',
      'variants' => array(
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123f8',
        ),
      ),
    ),
    'unifrakturmaguntia' => array(
      'name' => 'UnifrakturMaguntia',
      'variants' => array(
        'n4' => array(
          'name' => 'Book',
          'license' => 'http://typekit.com/eulas/0000000000000000000123fc',
        ),
      ),
    ),
    'unkempt' => array(
      'name' => 'Unkempt',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123fb',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000123fa',
        ),
      ),
    ),
    'unlock' => array(
      'name' => 'Unlock',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000123ff',
        ),
      ),
    ),
    'unna' => array(
      'name' => 'Unna',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001251c',
        ),
      ),
    ),
    'vt323' => array(
      'name' => 'VT323',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c6',
        ),
      ),
    ),
    'varela' => array(
      'name' => 'Varela',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001251d',
        ),
      ),
    ),
    'varela-round' => array(
      'name' => 'Varela Round',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001251e',
        ),
      ),
    ),
    'vast-shadow' => array(
      'name' => 'Vast Shadow',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000001256c',
        ),
      ),
    ),
    'vera-sans' => array(
      'name' => 'Vera Sans',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d30d',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000d30c',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/00000000000000000000d30b',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/00000000000000000000d30a',
        ),
      ),
    ),
    'vibur' => array(
      'name' => 'Vibur',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124b9',
        ),
      ),
    ),
    'vidaloka' => array(
      'name' => 'Vidaloka',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ba',
        ),
      ),
    ),
    'viga' => array(
      'name' => 'Viga',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124bb',
        ),
      ),
    ),
    'voces' => array(
      'name' => 'Voces',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124bc',
        ),
      ),
    ),
    'volkhov' => array(
      'name' => 'Volkhov',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c0',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124bd',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124be',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124bf',
        ),
      ),
    ),
    'vollkorn' => array(
      'name' => 'Vollkorn',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/00000000000000000000d30e',
        ),
        'i4' => array(
          'name' => 'Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c3',
        ),
        'n7' => array(
          'name' => 'Bold',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c1',
        ),
        'i7' => array(
          'name' => 'Bold Italic',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c2',
        ),
      ),
    ),
    'voltaire' => array(
      'name' => 'Voltaire',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c5',
        ),
      ),
    ),
    'waiting-for-the-sunrise' => array(
      'name' => 'Waiting for the Sunrise',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c7',
        ),
      ),
    ),
    'wallpoet' => array(
      'name' => 'Wallpoet',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c8',
        ),
      ),
    ),
    'walter-turncoat' => array(
      'name' => 'Walter Turncoat',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124c9',
        ),
      ),
    ),
    'wellfleet' => array(
      'name' => 'Wellfleet',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ca',
        ),
      ),
    ),
    'wire-one' => array(
      'name' => 'Wire One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124cb',
        ),
      ),
    ),
    'yellowtail' => array(
      'name' => 'Yellowtail',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124cc',
        ),
      ),
    ),
    'yeseva-one' => array(
      'name' => 'Yeseva One',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124cd',
        ),
      ),
    ),
    'yesteryear' => array(
      'name' => 'Yesteryear',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124ce',
        ),
      ),
    ),
    'zeyada' => array(
      'name' => 'Zeyada',
      'variants' => array(
        'n4' => array(
          'name' => 'Regular',
          'license' => 'http://typekit.com/eulas/0000000000000000000124cf',
        ),
      ),
    ),
  );
}
