<?php

/**
 * @file
 * Provides API homepage for Advanced Aggregates.
 */

/**
 * Advanced Aggreggates API & development documentation.
 *
 * @mainpage Advanced Aggreggates API & Developer Documentation
 * Welcome to the Advanced Aggreggates API & development documentation.
 *
 * Newcomers to Drupal development should read the conceptual information
 * in @link https://www.drupal.org/docs/7/api/ Drupal API Introduction @endlink
 * or @link https://api.drupal.org/api/drupal/7.x Drupal API Docs @endlink.
 * The heavily documented
 * @link https://api.drupal.org/api/examples/7.x-1.x Example modules @endlink
 * may also be helpful.
 *
 * For any comments, support or questions see the
 * @link https://drupal.org/project/advagg module page @endlink.
 * Also, feel free to comment here if it is specific to one function/file.
 *
 * - Primary components of Advanced Aggregates:
 *   - @link advagg_forms Forms @endlink
 *   - @link advagg_hooks Hooks @endlink
 *   - @link advagg_tests Test Suite @endlink
 * - Advanced Aggregate sub-modules:
 *   - @link advagg_bundler/advagg_bundler.module AdvAgg Bundler @endlink
 *   - @link advagg_css_cdn/advagg_css_cdn.module AdvAgg CSS CDN @endlink
 *   - @link advagg_css_compress/advagg_css_compress.module AdvAgg CSS Compress @endlink
 *   - @link advagg_ext_compress/advagg_ext_compress.module AdvAgg External Compress @endlink
 *   - @link advagg_font/advagg_font.module AdvAgg Font @endlink
 *   - @link advagg_js_cdn/advagg_js_cdn.module AdvAgg JS CDN @endlink
 *   - @link advagg_js_compress/advagg_js_compress.module AdvAgg JS Compress @endlink
 *   - @link advagg_mod/advagg_mod.module AdvAgg Modifier @endlink
 *   - @link advagg_relocate/advagg_relocate.module AdvAgg Relocate @endlink
 *   - @link advagg_sri/advagg_sri.module AdvAgg SRI @endlink
 *   - @link advagg_validator/advagg_validator.module AdvAgg Validator @endlink
 */
