<?php

/**
 * @file
 * OPML Parser plugin.
 */

/**
 * Feeds parser plugin that parses OPML feeds.
 */
class FeedsOPMLParser extends FeedsParser {

  /**
   * Implements FeedsParser::parse().
   */
  public function parse(FeedsSource $source, FeedsFetcherResult $fetcher_result) {
    feeds_include_library('opml_parser.inc', 'opml_parser');
    $opml = opml_parser_parse($fetcher_result->getRaw());
    $result = new FeedsParserResult($opml['items']);
    $result->title = $opml['title'];
    return $result;
  }

  /**
   * Return mapping sources.
   */
  public function getMappingSources() {
    return array(
      'title' => array(
        'name' => t('Feed title'),
        'description' => t('Title of the feed.'),
      ),
      'xmlurl' => array(
        'name' => t('Feed URL'),
        'description' => t('URL of the feed.'),
      ),
    ) + parent::getMappingSources();
  }

  /**
   * Overrides FeedsParser::providesSourceTitle().
   *
   * This parser supports retrieving a title from the source.
   */
  public function providesSourceTitle() {
    return TRUE;
  }
}
