<?php
// $Id$

/**
 * @file
 *
 */

function incubator_events_views_data_alter(&$data) {
  if (module_exists('views_date_format_sql')) {
    $data['field_data_field_event_date']['field_event_date_value']['field'] = array(
      'table' => 'field_data_field_event_date',
      'handler' => 'views_date_format_sql_handler_field_date',
      'click sortable' => 1,
      'additional fields' => array(),
      'entity_tables' => array(
        'node' => 'node',
        'node_revision' => 'node',
      ),
      'element_type' => 'div',
      'is revision' => 0,
    );
  }
}

function incubator_events_views_query_alter(&$view, &$query) {

  // The activities view organizes and groups upcoming events by day, and to do
  // this it uses the date_format_sql module as well as some tricks and hacks.
  //
  // There are two fields retrieved for the date, both based on the column
  // field_data_field_event_date_field_event_date_value:
  //
  // field_data_field_event_date_field_event_date_value, or "Day"
  // is the named day of the week, e.g. Sunday.  It is the date that is displayed.
  //
  // field_data_field_event_date_field_event_date_value_1 or "Day of week"
  // is the numerical day of the week, and is used for sorting the events, since
  // if the name were used, they would not sort according to the order of the days
  // in the week.
  if ($view->name == 'activities_upcoming_events' && in_array($view->current_display, array('default', 'page'))) {
    // Since date fields retrieve separate values for each occurrence of repeating events,
    // we must remove the date_delta fields from the query in order for the grouping to work.
    unset($query->fields['field_data_field_event_date_delta']);
    unset($query->fields['date_delta_date_filter']);
    // Also, for pgsql support, we must change the formatting string for the numerical day of week field.
    $replacement = db_driver() == 'pgsql' ? 'D' : '%w';
    $query->fields['field_data_field_event_date_field_event_date_value_1']['field'] =
      str_replace("'w'", "'$replacement'", $query->fields['field_data_field_event_date_field_event_date_value_1']['field']);
    // Finally, we must add the sort to the query, and it doesn't work to add it
    // in the views interface.
    array_unshift($query->orderby, array(
      'field' => 'field_data_field_event_date_field_event_date_value_1',
      'direction' => 'ASC'
    ));
  }
  elseif($view->name == 'upcoming_events' && in_array($view->current_display, array('page', 'page_1')) && !variable_get('incubator_events_views_disable_secondary', FALSE)) {
    // For the upcoming events and calendar views, we add the link in code so that
    // it can be translated.
    $text = ($view->current_display == 'page') ? '<a href="/events/calendar">' . t('View full calendar') . '</a>' : '<a href="/events/upcoming">' . t('View upcoming events list') . '</a>';
    $view->display_handler->handlers['header']['area']->options['content'] = $text;
  }
  elseif($view->name == 'localities' && $view->current_display == 'block_1' && arg(1) == 'calendar') {
    // If the current view is the calendar, we want the localities links to point
    // to the calendar for each community instead of the list of upcoming events.
    $view->display_handler->handlers['field']['name']->options['alter']['path'] = 'events/calendar/[tid]';
  }
  elseif($view->name == 'map_events') {
    $query->add_where_expression(0, "(SELECT MIN(ned.field_event_date_value) FROM {field_data_field_event_date} ned WHERE ned.revision_id = node.vid AND ned.field_event_date_value > :time AND ned.field_event_date_value < :time2) IS NOT NULL", array(':time' => strtotime('-2 hours'), ':time2' => strtotime('+3 months')));
  }
}
