<?php

/**
 * @file
 *
 */

function incubator_social_incubator_settings_menu() {
  return array(
    'description' => 'Settings for social site integration.',
    'title' => 'Social Integration',
  );
}

function incubator_social_incubator_settings() {
  
  $form = $form_state = array();
  
  module_load_include('inc', 'hybridauth', 'hybridauth.admin');
  
  $form['social_login'] = array(
    '#type' => 'fieldset',
    '#title' => t('Social login'),
    '#description' => t('Social login is handled by Hybridauth library. Please visit !link for the full list of settings.', 
      array('!link' => l(t('the Hybridauth administration page'), '/admin/config/people/hybridauth'))),
  );
  $core_settings = array(
    USER_REGISTER_ADMINISTRATORS_ONLY => t('Administrators only'),
    USER_REGISTER_VISITORS => t('Visitors'),
    USER_REGISTER_VISITORS_ADMINISTRATIVE_APPROVAL => t('Visitors, but administrator approval is required'),
  );
  $form['social_login']['hybridauth_register'] = array(
    '#type' => 'radios',
    '#title' => t('Who can register accounts?'),
    '#options' => array(
      0 => t('Follow core') . ': ' . $core_settings[variable_get('user_register', USER_REGISTER_VISITORS_ADMINISTRATIVE_APPROVAL)],
      1 => t('Visitors'),
      2 => t('Visitors, but administrator approval is required'),
    ),
    '#description' => t('Select who can register accounts through HybridAuth.') . ' '
      . t('The core settings are available at <a href="!link">Account settings</a>.',
        array('!link' => url('admin/config/people/accounts'))),
    '#default_value' => variable_get('hybridauth_register', 0),
  );
  $core_settings = array(
    0 => t("Don't require e-mail verification"),
    1 => t('Require e-mail verification'),
  );
  $form['social_login']['hybridauth_email_verification'] = array(
    '#type' => 'radios',
    '#title' => t('E-mail verification'),
    '#options' => array(
      0 => t('Follow core') . ': ' . $core_settings[variable_get('user_email_verification', TRUE)],
      1 => t('Require e-mail verification'),
      2 => t("Don't require e-mail verification"),
    ),
    '#description' => t('Select how to handle not verified e-mail addresses (authentication provider gives non-verified e-mail address).') . ' '
      . t('The core settings are available at <a href="!link">Account settings</a>.',
        array('!link' => url('admin/config/people/accounts'))),
    '#default_value' => variable_get('hybridauth_email_verification', 0),
  );
  foreach(incubator_social_preferred_providers() as $provider_id) {
    $keys_form = hybridauth_admin_provider_settings($form, $form_state, $provider_id);
    $enabled = variable_get("hybridauth_provider_{$provider_id}_enabled", FALSE);
    $form['social_login']['keys'][$provider_id] = $keys_form['keys'];
    $form['social_login']['keys'][$provider_id]['#title'] = $provider_id . ($enabled ? ' <span class="provider-enabled">' . t('Enabled') . '</span>' : '');
    $form['social_login']['keys'][$provider_id]['#collapsible'] = TRUE;
    $form['social_login']['keys'][$provider_id]['#collapsed'] = TRUE;
  }
  
  $form = system_settings_form($form);
  $form['#submit'][] = 'incubator_social_incubator_settings_submit';
  drupal_add_css('.provider-enabled{background-color:green;color:white;padding:1px 5px;}', array('type' => 'inline'));
  
  return $form;
  
}

function incubator_social_incubator_settings_submit(&$form, &$form_state) {
  foreach(incubator_social_preferred_providers() as $provider_id) {
    if ($form_state['values']["hybridauth_provider_{$provider_id}_keys_secret"] && (
        $form_state['values']["hybridauth_provider_{$provider_id}_keys_id"] ||
        $form_state['values']["hybridauth_provider_{$provider_id}_keys_key"]
      )) {
      variable_set("hybridauth_provider_{$provider_id}_enabled", TRUE);
    }
    else {
      variable_set("hybridauth_provider_{$provider_id}_enabled", FALSE);
    }
  }
}
