<?php

/**
 * @file
 *
 */

function incubator_disabled_robots() {
  drupal_add_http_header('Content-Type', 'text/plain');
  print "User-agent: *\nDisallow: /\n";
  exit(0);
}

function incubator_access_denied_page() {
  if (!user_is_anonymous()) {
    return;
  }
  drupal_set_title(t('Please log in'));
  $page['message'] = array(
    '#markup' => variable_get('incubator_disable_site', TRUE) ? 
                 t('You must log in to view this site.') :
                 t('You must log in to view this page.'),
    '#weight' => -10,
  );
  $page['login_form'] = drupal_get_form('user_login');
  $page['reset_password_link'] = array(
    '#markup' => l(t('Forgot your password? Reset it here.'), 'user/password'),
    '#weight' => 9,
  );
  return $page;
}
