<?php
// $Id$

/**
 * @file
 *
 */

$info = array();

// basic color fields
$info['fields'] = array(
  'bgtop' => t('Background: top'),
  'bgmain' => t('Background: fill'),
  'bgtext' => t('Background: text'),
  'bglinks' => t('Background: links'),
  'text' => t('Content: text'),
  'links' => t('Content: links'),
  'headers' => t('Content: headers'),
  'headerbg' => t('Header: bg'),
  'headertext' => t('Header: text'),
  'headerglow' => t('Menu: glow'),
  'menubg' => t('Menu: item bg'),
  'menutext' => t('Menu: text'),
  'menuactivebg' => t('Menu: active bg'),
  'menuactivetext' => t('Menu: active text'),
  'blockheaderbg' => t('Block header: bg'),
  'blockheadertext' => t('Block header: text'),
  'blockbg' => t('Block: background'),
  'blocktext' => t('Block: text'),
  'blocklinks' => t('Block: links'),
  'teaserbg' => t('Teaser: bg'),
  'teaserborder' => t('Teaser: border'),
  'submittedbg' => t('Post info: bg'),
  'submittedtext' => t('Post info: text'),
  'triptychbg' => t('Triptych: bg'),
  'triptychlinks' => t('Triptych: links'),
);

// Default color scheme
$info['schemes']['default'] = array(
  'title' => t('Default'),
  'colors' => array(
    'bgtop' => '#38362a',
    'bgmain' => '#736f57',
    'bgtext' => '#fefefe',
    'bglinks' => '#bbfe01',
    'text' => '#6e6d54',
    'links' => '#3996c5',
    'headers' => '#6d6c53',
    'headerbg' => '#dad5ba',
    'headertext' => '#68624b',
    'headerglow' => '#f3f1e5',
    'menubg' => '#999473',
    'menutext' => '#bafe00',
    'menuactivebg' => '#39372b',
    'menuactivetext' => '#bafe01',
    'blockheaderbg' => '#999474',
    'blockheadertext' => '#bbfe00',
    'blockbg' => '#f2f0e4',
    'blocktext' => '#6e6d53',
    'blocklinks' => '#3995c5',
    'teaserbg' => '#f2f0e5',
    'teaserborder' => '#999374',
    'submittedbg' => '#999373',
    'submittedtext' => '#f2f1e4',
    'triptychbg' => '#dad5b9',
    'triptychlinks' => '#3996c6',
  ),
);

$info['css'] = array('css/colors.css');

// Files we want to copy along with the CSS files, let's define these later.
$info['copy'] = array(
  'logo.png',
);

// Files used in the scheme preview.
$info['preview_css'] = 'color/preview.css';
$info['preview_js'] = 'color/preview.js';
$info['preview_html'] = 'color/preview.html';

// Gradients
$info['gradients'] = array();

// Color areas to fill (x, y, width, height).
$info['fill'] = array();

// Coordinates of all the theme slices (x, y, width, height)
// with their filename as used in the stylesheet.
$info['slices'] = array();

// Base file for image generation.
$info['base_image'] = 'color/base.png';


// More color schemes
$info['schemes']['sand'] = array(
  'title' => t('Red-orange Sand'),
  'colors' => array(
    'text' => '#524314',
    'links' => '#9f5809',
    'headers' => '#524314',
    'bgmain' => '#dcd1ad',
    'bgtop' => '#2c2307',
    'bgtext' => '#524314',
    'bglinks' => '#e3decf',
    'headerbg' => '#c9ab4c',
    'headertext' => '#584b23',
    'headerglow' => '#e3decf',
    'menubg' => '#a3210b',
    'menutext' => '#dbb748',
    'menuactivebg' => '#5e1508',
    'menuactivetext' => '#e3decf',
    'blockheaderbg' => '#a3210b',
    'blockheadertext' => '#dbb748',
    'blockbg' => '#e3decf',
    'blocktext' => '#524314',
    'blocklinks' => '#9f5809',
    'teaserbg' => '#e3decf',
    'teaserborder' => '#c9ab4c',
    'submittedbg' => '#c9ab4c',
    'submittedtext' => '#e3decf',
    'triptychbg' => '#ffffff',
    'triptychlinks' => '#9f5809',
  ),
);
$info['schemes']['green'] = array(
  'title' => t('Forest'),
  'colors' => array(
    'text' => '#5f6e54',
    'links' => '#508b12',
    'headers' => '#4b6132',
    'bgmain' => '#25390e',
    'bgtop' => '#5e8f2d',
    'bgtext' => '#c4d2b6',
    'bglinks' => '#c4d2b6',
    'headerbg' => '#e8f1df',
    'headertext' => '#508b12',
    'headerglow' => '#abcb8a',
    'menubg' => '#5e8f2d',
    'menutext' => '#c4d2b6',
    'menuactivebg' => '#32392b',
    'menuactivetext' => '#c4d2b6',
    'blockheaderbg' => '#5e8f2d',
    'blockheadertext' => '#c4d2b6',
    'blockbg' => '#ebf2e4',
    'blocktext' => '#616e53',
    'blocklinks' => '#508b12',
    'teaserbg' => '#ebf2e4',
    'teaserborder' => '#5e8f2d',
    'submittedbg' => '#5e8f2d',
    'submittedtext' => '#c4d2b6',
    'triptychbg' => '#25390e',
    'triptychlinks' => '#508b12',
  ),
);
$info['schemes']['colonial'] = array(
  'title' => t('Colonial'),
  'colors' => array(
    'text' => '#242e2e',
    'links' => '#306f6f',
    'headers' => '#536d6d',
    'bgmain' => '#577373',
    'bgtop' => '#2a3838',
    'bgtext' => '#242e2e',
    'bglinks' => '#ac914a',
    'headerbg' => '#dad3ba',
    'headertext' => '#4b6868',
    'headerglow' => '#dad3ba',
    'menubg' => '#bdb185',
    'menutext' => '#8b712d',
    'menuactivebg' => '#749799',
    'menuactivetext' => '#ffffff',
    'blockheaderbg' => '#749799',
    'blockheadertext' => '#ffffff',
    'blockbg' => '#e0ebeb',
    'blocktext' => '#536e6e',
    'blocklinks' => '#ac914a',
    'teaserbg' => '#dad3ba',
    'teaserborder' => '#bdb185',
    'submittedbg' => '#bdb185',
    'submittedtext' => '#ffffff',
    'triptychbg' => '#ffffff',
    'triptychlinks' => '#ac914a',
  ),
);
$info['schemes']['bluelagoon'] = array(
  'title' => t('Blue Lagoon'),
  'colors' => array(
    'text' => '#3b3b3b',
    'links' => '#0071b3',
    'headers' => '#3b3b3b',
    'bgmain' => '#ffffff',
    'bgtop' => '#48a9e4',
    'bgtext' => '#3b3b3b',
    'bglinks' => '#0071b3',
    'headerbg' => '#0779bf',
    'headertext' => '#ffffff',
    'headerglow' => '#0779bf',
    'menubg' => '#c5e3f5',
    'menutext' => '#3b3b3b',
    'menuactivebg' => '#ffffff',
    'menuactivetext' => '#3b3b3b',
    'blockheaderbg' => '#f6f6f2',
    'blockheadertext' => '#3b3b3b',
    'blockbg' => '#f6f6f2',
    'blocktext' => '#3b3b3b',
    'blocklinks' => '#0071b3',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#ffffff',
    'submittedbg' => '#f6f6f2',
    'submittedtext' => '#9ab7c8',
    'triptychbg' => '#292929',
    'triptychlinks' => '#0071b3',
  )
);
$info['schemes']['bluegray'] = array(
  'title' => t('Navy'),
  'colors' => array(
    'text' => '#636779',
    'links' => '#5580ff',
    'headers' => '#9297ac',
    'bgmain' => '#8c93a8',
    'bgtop' => '#2e417b',
    'bgtext' => '#000000',
    'bglinks' => '#ffffff',
    'headerbg' => '#252d45',
    'headertext' => '#c9cfdf',
    'headerglow' => '#b2b9cd',
    'menubg' => '#666f8c',
    'menutext' => '#002286',
    'menuactivebg' => '#c6c9d4',
    'menuactivetext' => '#002486',
    'blockheaderbg' => '#374877',
    'blockheadertext' => '#abbded',
    'blockbg' => '#dde0e9',
    'blocktext' => '#5f6472',
    'blocklinks' => '#5580ff',
    'teaserbg' => '#dde0e9',
    'teaserborder' => '#374877',
    'submittedbg' => '#374877',
    'submittedtext' => '#ffffff',
    'triptychbg' => '#252d45',
    'triptychlinks' => '#5580ff',
  ),
);
$info['schemes']['blankslate'] = array(
  'title' => t('Blank Slate Gray'),
  'colors' => array(
    'text' => '#343434',
    'links' => '#a5a5a5',
    'headers' => '#343434',
    'bgmain' => '#dddddd',
    'bgtop' => '#bebebe',
    'bgtext' => '#343434',
    'bglinks' => '#ffffff',
    'headerbg' => '#dddddd',
    'headertext' => '#343434',
    'headerglow' => '#cccccc',
    'menubg' => '#efefef',
    'menutext' => '#343434',
    'menuactivebg' => '#ffffff',
    'menuactivetext' => '#343434',
    'blockheaderbg' => '#dddddd',
    'blockheadertext' => '#343434',
    'blockbg' => '#ffffff',
    'blocktext' => '#343434',
    'blocklinks' => '#a5a5a5',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#dddddd',
    'submittedbg' => '#dddddd',
    'submittedtext' => '#ffffff',
    'triptychbg' => '#ffffff',
    'triptychlinks' => '#a5a5a5',
  )
);
$info['schemes']['seashell'] = array(
  'title' => t('Seashell'),
  'colors' => array(
    'bgtop' => '#4359a0',
    'bgmain' => '#78797a',
    'bgtext' => '#c8aab0',
    'bglinks' => '#ffffff',
    'text' => '#3a2f20',
    'links' => '#6f86df',
    'headers' => '#84555e',
    'headerbg' => '#9faee8',
    'headertext' => '#ffffff',
    'headerglow' => '#8599e8',
    'menubg' => '#f3e5e7',
    'menutext' => '#84555e',
    'menuactivebg' => '#ffffff',
    'menuactivetext' => '#3a2f20',
    'blockheaderbg' => '#fcf6f6',
    'blockheadertext' => '#84555e',
    'blockbg' => '#fcf6f6',
    'blocktext' => '#3a2f20',
    'blocklinks' => '#6f86df',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#c8aab0',
    'submittedbg' => '#c8aab0',
    'submittedtext' => '#ffffff',
    'triptychbg' => '#78797a',
    'triptychlinks' => '#6f86df',
  )
);
$info['schemes']['sandsky'] = array(
  'title' => t('Sand and Sky'),
  'colors' => array(
    'bgtop' => '#cfddf9',
    'bgmain' => '#f7f6f5',
    'bgtext' => '#3a2f20',
    'bglinks' => '#6b93e9',
    'text' => '#3a2f20',
    'links' => '#6b93e9',
    'headers' => '#8e705f',
    'headerbg' => '#9fb5e8',
    'headertext' => '#ffffff',
    'headerglow' => '#c5b6ac',
    'menubg' => '#f1f1e7',
    'menutext' => '#8e705f',
    'menuactivebg' => '#ffffff',
    'menuactivetext' => '#8e705f',
    'blockheaderbg' => '#c8b5aa',
    'blockheadertext' => '#ffffff',
    'blockbg' => '#ffffff',
    'blocktext' => '#3a2f20',
    'blocklinks' => '#6b93e9',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#c8b5aa',
    'submittedbg' => '#c8b5aa',
    'submittedtext' => '#ffffff',
    'triptychbg' => '#ffffff',
    'triptychlinks' => '#6b93e9',
  )
);
$info['schemes']['prairie'] = array(
  'title' => t('Prairie'),
  'colors' => array(
    'bgtop' => '#f8f8d1',
    'bgmain' => '#ffffff',
    'bgtext' => '#334f4b',
    'bglinks' => '#3a9f90',
    'text' => '#334f4b',
    'links' => '#bf9d2e',
    'headers' => '#7ca49e',
    'headerbg' => '#8abfb7',
    'headertext' => '#fbf9ed',
    'headerglow' => '#729f98',
    'menubg' => '#628681',
    'menutext' => '#dbf3ef',
    'menuactivebg' => '#f9f4c6',
    'menuactivetext' => '#6f6932',
    'blockheaderbg' => '#7ca49e',
    'blockheadertext' => '#fbf9ed',
    'blockbg' => '#ffffff',
    'blocktext' => '#343434',
    'blocklinks' => '#bf9d2e',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#ffffff',
    'submittedbg' => '#ffffff',
    'submittedtext' => '#7ca49e',
    'triptychbg' => '#ffffff',
    'triptychlinks' => '#bf9d2e',
  )
);
$info['schemes']['sunset1'] = array(
  'title' => t('Sunset 1'),
  'colors' => array(
    'bgtop' => '#fbd0be',
    'bgmain' => '#b6cce5',
    'bgtext' => '#5a3323',
    'bglinks' => '#bf2a1a',
    'text' => '#5a3323',
    'links' => '#bf2a1a',
    'headers' => '#4c6a8d',
    'headerbg' => '#f7f7e6',
    'headertext' => '#95353e',
    'headerglow' => '#f6c3b4',
    'menubg' => '#cac6bd',
    'menutext' => '#5a3323',
    'menuactivebg' => '#e4967f',
    'menuactivetext' => '#f7f7e6',
    'blockheaderbg' => '#cac6bd',
    'blockheadertext' => '#f7f7e6',
    'blockbg' => '#ffffff',
    'blocktext' => '#5a3323',
    'blocklinks' => '#bf2a1a',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#ffffff',
    'submittedbg' => '#f7f7e6',
    'submittedtext' => '#e4967f',
    'triptychbg' => '#5d83af',
    'triptychlinks' => '#bf2a1a',
  )
);
$info['schemes']['seagreen'] = array(
  'title' => t('Sea Green'),
  'colors' => array(
    'bgtop' => '#8bf1ba',
    'bgmain' => '#ffffff',
    'bgtext' => '#3b3b3b',
    'bglinks' => '#976c6a',
    'text' => '#3b3b3b',
    'links' => '#bc807e',
    'headers' => '#3b3b3b',
    'headerbg' => '#52ceaf',
    'headertext' => '#ffffff',
    'headerglow' => '#61ab82',
    'menubg' => '#5c9676',
    'menutext' => '#ffffff',
    'menuactivebg' => '#ccf7e0',
    'menuactivetext' => '#326a4b',
    'blockheaderbg' => '#f9f6ee',
    'blockheadertext' => '#3b3b3b',
    'blockbg' => '#f9f6ee',
    'blocktext' => '#3b3b3b',
    'blocklinks' => '#bc807e',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#ffffff',
    'submittedbg' => '#f9f6ee',
    'submittedtext' => '#52ceaf',
    'triptychbg' => '#292929',
    'triptychlinks' => '#bc807e',
  )
);
$info['schemes']['arizona'] = array(
  'title' => t('Arizona'),
  'colors' => array(
    'bgtop' => '#c1d7fd',
    'bgmain' => '#f3f7fe',
    'bgtext' => '#5a2914',
    'bglinks' => '#ea610e',
    'text' => '#5a2914',
    'links' => '#ea610e',
    'headers' => '#6f943b',
    'headerbg' => '#fff8e1',
    'headertext' => '#556d34',
    'headerglow' => '#f3f7fe',
    'menubg' => '#d4a775',
    'menutext' => '#496028',
    'menuactivebg' => '#d88562',
    'menuactivetext' => '#fff8e1',
    'blockheaderbg' => '#496028',
    'blockheadertext' => '#ffffff',
    'blockbg' => '#ffffff',
    'blocktext' => '#5a2914',
    'blocklinks' => '#ea610e',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#fff8e1',
    'submittedbg' => '#fff8e1',
    'submittedtext' => '#496028',
    'triptychbg' => '#496028',
    'triptychlinks' => '#cd3d00',
  )
);
$info['schemes']['lupine'] = array(
  'title' => t('Lupine'),
  'colors' => array(
    'bgtop' => '#badaff',
    'bgmain' => '#eae5fe',
    'bgtext' => '#5b9401',
    'bglinks' => '#7768c2',
    'text' => '#405f0e',
    'links' => '#9c93cb',
    'headers' => '#47631a',
    'headerbg' => '#6998ce',
    'headertext' => '#fafaf2',
    'headerglow' => '#547ba9',
    'menubg' => '#c3d5a7',
    'menutext' => '#24310e',
    'menuactivebg' => '#b6b0d6',
    'menuactivetext' => '#3e3764',
    'blockheaderbg' => '#f4f4e9',
    'blockheadertext' => '#47631a',
    'blockbg' => '#ffffff',
    'blocktext' => '#405f0e',
    'blocklinks' => '#9c93cb',
    'teaserbg' => '#ffffff',
    'teaserborder' => '#ffffff',
    'submittedbg' => '#f4f4e9',
    'submittedtext' => '#5f871f',
    'triptychbg' => '#f4f4e9',
    'triptychlinks' => '#9c93cb',
  )
);
