<?php

/**
 * @file
 *
 */

function incubator_disabled_robots() {
  drupal_add_http_header('Content-Type', 'text/plain');
  print "User-agent: *\nDisallow: /\n";
  exit(0);
}

function incubator_access_denied_page() {
  if (!user_is_anonymous()) {
    return;
  }
  drupal_set_title(t('Please log in'));
  $page['message'] = array(
    '#markup' => variable_get('incubator_disable_site', TRUE) ? 
                 t('You must log in to view this site.') :
                 t('You must log in to view this page.'),
    '#weight' => -10,
  );
  $page['login_form'] = drupal_get_form('user_login');
  $page['reset_password_link'] = array(
    '#markup' => l(t('Forgot your password? Reset it here.'), 'user/password'),
    '#weight' => 9,
  );
  return $page;
}

/**
 * This is an altered clone of taxonomy_term_page that displays the nodes in a
 * view, which can be altered in configuration.
 */
function incubator_taxonomy_term_page($term) {
  module_load_include('inc', 'taxonomy', 'taxonomy.pages');
  $build = taxonomy_term_page($term);
  
  if ($view = views_get_view('taxonomy_term')) { // intentional assignment of $view
    
    // Get rid of taxonomy's output
    unset($build['nodes']);
    unset($build['pager']);
    unset($build['no_content']);
    
    // set views argument to current term
    $view->args[0] = $term->tid;
    $view->display['default']->display_options['arguments']['term_node_tid_depth']['title'] = '';
    
    // set page display of view
    $build['nodes']['#markup'] = $view->execute_display('default');
    
    // free memory
    $view->destroy();
    
  }
  
  $build['term_heading']['#prefix'] = str_replace('term-listing-heading', 'term-listing-heading clearfix', $build['term_heading']['#prefix']);
  
  return $build;
}
