<?php

/**
 * @file
 *
 */

/**
 * tour-adminmenu: admin menu item to expand, by href
 * tour-follow: href to follow after tip is shown
 * tour-click: jquery element to click after the tip is shown
 * tour-preclick: jquery element to click before the tip is shown
 * tour-type: text to type into element specified by data-id
 */
function incubator_incubator_tours() {
  
  // =========================================================================== Tour step definitions.
  
  $click_save_configuration = array(
    array(
      'data' => t('As always, once you are finished, you must click the save button.'),
      'data-id' => 'edit-submit',
      'tour-click' => '#edit-submit',
      'data-options' => 'tipLocation:top', 
    ),
  );
  $save_configuration = array(
    array(
      'data' => t('Now click the save button, and you will be finished!'),
      'data-id' => 'edit-submit',
      'data-options' => 'tipLocation:top', 
    ),
  );
  
  
  // =========================================================================== Create a user
  $tours['incubator-create-user'] = array(
    'label' => t('Create a new user'),
    'routes' => array(
      'admin/people/create',
    ),
    'permission' => 'administer users',
    'tips' => array(
      array(
        'data' => t('Every user needs a real name...'),
        'data-id' => 'edit-field-realname',
      ),
      array(
        'data' => t('...and a username, which is usually short and lowercase...'),
        'data-id' => 'edit-name',
      ),
      array(
        'data' => t('...an email address...'),
        'data-id' => 'edit-mail',
      ),
      array(
        'data' => t('...and a password. You have to give them a password, but they won\'t need to use it or know it, so just put three random words together with some numbers, like "2fish4burglar7trophy" (but different)'),
        'data-id' => 'edit-pass-pass1',
      ),
      array(
        'data' => t('The roles that you give a user determine what they can do on the site.'),
        'data-id' => 'edit-roles',
      ),
      array(
        'data' => t('You should almost always notify new users that their account has been created.'),
        'data-id' => 'edit-notify',
      ),
    ),
    'help section' => t('People'),
    'pre-help tips' => array(
      array(
        'data' => t('To create a new user, you need to go to People > Add user in the admin menu.'),
        'data-href' => '/admin/people/create',
        'tour-adminmenu' => '/admin/people',
        'tour-follow' => '/admin/people/create',
      ),
    ),
    'post-help tips' => $save_configuration,
  );
  
  $tours['incubator-admin-users'] = array(
    'label' => t('Administer users with the people list'),
    'routes' => array(
      'admin/people',
    ),
    'permission' => 'administer users',
    'tips' => array(
      array(
        'data' => t('The table shows the name of each user on the site, as well as '
            . 'status, roles, and other data.'),
      ),
      array(
        'data' => t('You can filter the list of users by various metrics.'),
        'data-id' => 'edit-filters',
      ),
      array(
        'data' => t('You can also update multiple accounts at once from this page, '
            . 'adding or removing roles, or even canceling accounts.'),
        'data-id' => 'edit-operation',
      ),
      array(
        'data' => t('To view an account, you could click on the username link, '
            . 'or to edit that account, the "edit" link at the end of the row. '),
        'data-class' => 'username',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('You can add additional users by following the "Add user" link. '
            . 'This is detailed in another tour.'),
        'data-href' => '/admin/people/create',
      ),
    ),
    'help section' => t('People'),
    'pre-help tips' => array(
      array(
        'data'=> t('The "People" link will show you a list of all the users on a site.'),
        'data-href' => '/admin/people',
        'tour-follow' => '/admin/people',
      ),
    ),
  );

  
  // =========================================================================== Site information
  $tours['incubator-site-information'] = array(
    'label' => t('Change basic site information'),
    'routes' => array(
      'admin/config/site-information-settings',
      'admin/config/incubator/site-information',
      'admin/config/system/site-information',
    ),
    'permission' => 'administer incubator',
    'tips' => array(
      array(
        'data' => t('This page contains the most basic options for your site.'),
      ),
      array(
        'data' => t('This option blocks anonymous visitors and search engines from viewing your site. '
            . 'Once your site is ready to go live, this option should be un-checked.'),
        'data-id' => 'edit-incubator-site-status',
      ),
      array(
        'data' => t('Choose a representative title for your site. For example, '
            . 'a website for the local Bahá\'í community of Springfield might be named '
            . '"Springfield Bahá\'í" or "Bahá\'í Faith in Springfield". '),
        'data-id' => 'edit-site-name',
      ),
      array(
        'data' => t('The site slogan will appear under the site name in the header. '
            . 'It is like a subtitle, and is entirely optional.'),
        'data-id' => 'edit-site-slogan',
      ),
      array(
        'data' => t('When your site needs to send email, such as for password resets, '
            . 'this is the address it will be sent from. For most sites, it should be '
            . 'something like "no-reply@[your-domain.org]".'),
        'data-id' => 'edit-site-mail',
      ),
      array(
        'data' => t('Here you can choose a different path to serve as the front page.'),
        'data-id' => 'edit-site-frontpage',
      ),
    ),
    'help section' => t('Configuration'),
    'pre-help tips' => array(
      array(
        'data' => t('Hover over "Configuration" in the admin menu, and then choose "Site information."'),
        'data-href' => '/admin/config/site-information-settings',
        'tour-follow' => '/admin/config/site-information-settings',
        'tour-adminmenu' => '/admin/config',
      ),
    ),
    'post-help tips' => $save_configuration,
  );
  
  
  // =========================================================================== Admin content
  $tours['incubator-admin-content'] = array(
    'label' => t('Use the content administration list'),
    'routes' => array(
      'admin/content',
    ),
    'permission' => 'administer nodes',
    'tips' => array(
      array(
        'data' => t('The table lists all content nodes on the site, highlighting '
            . 'the node type, author, current status, time of last update, etc.'),
      ),
      array(
        'data' => t('You can use filters to find specific content on a large or complex site.'),
        'data-id' => 'edit-filters',
      ),
      array(
        'data' => t('You can update content, in bulk, directly from this page; '
            . 'just select several nodes and then choose an action from this list.'),
        'data-id' => 'edit-options',
      ),
      array(
        'data' => t('You can edit individual nodes directly from this page as well.'),
        'data-class' => 'edit.first',
        'data-options' => 'tipLocation:left',
      ),
    ),
    'help section' => t('Content'),
    'pre-help tips' => array(
      array(
        'data' => t('Click on the "Content" link in the admin menu.'),
        'data-href' => '/admin/content',
        'tour-follow' => '/admin/content',
      ),
    ),
  );
  
  
  // =========================================================================== Adjust theme
  $tours['incubator-skin-options'] = array(
    'label' => t('Adjust colors and styles'),
    'routes' => array(
      '<front>',
      'user/[uid]',
    ),
    'help section' => t('Appearance'),
    'permission' => 'set skin options',
    'tips' => array(
      array(
        'data' => t('Many themes have a number of options for colors, styles and layout.'),
      ),
      array(
        'data' => t('To adjust the look and feel of the site, you can click the '
            . '"Adjust theme options" link underneath the "Appearance" menu.'),
        'data-href' => '/admin/appearance/skinrlite',
        'tour-adminmenu' => '/admin/appearance',
        'tour-follow' => '/admin/appearance/skinrlite',
      ),
      array(
        'data' => t('Click on the eye icon on the right side of the screen.'),
      ),
      array(
        'data' => t('The revealed panel will allow you to change the colors and styles of the site.'),
        'data-id' => 'skinr-lite-chooser-toggle',
        'data-options' => 'tipLocation:left',
        'tour-preclick' => 'body:not(.skinr-lite-show-chooser) #skinr-lite-chooser-toggle',
      ),
      array(
        'data' => t('When you are satisfied with the way the site works, be sure to click "Done" '
            . 'at the bottom of the right panel.'),
      ),
    ),
  );
  
  
  // =========================================================================== Editing content
  
  $tours['incubator-edit-page'] = array(
    'label' => t('Add or edit a basic page'),
    'routes' => array(
      'node/[page]/edit',
      'node/add/page'
    ),
    'permission' => 'create page content',
    'tips' => array(
      array(
        'data' => t('A basic page is usually the simplest type of node, and is '
            . 'generally used for static content that does not change regularly.'),
      ),
      array(
        'data' => t('Like all content nodes, a basic page must have a title. '
            . 'You can enter a title now.'),
        'data-id' => 'edit-title',
      ),
      array(
        'data' => t('The main image will appear at the top of the page, and '
            . 'should be representative of the content. Click the button to add a main image.'),
        'data-id' => 'edit-field-main-image',
      ),
      array(
        'data' => t('The body is the main text of the page.'),
        'data-id' => 'body-add-more-wrapper',
        'data-options' => 'tipLocation:top',
      ),
    ),
    'help section' => t('Content'),
    'pre-help tips' => array(
      array(
        'data' => t('To add a basic page, first go to "Add content"'),
        'data-href' => '/node/add',
        'tour-follow' => '/node/add',
      ),
      array(
        'data' => t('Then click on "Basic page"'),
        'data-href' => '/node/add/page',
        'tour-follow' => '/node/add/page',
      ),
    ),
    'post-help tips' => $save_configuration,
  );
  
  $tours['incubator-menu-link'] = array(
    'label' => 'Add a menu item',
    'routes' => array(
      'node/add/*',
      'node/*/edit',
    ),
    'permission' => 'administer menu',
    'tips' => array(
      array(
        'data' => t('Below the Save button, you will see a list of further options. '
            . 'If "Menu settings" is not selected, please click it before you continue.'),
        'data-class' => 'vertical-tabs',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('You can add a link in the main menu by checking the '
            . '"Provide a menu link" checkbox. A list of options will appear.'),
        'data-id' => 'edit-menu-enabled',
        'tour-preclick' => '#edit-menu-enabled',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('The menu link title is the text that will appear on the page. '
            . 'Often this is either the same as the node title, or else a shorter version of it.'),
        'data-id' => 'edit-menu-link-title',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('The description will appear when the mouse poiter hovers over the link.'),
        'data-id' => 'edit-menu-link-description',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('The parent item will determine which menu the link appears in, '
            . 'and at what level it appears. If this is set to "Main menu", the link '
            . 'will be a top-level link in the main menu. It can also be a child '
            . 'of another menu link.'),
        'data-id' => 'edit-menu-parent',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('The weight determines where this link will appear relative '
            . 'to other links at the same level. Lower numbers are printed '
            . 'before higher numbers, and so they will generally appear closer '
            . 'to the top and/or left.'),
        'data-id' => 'edit-menu-weight',
        'data-options' => 'tipLocation:top',
      ),
    ),
  );
  
  
  $tours['incubator-wysiwyg-help'] = array(
    'label' => t('Use the wysiwyg editor'),
    'routes' => array(
      'node/add/*',
      'node/*/edit',
    ),
    'tips' => array(
      array(
        'data' => t('This editor can help you to add basic styles to your pages. '
            . 'This tour will explain some commonly used buttons.'),
        'data-id' => 'cke_edit-body-und-0-value',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:98px;background-position:-6px 0;"> </div><p>' . 
        t('The bold, italic, underline and strikethrough buttons function as their counterparts do on word processors.') . 
        '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top;',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:48px;background-position:-102px 0;"> </div><p>' . 
        t('Bulleted and numbered lists are obtained through these buttons.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:52px;background-position:-147px 0;"> </div><p>' . 
        t('To create a link to another web page, highlight some text and use the link button. '
            . 'To remove a link, just put the cursor in the link and hit the remove link button.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:27px;background-position:-195px 0;"> </div><p>' . 
        t('Blockquotes are formatted with this button.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:27px;background-position:-267px 0;"> </div><p>' . 
        t('The "remove format" button is helpful when you paste text in from another program; '
            . 'it will get rid of extraneous formatting on any selected text.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:100px;background-position:-297px 0;"> </div><p>' . 
        t('You can create headers (h2, h3, etc.) using this drop-down.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:50px;background-position:-401px 0;"> </div><p>' . 
        t('Use these buttons to find and replace text within your editing area.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => '<div class="wysiwyg-tour" style="width:26px;background-position:-472px 0;"> </div><p>' . 
        t('The add media button will help you put images alongside your text; however, '
            . 'those images will not replace the "Main Image" field, so use that first.') . '</p>',
        'data-class' => 'cke_top',
        'data-options' => 'tipLocation:top',
      ),
    ),
  );
  
  $tours['incubator-editor-walkthrough'] = array(
    'label' => t('Overview : Managing content'),
    'routes' => array(
      'user/[uid]',
      '<front>',
      'node/*',
      'admin/content',
    ),
    'tips' => array_merge(
      array(
        array(
          'data' => t('This site is built on Drupal, a Content Management System '
              . 'that stores content in a database and, when a request is made, '
              . 'arranges it into the document that you read in a web browser.'),
        ),
        array(
          'data' => t('The basic unit of content is called a "node." Most urls on your site '
              . '(though not all) will display the content of a node, or a listing of several nodes.'),
        ),
        array(
          'data' => t('To create a new node, you can go to the "Add content" link.'),
          'data-href' => '/node/add',
          'tour-follow' => '/node/add',
        ),
        array(
          'data' => t('You may see a list of several types of nodes, like events '
              . 'or localities. For now, we will add a page.'),
          'tour-follow' => '/node/add/page',
        ),
        array(
          'data' => t('A basic page is usually the simplest type of node, and is '
              . 'generally used for static content that does not change regularly.'),
        ),
        array(
          'data' => t('Like all content nodes, a basic page must have a title. '
              . 'You can enter a title now.'),
          'data-id' => 'edit-title',
          'tour-type' => t('About this page'),
        ),
        array(
          'data' => t('The main image will appear at the top of the page, and '
              . 'should be representative of the content. Click the button to add a main image.'),
          'data-id' => 'edit-field-main-image',
        ),
        array(
          'data' => t('There may be many different types of nodes on your site, '
              . 'and each node type will have different fields; for example, '
              . 'an event would have a field for start and end times.'),
        ),
        array(
          'data' => t('The body is the main text of the page.'),
          'data-id' => 'body-add-more-wrapper',
          'data-options' => 'tipLocation:top',
        ),
      ),
      $tours['incubator-wysiwyg-help']['tips'],
      $tours['incubator-menu-link']['tips'],
      $click_save_configuration,
      array(
        array(
          'data' => t('Status messages will give you feedback on the actions you have taken.'),
          'data-class' => 'messages',
        ),
        array(
          'data' => t('The title, body and fields from your node are displayed '
              . 'in the main content area of the page.'),
          'data-id' => 'block-system-main',
        ),
        array(
          'data' => t('To edit or delete an existing node, use the "Edit" link just above the body area.'),
          'data-link' => t('Edit'),
          'tour-follow' => t('Edit'),
        ),
        array(
          'data' => t('For now, we will delete the testing node we just created.'),
        ),
        array(
          'data' => t('Click the "Delete" button.'),
          'data-id' => 'edit-delete',
          'tour-click' => '#edit-delete',
        ),
        array(
          'data' => t('Then confirm the request.'),
          'data-id' => 'edit-submit',
          'tour-click' => '#edit-submit',
        ),
        array(
          'data' => t('To see all the nodes on a site, click on the "Content" link in the admin menu.'),
          'data-href' => '/admin/content',
          'tour-follow' => '/admin/content',
        ),
      ),
      $tours['incubator-admin-content']['tips'],
      array(
        array(
          'data' => t('These tools should enable you to create and maintain content on the site.')
        ),
      )
    ),
    'permission' => 'administer nodes',
    'help section' => '',
  );
  
  
  // ===========================================================================
  // MODULES PAGE
  $module_status = array();
  foreach (array('localities', 'events', 'facilities', 'news', 'content_review', 'analytics', 'private') as $module) {
    $module_status[$module] = module_exists("incubator_$module") ? 'enabled' : 'disabled';
  }
  $tours['incubator-modules'] = array(
    'label' => t('Enable or disable features'),
    'routes' => array(
      'admin/modules',
    ),
    'permission' => 'administer incubator',
    'tips' => array(
      array(
        'data' => t('Each of these modules provides different features on your website.'),
      ),
      array(
        'data' => t('It is important to plan out your website based on the needs '
            . 'and resources of your organization. You should only enable modules '
            . 'that provide functionality you need and have the resources to maintain.'),
      ),

      // Local areas
      array(
        'data' => t('If your organization serves several cities or areas, and particularly if '
            . 'the public is likely to search for you in those cities (e.g. not just "Springfield Bahá\'í" '
            . 'but also "Bahá\'ís in Dayton" and "Evansville Bahá\'ís"), you may wish to '
            . 'enable the "Local Content" module and perhaps also the "Mapping" module.'),
        'data-id' => "edit-modules-{$module_status['localities']}-incubator-localities",
      ),

      // Events
      array(
        'data' => t('If your organization puts on events to which the public is invited, '
            . 'you may wish to enable the "Events / Calendar" module. However, bear in '
            . 'mind that maintaining a calendar is one of the most labor-intensive tasks '
            . 'for website editors, because the listings are outdated so quickly.<br/> If '
            . 'you find that you cannot keep the calendar up-to-date, it is better to '
            . 'have only a general description of your events with contact information, '
            . 'and for that you may not need this module.'),
        'data-id' => "edit-modules-{$module_status['events']}-incubator-events",
      ),

      // Facilities
      array(
        'data' => t('If your organization has physical buildings, such as one or more local centers, '
            . 'you may consider enabling the "Facilities" module and perhaps also the "Mapping" module.'),
        'data-id' => "edit-modules-{$module_status['facilities']}-incubator-facilities",
      ),

      // News
      array(
        'data' => t('If you have people who will be creating content based on current events, '
            . 'such as news stories, videos or photo galleries, then you will want the "News," '
            . '"Video" and "Photo Galleries" modules'),
        'data-id' => "edit-modules-{$module_status['news']}-incubator-news",
      ),

      // Editing workflow
      array(
        'data' => t('If you have a person or a team of people who will act as editors '
            . 'for the content created by others--checking, revising, publishing and archiving '
            . 'content as needed--then you may enable the "Editing Workflow" module.'),
        'data-id' => "edit-modules-{$module_status['content_review']}-incubator-content-review",
      ),

      // Stats
      array(
        'data' => t('If you wish to track statistics on the visitors to your website, '
            . 'you can enable the "Stats & Analytics" module and set it up with a Google Analytics account. '
            . 'This is recommended for most public sites.'),
        'data-id' => "edit-modules-{$module_status['analytics']}-incubator-analytics",
        'data-options' => 'tipLocation:top',
      ),
    ),
    'help section' => t('Configuration'),
    'pre-help tips' => array(
      array(
        'data' => t('To enable additional functionality on your site, go to the "Modules" page.'),
        'data-href' => '/admin/modules',
        'tour-follow' => '/admin/modules',
      ),
    ),
    'post-help tips' => $save_configuration,
  );
      
  // ===========================================================================
  // STARTUP TOUR FOR ADMINISTRATORS
  
  $site_timezone = (variable_get('date_default_timezone', 'UTC') != 'UTC' || variable_get('incubator_tours_startup_complete', FALSE)) ? array() : 
  array(
    array(
      'data' => t('You should also set the timezone for your site'),
      'data-href' => '/admin/config',
      'tour-follow' => '/admin/config',
    ),
    array(
      'data' => t('...then choose the "Regional settings" link. You can also see '
          . 'this link if you hover over the "Configuration" item in the administration menu.'),
      'data-href' => '/admin/config/incubator/regional',
      'tour-follow' => '/admin/config/incubator/regional',
    ),
    array(
      'data' => t('Please choose the proper timezone for your area.'),
      'data-id' => 'edit-timezone',
    ),
    array(
      'data' => t('Then click the "Save configuration" button.'),
      'data-id' => 'edit-submit',
      'tour-click' => '#edit-submit',
    ),
  );
  
  $tours['incubator-administrator-walkthrough'] = array(
    // 'id' is added automatically
    'label' => t('Overview : Administering this site'),
    'routes' => array(
      'user/[uid]',
      '<front>',
      'admin/people',
      'admin/content',
      'admin/config',
      'admin/config/incubator/site-information',
      'admin/config/site-information-settings',
      'admin/modules',
    ),
    'permission' => 'administer incubator',
    'tips' => array_merge(
      array(
        array(
          'data' => t('Welcome to your website! This website is built on the open-source '
            . '"Bahá\'í Incubator" distribution of Drupal. We hope this walkthrough will '
            . 'help you prepare to administer all aspects of the website.'),
        ),
        array(
          'data' => t('You should see a black admin menu across the top of the screen. '
              . 'This tour will familiarize you with some of its features.'),
        ),
      ),
      $tours['incubator-admin-users']['pre-help tips'],
      $tours['incubator-admin-users']['tips'],
      array(
        array(
          'data' => t('The "Content" listing will show you a similar list of all the content on the site. '
              . 'It is explained in detail in the separate tour for content editing.'),
          'data-href' => '/admin/content',
        ),
        array(
          'data' => t('Many of the optional features of your site are under the "Configuration" link. '
              . 'You can click directly on the link to see a page of these options.'),
          'data-href' => '/admin/config',
          'tour-follow' => '/admin/config',
        ),
        array(
          'data' => t('This page has detailed information on common configuration options.'),
        ),
        array(
          'data' => t('Once you are used to the systems, you will probably prefer '
              . 'to simply hover over the link, exposing the options directly.'),
          'data-href' => '/admin/config',
        ),
        array(
          'data' => t('You should at least be familiar with the site information settings.'),
          'data-href' => '/admin/config/site-information-settings',
          'tour-follow' => '/admin/config/site-information-settings',
          'tour-adminmenu' => '/admin/config',
          'data-options' => 'tipLocation:right',
        ) ,
      ),
      $tours['incubator-site-information']['tips'],
      $click_save_configuration,
      $site_timezone,
      array(
        array(
          'data' => t('To enable additional functionality on your site, go to the "Modules" page.'),
          'data-href' => '/admin/modules',
          'tour-follow' => '/admin/modules',
        ),
      ),
      $tours['incubator-modules']['tips'],
      $click_save_configuration,
      $tours['incubator-skin-options']['tips'],
      array(
        array(
          'data' => t('This brief introduction should help you get started using your new Drupal website. '
              . 'If you have not yet done so, you may wish to see other general tours that will help you maintain the site. '
              . 'You can find them on your user page, or on !help.', array('!help' => l('the help page', 'help'))),
          'data-button' => t('Finished!'),
        ),
      )
    ),
    'help section' => '',
  );
  if (variable_get('date_default_timezone', 'UTC') == 'UTC' && !variable_get('incubator_tours_startup_complete', FALSE)) {
    $tours['incubator-administrator-walkthrough']['routes'][] = 'admin/config/incubator/regional';
  }
  
    
  return $tours;
}
