<?php

/**
 * @file
 *
 */

function incubator_email_service_incubator_settings_menu() {
  return array(
    'description' => 'Set up email services like Zoho and Google apps',
  );
}

function incubator_email_service_incubator_settings() {
  $form['intro'] = array(
    '#markup' => t('Services like Zoho and Google Apps allow you to receive '
        . 'email at addresses on your domain. Google Apps has been popular for '
        . 'some time, but it has recentely removed its free offerings. Zoho '
        . 'still offers a free level of service. After your chosen service is '
        . 'verified, this module should be disabled, and once you fill out one '
        . 'of the options below, the module will be automatically disabled after '
        . 'half an hour.')
  );
  
  $form['zoho'] = array(
    '#type' => 'fieldset',
    '#title' => t('Zoho'),
    '#collapsible' => FALSE,
    '#description' => t('Zoho.com offers email and other applications for small '
        . 'businesses.'),
    'zoho_verification' => array(
      '#type' => 'textfield',
      '#title' => t('Verification number'),
      '#description' => t('To get the verification number, you must '
          . '<a href="http://zoho.com">sign up for an account on Zoho.com</a> '
          . 'using your domain. After sign-up, you will be asked to verify '
          . 'your ownership of the domain. Choose "HTML Method", download '
          . 'and open the file, and copy the numbers into this box.'),
      '#default_value' => variable_get('zoho_verification', ''),
    ),
  );
  
  $form = system_settings_form($form);
  
  $form['#submit'][] = 'incubator_email_service_settings_save';
  
  return $form;
}

function incubator_email_service_settings_save() {
  if (variable_get('zoho_verification', '')) {
    variable_set('incubator_email_service_enabled', time() + 1800);
  }
  drupal_flush_all_caches();
}
