(function ($) {

Drupal.behaviors.incubatorSocialColorChooser = {
  attach: function (context, settings) {
    
    // Hide the main color chooser
    $(".theme-color-choosers").hide();
    
    // Show the color choosers from each form item
    $("div.description .theme-color-choosers").show();
    
    // Prepare the Farbtastic widget
    var farb = $.farbtastic('#markerly-colorpicker');
    $('.colorpicker-input').each(function() {
      // Set the background colors of all of the textfields appropriately.
      farb.linkTo(this);
      // When clicked, they get linked to the associated farbtastic colorpicker.
      $(this).focus(function () {
        farb.linkTo(this);
      });
    });
    
    // Handle clicks on theme colors
    $("div.description .color-chooser", context).css('cursor', 'pointer').click(function() {
      var background = $(this).css('background-color');
      var text = $(this).text();
      $(this).parents('.form-item').children('input.colorpicker-input').css('background-color', background).val(text).focus();
    });
  }
};

}(jQuery));
