<?php

/**
 * @file
 *
 * Implements API calls for media module. Media module doesn't let you upload
 * any files unless you have the "edit media" permission, which is too much for
 * someone who is just posting blog entries. We allow upload for certain roles
 * in the Incubator system that would not already have it.
 */

/**
 * Implements hook_media_browser_plugin_info().
 * 
 * If the current user doesn't already have access to the upload plugin, we
 * check to see if he can create certain kinds of content for which uploading is
 * necessary.
 */
function incubator_media_browser_plugin_info() {
  $plugins = array();
  
  if ((
        !user_access('administer media') && !user_access('edit media')          // IF the user doesn't already have access...
      ) && (
        user_access('create page content') ||                                   // ...and he can create a basic page...
        user_access('create news content') ||                                   // ...or a news item...
        user_access('create blog content') ||                                   // ...or a blog post...
        user_access('create event content')                                     // ...or an event...
      )) {
    $plugins['upload'] = array(                                                 // ,,,THEN allow access to the upload form.
      '#weight' => -10,
    );
  }
  
  return $plugins;
}

/**
 * Implements hook_media_browser_plugin_view().
 * 
 * If we have provided the upload plugin above then this function gets called.
 * All it does is call the real view function for the upload plugin.
 */
function incubator_media_browser_plugin_view($plugin_name, $params) {
  if ($plugin_name == 'upload') {
    module_load_include('inc', 'media', 'media.media');
    return media_media_browser_plugin_view($plugin_name, $params);
  }
}
