<?php

/**
 * @file
 *
 */

function incubator_tours_help() {
  $tours = incubator_tours_get_tours('*');
  $output = array();
  // Add elements to page bottom
  $output['_incubator_tours_joyride'] = array(
    '#prefix' => '<div class="incubator-tours-joyride">',
    '#suffix' => '</div>',
  );
  foreach ($tours as $name => $tour) {
    if (isset($tour['help section'])) {
      $section = $tour['help section'];
      $output[$section]['#theme'] = 'item_list';
      $output[$section]['#items'][] = l($tour['label'], '', array(
        'attributes' => array(
          'class' => array(
            'incubator-tours-start-link'
          ),
          'data-id' => $tour['id'],
        ),
      ));
      if (!empty($tour['help section'])) {
        $output[$section]['#prefix'] = '<h3>' . $section . '</h3>';
      }
      $output['_incubator_tours_joyride'][$name] = array(
        '#theme' => 'item_list',
        '#items' => $tour['tips'],
        '#attributes' => array(
          'id' => $tour['id'],
        ),
      );
    }
  }
  ksort($output);
  
  return $output;
}
