/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */



/**
 * @file
 * This file holds the javascript functions for the map UI
 *
 * @ingroup openlayers
 */

(function ($) {

/**
 * Helper functions.
 */
Drupal.openlayers_ui = {

  /**
   * Update the center of the helpmap using the values from the form
   *
   * Take the center lat, lon and zoom values from the form and update
   * the helper map.
   */
  'updateMapCenter': function() {
    var data = $('#openlayers-center-helpmap').data('openlayers');
    if (data) {
      var zoom = $('.openlayers-form-zoom').val();
      var lonlat = $('.openlayers-form-centerpoint').val().split(', ', 2);
      // Create new center
      var center = new OpenLayers.LonLat(
          parseFloat(lonlat[0]),
          parseFloat(lonlat[1]));
      // Transform center
      center.transform(
          new OpenLayers.Projection('EPSG:4326'),
          new OpenLayers.Projection('EPSG:900913'));
     // Set center of map.
      data.openlayers.setCenter(center, zoom);
    }
  },

  /**
   * Event callback for updating center form field values when map
   * is dragged or zoomed.
   */
  'updateCenterFormValues': function() {
    var data = $('#openlayers-center-helpmap').data('openlayers');
    if (data) {
      var helpmap = data.openlayers;
      var zoom = helpmap.getZoom();
      var center = helpmap.getCenter();

       // Transform for projection
      center.transform(
          new OpenLayers.Projection('EPSG:900913'),
          new OpenLayers.Projection('EPSG:4326'));

      // Get new lat and lon
      var lat = center.lat;
      var lon = center.lon;

      // Set new values
      $('.openlayers-form-zoom').val(zoom);
      $('.openlayers-form-centerpoint').val(lon+', '+lat);


    }
  }
}
})(jQuery);
