<?php

// Great Britain

function location_province_list_gb() {
  return array(
    'GSY' => "Guernsey",
    'JSY' => "Jersey",
    'BDG' => "Barking and Dagenham",
    'BNE' => "Barnet",
    'BNS' => "Barnsley",
    'BAS' => "Bath and North East Somerset",
    'BDF' => "Bedfordshire",
    'BEX' => "Bexley",
    'BIR' => "Birmingham",
    'BBD' => "Blackburn with Darwen",
    'BPL' => "Blackpool",
    'BOL' => "Bolton",
    'BMH' => "Bournemouth",
    'BRC' => "Bracknell Forest",
    'BRD' => "Bradford",
    'BEN' => "Brent",
    'BNH' => "Brighton and Hove",
    'BST' => "Bristol City of",
    'BRY' => "Bromley",
    'BKM' => "Buckinghamshire",
    'BUR' => "Bury",
    'CLD' => "Calderdale",
    'CAM' => "Cambridgeshire",
    'CMD' => "Camden",
    'CHS' => "Cheshire",
    'CON' => "Cornwall",
    'COV' => "Coventry (West Midlands district)",
    'CRY' => "Croydon",
    'CMA' => "Cumbria",
    'DAL' => "Darlington",
    'DER' => "Derby",
    'DBY' => "Derbyshire",
    'DEV' => "Devon",
    'DNC' => "Doncaster",
    'DOR' => "Dorset",
    'DUD' => "Dudley (West Midlands district)",
    'DUR' => "Durham",
    'EAL' => "Ealing",
    'ERY' => "East Riding of Yorkshire",
    'ESX' => "East Sussex",
    'ENF' => "Enfield",
    'ESS' => "Essex",
    'GAT' => "Gateshead (Tyne & Wear district)",
    'GLS' => "Gloucestershire",
    'GRE' => "Greenwich",
    'HCK' => "Hackney",
    'HAL' => "Halton",
    'HMF' => "Hammersmith and Fulham",
    'HAM' => "Hampshire",
    'HRY' => "Haringey",
    'HRW' => "Harrow",
    'HPL' => "Hartlepool",
    'HAV' => "Havering",
    'HEF' => "Herefordshire County of",
    'HRT' => "Hertfordshire",
    'HIL' => "Hillingdon",
    'HNS' => "Hounslow",
    'IOW' => "Isle of Wight",
    'IOS' => "Isles of Scilly",
    'ISL' => "Islington",
    'KEC' => "Kensington and Chelsea",
    'KEN' => "Kent",
    'KHL' => "Kingston upon Hull City of",
    'KTT' => "Kingston upon Thames",
    'KIR' => "Kirklees",
    'KWL' => "Knowsley",
    'LBH' => "Lambeth",
    'LAN' => "Lancashire",
    'LDS' => "Leeds",
    'LCE' => "Leicester",
    'LEC' => "Leicestershire",
    'LEW' => "Lewisham",
    'LIN' => "Lincolnshire",
    'LIV' => "Liverpool",
    'LND' => "London City of",
    'LUT' => "Luton",
    'MAN' => "Manchester",
    'MDW' => "Medway",
    'MRT' => "Merton",
    'MDB' => "Middlesbrough",
    'MIK' => "Milton Keynes",
    'NET' => "Newcastle upon Tyne",
    'NWM' => "Newham",
    'NFK' => "Norfolk",
    'NEL' => "North East Lincolnshire",
    'NLN' => "North Lincolnshire",
    'NSM' => "North Somerset",
    'NTY' => "North Tyneside",
    'NYK' => "North Yorkshire",
    'NTH' => "Northamptonshire",
    'NBL' => "Northumberland",
    'NGM' => "Nottingham",
    'NTT' => "Nottinghamshire",
    'OLD' => "Oldham",
    'OXF' => "Oxfordshire",
    'PTE' => "Peterborough",
    'PLY' => "Plymouth",
    'POL' => "Poole",
    'POR' => "Portsmouth",
    'RDG' => "Reading",
    'RDB' => "Redbridge",
    'RCC' => "Redcar and Cleveland",
    'RIC' => "Richmond upon Thames",
    'RCH' => "Rochdale",
    'ROT' => "Rotherham",
    'RUT' => "Rutland",
    'SHN' => "St Helens",
    'SLF' => "Salford",
    'SAW' => "Sandwell",
    'SFT' => "Sefton",
    'SHF' => "Sheffield",
    'SHR' => "Shropshire",
    'SLG' => "Slough",
    'SOL' => "Solihull",
    'SOM' => "Somerset",
    'SGC' => "South Gloucestershire",
    'STY' => "South Tyneside",
    'STH' => "Southampton",
    'SOS' => "Southend-on-Sea",
    'SWK' => "Southwark",
    'STS' => "Staffordshire",
    'SKP' => "Stockport",
    'STT' => "Stockton-on-Tees",
    'STE' => "Stoke-on-Trent",
    'SFK' => "Suffolk",
    'SND' => "Sunderland",
    'SRY' => "Surrey",
    'STN' => "Sutton",
    'SWD' => "Swindon",
    'TAM' => "Tameside",
    'TFW' => "Telford and Wrekin",
    'THR' => "Thurrock",
    'TOB' => "Torbay",
    'TWH' => "Tower Hamlets",
    'TRF' => "Trafford",
    'WKF' => "Wakefield",
    'WLL' => "Walsall",
    'WFT' => "Waltham Forest",
    'WND' => "Wandsworth",
    'WRT' => "Warrington",
    'WAR' => "Warwickshire",
    'WBK' => "West Berkshire",
    'WSX' => "West Sussex",
    'WSM' => "Westminster",
    'WGN' => "Wigan",
    'WIL' => "Wiltshire",
    'WNM' => "Windsor and Maidenhead",
    'WRL' => "Wirral",
    'WOK' => "Wokingham",
    'WLV' => "Wolverhampton",
    'WOR' => "Worcestershire",
    'YOR' => "York",
    'ANT' => "Antrim",
    'ARD' => "Ards",
    'ARM' => "Armagh",
    'BLA' => "Ballymena",
    'BLY' => "Ballymoney",
    'BNB' => "Banbridge",
    'BFS' => "Belfast",
    'CKF' => "Carrickfergus",
    'CSR' => "Castlereagh",
    'CLR' => "Coleraine",
    'CKT' => "Cookstown",
    'CGV' => "Craigavon",
    'DRY' => "Derry",
    'DOW' => "Down",
    'DGN' => "Dungannon and South Tyrone",
    'FER' => "Fermanagh",
    'LRN' => "Larne",
    'LMV' => "Limavady",
    'LSB' => "Lisburn",
    'MFT' => "Magherafelt",
    'MYL' => "Moyle",
    'NYM' => "Newry and Mourne",
    'NTA' => "Newtownabbey",
    'NDN' => "North Down",
    'OMH' => "Omagh",
    'STB' => "Strabane",
    'ABE' => "Aberdeen",
    'ABD' => "Aberdeenshire",
    'ANS' => "Angus",
    'AGB' => "Argyll and Bute",
    'CLK' => "Clackmannanshire",
    'DGY' => "Dumfries and Galloway",
    'DND' => "Dundee",
    'EAY' => "East Ayrshire",
    'EDU' => "East Dunbartonshire",
    'ELN' => "East Lothian",
    'ERW' => "East Renfrewshire",
    'EDH' => "Edinburgh",
    'ELS' => "Eilean Siar",
    'FAL' => "Falkirk",
    'FIF' => "Fife",
    'GLG' => "Glasgow",
    'HLD' => "Highland",
    'IVC' => "Inverclyde",
    'NAY' => "North Ayrshire",
    'NLK' => "North Lanarkshire",
    'ORK' => "Orkney Islands",
    'PKN' => "Perth and Kinross",
    'MLN' => "Midlothian",
    'MRY' => "Moray",
    'RFW' => "Renfrewshire",
    'SCB' => "Scottish Borders The",
    'ZET' => "Shetland Islands",
    'SAY' => "South Ayrshire",
    'SLK' => "South Lanarkshire",
    'STG' => "Stirling",
    'WDU' => "West Dunbartonshire",
    'WLN' => "West Lothian",
    'BGW' => "Blaenau Gwent",
    'BGE' => "Bridgend",
    'CAY' => "Caerphilly",
    'CRF' => "Cardiff",
    'CMN' => "Carmarthenshire",
    'CGN' => "Ceredigion",
    'CWY' => "Conwy",
    'DEN' => "Denbighshire",
    'FLN' => "Flintshire",
    'GWN' => "Gwynedd",
    'AGY' => "Isle of Anglesey",
    'MTY' => "Merthyr Tydfil",
    'MON' => "Monmouthshire",
    'NTL' => "Neath Port Talbot",
    'NWP' => "Newport",
    'PEM' => "Pembrokeshire",
    'POW' => "Powys",
    'RCT' => "Rhondda Cynon Taf",
    'SWA' => "Swansea",
    'TOF' => "Torfaen",
    'VGL' => "Vale of Glamorgan",
    'WRX' => "Wrexham",
  );
}

function location_map_link_gb_providers() {
  return array(
    'google' => array(
      'name' => 'Google Maps',
      'url' => 'http://maps.google.co.uk',
      'tos' => 'http://www.google.co.uk/help/terms_maps.html',
    ),
  );
}

function location_map_link_gb_default_providers() {
  return array('google');
}

function location_map_link_gb_google($location = array()) {
  $query_params = array();

  foreach (array('street', 'city', 'postal_code', 'country') as $field) {
    if (isset($location[$field])) {
      $query_params[] = $location[$field];
    }
  }

  if (count($query_params)) {
    return ('http://maps.google.co.uk?q='. urlencode(implode(', ', $query_params)));
  }
  else {
    return NULL;
  }
}

/**
 * Returns minimum and maximum latitude and longitude needed to create a bounding box.
 */
function location_bounds_gb() {
  // NaturalEarth 10m Admin 0 - Countries (v1.3.0)
  // EPSG:900913
  // From ISO code GB.
  return array(
    'minlng' => -13.691355,
    'minlat' => 49.9096161,
    'maxlng' => 1.77170536,
    'maxlat' => 60.8475532,
  );
}
