<?php
// $Id$

/**
 * @file
 *
 */

function incubator_admin_settings() {
  $form['incubator_images'] = array(
    '#title' => t('Main image float direction'),
    '#description' => t('Direction that all "main image" contents will float.'),
    '#type' => 'select',
    '#options' => array('left' => t('Left', array(), array('#context' => 'Direction')), 'right' => t('Right', array(), array('#context' => 'Direction'))),
    '#default_value' => variable_get('incubator_images', 'right'),
  );
  $form['incubator_images_small_size'] = array(
    '#title' => t('Small image size (in pixels)'),
    '#description' => t('Images in lists of content will have this length as their largest dimension.  Preview videos will appear this size.'),
    '#type' => 'textfield',
    '#default_value' => variable_get('incubator_images_thumbnail_size', INCUBATOR_IMAGES_THUMBNAIL_SIZE),
  );
  $form['incubator_images_medium_size'] = array(
    '#title' => t('Medium image size (in pixels)'),
    '#description' => t('Main images on page views will have this length as their largest dimension.'),
    '#type' => 'textfield',
    '#default_value' => variable_get('incubator_images_medium_size', INCUBATOR_IMAGES_MEDIUM_SIZE),
  );
  $form['incubator_images_large_size'] = array(
    '#title' => t('Large image size (in pixels)'),
    '#description' => t('Zoomed images in colorboxes will have this length as their largest dimension.  Full videos will appear in this size.'),
    '#type' => 'textfield',
    '#default_value' => variable_get('incubator_images_large_size', INCUBATOR_IMAGES_LARGE_SIZE),
  );
  $form['warning'] = array(
    '#markup' => t('Submitting this form will flush all caches on your site.  This may impact performance for a short time.  ')
  );

  $form = system_settings_form($form);
  $form['#submit'][] = 'incubator_admin_settings_submit';
  return $form;
}

function incubator_admin_settings_submit(&$form, &$form_state) {
  // flush ALL CACHES.
  drupal_flush_all_caches();

  // flush image styles for thumbnail, medium, large
  image_style_flush(image_style_load('thumbnail'));
  image_style_flush(image_style_load('medium'));
  image_style_flush(image_style_load('large'));

  // set video small display size
  // set video large display size
  foreach (array('small', 'large') as $size) {
    $view_mode = "media_$size";
    $displays = file_displays_load('video', $view_mode, TRUE);
    foreach (array('vimeo', 'youtube') as $provider) {
      $formatter_name = "media_{$provider}_video";
      if (!empty($displays[$formatter_name])) {
        $default_display = _incubator_file_display_video_default($provider, $size);
        $sizes = array_intersect_key($default_display, array('height' => 1, 'width' => 1));
        $display = isset($displays[$formatter_name]) ? (array) $displays[$formatter_name] : (array) file_display_new($file_type, $view_mode, $formatter_name);
        $display['settings'] = array_merge($default_display, $display['settings'], $sizes);
        file_display_save((object) $display);
      }
    }
  }

}

function _incubator_file_display_video_default($provider, $size = 'small') {
  if (!module_load_include('inc', "media_$provider", "includes/media_$provider.variables") &&
      !module_load_include('inc', "media_$provider", "media_$provider.variables")) {
    return FALSE;
  }
  if (function_exists($function = "media_{$provider}_variable_default")) {
    $settings = $function();
    unset($settings['preview_uri']);
    $image_size = ($size == 'small') ? 'thumbnail' : $size;
    $size = variable_get("incubator_images_{$image_size}_size", constant('INCUBATOR_IMAGES_' . strtoupper($image_size) . '_SIZE'));
    $settings['width'] = $size;
    $settings['height'] = (string) round($size * .75, 0);
    if ($provider == 'youtube') {
      $settings = array_merge($settings, array('related' => FALSE, 'showsearch' => FALSE, 'modestbranding' => TRUE));
      if ($size == 'large') {
        $settings['hd'] = TRUE;
      }
    }
    return $settings;
  }
  return FALSE;
}
