<?php
// $Id$

/**
 * @file
 *
 */

function incubator_mapping_incubator_settings_menu() {
  return array('description' => 'Settings for maps provided by the Incubator.');
}

function incubator_mapping_incubator_settings($form_state) {
  $title = t('Incubator map settings');
  $description = t('Set the map position and zoom defaults on the map below.');
  $form['helpmap'] = array(
    '#markup' => "<h3>$title</h3>" .
    '<div class="form-item openlayers-center-helpmap" style="display:block">' .
    '<div class="description">'. $description . '</div></div>'
  );
  
  $map = leaflet_map_get_info('OSM Mapnik');
  list($lon, $lat) = explode(', ', variable_get('incubator_mapping_centerpoint', '-96, 38'));
  $map['center'] = array(
    'lon' => is_numeric($lon) ? $lon : -99,
    'lat' => is_numeric($lat) ? $lat : 39,
    'force' => TRUE,
  );
  $map['settings']['zoom'] = variable_get('incubator_mapping_zoom', '4');
  $map['settings']['scrollWheelZoom'] = FALSE;
  $form['map'] = leaflet_build_map($map, array(), '400px');
  $form['map']['#attached']['js'][] = array(
    'data' => drupal_get_path('module', 'incubator_mapping') . '/js/incubator_mapping_admin.js',
    'options' => array(
      'scope' => 'footer',
      'weight' => 20,
    ),
  );
  
  $form['incubator_mapping_centerpoint'] = array(
    '#type' => 'hidden',
    '#default_value' => variable_get('incubator_mapping_centerpoint', '-96, 38'),
    '#attributes' => array('id' => 'incubator_mapping_centerpoint_set'),
  );
  $form['incubator_mapping_zoom'] = array(
    '#type' => 'hidden',
    '#default_value' => variable_get('incubator_mapping_zoom', '4'),
    '#attributes' => array('id' => 'incubator_mapping_zoom_set'),
  );
  
  $form['#attributes']['style'] = 'max-width:800px;';
  
//  $form['restrict'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('Restrict Extent')
//  );
//  $form['restrict']['incubator_mapping_restrict_extent'] = array(
//    '#type' => 'checkbox',
//    '#title' => t('Restrict Extent'),
//    '#description' => t('Setting the restricted extent of a map prevents users
//      from panning the map outside a specified area. This can be set
//      interactively by holding the shift key and dragging a box over the map
//      above. Setting the extent does not restrict how far users can zoom out,
//      so setting restricted zoom levels (via individual layer settings) is
//      recommended.'),
//    '#id' => 'restrictextent',
//    '#default_value' => variable_get('incubator_mapping_restrict_extent', FALSE),
//  );
//  $form['restrict']['incubator_mapping_restricted_extent'] = array(
//    '#type' => 'textfield',
//    '#title' => t('Restricted Extent'),
//    '#description' => t('Prevents users from panning outside of a specific bounding box'),
//    '#default_value' => variable_get('incubator_mapping_restrict_extent', ''),
//    '#attributes' => array('class' => array('openlayers-form-restrictedExtent')),
//    '#size' => 25,
//    '#process' => array('ctools_dependent_process'),
//    '#dependency' => array('restrictextent' => array(1))
//  );
  return system_settings_form($form);
}
