<?php

/**
 * Configuration form for Selectize.js.
 * @param $form
 * @param $form_state
 * @return mixed
 */
function selectize_admin_settings($form, $form_state) {
  $local_available = file_exists(libraries_get_path('selectize') . '/dist/js/selectize.min.js');
  $form['selectize_local'] = array(
    '#type' => 'checkbox',
    '#title' => t('Serve selectize.js from local file instead of cdnjs.com'),
    '#default_value' => variable_get('selectize_local', FALSE),
    '#enabled' => $local_available,
  );
  if (!$local_available) {
    $form['selectize_local']['#description'] = t('In order to serve selectize.js from your server, you need to download !selectize and extract the entire contents of the archive into the %path directory on your server. Until this is done, selectize.js will be served from cdnjs.com.', array('!selectize' => l(t('Selectize.js library'), 'https://github.com/selectize/selectize.js'), '%path' => 'sites/all/libraries/selectize'));
  }
  
  $form['selectize_elements'] = array(
    '#type' => 'textarea',
    '#title' => t('CSS Classes'),
    '#description' => t('Apply Selectize.js to the classes above for particular select elements.'),
    '#default_value' => variable_get('selectize_elements', NULL)
  );

  $form['selectize_all'] = array(
    '#type' => 'checkbox',
    '#title' => t('Apply to all'),
    '#description' => t('Apply Selectize.js to all select elements on the site.'),
    '#default_value' => variable_get('selectize_all', FALSE)
  );

  $form['selectize_admin'] = array(
    '#type' => 'checkbox',
    '#title' => t('Apply in admin areas'),
    '#description' => t('Apply Selectize.js while in admin areas. Unselect this to ensure compatibility with the backend.'),
    '#default_value' => variable_get('selectize_admin', FALSE)
  );

  return system_settings_form($form);
}