<?php

/**
 * @file
 *
 */

function incubator_content_review_incubator_tours_alter(&$tours) {
  
  $click_save_configuration = array(
    array(
      'data' => t('As always, once you are finished, you must click the save button.'),
      'data-id' => 'edit-submit',
      'tour-click' => '#edit-submit',
      'data-options' => 'tipLocation:top', 
    ),
  );
  
  $tours['incubator-editor-walkthrough']['tips'] = array_merge(
    array(
      array(
        'data' => t('This site is built on Drupal, a Content Management System '
            . 'that stores content in a database and, when a request is made, '
            . 'arranges it into the document that you read in a web browser.'),
      ),
      array(
        'data' => t('The basic unit of content is called a "node." Most urls on your site '
            . '(though not all) will display the content of a node, or a listing of several nodes.'),
      ),
      array(
        'data' => t('To create a new node, you can go to the "Add content" link.'),
        'data-href' => '/node/add',
        'tour-follow' => '/node/add',
      ),
      array(
        'data' => t('You may see a list of several types of nodes, like events '
            . 'or localities. For now, we will add a page.'),
        'tour-follow' => '/node/add/page',
      ),
      array(
        'data' => t('A basic page is usually the simplest type of node, and is '
            . 'generally used for static content that does not change regularly.'),
      ),
      array(
        'data' => t('Like all content nodes, a basic page must have a title. '
            . 'You can enter a title now.'),
        'data-id' => 'edit-title',
        'tour-type' => t('About this page'),
      ),
      array(
        'data' => t('The main image will appear at the top of the page, and '
            . 'should be representative of the content. Click the button to add a main image.'),
        'data-id' => 'edit-field-main-image',
      ),
      array(
        'data' => t('There may be many different types of nodes on your site, '
            . 'and each node type will have different fields; for example, '
            . 'an event would have a field for start and end times.'),
      ),
      array(
        'data' => t('The body is the main text of the page.'),
        'data-id' => 'body-add-more-wrapper',
        'data-options' => 'tipLocation:top',
      ),
    ),
    $tours['incubator-wysiwyg-help']['tips'],
    $tours['incubator-menu-link']['tips'],
    array(
      array(
        'data' => t('This content will be marked as a draft, visible only to you '
            . 'and other editors.'),
        'data-id' => 'edit-workbench-moderation-state-new',
      ),
    ),
    $click_save_configuration,
    array(
      array(
        'data' => t('Status messages will give you feedback on the actions you have taken.'),
        'data-class' => 'messages',
      ),
      array(
        'data' => t('The title, body and fields from your node are displayed '
            . 'in the main content area of the page.'),
        'data-id' => 'block-system-main',
      ),
      array(
        'data' => t('If a node is unpublished, the body appears in a highlighted color.'),
        'data-id' => 'block-system-main',
      ),
      array(
        'data' => t('The workbench block shows up when there are things that you need to do as an editor or author.'),
        'data-id' => 'block-incubator-content-review-incubator-content-review'
      ),
      array(
        'data' => t('To edit an existing node, you can use the "Edit" link just above the body area.'),
        'data-link' => t('Edit draft'),
        'tour-follow' => t('Edit draft'),
      ),
      array(
        'data' => t('For now, we will delete the testing node we just created.'),
      ),
      array(
        'data' => t('Click the "Delete" button.'),
        'data-id' => 'edit-delete',
        'tour-click' => '#edit-delete',
      ),
      array(
        'data' => t('Then confirm the request.'),
        'data-id' => 'edit-submit',
        'tour-click' => '#edit-submit',
      ),
      array(
        'data' => t('The "Workbench" is your content staging area, where you and the other contributors can work on content together.'),
        'data-href' => '/admin/workbench',
      ),
      array(
        'data' => t('The main page will show all the activity on the site that needs your attention '
        . 'or that is waiting for attention from others.'),
      ),
      array(
        'data' => t('To see all the nodes on a site, you can click on the "Content" link in the admin menu.'),
        'data-href' => '/admin/content',
        'tour-follow' => '/admin/content',
      ),
    ),
    $tours['incubator-admin-content']['tips'],
    array(
      array(
        'data' => t('These tools should enable you to create and maintain content on the site.')
      ),
    )
  );
  
}
