<?php
// $Id$

/**
 * @file
 *
 */

function incubator_events_incubator_settings_menu() {
  return array('description' => 'Settings for events and calendars.');
}

function incubator_events_incubator_settings() {
  $form['incubator_events_views_choice'] = array(
    '#type' => 'select',
    '#title' => t('Show menu links for'),
    '#options' => array('calendar' => t('Calendar'), 'upcoming' => t('Event List'), 'both' => t('Both')),
    '#default_value' => variable_get('incubator_events_views_choice', 'upcoming'),
    '#description' => t('Whichever view is chosen will appear in the main menu.'),
  );
  $form['incubator_events_views_disable_secondary'] = array(
    '#type' => 'checkbox',
    '#title' => t('Completely disable the other view'),
    '#default_value' => variable_get('incubator_events_views_disable_secondary', FALSE),
    '#description' => t('If this option is checked, whichever view is not enabled above will be completely disabled.'),
    '#states' => array(
      'invisible' => array(
        ':input[name="incubator_events_views_choice"]' => array('value' => 'both'),
      ),
    ),
  );
  
  $form['upcoming'] = array(
    '#type' => 'fieldset',
    '#title' => t('Event list display options'),
  );
  $form['upcoming']['incubator_events_views_upcoming_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Title for upcoming events page'),
    '#default_value' => variable_get('incubator_events_views_upcoming_title', 'Activities and Events'),
  );
  $form['upcoming']['incubator_events_popups'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use popups in event list'),
    '#description' => t('When people click a link to an event, instead of taking them to the page, this will make the teaser pop up on the current page. It may be useful for sites with many events where the events have no descriptive text or images, so taking people to a different page to see nothing special might be annoying.'),
    '#default_value' => variable_get('incubator_events_popups', FALSE),
  );

  // UPCOMING EVENTS OPTIONS
  
  $grouping_fields = incubator_events_get_grouping_fields();
  $grouping_primary = variable_get('incubator_events_grouping_primary', 'default');
  $grouping_secondary = variable_get('incubator_events_grouping_secondary', 'default');
  $form['upcoming']['grouping'] = array(
    '#type' => 'fieldset',
    '#title' => t('Grouping: @grouping', array('@grouping' => str_replace('0', '(none)', implode(', ', $grouping_fields)))),
    '#collapsible' => TRUE,
    '#collapsed' => ($grouping_primary == 'default' && $grouping_secondary == 'default'),
  );
  $grouping_options = array(
    'default' => t('Default'),
    0 => t('- none -'),
    'address' => t('Address'),
  );
  $vocabularies = taxonomy_get_vocabularies();
  foreach ($vocabularies as $v) {
    $grouping_options['field_' . $v->machine_name] = $v->name;
  }
  $form['upcoming']['grouping']['incubator_events_grouping_primary'] = array(
    '#type' => 'select',
    '#title' => t('Primary grouping field'),
    '#default_value' => $grouping_primary,
    '#description' => t(''),
    '#options' => $grouping_options,
  );
  $form['upcoming']['grouping']['incubator_events_grouping_secondary'] = array(
    '#type' => 'select',
    '#title' => t('Secondary grouping field'),
    '#default_value' => $grouping_secondary,
    '#options' => $grouping_options,
    '#states' => array(
      'invisible' => array(
        ':input[name="incubator_events_grouping_primary"]' => array('value' => '0'),
      ),
      'disabled' => array(
        ':input[name="incubator_events_grouping_primary"]' => array('value' => 'address'),
      ),
    ),
  );
  $form['upcoming']['grouping']['incubator_events_grouping_address'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Address items for grouping'),
    '#options' => array(
      'name' => t('Name'),
      'street' => t('Street'),
      'additional' => t('Additional'),
      'city' => t('City'),
      'province' => t('Province'),
      'postal_code' => t('Postal code'),
      'country' => t('Country'),
      'country_name' => t('Country name'),
    ),
    '#default_value' => variable_get('incubator_events_grouping_address', array('city' => 'city')),
    '#states' => array(
      'invisible' => array(
        ':input[name="incubator_events_grouping_primary"]' => array('!value' => 'address'),
        ':input[name="incubator_events_grouping_secondary"]' => array('!value' => 'address'),
      ),
    ),
  );
  
  // CALENDAR OPTIONS

  $form['calendar'] = array(
    '#type' => 'fieldset',
    '#title' => t('Calendar display options')
  );
  $form['calendar']['incubator_events_views_calendar_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Title for calendar page'),
    '#default_value' => variable_get('incubator_events_views_calendar_title', 'Calendar'),
  );
  $form['calendar']['incubator_events_views_calendar_firstday'] = array(
    '#type' => 'select',
    '#title' => t('First day of week'),
    '#options' => array(
      '0' => t('Sunday'),
      '1' => t('Monday'),
      '2' => t('Tuesday'),
      '3' => t('Wednesday'),
      '4' => t('Thursday'),
      '5' => t('Friday'),
      '6' => t('Saturday'),
    ),
    '#default_value' => variable_get('incubator_events_views_calendar_firstday', '0'),
  );
  $form['calendar']['incubator_events_views_calendar_weekmode'] = array(
    '#type' => 'select',
    '#title' => t('Display of weeks on month view'),
    '#options' => array(
      'fixed' => t('Always show 6 weeks'),
      'liquid' => t('Show 4, 5, or 6 weeks with constant calendar height'),
      'variable' => t('Show 4, 5, or 6 weeks with constant row height'),
    ),
    '#default_value' => variable_get('incubator_events_views_calendar_weekmode', 'variable'),
  );
  $form['calendar']['incubator_events_views_calendar_editable'] = array(
    '#type' => 'checkbox',
    '#title' => t('Allow drag / drop editing of events on calendar'),
    '#default_value' => variable_get('incubator_events_views_calendar_editable', FALSE),
    '#description' => t('Note that drag / drop editing does not work in all circumstances; repeating events, for example, cannot be changed by drag and drop on the calendar.')
  );
  if (variable_get('incubator_is_bahai_site', NULL) !== FALSE) {
    $form['calendar']['incubator_events_show_bahai_calendar'] = array(
      '#type' => 'checkbox',
      '#title' => t("Show the Bahá'í calendar holy days"),
      '#default_value' => variable_get('incubator_events_show_bahai_calendar', incubator_is_bahai_site()),
    );
  }
  
  $form = system_settings_form($form);
  $form['#submit'][] = 'incubator_events_admin_form_submit';                    // this must be after the system form submit function

  return $form;
}

function incubator_events_admin_form_submit(&$form, &$form_state) {
  
  $choice = variable_get('incubator_events_views_choice', 'upcoming');
  if ($links = db_query('SELECT * FROM {menu_links} WHERE link_path IN (:path)', array(':path' => array('events/upcoming', 'events/calendar')))->fetchAllAssoc('link_path')) {
    foreach (array('upcoming', 'calendar') as $var) {
      if (!empty($links["events/$var"])) {
        ${$var} = (array) $links["events/$var"];
        if (${$var}['customized']) {
          ${$var}['hidden'] = in_array($choice, array('both', $var)) ? 0 : 1;
          ${$var}['options'] = unserialize(${$var}['options']);
          menu_link_save(${$var});
        }
      }
    }
  }

  cache_clear_all('ctools_export:views_view:incubator_events', 'cache_views');
  cache_clear_all('ctools_export:views_view:incubator_regular_events', 'cache_views');
  drupal_flush_all_caches();
  menu_rebuild();
  if (module_exists('redirect') && !variable_get('incubator_events_views_disable_secondary', FALSE)) {
    redirect_delete_by_path('events/calendar');
    redirect_delete_by_path('events/upcoming');
  }
}
