<?php

/**
 * @file
 *
 */

function incubator_events_incubator_tours() {
  $tours = array();
  
  $tours['incubator-events-add-event'] = array(
    'label' => t('Create an event'),
    'routes' => array(
      'node/add/event',
    ),
    'permission' => 'create event content',
    'tips' => array(
      array(
        'title' => t('About Events'),
        'data' => t('When you are publicizing an event, there are three important '
            . 'questions that must be answered. These are: '
            . '<ol><li>What is happening?</li>'
            . '<li>When does it happen?</li>'
            . '<li>Where does it happen?</li></ol>'),
      ),
      array(
        'title' => t('Drop-in Events'),
        'data' => t('If you want visitors to drop in to your event, then the '
            . 'time and location must be very specific.'),
        'data-class' => 'form-item-location-chooser',
        'data-options' => 'tipLocation:top',
        'tour-preclick' => '#edit-field-event-date .fieldset-title',
      ),
      array(
        'title' => t('RSVP Events'),
        'data' => t('For other events, you may want to know when new people are coming. '
            . 'A weekly children\'s class may accept new members, but only '
            . 'with prior notice, so you could publish a phone number and '
            . 'leave the location and time very general.'),
        'data-id' => 'edit-field-event-info',
        'tour-preclick' => '#edit-field-event-date .fieldset-title',
      ),
      array(
        'title' => t('RSVP Events'),
        'data' => t('You could even leave the time blank, in which case the event '
            . 'would not appear on the calendar, but would still show up in the '
            . 'list of all events.'),
        'data-id' => 'edit-field-event-date',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'title' => t('What is happening?'),
        'data' => t('The title of an event should be brief, yet convey enough information '
            . 'that a complete stranger would have some ideas about the event. '
            . 'Instead of just "Children\'s Class", you might choose as a title '
            . '"East Springfield Children\'s Class" or '
            . '"Tuesday Children\'s Class at the Smiths".'),
        'data-class' => 'form-item-title',
      ),
      array(
        'title' => t('What is happening?'),
        'data' => t('The info field will appear in lists of events, such as the '
            . 'upcoming events page and calendar. It should be extremely short. '
            . 'For recurring events, you may wish to indicate the regular time '
            . 'and place, e.g. "Mondays at 7 in the library." You can also put a '
            . 'contact number in this field, as long as the contact person approves.'),
        'data-id' => 'edit-field-event-info',
      ),
      array(
        'title' => t('What is happening?'),
        'data' => t('It is best to write at least a sentence or two describing the event.'),
        'data-id' => 'edit-body',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'title' => t('Where?'),
        'data' => t('You can choose a common location here.'),
        'data-class' => 'form-item-location-chooser',
      ),
      array(
        'title' => t('Where?'),
        'data' => t('You can specify a custom location at the bottom of the page. '
            . 'Remember that the location can be just a general area, like '
            . 'an intersection or a street, or even just a city or neighborhood.'),
        'data-id' => 'edit-locations-0',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'title' => t('When?'),
        'data' => t('If you want the event to appear on the calendar with '
            . 'specific dates, click the "Event Date" label to see the date fields. '
            . 'If you need help, choose the help topic for "Add event date".'),
        'data-id' => 'edit-field-event-date',
        'data-options' => 'tipLocation:top',
      ),
    ),
    'help section' => t('Content'),
    'pre-help tips' => array(
      array(
        'data' => t('To add an event, go to "Add content" and then click on "Event".'),
        'data-href' => '/node/add',
        'tour-follow' => '/node/add/event',
      ),
    ),
    'post-help tips' => array(
      array(
        'data' => t('Remember to save the event when you are finished.'),
        'data-id' => 'edit-submit',
      ),
    ),
  );
  
  $tours['incubator-events-edit-event'] = array(
    'label' => t('Edit an event'),
    'routes' => array(
      'node/[event]/edit',
    ),
    'tips' => $tours['incubator-events-add-event']['tips'],
  );
  
  $tours['incubator-events-add-event-date'] = array(
    'label' => t('Add an event date'),
    'routes' => array(
      'node/[event]/edit',
      'node/add/event',
    ),
    'tips' => array(
      array(
        'data' => t('First, ensure that the "Event Date" field is expanded. '
            . 'If not, click the title to expand it.'),
        'data-id' => 'edit-field-event-date',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('Now you can choose a date in the date field. On most sites, '
            . 'a calendar will pop up when you click on the date field.'),
        'data-id' => 'edit-field-event-date-und-0-value',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('Click in the time field and you should be able to type a time. '
            . 'Tab and shift-tab to move between hours, minutes, and am/pm.'),
        'data-class' => 'form-item-field-event-date-und-0-value-time',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('If you want to specify the end time of an event, '
            . 'you can check the "Show End Time" box. Unless your event is an '
            . 'overnight event, the date should be the same as the main date.'),
        'data-class' => 'form-item-field-event-date-und-0-show-todate .option',
        'data-options' => 'tipLocation:right',
      ),
      array(
        'data' => t('If this event happens only once, you can close this tour now. '
            . 'If it repeats on a regular basis, please click the "Repeat" checkbox '
            . 'and then continue.'),
        'data-class' => 'form-item-field-event-date-und-0-show-repeat-settings .option',
        'data-options' => 'tipLocation:right',
      ),
      array(
        'data' => t('There are several options for the periodicity, and while '
            . 'most are fairly straightforward, complex ones can take some experimentation. '
            . 'For example, an event that happens on second and last Mondays '
            . 'of each month is a "Monthly" repeat, and you must click the '
            . 'radio button for "On the" and then select both "Second" and "Last" '
            . 'by clicking with your command (Mac) or control (Win) key held down.'),
        'data-id' => 'edit-field-event-date-und-0-rrule-freq',
        'data-options' => 'tipLocation:top',
      ),
      array(
        'data' => t('Events cannot repeat forever. You must choose '
            . 'either a number of occurrences or a specific end date.'),
        'data-class' => 'range-of-repeat',
      ),
      array(
        'data' => t('Exclude and include dates are useful if one occurrence of a '
            . 'repeating event will be skipped, or if a special session is scheduled '
            . 'at another time.'),
        'data-id' => 'edit-field-event-date-und-0-rrule-show-exceptions',
        'data-options' => 'tipLocation:top'
      ),
    ),
  );
  
  return $tours;
}
