<?php

/**
 * @file
 *
 */

function incubator_social_incubator_settings_menu() {
  return array(
    'description' => 'Settings for social site integration.',
    'title' => 'Social Integration',
  );
}

function incubator_social_incubator_settings() {

  $form = $form_state = array();

  // =============================
  // SHARING

  $form['sharing'] = array(
    '#type' => 'fieldset',
    '#title' => t('Sharing'),
  );

  // Social widgets: Socialite.js
  $form['sharing']['incubator_social_widgets'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use social sharing buttons'),
    '#description' => t('Enables buttons for Facebook like, Twitter share, Google +1.'),
    '#default_value' => variable_get('incubator_social_widgets', FALSE),
  );
  $form['sharing']['incubator_social_widgets_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Widget settings'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
    '#states' => array(
      'invisible' => array(
        ':input[name="incubator_social_widgets"]' => array('checked' => FALSE),
      ),
    ),
  );
  $form['sharing']['incubator_social_widgets_settings']['incubator_social_widgets_node_full'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show social buttons on full node display'),
    '#default_value' => variable_get('incubator_social_widgets_node_full', TRUE),
  );
  $form['sharing']['incubator_social_widgets_settings']['incubator_social_widgets_node_teaser'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show social buttons on teasers'),
    '#default_value' => variable_get('incubator_social_widgets_node_teaser', TRUE),
  );
  $form['sharing']['incubator_social_widgets_settings']['incubator_social_widgets_services'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Buttons to implement'),
    '#options' => array(
      'tw' => t('Twitter'),
      'go' => t('Google+'),
      'li' => t('LinkedIn'),
      'fb' => t('Facebook'),
    ),
    '#default_value' => variable_get('incubator_social_widgets_services', array('tw', 'go', 'fb')),
  );


  // =============================
  // METATAGS : DESCRIPTIONS & LOGO

  $form['metatags'] = array(
    '#type' => 'fieldset',
    '#title' => t('Meta tags'),
  );

  $form['metatags']['descriptions'] = array(
    '#type' => 'fieldset',
    '#title' => t('Page descriptions for views'),
    '#description' => t('Page descriptions appear on social networks and search engine results as supplementary text to a shared page. '
        . 'Most descriptions use a summary of the page content; but for views, there is no content, so the view description can be set here.'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );

  $views = views_get_all_views();
  foreach ($views as $name => $view) {
    if (!$view->disabled && !empty($view->human_name)) {
      foreach ($view->display as $display) {
        if ($display->display_plugin == 'page') {
          $form['metatags']['descriptions']["incubator_social_views_descriptions_$name"] = array(
            '#type' => 'textarea',
            '#title' => check_plain($view->human_name),
            '#default_value' => variable_get("incubator_social_views_descriptions_$name", $view->description),
            '#rows' => 2,
          );
          continue;
        }
      }
    }
  }

  $points = array(
    t('The default image should be like a logo that represents your entire site.'),
    t('The default image should not usually have transparency.'),
    t('Small images (less than 600 x 315px) should be square.'),
    t('Larger images should have a wide aspect of 1.91:1, and will appear large on Facebook.'),
  );
  $form['metatags']['social_logo'] = array(
    '#type' => 'fieldset',
    '#title' => t('Sharing image'),
    '#description' => t('The default social sharing image will show in social news feeds for pages that do not have a page-specific image. It is important to specify this because otherwise Facebook can choose any picture from the page!') .
      '<ul><li>' . implode('</li><li>', $points) . '</li></ul>',
  );
  if ($img_uri = variable_get('incubator_social_image_path', '')) {
    if ($img = image_load($img_uri)) {
      $img_path = file_create_url($img_uri);
      $height = $img->info['height'];
      $width = $img->info['width'];
      $ratio = $width / $height;
      $size = ($height > 599 && $width > 314) ? 'large' : 'small';
      $aspect = ($ratio >= 1 && $size = 'small') || ($ratio >= 1.91 && $size == 'large') ? 'wide' : 'tall';
      $class = "image $size $aspect";
      $img_markup = "background-image:url($img_path)";
    }
  }
  if (empty($img_markup)) {
    $img_markup = '';
    $class = 'no-image';
  }
  global $base_url;
  $title = t('Example of how a shared page might look on Facebook');
  $text = t('This is an example of how a page shared from your site might look on Facebook. If you upload an image as the default, it will appear here.');
  $text .= '<span class="no-image-warning"> ' . t('If no default image is specified, Facebook will choose which image to share!') . '</span>';
  $form['metatags']['social_logo']['demonstration'] = array(
    '#markup' => "<div class='incubator-social-demo $class'><div class='social-image-wrapper' style='$img_markup'></div><div class='social-text-wrapper'><h3>$title</h3>$base_url<br/><p>$text</p></div></div>",
  );
  $form['metatags']['social_logo']['incubator_social_image_path'] = array(
    '#type' => 'textfield',
    '#title' => t('Default social sharing image path'),
    '#default_value' => $img_uri,
  );
  $form['metatags']['social_logo']['incubator_social_image_upload'] = array(
    '#type' => 'file',
    '#title' => t('Upload custom image'),
    '#description' => t('Upload a custom image here. Allowed extensions: jpg, jpeg, png, gif. Uploaded images will be renamed.'),
  );

  // =============================
  // SOCIAL ACCOUNTS

//  $form['incubator_social_accounts'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('Accounts'),
//    '#description' => t('If your organization maintains public accounts on '
//        . 'social media services, enter the information here.'),
//    '#collapsible' => FALSE,
//    '#collapsed' => FALSE,
//  );

  // =============================
  // SOCIAL LOGIN (REMOVED)

  $form = system_settings_form($form);
  $form['#submit'][] = 'incubator_social_incubator_settings_submit';
  $form['#validate'][] = 'incubator_social_incubator_settings_validate';
  drupal_add_css(drupal_get_path('module', 'incubator_social') . '/incubator_social.admin.css');

  return $form;

}

function incubator_social_incubator_settings_validate($form, &$form_state) {
  $file = file_save_upload('incubator_social_image_upload', array(
    // Validates file is really an image.
    'file_validate_is_image' => array(),
    // Validate extensions.
    'file_validate_extensions' => array('png gif jpg jpeg'),
  ));
  // If the file passed validation:
  if (isset($file)) {
    if ($file) {
      // Save the file for use in the submit handler.
      $form_state['storage']['incubator_social_file'] = $file;
      if ($form_state['values']['incubator_social_image_path']) {
        drupal_set_message(t('Your image has been uploaded; you may need to refresh the page if you still see the old image.'), 'warning');
        $form_state['values']['incubator_social_image_path'] = '';
      }
    }
    else {
      form_set_error('incubator_social_image_upload', t('The image could not be uploaded.'));
    }
  }
  if ($form_state['values']['incubator_social_image_path']) {
    module_load_include('inc', 'system', 'system.admin');
    $path = _system_theme_settings_validate_path($form_state['values']['incubator_social_image_path']);
    if (!$path) {
      form_set_error('incubator_social_image_path', t('The image path is not valid.'));
    }
    else {
      $form_state['values']['incubator_social_image_path'] = $path;
    }
  }
}

function incubator_social_incubator_settings_submit(&$form, &$form_state) {

  // SHARING

  variable_set('incubator_social_widgets_services', array_filter($form_state['values']['incubator_social_widgets_services']));

  if (!empty($form_state['storage']['incubator_social_file'])) {
    $file = $form_state['storage']['incubator_social_file'];
    unset($form_state['storage']['incubator_social_file']);
    $ext = array();
    preg_match('/(\.[^.]+)$/', $file->filename, $ext);
    if ($new_path = file_unmanaged_copy($file->uri, 'public://site-social-logo' . $ext[1], FILE_EXISTS_REPLACE)) {
      variable_set('incubator_social_image_path', $new_path);
    }
  }

  // SOCIAL LOGIN

  drupal_flush_all_caches();

}
