(function($) {
  
Drupal.behaviors.incubator_tours = {
  attach: function (context, settings) {
    var startOptions = {
      autoStart: true,
      startOffset: 0,
      preRideCallback: function (index, tip) {
        sessionStorage.removeItem('incubatorToursHref');
        sessionStorage.removeItem('incubatorToursClick');
      },
      preStepCallback: function (index, tip) {
// Set session variables for tour
        sessionStorage.setItem('incubatorToursStart', this.$content_el.attr('id'));
        sessionStorage.setItem('incubatorToursIndex', index);
// Follow href or click element defined in postStepCallback
        var href = sessionStorage.getItem('incubatorToursHref');
        var click = sessionStorage.getItem('incubatorToursClick');
        if (href) {
          sessionStorage.removeItem('incubatorToursHref');
          window.location.href = href;
          this.stopImmediatePropagation();
        }
        else if (click !== undefined && $(click).length) {
          sessionStorage.removeItem('incubatorToursClick');
          $(click).click();
          if (sessionStorage.getItem('incubatorToursClickContinue') !== undefined) {
            sessionStorage.removeItem('incubatorToursClickContinue');
            this.stopImmediatePropagation();
          }
        }
// After this, autostart the tour at the next item
        sessionStorage.setItem('incubatorToursIndex', index + 1);
// Remove the continue flag
        sessionStorage.removeItem('incubatorToursClickContinue');
// Take care of admin menu positioning
        $('#admin-menu').css('position', 'absolute');
// Click the "tour-preclick" element before showing the tip.
        var sel = this.$li.attr('tour-preclick');
        if (sel !== undefined && $(sel).length) {
          $(sel).click();
        }
// Type text
        var text = this.$li.attr('tour-type');
        var id = this.$li.attr('data-id');
        if (text !== undefined && id !== undefined && $('#' + id).length) {
          $('#' + id).val(text);
        }
      },
      postStepCallback: function (index, tip) {
// Check for a path to follow
        var follow = this.$li.attr('tour-follow');
        if (follow !== undefined) {
          // Get href from link with matching text, if any
          var link = $('a').filter(function(index) { return $(this).text() === follow; }).first();
          var href = '';
          if (link.length) {
            href = link.attr('href');
          }
          // If no link with matching text, assume href = follow
          else {
            href = follow;
          }
          sessionStorage.setItem('incubatorToursHref', href);
        }
// Check for an element to click
        var clickElement = this.$li.attr('tour-click');
        if (clickElement !== undefined) {
          sessionStorage.setItem('incubatorToursClick', clickElement);
          if (this.$li.attr('tour-click-continue') !== undefined) {
            sessionStorage.setItem('incubatorToursClickContinue', true);
          }
        }
// Remove Start and Index
        sessionStorage.removeItem('incubatorToursStart');
        sessionStorage.removeItem('incubatorToursIndex');
// Expose links for next step
        if (this.$tip_content[index + 1] !== undefined) {
          var exposeLink = this.$tip_content[index + 1].getAttribute('tour-adminmenu');
          if (exposeLink !== undefined) {
            $('a[href="' + exposeLink + '"]').siblings('ul').first().css('display', 'block').css('left', 'auto');
          }
        }
      },
      postRideCallback: function (index, tip) {
// Remove all local storage
        sessionStorage.removeItem('incubatorToursHref');
        sessionStorage.removeItem('incubatorToursClick');
        sessionStorage.removeItem('incubatorToursClickContinue');
        sessionStorage.removeItem('incubatorToursStart');
        sessionStorage.removeItem('incubatorToursIndex');
        $('#incubator-tours-start-links').css('left', '');
      }
    };

// Start the tour on a click
    $('.incubator-tours-start-link').click(function(e) {
      e.preventDefault();
      $('#incubator-tours-start-links').css('left', '-280px');
// Get the tour id
      var tour_id = $(this).attr('data-id');
// Check for validity
      if (tour_id.length) {
        var element = $('#' + tour_id);
        if (element.length) {
          if (element.attr('tour-option-modal') !== undefined) {
            startOptions['modal'] = true;
          }
          if (element.attr('tour-option-expose') !== undefined) {
            startOptions['expose'] = true;
          }
          $('#' + tour_id).joyride(startOptions);
        }
      }
    });

// Start the tour on page load, when required
    var startTour = sessionStorage.getItem('incubatorToursStart');
    if (startTour !== undefined && $('#' + startTour).length) {
      $('#admin-menu').css('position', 'absolute');
      var newIndex = sessionStorage.getItem('incubatorToursIndex');
      // Set the startOffset. This should always be defined, even if it is 0.
      startOptions.startOffset = (newIndex !== undefined ? newIndex : 0);
      // Start the tour.
      $('#' + startTour).joyride(startOptions);
    }
    
  }
};
  
}(jQuery));
